﻿<%@ page language="C#" autoeventwireup="true" inherits="Nd.Webs.FrameWork.Web.Agent.AgentList, App_Web_agentlist.aspx.706e31b2" %>
<%@ Import Namespace="Nd.Webs.FrameWork.Utility" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>我的代理人列表</title>
    <link type="text/css" rel="Stylesheet" href="../lib/Skin/<%=Style %>/style.css" />
    <script type="text/javascript" src="../Lib/Js/Utility.js"></script>
    <script type="text/javascript" src="../Lib/Js/CellColorChange.js"></script>
    <script type="text/javascript" src="../Lib/Js/autosuggest.js"></script>
    <script type="text/javascript" src="../Lib/Js/DateFormat.js"></script>
    <script type="text/javascript" src="/EaLib/Js/My97DatePicker/WdatePicker.js"></script>
    <script type="text/javascript">
        var UserID = "<%=UserID %>";
        var AgentID;
        var AgentName;
        //添加代理人
        function AddAgent()
        {
            var agentID = document.getElementById("UserNameID").value;
            var agentName = document.getElementById("UserName").value;
            if(agentID.length == 0)
            {
                SetError("请输入并选择姓名！");
                return;
            }
            
            if(agentID == UserID)
            {
                SetError("您不能添加自己为代理！");
                return;
            }
            
            var tb = document.getElementById("agentPanel").firstChild;
            for(var i = 1; i < tb.rows.length; i++)
            {
                if(tb.rows[i].cells[0].firstChild.getAttribute("agentID") == agentID)
                {
                    SetError("您的代理对象中已经存在此代理人，请不要重复添加！");
                    return;
                }
            }
            
            if(agentID != AgentID)
            {
                ClearError();
                AgentID = agentID;
                AgentName = agentName;
                document.getElementById("addBtn").disabled = true;
                Utility.Ajax.Request({
                    url: "Handler/AgentHandler.ashx?action=AddAgent",
                    param: {UserID: UserID, AgentID: agentID},
                    success: AddAgentHandler
                    });
                
                function AddAgentHandler(xmlHttp)
                {
                    var result = xmlHttp.responseText.split("$");
                    switch(result[0])
                    {
                        case "0":
                            //失败
                        case "9":
                            //未登录
                            alert(result[1]);
                            SetError(result[1]);
                            break;
                        case "1":
                            //成功
                            alert(result[1]);
                            if(tb.rows.length > 1 && tb.rows[1].cells.length == 1)
                            {
                                tb.deleteRow(1);
                            }
                            var row = tb.insertRow(-1);
                            var agentCell = row.insertCell(-1);
                            agentCell.innerHTML = "<span agentID=\"" + agentID + "\">" + agentName + "</span>";
                            var statusCell = row.insertCell(-1);
                            statusCell.innerHTML = "<span status=\"0\" style=\"color: red\">已禁用</span>";
                            var memoCell = row.insertCell(-1);
                            memoCell.innerHTML = "&nbsp;";
                            var timeSpanCell = row.insertCell(-1);
                            timeSpanCell.innerHTML = "<span style=\"color: green\">不限制</span>";
                            var addTimeCell = row.insertCell(-1);
                            addTimeCell.innerHTML = new Date().Format("yyyy-MM-dd HH:mm:ss");
                            var handlerCell = row.insertCell(-1);
                            var strHtml = new Utility.StringBuffer();
                            strHtml.Append("<input type=\"button\" value=\"授权\" class=\"btn\" onclick=\"GrantAgent(this)\" />");
                            strHtml.Append("<input type=\"button\" value=\"变更\" class=\"btn\" onclick=\"ChangeAgent(this)\" />");
                            strHtml.Append("<span><input type=\"button\" value=\"启用\" style=\"color: red\" onclick=\"ChangeAgentStatus(this, 1)\" class=\"btn\" /> </span>");
                            strHtml.Append("<input type=\"button\" value=\"删除\" class=\"btn\" onclick=\"DelAgent(this)\" />");
                            handlerCell.innerHTML = strHtml.ToString();
                            break;
                    }
                    document.getElementById("addBtn").disabled = false;
                }
            }
        }
        
        //修改代理人启用状态
        function ChangeAgentStatus(el, status)
        {
            var row = el.parentNode;
            while(row != null && row.tagName != "TR")
            {
                row = row.parentNode;
            }
            var userID = UserID;
            var agentID = row.cells[0].firstChild.getAttribute("agentID");
            el.disabled = true;
            Utility.Ajax.Request({
                    url: "Handler/AgentHandler.ashx?action=SetInherit",
                    param: {UserID: userID, AgentID: agentID, IsInherit: status},
                    success: ChangeAgentStatusHandler
                    });
            
            function ChangeAgentStatusHandler(xmlHttp)
            {
                var result = xmlHttp.responseText.split("$");
                switch(result[0])
                {
                    case "0":
                        //失败
                    case "9":
                        //未登录
                        alert(result[1]);
                        SetError(result[1]);
                        break;
                    case "1":
                        //成功
                        alert(result[1]);
                        if(status == 0)
                        {
                            row.cells[1].innerHTML = "<span status=\"0\" style=\"color: red\">已禁用</span>";
                            el.parentNode.innerHTML = "<input type=\"button\" value=\"启用\" style=\"color: red\" onclick=\"ChangeAgentStatus(this, 1)\" class=\"btn\" />";
                        }
                        else
                        {
                            var beginTime;
                            var endTime;
                            if(row.cells[3].childNodes.length != 1)
                            {
                                beginTime = row.cells[3].firstChild.innerHTML;
                                endTime = row.cells[3].lastChild.innerHTML;
                            }
                            var nowTime = new Date().Format("yyyy-MM-dd HH:mm");
                            if(beginTime && endTime && (beginTime > nowTime || endTime < nowTime))
                            {
                                row.cells[1].innerHTML = "<span status=\"1\" style=\"color: red\">已启用(代理时间外)</span>";
                            }
                            else
                            {
                                row.cells[1].innerHTML = "<span status=\"1\" style=\"color: green\">已启用(代理时间内)</span>";
                            }
                            el.parentNode.innerHTML = "<input type=\"button\" value=\"禁用\" onclick=\"ChangeAgentStatus(this, 0)\" class=\"btn\" />";
                        }
                        break;
                }
                el.disabled = false;
            }
        }
        
        function DelAgent(el)
        {
            var row = el.parentNode;
            while(row != null && row.tagName != "TR")
            {
                row = row.parentNode;
            }
            var userID = UserID;
            var agentID = row.cells[0].firstChild.getAttribute("agentID");
            el.disabled = true;
            Utility.Ajax.Request({
                    url: "Handler/AgentHandler.ashx?action=DeleteAgent",
                    param: {UserID: userID, AgentID: agentID},
                    success: DelAgentHandler
                    });
            
            function DelAgentHandler(xmlHttp)
            {
                var result = xmlHttp.responseText.split("$");
                switch(result[0])
                {
                    case "0":
                        //失败
                    case "9":
                        //未登录
                        alert(result[1]);
                        SetError(result[1]);
                        el.disabled = false;
                        break;
                    case "1":
                        //成功
                        alert(result[1]);
                        row.parentNode.removeChild(row);
                        break;
                }
            }
        }
        
        //管理授权
        function GrantAgent(el)
        {
            var row = el.parentNode;
            while(row != null && row.tagName != "TR")
            {
                row = row.parentNode;
            }
            var agentID = row.cells[0].firstChild.getAttribute("agentID");
            
            location.href="AgentTree.aspx?setAgentID="+agentID;
        }
        
        //变更代理信息
        function ChangeAgent(el)
        {
            var row = el.parentNode;
            while(row != null && row.tagName != "TR")
            {
                row = row.parentNode;
            }
            var agentID = row.cells[0].firstChild.getAttribute("agentID");
            //变更前信息
            var oldStatusValue = row.cells[1].firstChild.getAttribute("status");
            var oldStatusText = row.cells[1].innerHTML;
            row.cells[1].setAttribute("old", oldStatusText);
            var oldMemo = row.cells[2].innerHTML;
            row.cells[2].setAttribute("old", oldMemo);
            var oldTimeSpane = row.cells[3].innerHTML;
            row.cells[3].setAttribute("old", oldTimeSpane);
            var oldHandler = row.cells[5].innerHTML;
            row.cells[5].setAttribute("old", oldHandler);
            var oldTimeSpanValue = 0;
            var oldBeginTime;
            var oldEndTime;
            if(row.cells[3].childNodes.length != 1)
            {
                oldTimeSpanValue = 1;
                oldBeginTime = row.cells[3].firstChild.innerHTML;
                oldEndTime = row.cells[3].lastChild.innerHTML;
            }
            
            //状态
            var statusHtml = new Utility.StringBuffer();
            statusHtml.AppendFormat("<input id=\"status_{0}_1\" name=\"status_{0}\" type=\"radio\" {1}/>", agentID, oldStatusValue == "1" ? "checked=\"checked\"" : "");
            statusHtml.AppendFormat("<label for=\"status_{0}_1\">启用</label>", agentID);
            statusHtml.AppendFormat("<input id=\"status_{0}_0\" name=\"status_{0}\" type=\"radio\" {1}/>", agentID, oldStatusValue != "1" ? "checked=\"checked\"" : "");
            statusHtml.AppendFormat("<label for=\"status_{0}_0\">禁用</label>", agentID);
            row.cells[1].innerHTML = statusHtml.toString();
            row.cells[2].innerHTML = "<input type=\"text\" onfocus=\"this.select()\" class=\"tinput\" maxlength=\"50\" value=\"" + oldMemo + "\" />";
            
            //代理时间段
            var timeSpanHtml = new Utility.StringBuffer();
            timeSpanHtml.AppendFormat("<input id=\"timeSpan_{0}_1\" name=\"timeSpan_{0}\" type=\"radio\" onclick=\"this.parentNode.lastChild.style.display='none'\" {1}/>", agentID, oldTimeSpanValue == 0 ? "checked=\"checked\"" : "");
            timeSpanHtml.AppendFormat("<label for=\"timeSpan_{0}_1\">不限制</label>", agentID);
            timeSpanHtml.AppendFormat("<input id=\"timeSpan_{0}_0\" name=\"timeSpan_{0}\" type=\"radio\" onclick=\"this.parentNode.lastChild.style.display='block'\" {1}/>", agentID, oldTimeSpanValue == 1 ? "checked=\"checked\"" : "");
            timeSpanHtml.AppendFormat("<label for=\"timeSpan_{0}_0\">设置代理时间段</label>", agentID);
            timeSpanHtml.AppendFormat("<div style=\"display: {0}\">", oldTimeSpanValue == 0 ? "none" : "block");
            timeSpanHtml.AppendFormat("<input type=\"text\" id=\"beginTime_{0}\" size=\"16\" maxdate=\"#F{$('endTime_{0}').value}\" onclick=\"new WdatePicker(this, '%Y-%M-%D %h:00', true)\" value=\"{1}\" class=\"tinput\" readonly=\"readonly\" style=\"cursor: pointer; width: 100px\" />~", agentID, oldBeginTime ? oldBeginTime : new Date().Format("yyyy-MM-dd HH:00"));
            timeSpanHtml.AppendFormat("<input type=\"text\" id=\"endTime_{0}\" size=\"16\" mindate=\"#F{$('beginTime_{0}').value}\" onclick=\"new WdatePicker(this, '%Y-%M-%D %h:00', true)\" value=\"{1}\" class=\"tinput\" readonly=\"readonly\" style=\"cursor: pointer; width: 100px\" />", agentID, oldEndTime ? oldEndTime : new Date().AddMonths(1).Format("yyyy-MM-dd HH:00"));
            timeSpanHtml.Append("</div>");
            row.cells[3].innerHTML = timeSpanHtml.ToString();
            
            //按钮
            row.cells[5].innerHTML = "<input type=\"button\" value=\"修改\" onclick=\"UpdateAgent(this)\" class=\"btn\" /> <input type=\"button\" value=\"取消\" onclick=\"CancelChange(this)\" class=\"btn\" />";
        }
        
        function UpdateAgent(el)
        {
            var row = el.parentNode;
            while(row != null && row.tagName != "TR")
            {
                row = row.parentNode;
            }
            var data = {};
            data.UserID = UserID;
            var agentID = row.cells[0].firstChild.getAttribute("agentID");
            data.AgentID = agentID;
            data.IsInherit = row.cells[1].firstChild.checked ? "1" : "0";
            data.Memo = row.cells[2].firstChild.value;
            if(row.cells[3].childNodes[2].checked)
            {
                data.BeginTime = document.getElementById("beginTime_" + agentID).value;
                data.EndTime = document.getElementById("endTime_" + agentID).value;
            }
            row.disabled = true;
            Utility.Ajax.Request({
                    url: "Handler/AgentHandler.ashx?action=UpdateAgent",
                    param: data,
                    success: UpdateAgentHandler
                    });
            
            function UpdateAgentHandler(xmlHttp)
            {
                var result = xmlHttp.responseText.split("$");
                switch(result[0])
                {
                    case "0":
                        //失败
                    case "9":
                        //未登录
                        alert(result[1]);
                        SetError(result[1]);
                        break;
                    case "1":
                        //成功
                        alert(result[1]);
                        row.cells[5].innerHTML = row.cells[5].getAttribute("old");
                        var isAgentOut = true;
                        if(data.BeginTime && data.EndTime)
                        {
                            var nowTime = new Date().Format("yyyy-MM-dd HH:mm");
                            var color = "red";
                            if(data.BeginTime <= nowTime && data.EndTime >= nowTime)
                            {
                                color = "green";
                                isAgentOut = false;
                            }
                            var timeSpanHtml = new Utility.StringBuffer();
                            timeSpanHtml.AppendFormat("<span style=\"color: {0}\">{1}</span>", color, data.BeginTime);
                            timeSpanHtml.Append("<span>&nbsp;~&nbsp;</span>");
                            timeSpanHtml.AppendFormat("<span style=\"color: {0}\">{1}</span>", color, data.EndTime);
                            row.cells[3].innerHTML = timeSpanHtml.ToString();
                        }
                        else
                        {
                            row.cells[3].innerHTML = "<span style=\"color: green\">不限制</span>";
                            isAgentOut = false;
                        }
                        row.cells[2].innerHTML = data.Memo;
                        
                        if(data.IsInherit == "0")
                        {
                            row.cells[1].innerHTML = "<span status=\"0\" style=\"color: red\">已禁用</span>";
                            row.cells[5].childNodes[2].innerHTML = "<input type=\"button\" value=\"启用\" style=\"color: red\" onclick=\"ChangeAgentStatus(this, 1)\" class=\"btn\" />";
                        }
                        else
                        {
                            if(isAgentOut)
                            {
                                row.cells[1].innerHTML = "<span status=\"1\" style=\"color: red\">已启用(代理时间外)</span>";
                            }
                            else
                            {
                                row.cells[1].innerHTML = "<span status=\"1\" style=\"color: green\">已启用(代理时间内)</span>";
                            }
                            row.cells[5].childNodes[2].innerHTML = "<input type=\"button\" value=\"禁用\" onclick=\"ChangeAgentStatus(this, 0)\" class=\"btn\" />";
                        }
                        break;
                }
                row.disabled = false;
            }
        }
        
        //取消修改代理
        function CancelChange(el)
        {
            var row = el.parentNode;
            while(row != null && row.tagName != "TR")
            {
                row = row.parentNode;
            }
            row.cells[1].innerHTML = row.cells[1].getAttribute("old");
            row.cells[2].innerHTML = row.cells[2].getAttribute("old");
            row.cells[3].innerHTML = row.cells[3].getAttribute("old");
            row.cells[5].innerHTML = row.cells[5].getAttribute("old");
        }
        
        function SetError(msg)
        {
            var errorMsg = document.getElementById("errorMsg");
            errorMsg.innerHTML = msg;
            errorMsg.style.display = "";
            document.getElementById("UserName").focus();
            document.getElementById("UserName").select();
        }
        function ClearError()
        {
            var errorMsg = document.getElementById("errorMsg");
            if(errorMsg.style.display != "none")
            {
                errorMsg.style.display = "none";
            }
        }
        
        //设置默认按钮
        function SetDefaultBtn(evt, btnID)
        {
            if(evt.keyCode==13)
            {
                if(!document.getElementById("tat_table_UserName"))
                {
                    document.getElementById(btnID).onclick();
                }
            }
        }
    </script>
</head>
<body>
    <div class="TableForm TLtrover" style="padding: 5px;">
        添加代理人：<input id="UserName" type="text" class="tinput" onkeydown="SetDefaultBtn(event, 'addBtn')" />
        <input id="UserNameID" type="hidden" />
        <input id="addBtn" type="button" value="添加" class="btn" onclick="AddAgent()" />
        <input id="grantBtn" type="button" value="代理组授权" class="btn" onclick="location.href='AgentTree.aspx'" />
        <span id="errorMsg" style="color: Red; display: none"></span>
    </div>
    <div id="agentPanel" runat="server" style="width: 100%"></div>
    <script type="text/javascript">
        var obj = new actb({id: "UserName", url: "../Handler/HRDataLib.ashx?action=SearchUser&userName=", buttonID: "addBtn"});
    </script>
</body>
</html>
