﻿<%@ Page Language="C#" inherits="HDGrid.BasePage" %>
<%@ Import Namespace="Nd.Webs.FrameWork.Utility" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">
        protected string TreeData = "";
        protected void Page_Load(object sender, EventArgs e)
        {
            string t = Request.QueryString["t"];
            HDGrid.CommonTree ct = new HDGrid.CommonTree();
            if (!string.IsNullOrEmpty(Request.QueryString["l"])) ct.MultiLang = true;
            switch (t)
            {
                case "bxs_level":
                    ct.TableName = "BXS_补习级别";
                    break;
                case "jxc_proclass":
                    ct.RootName = "商品分类";
                    ct.TableName = "JXCI_商品分类";
                    break;
                case "jxc_kjkm":
                    ct.RootName = "会计科目";
                    ct.TableName = "JXC_会计科目";
                    break;
                default:
                    if (Request.QueryString["r"] != null)
                        ct.RootName = Request.QueryString["r"];
                    ct.TableName = t;
                    break;
            }
            string action = Request.QueryString["action"];
            switch (action)
            {
                case "EditTreeViewAction":
                    Response.Write(ct.EditTreeViewAction());
                    ct.ClearCache_Related();
                    Response.End();
                    break;
                default:
                    break;
            }

            TreeData = ct.GetTreeNodes();
        }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link type="text/css" rel="stylesheet" href="<%=LibUrl %>/Lib/Skin/<%=Style %>/style.css" id="mystylecss"/>
    <script type="text/javascript" src="/HDGrid/MUI/js/mui-base.js"></script>
    <script type="text/javascript" src="/HDGrid/MUI/js/jquery.pack.js"></script> 
    <script type="text/javascript" src="/HDGrid/MUI/js/MzTreeView/MzTreeView.js"></script>
    <script type="text/javascript" src="js/CommonTreeView.js"></script>
    
<script type="text/javascript">
<!--
    var LangPachs = ['开启管理'
        , '关闭管理'
        , '保存成功'
        , '根结点'
];

    var TreeData = "<% = TreeData %>";
    var TableName = $.q("t");
//-->
</script>
<style> 
#MainFrame{
	overflow:hidden;
	margin:2px;
}
#LeftArea{
	width:200px;margin-right:5px;float:left;
}
#TreeView{
	height:200px;
	overflow:auto;
	padding:5px 5px;
}

#divContextMenu
{
	position:absolute;
	border:solid 1px gray;
	background-color:threedface;
	display:none;
	height:20px;
}
#divContextMenu a:hover
{
	background-color:Blue;
}

</style>
</head>
<body>
    <div style="margin-top: 0px;">
        <div id="TreeView" style="overflow: auto;"></div>
    </div>
    
    <div id="divContextMenu">
        <a href="#" onclick="tree.addSubNode('新节点');" title="新增子节点" style="padding:2px;"><img border="0" alt="" align="absmiddle" src="<%=LibUrl %>/Lib/Skin/Images/edittree/Add.gif" width="16" height="16" /></a>
        <a href="#" onclick="tree.renameNode()" title="重命名" style="padding:2px;"><img border="0" alt="" align="absmiddle" src="<%=LibUrl %>/Lib/Skin/Images/edittree/Rename.gif" width="16" height="16" /></a>
        <a href="#" onclick="tree.deleteNode()" title="删除" style="padding:2px;"><img border="0" alt="" align="absmiddle" src="<%=LibUrl %>/Lib/Skin/Images/edittree/Delete.gif" width="16" height="16" /></a>
        <a href="#" onclick="tree.cutNode()" title="剪切" style="padding:2px;"><img border="0" alt="" align="absmiddle" src="<%=LibUrl %>/Lib/Skin/Images/edittree/Cut.gif" width="16" height="16" /></a>
        <a href="#" onclick="tree.pasteNode()" title="粘贴" style="padding:2px;"><img border="0" alt="" align="absmiddle" src="<%=LibUrl %>/Lib/Skin/Images/edittree/Paste.gif" width="16" height="16" /></a>
        <a href="#" onclick="tree.moveUpNode()" title="上移" style="padding:4px;"><img border="0" alt="" align="absmiddle" src="<%=LibUrl %>/Lib/Skin/Images/edittree/ShiftUp.gif" width="12" height="12" /></a>
        <a href="#" onclick="tree.moveDownNode()" title="下移" style="padding:4px;"><img border="0" alt="" align="absmiddle" src="<%=LibUrl %>/Lib/Skin/Images/edittree/ShiftDown.gif" width="12" height="12" /></a>
    </div>
</body>
</html>
