﻿var tree;
$(function() {
    //return;
    tree = new CommonTreeView("treeview");
    tree.setDataSource(TreeData);

    tree.setContextMenu(document.getElementById("divContextMenu"));
    tree.setEditable(true);
    if($.q("exp")=="1") tree.expandAll = true;
    //alert(tree.toHTML());
    tree.element = document.getElementById('TreeView');
    document.getElementById('TreeView').innerHTML = tree.toHTML();
    tree.showContextMenu = true;

    $("#aToggleAdmin").bind("click", function(e) {
        var el = document.getElementById("aToggleAdmin");
        if (el.innerHTML == "[" + LangPachs[0] + "]") {
            el.innerHTML = "[" + LangPachs[1] + "]";
            tree.showContextMenu = true;
            tree.mf_ShowConextMenu();
        } else {
            el.innerHTML = "[" + LangPachs[0] + "]";
            tree.showContextMenu = false;
            tree.hideConextMenu();
        }
    });
    if (!($.browser.msie && $.browser.version == "6.0")) $(window).bind("resize", HandleOnResize);
    HandleOnResize();
});
function HandleOnResize() {
    var h = $(window).height() - 10;
    $("#TreeView").height(h);
}
 //////////////////////////////////////
//Include(_BasePath + "js/MzTreeView/MzTreeView.js");
function CommonTreeView(TName) {
    if (_moInPrototype) return;
    MzTreeView.call(this, TName);
    this.init2();
}
_p = Inherit(CommonTreeView, MzTreeView, "CommonTreeView");
//_p = CommonTreeView.prototype = new MzTreeView;

_p.init2 = function() {
    this.loadDataAtOnce = true;
    this.addEventListener("addto", this._onAddToNode, this);
    this.addEventListener("rename", this._onRenameNode, this);
    this.addEventListener("delete", this._onDeleteNode, this);
    this.addEventListener("moveto", this._onMoveToNode, this);
    this.addEventListener("moveup", this._onMoveUpNode, this);
    this.addEventListener("movedown", this._onMoveDownNode, this);
    this.addEventListener("focus", this._onFocus, this);
    this.nodes['0_1'] = 'text:'+LangPachs[3];
};
_p.setDataSource = function(data) {
    if (!data) return;
    eval(data);
};
_p.nodeInit = function(sourceIndex, parentId) {
    //alert(sourceIndex);
    this.index++;
    var source = this.nodes[sourceIndex], d = this.divider;
    var text = this.getAttribute(source, "text");
    var hint = this.getAttribute(source, "hint");
    var sid = sourceIndex.substr(sourceIndex.indexOf(d) + d.length);
    var node = this.node[this.index] =
	{
	    "id": String(this.index),
	    "text": text,
	    "hint": hint ? hint : text,
	    "icon": this.getAttribute(source, "icon"),
	    "path": this.node[parentId].path + d + this.index,
	    "isLoad": false,
	    "isBuild": false,
	    "isExpand": false,
	    "parentId": parentId,
	    "parentNode": this.node[parentId],
	    "sourceIndex": sourceIndex,
	    "sourceId": sid,
	    "childAppend": "",
	    "nodeType": this.getAttribute(source, "nt"), //1-folder；0-file
	    "showno": this.getAttribute(source, "showno")
	};
    this.nodes[sourceIndex] = "index:" + this.index + ";" + source;
    node.hasChild = this.names.search(new RegExp("(^|" + this._d + ")" + sid + d)) > -1 || (!this.loadDataAtOnce && this.getAttribute(source, "hcn") == "1");
    //if(node.hasChild)  
    node.childNodes = [];
    return node;
};
_p.buildNode = function(id) {
    var node = this.node[id];
    if (node.isBuild) return;
    if (node.hasChild) {

        var tcn = this.node[id].childNodes; //.sort(this.sortFolders);
        var str = "";
        for (var i = 0; i < tcn.length; i++)
            str += this.nodeToHTML(tcn[i], i == tcn.length - 1);
        var temp = this.getElementById(this.name + "_tree_" + id).childNodes;
        temp[temp.length - 1].innerHTML = str;
        node.isBuild = true;
    }
};
_p.sortFolders = function(a, b) {
    return (a.text).localeCompare(b.text);
};

/////////////////////////////////Event Function//////////////////////////////////////////
_p._onFocus = function() {
    //this.contextNode = this.currentNode;
    //alert(this.contextNode.text);
    //ShowDeptParam(this.currentNode.sourceId);
};
_p._onLoad = function(e) {
//    if (this.rootNode.childNodes.length > 0)
//        this.focusClientNode(this.rootNode.childNodes[0].id);
//    else
        this.focusClientNode("1");

    tree.hideConextMenu();
};

_p._onAddToNode = function(e) {

};

_p.addSiblingNode = function(text) {
    var pid = this.currentNode.parentNode.id;
    return this.addNode(text, "1", pid);
};
_p.addSubNode = function(text) {
    var pid = this.currentNode.id;
    return this.addNode(text, "1", pid);
};
_p.addNode = function(text, nodeType, pnId) {
    if (!this.editable) return;
    var newNode;
    if (pnId == null) pnId = this.contextNode.id;
    var ret = $.ajax({
    url: "?action=EditTreeViewAction&subaction=add&Name=" + escape(text) + "&ParentID=" + this.node[pnId].sourceId + "&Layer=" + (this.getLevel(pnId) + 1) + "&t=" + TableName + "&l=" + ($.q("l")||"") + "&rnd=" + Math.random(),
        async: false
    }).responseText;
    if (ret == "0") {
        alert("error!");
        return null;
    }
    else {
        newNode = this.newNode(pnId, text, nodeType, null, ret);
    }
    this.resumeColor();
    this.hideConextMenu();
    return newNode;
};
_p._onRenameNode = function(e) {
    var a = this.renameInputEl.parentNode.firstChild;
    var id = a.id.substr(a.id.lastIndexOf("_") + 1);
    var ret = $.ajax({
    url: "?action=EditTreeViewAction&subaction=rename&ID=" + this.node[id].sourceId + "&Name=" + escape(this.renameInputEl.value.trim()) +  "&t=" + TableName + "&l=" + ($.q("l")||""),
        async: false
    }).responseText;
    if (!ret) {
        e.preventDefault();
        alert("error!");
    }
};
_p._onDeleteNode = function(e) {
    var ret = $.ajax({
    url: "?action=EditTreeViewAction&subaction=delete&ID=" + this.contextNode.sourceId +  "&t=" + TableName + "&l=" + ($.q("l")||""),
        async: false
    }).responseText;
    if (!ret) {
        e.preventDefault();
        alert("error!");
    }
};
_p._onCopyToNode = function(e) {
};
_p._onMoveToNode = function(e) {
    var ret = $.ajax({
    url: "?action=EditTreeViewAction&subaction=moveto&SrcID=" + this.currentCutNode.sourceId + "&DesID=" + this.contextNode.sourceId +  "&t=" + TableName + "&l=" + ($.q("l")||""),
        async: false
    }).responseText;
    if (ret == "0") {
        e.preventDefault();
        //alert(ret);
    }
};

_p._onMoveUpNode = function(e) {
    var ret = $.ajax({
    url: "?action=EditTreeViewAction&subaction=moveup&SrcID=" + this.contextNode.sourceId + "&DesID=" + this.desNode.sourceId + "&SrcShowNO=" + this.contextNode.showno + "&DesShowNO=" + this.desNode.showno +  "&t=" + TableName + "&l=" + ($.q("l")||""),
        async: false
    }).responseText;
    if (ret == "0") {
        e.preventDefault();
        //alert(ret);
    } else {
        var tmp = this.contextNode.showno;
        this.contextNode.showno = this.desNode.showno;
        this.desNode.showno = tmp;
    }
};
_p._onMoveDownNode = function(e) {
    var ret = $.ajax({
    url: "?action=EditTreeViewAction&subaction=movedown&SrcID=" + this.contextNode.sourceId + "&DesID=" + this.desNode.sourceId + "&SrcShowNO=" + this.contextNode.showno + "&DesShowNO=" + this.desNode.showno +  "&t=" + TableName + "&l=" + ($.q("l")||"") ,
        async: false
    }).responseText;
    if (ret == "0") {
        e.preventDefault();
        alert(ret);
    } else {
        var tmp = this.contextNode.showno;
        this.contextNode.showno = this.desNode.showno;
        this.desNode.showno = tmp;
    }
};
_p.dispose = function() {
    if (this._disposed) return;
    MzTreeView.prototype.dispose.call(this);
};
