﻿
function getCookie(name) {
    var arr = document.cookie.match(new RegExp("(^| )" + name + "=([^;]*)(;|$)"));
    if (arr != null) return arr[2]; return null;
};
function getEditorLangType() {
    var lan = getCookie("langtype");
    switch (lan) {
        case "cn":
            return "zh";
        case "en":
            return "en";
        default:
            return "zh";
    };
}
var cfg = {
    //mode : "textareas",
    mode: "exact",
    elements: "ddc",
    theme: "advanced",
    plugins: "style,layer,table,advimage,inlinepopups,media,searchreplace,contextmenu,paste,save,fullscreen",
    //plugins: "style,table,emotions,inlinepopups,insertdatetime,preview,blogimage,media,searchreplace,contextmenu,paste,fullscreen",
    theme_advanced_buttons1: "formatselect,fontselect,fontsizeselect,bold,italic,underline,|,justifyleft,justifycenter,justifyright,justifyfull,|,bullist,numlist,|,outdent,indent,|,forecolor,backcolor,styleprops,|",
    theme_advanced_buttons2: "cut,copy,paste,pastetext,pasteword,search,removeformat,sweeperformat,|,undo,redo,|,tablecontrols,|,hr,image,insertlayer,absolute,|,fullscreen",
    theme_advanced_toolbar_location: "top",
    theme_advanced_toolbar_align: "left",
    theme_advanced_statusbar_location: "bottom",
    theme_advanced_modebutton: 1, //cwm
    theme_advanced_inline_sourcecode: 1, //cwm
    theme_advanced_changesize: 300, //cwm
    theme_advanced_resizing: true,
    theme_advanced_path: false,

    // Example content CSS (should be your site CSS)
    content_css: "css/content.css",
    language: getEditorLangType()
//    , save_onsavecallback: function(ed) {
//        onSave(ed.getContent({ format: 'raw' }));
//    }
}
var tmr;
$(function() {
    tinyNDE.init(cfg);
    $(window).bind("resize", HandleOnResize);
    tmr = window.setInterval(HandleOnResize, 300);
    HandleOnResize();
});

function HandleOnResize() {
    //	        var wh = $(window).height(), ww = $(window).width();
    //	        $("#ddc").width(ww - 12 + 12);
    //	        $("#ddc").height(wh - 30 - 12);
    if (document.getElementById("ddc_ifr")) {
        var toolBarH = 26 + 26 + 25; //36 + 27+15;
        var hh = $(window).height() - toolBarH - 30 - 8;
        //alert(hh);
        document.getElementById("ddc_preview").style.height = document.getElementById("ddc_code").style.height = document.getElementById("ddc_ifr").style.height = hh + "px";

        clearInterval(tmr);
    }
}
$(function() {
    if ($.q("pos") == "1") $("#liAddEdit").hide();
    $("#btnAddField").click(function() {
        var fieldVal = $("#fieldName").val();
        if (fieldVal == "") return;
        tinyNDE.execCommand('ndeInsertContent', false, fieldVal);
    });
    $("#btnAddEditField").click(function() {
        var fieldVal = $("#fieldName").val();
        if (fieldVal == "") return;
        tinyNDE.execCommand('ndeInsertContent', false, "{" + fieldVal + "}");
    });

    $("#btnPrint").click(function() {
        var sb = [];
        sb.push("<link type=\"text/css\" rel=\"stylesheet\" href=\"/HDGrid/HtmlEditor/themes/advanced/skins/default/content.css\">");
        sb.push("<style type='text/css'>body{margin:0px;}</style>");
        var con = tinyNDE.get('ddc').getContent();
        var upw = $("#upwidth").val();
        if (!isNaN(upw)) upw += "px";
        var leftw = $("#leftwidth").val();
        if (!isNaN(leftw)) leftw += "px";
        sb.push("<div style=\"position: relative;left:", leftw, ";top:", upw, ";\">");
        sb.push(con);
        sb.push("</div>");
        printHtml(sb.join(""), function() {
        });
    });
    $("#btnSave").click(onSave);

});


var templateid;
function onSave() {
    if (templateid == null) templateid = $.q("id")||$.g("templateid").value;
    var sb = [];
    sb.push("{"
    , "\"us\":\"", $("#upwidth").val(), "\""
    , ",\"ls\":\"", $("#leftwidth").val(), "\""
    , "}");
    var con = tinyNDE.get('ddc').getContent();
    //return;
    var data = {
        tid: templateid || ""
        , from: $.q("f")
        , type: $.q("t")
        , pager: $.q("p")
        , name: $.g("templatename").value
        , config: sb.join("")
	    , content: con
    };
    $.post("?act=save&rnd=" + Math.random(), data, function(ret) {
        if (ret && !isNaN(ret)) {
            templateid = ret;
            alert("saved successfully!");
            if (parent.child && typeof (parent.TemplateID) != 'undefined') {
                parent.TemplateID = templateid;
            }
            return;
        }
        if (ret) alert(ret);
        else {
            alert("saved successfully!");
            if (parent.child && typeof (parent.TemplateID) != 'undefined') {
                parent.TemplateID = templateid;
            }
        }
    });
}
