﻿<%@ WebHandler Language="C#" Class="autosuggest" %>

using System;
using System.Web;
using System.Data;
using System.IO;
using System.Collections.Specialized;
using System.Text.RegularExpressions;
using MUI.Components.Database;

public class autosuggest : IHttpHandler {

    public void ProcessRequest(HttpContext context)
    {
        context.Response.ContentType = "text/plain";

        string callback = context.Request.QueryString["callback"];
        string info = GetDataList_actb(context);
        info = Regex.Replace(info, "\r|\n", "").Replace("\"", "\\\"");
        context.Response.Write(String.Format("{0}(\"{1}\")", callback, info));
    }

    public static string GetDataList_actb(HttpContext context)
    {
        string connStr = context.Request.QueryString["con"];
        string sql = context.Request.QueryString["sql"];
        int sec = Convert.ToInt32(context.Request.QueryString["sec"] ?? "300");//缓存秒数
        string cacheKey = context.Request.QueryString["ckey"];
        bool isClear = context.Request.QueryString["clear"] == "1";//是否清除缓存
        bool isPY = context.Request.QueryString["py"] == "1";//是否拼音搜索
        bool isGetData = context.Request.QueryString["get"] == "1";//是否第一次返回数据
        bool isHavingID = context.Request.QueryString["hid"] == "1";
        
        string input = context.Request.QueryString["val"];//搜索值
        bool isQuery = context.Request.QueryString["q"] == "1";//是否来自查询区字段
        bool isCacheStr=false;//是否缓存字符串
        if(isGetData) isCacheStr=true;//如果是第一次返回数据，则缓存字符串
        string sRet = "";
        DataTable dt = null;
        if(string.IsNullOrEmpty(cacheKey)) cacheKey = sql.Replace(" ", "").Replace(",", "");// +"_" + Nd.Webs.EaLogin.EaUser.Instance.CorpID;
        if (isClear) HttpContext.Current.Cache.Remove(cacheKey);
        if (isCacheStr && HttpContext.Current.Cache[cacheKey] != null)
        {
            return (String)HttpContext.Current.Cache[cacheKey];
        }
        else
        {
            if (HttpContext.Current.Cache[cacheKey] == null)
            {
                if (!string.IsNullOrEmpty(connStr)) { if (System.Configuration.ConfigurationManager.ConnectionStrings[connStr] == null)connStr = System.Configuration.ConfigurationSettings.AppSettings[connStr]; else connStr = System.Configuration.ConfigurationManager.ConnectionStrings[connStr].ConnectionString; }
                MUI.Components.Database.DbOperator objDB = MUI.Components.Database.DbBridge.GetDbOperator(connStr);
                dt = objDB.ExecSqlForTable(sql);
                objDB.Dispose();
                if (dt != null)
                {
                    if (dt.Columns.Count == 1) isHavingID = false;
                    if (isPY)
                    {
                        //构建拼音名
                        dt.Columns.Add("PY", typeof(string));
                        foreach (DataRow dr in dt.Rows)
                        {
                            dr["PY"] = MUI.Components.Utility.CommonAPI.GetLetterFromString(isHavingID ? dr[1].ToString() : dr[0].ToString());
                        }
                    }
                    if (!isCacheStr) HttpContext.Current.Cache.Insert(cacheKey, dt, null, DateTime.Now.AddSeconds(sec), TimeSpan.Zero);
                }
            }
            else
            {
                dt = (DataTable)HttpContext.Current.Cache[cacheKey];
            }
            if (dt == null) return sRet;
            int l = dt.Columns.Count;
            if (l == 1 || (isPY && l == 2)) isHavingID = false;
            string colID = "", colName = "";
            if (isHavingID)
            {
                colID = dt.Columns[0].ColumnName;
                colName = dt.Columns[1].ColumnName;
            }
            else
            {
                colName = dt.Columns[0].ColumnName;
            }
            System.Text.StringBuilder str = new System.Text.StringBuilder();
            DataRow[] drs = null;
            string where = "";
            if (!string.IsNullOrEmpty(input))
            {
                #region 获取查询条件
                if (isPY)
                {
                    where = string.Format("{0} like '%{1}%' or PY like '%{1}%'", colName, input);
                    if (isHavingID)
                    {
                        if (l > 3)
                        {
                            for (int i = 2; i < l - 1; i++)
                            {
                                where += " or " + string.Format("{0} like '%{1}%'", dt.Columns[i].ColumnName, input);
                            }
                        }
                    }
                    else
                    {
                        if (l > 2)
                        {
                            for (int i = 1; i < l - 1; i++)
                            {
                                where += " or " + string.Format("{0} like '%{1}%'", dt.Columns[i].ColumnName, input);
                            }
                        }
                    }
                }
                else
                {
                    where = string.Format("{0} like '%{1}%'", colName, input);
                    if (isHavingID)
                    {
                        if (l > 2)
                        {
                            for (int i = 2; i < l - 1; i++)
                            {
                                where += " or " + string.Format("{0} like '%{1}%'", dt.Columns[i].ColumnName, input);
                            }
                        }
                    }
                    else
                    {
                        if (l > 1)
                        {
                            for (int i = 1; i < l - 1; i++)
                            {
                                where += " or " + string.Format("{0} like '%{1}%'", dt.Columns[i].ColumnName, input);
                            }
                        }
                    }
                }
                drs = dt.Select(where);
                #endregion
            }
            else
            {
                drs = dt.Select();
            }
            foreach (DataRow dr in drs)
            {
                if (isGetData && string.IsNullOrEmpty(input))
                {
                    if (isHavingID)
                    {
                        str.Append(dr[colID].ToString() + "," + dr[colName].ToString());
                        for (int i = 2; i < l; i++)
                        {
                            str.AppendFormat(";{0}", dr[dt.Columns[i].ColumnName].ToString());
                        }
                    }
                    else
                    {
                        str.Append(dr[colName].ToString());
                        for (int i = 1; i < l; i++)
                        {
                            str.AppendFormat(";{0}", dr[dt.Columns[i].ColumnName].ToString());
                        }
                    }
                    str.Append("|");

                }
                else
                {
                    if (isHavingID)
                    {
                        str.Append(dr[colID].ToString() + "," + dr[colName].ToString() + "|");
                    }
                    else
                    {
                        str.Append(dr[colName].ToString() + "|");
                    }
                }
            }
            if (isQuery && isHavingID) str.Append("全部" + ",|");
            if (str.Length > 0)
            {
                sRet = str.ToString().TrimEnd('|');
            }
            if (isCacheStr) HttpContext.Current.Cache.Insert(cacheKey, sRet, null, DateTime.Now.AddSeconds(sec), TimeSpan.Zero);
            return sRet;
        }
    }
    public bool IsReusable {
        get {
            return false;
        }
    }

}