﻿<%@ Page Language="C#" %>
<%@ Import Namespace="Nd.Webs.FrameWork.Utility" %>
<script runat="server">
    protected void Page_Load(object sender, EventArgs e)
    {
        this.btnUpload.Text = "上传";
    }
    #region Web 窗体设计器生成的代码
	override protected void OnInit(EventArgs e)
	{
		//
		// CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
		//
		InitializeComponent();
		base.OnInit(e);
	}
	
	/// <summary>
	/// 设计器支持所需的方法 - 不要使用代码编辑器修改
	/// 此方法的内容。
	/// </summary>
	private void InitializeComponent()
	{    
		this.btnUpload.Click += new System.EventHandler(this.btnUpload_Click);
		this.Load += new System.EventHandler(this.Page_Load);

	}
	#endregion
    protected void btnUpload_Click(object sender, EventArgs e)
    {
        int maxSize = 10000;//KB
        string filterExt = "*";
        string savePath = System.Configuration.ConfigurationSettings.AppSettings["UploadPath"];

        string uploadType = Request.QueryString["type"];
        if (!string.IsNullOrEmpty(Request.QueryString["maxsize"])) maxSize = Int32.Parse(Request.QueryString["maxsize"]);
        if (!string.IsNullOrEmpty(Request.QueryString["filterExt"])) filterExt = Request.QueryString["filterExt"];
        if (Request.QueryString["savePath"] != null) savePath = Request.QueryString["savePath"];
        else savePath += string.Concat(Nd.Webs.EaLogin.EaUser.Instance.CorpID + "/HDGrid");
        if (uploadType == "2")
        {
            #region 上传到数据库
            if (uploadedFile.PostedFile == null || uploadedFile.PostedFile.ContentLength == 0 || uploadedFile.PostedFile.FileName.Length < 3)
            {
                return;
            }
            //文件大小限制判断
            if (maxSize > 0 && uploadedFile.PostedFile.ContentLength > maxSize * 1000)
            {
                Page.ClientScript.RegisterStartupScript(typeof(Page),"_FileSize", "ErrorTip('文件大小不能超过" + maxSize + "KB！');",true);
                return;
            }
            //文件类型 限制判断
            string sExtensionName = System.IO.Path.GetExtension(uploadedFile.PostedFile.FileName).Replace(".", "").ToLower();
            if (filterExt.ToLower().IndexOf("*") == -1 && filterExt.ToLower().IndexOf(sExtensionName) == -1)
            {
                Page.ClientScript.RegisterStartupScript(typeof(Page),"_FileType", "ErrorTip('上传文件类型不符');",true);
                return;
            }
            //文件正确			
            try
            {
                Cache.Remove(string.Concat("Cache_UF_",Request.ServerVariables["REMOTE_HOST"] ,"_", Request.QueryString["fn"]));
                Cache.Insert(string.Concat("Cache_UF_",Request.ServerVariables["REMOTE_HOST"] ,"_", Request.QueryString["fn"]), MUI.Components.Utility.CommonAPI.ReadFileToBinary(uploadedFile), null, DateTime.Now.AddMinutes(10), TimeSpan.Zero);
                Page.ClientScript.RegisterStartupScript(typeof(Page), "ksjsdfs", "ReturnResult('" + Guid.NewGuid().ToString() + "');", true);
            }
            catch
            {
                this.Page.ClientScript.RegisterStartupScript(typeof(Page),"_UploadFile", "ErrorTip('文件上传失败');",true);
            }
            #endregion
        }
        else
        {
            #region 上传到文件夹
            if (uploadedFile.PostedFile == null || uploadedFile.PostedFile.ContentLength == 0 || uploadedFile.PostedFile.FileName.Length < 3)
            {
                return;
            }
            //文件大小限制判断
            if (maxSize > 0 && uploadedFile.PostedFile.ContentLength > maxSize * 1000)
            {
                this.Page.ClientScript.RegisterStartupScript(typeof(Page),"_FileSize", "ErrorTip('文件大小不能超过" + maxSize + "KB！');",true);
                return;
            }
            //文件类型 限制判断
            string sExtensionName = System.IO.Path.GetExtension(uploadedFile.PostedFile.FileName).Replace(".", "").ToLower();
            if (!string.IsNullOrEmpty(filterExt) && filterExt.ToLower().IndexOf("*") == -1 && filterExt.ToLower().IndexOf(sExtensionName) == -1)
            {
                this.Page.ClientScript.RegisterStartupScript(typeof(Page),"_FileType", "ErrorTip('上传文件类型不符');",true);
                return;
            }
            //文件正确
            savePath = savePath.Replace("yyyy", DateTime.Now.Year.ToString()).Replace("YYYY", DateTime.Now.Year.ToString()).Replace("mm", DateTime.Now.Month.ToString("00")).Replace("MM", DateTime.Now.Month.ToString("00")).Replace("dd", DateTime.Now.Day.ToString("00")).Replace("DD", DateTime.Now.Day.ToString("00"));
            string physicalPath = Server.MapPath(savePath);
            if (!System.IO.Directory.Exists(physicalPath)) System.IO.Directory.CreateDirectory(physicalPath);
            if (physicalPath.EndsWith("/") == false) physicalPath += "/";
            string sFileName = MUI.Components.ClassLib.FileManager.GetRndFileName(System.IO.Path.GetExtension(uploadedFile.PostedFile.FileName).Substring(1));
            try
            {
                uploadedFile.PostedFile.SaveAs(string.Concat(physicalPath, sFileName));
            }
            catch
            {
                this.Page.ClientScript.RegisterStartupScript(typeof(Page),"_FileType", "ErrorTip('文件上传失败，请检查文件夹" + savePath + "写权限！');",true);
                return;
            }
            string virtualPath = savePath;
            if (virtualPath.EndsWith("/") == false) virtualPath += "/";
            Page.ClientScript.RegisterStartupScript(typeof(Page), "ksjfs", "ReturnResult('" + virtualPath.Replace("~", Request.ApplicationPath == "/" ? "" : Request.ApplicationPath) + sFileName + "');", true);
            #endregion
        }
    }
</script>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title></title>

<script type="text/javascript">

    function GetQueryString(name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
        var r = window.location.search.substr(1).match(reg);
        if (r != null) return unescape(r[2]); return null;
    }
    function g(id) {
        return document.getElementById(id);
    }
    var fc = GetQueryString("fc");
    function submit() {
        //document.getElementById("btnUpload").click();
    }
    function ErrorTip(msg) {
        alert(msg);
    }
    function ReturnResult(virpath) {
        var obj = parent.document.getElementById("C_" + GetQueryString("fn"));
        if (obj) {
            obj.value = virpath;
            parent.FireEvent(obj, "change");
            alert('上传成功');
        }
        else {
            alert(virpath);
        }
    }
    function RemoveUploadFile() {
        parent.window[fc].RemoveUploadFile(GetQueryString("fn"), GetQueryString("type"));
    }
</script>


</head>
<body style="margin: 0px; background-color: transparent;overflow:hidden;" scroll="no">
    <form id="Form1" method="post" enctype="multipart/form-data" runat="server">
    <table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
            <td><input id="uploadedFile" type="file" style="font-size: 12px; width: 99%;" name="uploadedFile" runat="server"/></td>
            <td width="54px;" align="center"><asp:Button ID="btnUpload" runat="server" Text="upload" Style="font-size: 12px;width:50px;"></asp:Button><input type="hidden" id="hRetUploadPath" runat="server"/></td>
            <td width="22px;" align="center" id="tdDel"><input type="button" style="font-size: 12px;background:threedface url(../images/delete.gif) no-repeat scroll center center;width:22px;height:22px;" value=" " onclick="RemoveUploadFile()" /></td>
        </tr>
    </table>
    </form>
</body>

<script type="text/javascript">
    if (parent.window[fc].state == 1) g("tdDel").style.display = "none";
</script>
</html>