﻿<%@ Page Language="C#" %>
<%@ Import Namespace="Nd.Webs.FrameWork.Utility" %>
<script runat="server"> 
    protected void Page_Load(object sender, EventArgs e)
    {
        int maxSize = 2000;//KB
        string filterExt = "*";
        string savePath = System.Configuration.ConfigurationSettings.AppSettings["UploadPath"];
        string uploadType = Request.QueryString["type"];
        string fileName = "";//保存文件名
        int width = 0, height = 0; //压缩尺寸        
        
        if (!string.IsNullOrEmpty(Request.QueryString["maxsize"])) maxSize = Int32.Parse(Request.QueryString["maxsize"]);
        if (!string.IsNullOrEmpty(Request.QueryString["filterext"])) filterExt = Request.QueryString["filterext"].ToLower();
        if (!string.IsNullOrEmpty(Request.QueryString["savepath"])) savePath = Request.QueryString["savepath"];
        else savePath += string.Concat(Nd.Webs.EaLogin.EaUser.Instance.CorpID + "/unknown");
        if (!string.IsNullOrEmpty(Request.QueryString["filename"])) fileName = Request.QueryString["filename"];
        if (!string.IsNullOrEmpty(Request.QueryString["width"])) width =Int32.Parse( Request.QueryString["width"]);
        if (!string.IsNullOrEmpty(Request.QueryString["height"])) height = Int32.Parse(Request.QueryString["height"]);

        if (flUploadFile.PostedFile == null) return;
        HttpPostedFile postedFile = flUploadFile.PostedFile;
        string originalFileName = System.IO.Path.GetFileName(postedFile.FileName);

        //判断文件大小是否超出允许上传的最大限制	
        if (postedFile.ContentLength / 1024 > maxSize)
        {
            Page.ClientScript.RegisterClientScriptBlock(typeof(Page), "ksdjdf", "alert('" + "文件太大" + "');", true);
            return;
        }
        //判断文件扩展名
        string ext = System.IO.Path.GetExtension(postedFile.FileName).ToLower();
        string ext2=ext.Substring(1);
        if (filterExt.IndexOf("*") == -1 && filterExt.IndexOf(ext2) == -1)
        {
            Page.ClientScript.RegisterClientScriptBlock(typeof(Page), "ksdddjf", "alert('" + "文件类型不符" + "');", true);
            return;
        }

        if (string.IsNullOrEmpty(fileName))
        {
            if (originalFileName.Length > 34) 
                fileName = originalFileName.Substring(0, 30) + ext;
            else
                fileName = originalFileName;
        }
        else
        {
            if (fileName == "rnd")
                fileName = MUI.Components.ClassLib.FileManager.GetRndFileName(ext2);
            else
                fileName += ext;
        }
        savePath = savePath.Replace("yyyy", DateTime.Now.Year.ToString()).Replace("YYYY", DateTime.Now.Year.ToString()).Replace("mm", DateTime.Now.Month.ToString("00")).Replace("MM", DateTime.Now.Month.ToString("00")).Replace("dd", DateTime.Now.Day.ToString("00")).Replace("DD", DateTime.Now.Day.ToString("00"));
        string physicalPath = Server.MapPath(savePath);
        if (!System.IO.Directory.Exists(physicalPath)) System.IO.Directory.CreateDirectory(physicalPath);
        if (!physicalPath.EndsWith("/")) physicalPath += "/";
        string sSavePath = string.Concat(physicalPath, fileName);

        bool success = true;
        if (width != 0 || height != 0)
        {
            success = MUI.Components.Utility.CommonAPI.UploadImage(postedFile.InputStream, sSavePath, width, height);
        }
        try
        {
            //if (System.IO.File.Exists(sSavePath)) 
            //    System.IO.File.Delete(sSavePath);
            flUploadFile.PostedFile.SaveAs(sSavePath);
        }
        catch
        {
            success = false;
        }
        if(!success){
            this.Page.ClientScript.RegisterStartupScript(typeof(Page), "wjscsb", "alert('"+"文件上传失败"+"');", true);
            return;
        }

        string virtualPath = savePath;
        if (virtualPath.EndsWith("/") == false) virtualPath += "/";
        Page.ClientScript.RegisterStartupScript(typeof(Page), "wjsccg", "AfterUpload('" + string.Concat(virtualPath, fileName) + "',"+postedFile.ContentLength+");", true);            
    }
</script>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>文件上传</title>
<script type="text/javascript">
    function GetQueryString(name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
        var r = window.location.search.substr(1).match(reg);
        if (r != null) return unescape(r[2]); return null;
    }
    //获取指定格式的文件或文件夹大小尺寸
    function GetFormatFileLengthString(size) {
        if (size >= 1073741824) {
            return (size / 1073741824).toFixed(2) + "GB";
        }
        else if (size >= 1048576) {
            return (size / 1048576).toFixed(2) + "MB";
        }
        else if (size >= 1024) {
            return (size / 1024).toFixed(2) + "KB";
        }
        else
            return size + "Bytes";
    }
    function AddFile() {
        var el = document.getElementById("flUploadFile");
        var v = el.value;
        if (v == "") {
            alert('请选择要上传的文件');
            return;
        }
        var exts = GetQueryString("filterext").toLowerCase();
        var ext = v.substr(v.lastIndexOf(".") + 1).toLowerCase();
        if (exts.indexOf("*") == -1 && exts.indexOf(ext) == -1) {
            alert('上传文件类型不符');
            return false;
        }
        var form = document.getElementById("form1");
        form.submit();
        //form.reset();
        return true;
    }
    function AfterUpload(virpath,size) {
       if(GetQueryString("tip")!="0") alert('上传成功');
        var cb = GetQueryString("cb");
        if (cb) {
            parent[cb](virpath, GetFormatFileLengthString(size), unescape(GetQueryString("data")), document.getElementById("lblText"));
        }
        else {
            alert("请指定回调函数！");
        }
    }
    function RemoveUploadFile() {
        var cb = GetQueryString("cbdel");
        if (cb) {
            parent[cb]();
        }
        else {
            alert("请指定回调函数！");
        }
    }
    function onLoad() {
        var cb = GetQueryString("init");
        if (cb) {
            document.getElementById("btn").className = "";
            parent[cb](document.getElementById("lblText"), document.getElementById("flUploadFile"));
        }
        else {
            
        }
    }
</script>
<style type="text/css">
    a.addfile1 {
    background: url("images/org_select.png") no-repeat scroll 0 4px transparent;
    color: #207BD6;
    display: inline-block;
    padding-left: 12px;
    position: relative;
    font-size: 12px;
    text-decoration: none;
    height: 22px; 
    line-height: 22px; 
}
a.addfile2 {
    background: url("images/btns.gif") no-repeat scroll -9px -58px transparent;
    display: inline-block;
    padding-left: 0px;
    position: relative;
    overflow: hidden;
    text-decoration: none;
    text-align:center;
    width: 55px;
    height: 25px; 
    line-height: 25px; 
    margin-top: 0px;
    font-size: 12px;
    color:#000000;
}
.inputfile{
    cursor: pointer;
    left: -5px;
    opacity: 0;filter:alpha(opacity=0);
    position: absolute;
    width: 60px;
    z-index:9999;
}
</style>
</head>
<body onload="onLoad()" style="margin: 0px; background-color: transparent;overflow:hidden;width:100%" scroll="no">
    <form id="form1" method="post" enctype="multipart/form-data" runat="server">  
         <table id="tb" border="0" cellpadding="0" cellspacing="0" width="100%">
            <tr>
                <td align="right"><a id="btn" href="javascript:void(0);" onclick="this.blur();" class="addfile2"><div id="lblText" style="position:relative;z-index:9;display:inline;left:0px;font-size:12px;">上传</div><input class="inputfile" id="flUploadFile" type="file" onchange="AddFile();" hidefocus="true" size="1" runat="server"/></a></td>
                <td align="center" id="tdDel" style="padding-left:3px;"><a href="javascript:void(0);" class="addfile2" onclick="RemoveUploadFile();this.blur();">删除</a></td>
            </tr>
        </table>  
    </form>
</body>

<script type="text/javascript">
    if (GetQueryString("cbdel") == null || GetQueryString("cbdel") == "") document.getElementById("tdDel").style.display = "none";
    if (GetQueryString("btn") == "0")
        document.getElementById("btn").className = "addfile1";
    else if (GetQueryString("btn") == "clear")
        document.getElementById("btn").className = "";
    if(GetQueryString("text") != null) {
        document.getElementById("lblText").innerHTML = unescape(GetQueryString("text"));
    }
</script>
</html>