﻿<%@ WebHandler Language="C#" Class="getcss" %>

using System;
using System.Web;
using System.Text.RegularExpressions;

public class getcss : IHttpHandler {

    public void ProcessRequest(HttpContext context)
    {
        context.Response.ContentType = "text/plain";
        //context.Response.Write("Hello World");

        string path = context.Request.QueryString["path"];
        string minWidth = context.Request.QueryString["mw"];
        string winWidth = context.Request.QueryString["ww"];
        string discount = context.Request.QueryString["dis"];

        string cacheKey = string.Empty;
        if (string.IsNullOrEmpty(minWidth))
            cacheKey = path;
        else
            cacheKey = string.Concat(path, "_",discount??"1", winWidth);
        if (HttpContext.Current.Cache[cacheKey] == null)//true || 
        {
            System.IO.StreamReader sr = new System.IO.StreamReader(System.Web.HttpContext.Current.Server.MapPath(path), System.Text.Encoding.UTF8);
            string content = sr.ReadToEnd();
            sr.Close();
            if (!string.IsNullOrEmpty(minWidth))
            {
                decimal pp = Math.Round(((Convert.ToDecimal(winWidth) / Convert.ToDecimal(minWidth)))*Convert.ToDecimal(discount??"1"), 2);
                Regex re = new Regex(@"(\:|\s)([\d]+)px", RegexOptions.Multiline);
                content = re.Replace(content, new MatchEvaluator(delegate(Match mc)
                {
                    return string.Concat(mc.Groups[1].Value, Math.Floor(Convert.ToInt32(mc.Groups[2].Value) * pp), "px");
                }));
            }
            HttpContext.Current.Cache.Insert(cacheKey, content, null, DateTime.Now.AddHours(12), TimeSpan.Zero);
            context.Response.Write(content);
        }
        else
        {
            context.Response.Write((string)HttpContext.Current.Cache[cacheKey]);
        }
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

}