﻿if(typeof AjaxPro == "undefined")
AjaxPro= {};
Extend(AjaxPro,{
    m: {
        '\b': '\\b',
        '\t': '\\t',
        '\n': '\\n',
        '\f': '\\f',
        '\r': '\\r',
        '"': '\\"',
        '\\': '\\\\'
    },
    toJSON: function(o) {
        if (o == null) {
            return "null";
        }
        var v = [];
        var i;
        var c = o.constructor;
        if (c == Number) {
            return isFinite(o) ? o.toString() : AjaxPro.toJSON(null);
        } else if (c == Boolean) {
            return o.toString();
        } else if (c == String) {
            if (/["\\\x00-\x1f]/.test(o)) {
                o = o.replace(/([\x00-\x1f\\"])/g, function(a, b) {
                    var c = AjaxPro.m[b];
                    if (c) {
                        return c;
                    }
                    c = b.charCodeAt();
                    return '\\u00' +
						Math.floor(c / 16).toString(16) +
						(c % 16).toString(16);
                });
            }
            return '"' + o + '"';
        } else if (c == Array) {
            for (i = 0; i < o.length; i++) {
                v.push(AjaxPro.toJSON(o[i]));
            }
            return "[" + v.join(",") + "]";
        } else if (c == Date) {
            var d = {};
            d.__type = "System.DateTime";
            if (AjaxPro.noUtcTime == true) {
                d.Year = o.getFullYear();
                d.Month = o.getMonth() + 1;
                d.Day = o.getDate();
                d.Hour = o.getHours();
                d.Minute = o.getMinutes();
                d.Second = o.getSeconds();
                d.Millisecond = o.getMilliseconds();
            } else {
                d.Year = o.getUTCFullYear();
                d.Month = o.getUTCMonth() + 1;
                d.Day = o.getUTCDate();
                d.Hour = o.getUTCHours();
                d.Minute = o.getUTCMinutes();
                d.Second = o.getUTCSeconds();
                d.Millisecond = o.getUTCMilliseconds();
            }
            return AjaxPro.toJSON(d);
        }
        if (typeof o.toJSON == "function") {
            return o.toJSON();
        }
        if (typeof o == "object") {
            for (var attr in o) {
                if (typeof o[attr] != "function") {
                    v.push('"' + attr + '":' + AjaxPro.toJSON(o[attr]));
                }
            }
            if (v.length > 0) {
                return "{" + v.join(",") + "}";
            }
            return "{}";
        }
        return o.toString();
    },
    eval : function(s) {
        return eval("(" + s + ")");
    }
});