﻿///获取新的ID
function g(id) {
    return document.getElementById(id);
}
function Guid(pre) {
    pre = pre || "";
    return pre + Math.random().toString().substr(2);
}
function NewID(pre) {
    var id;
    do {
        id = guid(pre);
    }
    while (g(id))
    return id;
}
//获取新的单据号
function GetNewVoucher(prefix,len) {
    today = new Date();
    var yy = today.getFullYear();
    var mo = (today.getMonth() + 1);
    var dd = today.getDate();
    var hh = today.getHours();
    var mm = today.getMinutes();
    var ss = today.getSeconds();
    if (yy < 10) yy = '0' + yy;
    if (mo < 10) mo = '0' + mo;
    if (hh < 10) hh = '0' + hh;
    if (mm < 10) mm = '0' + mm;
    if (ss < 10) ss = '0' + ss;
    var id = yy.toString() + mo.toString() + dd.toString() + hh.toString() + mm.toString() + ss.toString();
    if (!len) len = 4;
    id = id + Math.random().toString().substr(2, len);
    if (prefix) id = prefix + id;
    return id;
}

///////////////////////////////////////////////////////////一些字符串常用操作函数//////////////////////////////////////////////////
//去掉左右侧空格
function Trim(s) {
    if (s == null)
        return null;
    var r;
    var reg = new RegExp("^[ \t]*");
    r = s.replace(reg, "");
    s = r;
    reg = new RegExp("[ \t]*$");
    r = s.replace(reg, "");
    return r;
}
//验证字符串(包含汉字)有多少个字符长
function LenOf(str) {
    str = str + 'a';
    var str1 = str.match(/[\x00-\xff]/g).length;
    return ((str.length - str1) * 2 + str1 - 1);
}
//字符串替换函数
function Replace(str, oldStr, newStr, gim) {
    var reg = new RegExp(oldStr, "gm");
    if (gim != null) reg = new RegExp(oldStr, gim);
    return str.replace(reg, newStr);
}
String.prototype.Replace = function(oldStr, newStr, gim) {
    var reg = new RegExp(oldStr, "gm");
    if (gim != null) reg = new RegExp(oldStr, gim);
    return this.replace(reg, newStr);
}
//功能：获取指定数量的字符，超过的用“...”
//参数：str-字符串,num-获取字符数(汉字算2个字符)
function GetPreWord(str, num) {
    if (str == "") return str;
    if (typeof jQuery != "undefined") str = jQuery("<p>").append(str).text();
    else {
        str = str.replace(/<(.*)>/g, "").replace(/\r|\n/gm, "");
        if (str.indexOf("<") != -1) str += ">";
        str = str.replace(/<(.*)>/, "");
        if (Trim(str) == "") str = "[media]";
    }
    if (LenOf(str) <= num) return str;
    var p = 0; q = 0;
    for (p = 0; p < str.length; p++) {
        if (str.charAt(p).search(/[\x00-\xff]/) == -1)
            q += 2;
        else
            q += 1;
        if (q > num) break;
    }
    return str.substr(0, p) + "...";
}
//替换特殊字符(当文本呈现在网页上时)
function HTMLEncode(text) {
    text = text.replace(/&/g, "&amp;");
    text = text.replace(/\"/g, "&quot;");
    text = text.replace(/</g, "&lt;");
    text = text.replace(/>/g, "&gt;");
    text = text.replace(/\'/g, "&#146;");
    text = text.replace(/\ /g, "&nbsp;");
    text = text.replace(/\r\n/g, "<br/>");
    text = text.replace(/\n/g, "<br/>");
    text = text.replace(/\t/g, "&nbsp;&nbsp;&nbsp;&nbsp;");
    return text;
}
//替换特殊字符(当网页源码转化为文本时)
function HTMLDecode(text) {
    text = text.replace(/&amp;/g, "&");
    text = text.replace(/&quot;/g, "\"");
    text = text.replace(/&lt;/g, "<");
    text = text.replace(/&gt;/g, ">");
    text = text.replace(/&#146;/g, "'");
    text = text.replace(/<br>/g, "\n");
    text = text.replace(/&nbsp;&nbsp;&nbsp;&nbsp;/g, "\t");
    text = text.replace(/&nbsp;/g, " ");
    return text;
}

//将字符串转化为16进制编码.
//在 javascript 中，string 有一个方法是 charCodeAt(i)，它返回一个整数，代表指定位置上字符的 Unicode 编码，然后再转化成 16 进制。
function ConvertTo16(str) {
    if (str == null) return "";

    var cht = "0123456789abcdef";
    var arr = new Array(str.length);

    for (var i = 0; i < str.length; i++) {
        var chc = str.charCodeAt(i);

        if (chc < 32 || chc == 34 || chc == 39 || (chc >= 128 && chc <= 255)) {
            arr[i] = "\\x" + cht.charAt(chc / 0x10) + cht.charAt(chc % 0x10);
        }
        else if (chc >= 256) {
            arr[i] = "\\u" + cht.charAt(chc / 0x1000); chc %= 0x1000;
            arr[i] += cht.charAt(chc / 0x100); chc %= 0x100;
            arr[i] += cht.charAt(chc / 0x10);
            arr[i] += cht.charAt(chc % 0x10);
        }
        else {
            //arr[i]  = str.charAt(i);
            arr[i] = "\\x" + cht.charAt(chc / 0x10) + cht.charAt(chc % 0x10);
        }
    }
    return arr.join("");
}
//将16进制编码转化为字符串.
function ConvertFrom16(str) {
    var ret = "";
    var arr = str.split("\\");
    for (var i = 0; i < arr.length; i++) {
        var chc = arr[i];
        if (chc == "") continue;
        if (chc.charAt(0) == "x") {
            ret += String.fromCharCode(parseInt(chc.charAt(1), 16) * 16 + parseInt(chc.charAt(2), 16));
        }
        else if (chc.charAt(0) == "u") {
            ret += String.fromCharCode(parseInt(chc.charAt(1), 16) * Math.pow(16, 3) + parseInt(chc.charAt(2), 16) * Math.pow(16, 2) + parseInt(chc.charAt(3), 16) * 16 + parseInt(chc.charAt(4), 16));
        }
    }
    return ret;
};
//整数转化为字符串，不足位数的在前面加零
function FillZeroToString(obj, num) {
    var n = obj.toString().length;
    if (n == num) return obj.toString();
    var s = "";
    if (n < num) {
        for (var i = 0; i < (num - n); i++) {
            s += "0";
        }
    }
    return s + obj.toString();
}
//获得新的单号
function newno(curno) {
    var re = /[\d]+$/;
    var a = curno.match(re);
    var wb = a[0];
    if (wb.length > 6) wb = wb.substr(wb.length - 6);
    var nwb = FillZeroToString(parseInt(wb) + 1, wb.length);
    var pre = curno.substr(0, curno.length - wb.length);
    return pre + nwb;
}
//在URL中插入其它参数
function InsertParamToUrl(Url, Str) {
    if (Str == null || Str == "") return Url;
    if (Url.toLowerCase().indexOf("open") != -1) {
        if (Url.indexOf(",") != -1) {
            if (Url.indexOf("?") == -1)
                Url = Url.substr(0, Url.indexOf(",") - 1) + "?" + Str + Url.substr(Url.indexOf(",") - 1);
            else
                Url = Url.substr(0, Url.indexOf(",") - 1) + "&" + Str + Url.substr(Url.indexOf(",") - 1);
        }
        else {
            if (Url.indexOf("?") == -1)
                Url = Url.substr(0, Url.indexOf(")") - 1) + "?" + Str + Url.substr(Url.indexOf(")") - 1);
            else
                Url = Url.substr(0, Url.indexOf(")") - 1) + "&" + Str + Url.substr(Url.indexOf(")") - 1);
        }
    }
    else {
        if (Url.indexOf("?") == -1)
            Url = Url + "?" + Str;
        else
            Url = Url + "&" + Str;
    }
    return Url;
}
function EscapeURL(url) {
    //if (url.indexOf("?") == -1) return url;
    //var rg = new RegExp("(\\?|#|&)[\\w]+=([^&]*)", "g");
    var rg = new RegExp("(^|\\?|#|&)[^=]+=([^\"&]*)", "g");
    var reg = /[\u4E00-\u9FA5]/;
    if (!reg.test(url)) return url;
    var mcs = url.match(rg);
    if (mcs == null) return url;
    for (var i = 0, l = mcs.length; i < l; i++) {
        var c = mcs[i].substr(mcs[i].indexOf("="));
        //url = url.replace(c, "=" + (reg.test(c) ? escape(c.substr(1)) : c.substr(1))).replace("+", 
        url = url.replace(c, "=" +(reg.test(c)?escape(c.substr(1)):c.substr(1)));//.replace("+", " ");" ");
    }
    return url;

//    var ur = "", se = url;
//    if (url.indexOf("?") != -1) {
//        ur = url.substr(0, url.indexOf("?") + 1);
//        se = url.substr(url.indexOf("?") + 1);
//    }
//    var rg = new RegExp("(^|\\?|#|&)[^=&]+=([^'\"&]*)", "g");
//    var rg2 = new RegExp("(^|\\?|#|&)([^=&]+)=([\\w]*)");
//    var mcs = se.match(rg);
//    var mcs2, tmp;
//    for (var i = 0, l = mcs.length; i < l; i++) {
//        //var c = mcs[i].substr(mcs[i].indexOf("="));
//        //url = url.replace(c, "=" + escape(c.substr(1))).replace("+", " ");
//        mcs2 = mcs[i].match(rg2);
//        se = se.replace(mcs2[0], mcs2[1] + encodeURIComponent(mcs2[2]) + "=" + encodeURIComponent(mcs2[3]));
//    }
//    return ur + se;
}
//获取正确的URL
function GetURL(url, param) {
    //    if (ApplicationPath == undefined) return InsertParamToUrl(url, param);
    //    if (url.indexOf(ApplicationPath) == 0 || url.indexOf("..") == 0) return InsertParamToUrl(url, param);
    //    else return InsertParamToUrl(ApplicationPath + "/" + url, param);
    url = EscapeURL(url);
    if (param)
        return InsertParamToUrl(url, param);
    else
        return url;
}
function NewURL(url) {
    if (url.indexOf("rnd") == -1) {
        if (url.indexOf("?") == -1)
            url += "?rnd=" + Math.random();
        else
            url += "&rnd=" + Math.random();

    } else {
        url = url.substr(0, url.indexOf("rnd")) + "rnd=" + Math.random();
    }
    return url;
}
//获取指定格式的文件或文件夹大小尺寸
function GetFormatFileLengthString(size) {
    if (size >= 1073741824) {
        return (size / 1073741824).toFixed(2) + " GB";
    }
    else if (size >= 1048576) {
        return (size / 1048576).toFixed(2) + " MB";
    }
    else if (size >= 1024) {
        return (size / 1024).toFixed(2) + " KB";
    }
    else
        return size + " Bytes";
}

//获取数字格式的文件或文件夹大小(Bytes)
function GetFileLengthNumeric(size) {
    return eval(size.replace(" ", "").replace("Bytes", "").replace("KB", "*1024").replace("MB", "*1024*1024").replace("GB", "*1024*1024*1024"));
}
//获取每3位以","分隔的数字字符串
function GetCommaSplitNumber(num) {
    num = num.toString();
    if (num.length > 3) {
        if (num.indexOf(".") == -1)
            return GetCommaSplitNumber(num.substr(0, num.length - 3)) + "," + num.substr(num.length - 3);
        else {
            return GetCommaSplitNumber(num.substr(0, num.indexOf(".")))  + num.substr(num.indexOf("."));
        }
    }
    else
        return num;
}
//格式化数据
function FormatValue(formatStr, val) {
    var arr = formatStr.match(/\{(.+)\}/);
    if (arr == null) return val;
    var arr2 = arr[1].split(":");
    if (arr2.length == 1) return val;
    val = formatStr.replace("{" + arr[1] + "}", FormatData(val, arr2[1]));
    return val;
}
//格式化数据
function FormatData(val, formatString) {
    var ret = val;
    if (formatString == "" || formatString == null) return val;
    var t = formatString.substr(0, 1);
    if (Date.is(val) || formatString.startsWith("dd") || IsDate(val) || IsDateTime(val)) t = "";
    var f = formatString.substr(1); if (f == "") f = 0;
    switch (t.toUpperCase()) {
        case "C": //货币格式
            ret = "￥" + GetCommaSplitNumber(new Number(val).toFixed(parseInt(f)));
            break;
        case "D": //整数格式
            ret = new Number(val).toFixed(0);
            break;
        case "E": //指数格式
            ret = new Number(val).toExponential(parseInt(f));
            break;
        case "F": //小数格式
            ret = new Number(val).toFixed(parseInt(f));
            break;
        case "N": //小数格式（有逗号）
            ret = GetCommaSplitNumber(new Number(val).toFixed(parseInt(f)));
            break;
        case "P": //百分数格式
            ret = GetCommaSplitNumber((new Number(val) * 100).toFixed(parseInt(f))) + "%";
            break;
        default:
            if (typeof (val) == "string") {//isNaN(Date.parse(val) && 
                if (IsDateTime(val)) {
                    var arr = val.match(/^(\d{0,4})-(\d{0,2})-(\d{0,2}) (\d{0,2}):(\d{0,2}):(\d{0,2})$/);
                    if (arr != null) {
                        ret = formatString.replace("yyyy", arr[1]).replace("MM", arr[2]).replace("dd", arr[3]).replace("HH", arr[4]).replace("mm", arr[5]).replace("ss", arr[6]);
                    }
                } else if (IsDate(val)) {
                    var arr = val.match(/^(\d{0,4})-(\d{0,2})-(\d{0,2})$/);
                    if (arr != null)
                        ret = formatString.replace("yyyy", arr[1]).replace("MM", arr[2]).replace("dd", arr[3]);
                }
            } else {
                var dd;
                if (Date.is(val)) dd = val;
                else dd = new Date(val);
                //ret = formatString.replace("yyyy", dd.getFullYear()).replace("MM", dd.getMonth() + 1).replace("dd", dd.getDate()).replace("HH", dd.getHours()).replace("mm", dd.getMinutes()).replace("ss", dd.getSeconds());
                ret = dd.toString(formatString);
            }
            break;
    }
    return ret;
}
//是否有效颜色值
function IsColor(color) {
    var temp = color;
    if (temp == "") return true;
    if (temp.length != 7) return false;
    return (temp.search(/\#[a-fA-F0-9]{6}/) != -1);
}

function UrlParam(data) {
    var s = [];
    if (data) {
        if (data.constructor == String) {
            return data;
        }
        else {
            for (var name in data) {
                s.push(encodeURIComponent(name) + "=" + encodeURIComponent(data[name]));
            }
        }
    }
    return s.join("&").replace(/%20/g, "+")
}
//////////////////////////////////////////////////////日期时间操作函数///////////////////////////////////////
//获取当前日期
function GetDate(y, m, d) {
    if (y == null) y = 0;
    if (m == null) m = 0;
    if (d == null) d = 0;
    var today = new Date();
    var yy = today.getFullYear() + y;
    var mo = (today.getMonth() + 1) + m;
    var dd = today.getDate() + d;
    if (mo < 10) mo = '0' + mo;
    if (dd < 10) dd = '0' + dd;
    return yy + "-" + mo + "-" + dd;
}
//获取中文格式当前日期
function GetLocalDate() {
    today = new Date();
    return today.getFullYear() + "年" + (today.getMonth() + 1) + "月" + today.getDate() + "日" + " " + WeekName[today.getDay() + 1];
}
function IsDate(str) {
    if (str == "" || str==null) return false;
    var a = str.toString().match(/^(\d{0,4})-(\d{0,2})-(\d{0,2})$/);
    if (a == null) return false;
    if (a[2] > 12 || a[3] > 31) return false;
    return true;
}
function IsTime(str) {
    var a = str.toString().match(/^(\d{2}):(\d{2}):(\d{2})$/);
    var a2 = str.toString().match(/^(\d{2}):(\d{2})$/);
    if (a == null && a2 == null) return false;
    if (a != null && (a[1] >= 24 || a[2] >= 60 || a[3] >= 60)) return false;
    else if (a2 != null && (a2[1] >= 24 || a2[2] >= 60)) return false; 
    return true;
}
function IsDateTime(str) {
    var a = str.toString().match(/^(\d{0,4})-(\d{0,2})-(\d{0,2}) (\d{0,2}):(\d{0,2}):(\d{0,2})$/);
    if (a == null) return false;
    if (a[2] > 12 || a[3] > 31 || a[4] >= 24 || a[5] >= 60 || a[6] >= 60) return false;
    return true;
}
function ConvertToDateTime(str) {
    var a = null;
    if (str.indexOf(" ") != -1) {
        a = str.toString().match(/^(\d{0,4})-(\d{0,2})-(\d{0,2}) (\d{0,2}):(\d{0,2}):(\d{0,2})$/);
        if (a == null) return null;
        return new Date(a[1], a[2] - 1, a[3], a[4], a[5], a[6]);
    }
    else {
        a = str.toString().match(/^(\d{0,4})-(\d{0,2})-(\d{0,2})$/);
        if (a == null) return null;
        return new Date(a[1], a[2] - 1, a[3]);
    }
}
//将日期型字段值转化为“yyyy-MM-dd( HH-mm-ss)”格式的字符串
function ConvertDate(date) {
    var d = new Date(date);
    if (d == null) return d;
    var yy = d.getYear();
    var mo = (d.getMonth() + 1);
    var dd = d.getDate();
    var hh = d.getHours();
    var mm = d.getMinutes();
    var ss = d.getSeconds();
    if (mo < 10) mo = '0' + mo;
    if (dd < 10) dd = '0' + dd;
    if (hh < 10) hh = '0' + hh;
    if (mm < 10) mm = '0' + mm;
    if (ss < 10) ss = '0' + ss;
    if (hh == "00" && mm == "00" && ss == "00") return yy + "-" + mo + "-" + dd;
    else return yy + "-" + mo + "-" + dd + " " + hh + ":" + mm + ":" + ss;
}

/******************************一些控件操作函数******************************************/
//下拉框控件绑定数组数据
function BindDataToSelect_Array(el, arr) {
    if (!arr) return;
    for (var i = 0, l = arr.length; i < l; i++) {
        el.options[i] = new Option(arr[i].name || arr[i].text || "", arr[i].value || arr[i].name);
    }
};
//功能：由字符串序列建下拉选择项//
//参数：bSemicolon-是否以分号分隔的字符串//
function BindDataToSelect_Str(el, dataSrc, selectedValue, bSemicolon) {
    if (!dataSrc) {
        el.length = 0;
        return;
    }
    el.length = 0;
    var arrDataSrc,arrItem;
    if (bSemicolon || dataSrc.indexOf(";") != -1) {
        arrDataSrc = dataSrc.split(';');
        for (var k = 0; k < arrDataSrc.length; k++) {
            if (!arrDataSrc[k]) continue;
            arrItem = arrDataSrc[k].split(',');
            if (arrItem.length == 1)
                el.options[k] = new Option(arrItem[0], arrItem[0]);
            else
                el.options[k] = new Option(arrItem[1], arrItem[0]);
            if (arrItem[0] == selectedValue) el.selectedIndex = k;
        }
    }
    else {
        arrDataSrc = dataSrc.split(',');
        for (var k = 0; k < arrDataSrc.length; k++) {
            if (arrDataSrc[k] == "" && k > 0) continue;
            el.options[k] = new Option(arrDataSrc[k], arrDataSrc[k]);
            if (arrDataSrc[k] == selectedValue) el.selectedIndex = k;
        }
    }
};
//从XML文件中装载表数据到下拉框
function BindDataToSelect_XmlTable(xmlFile, tableName, el, selectedValue) {
    var doc = GetXmlDocument(xmlFile);
    var nodeList = doc.documentElement.childNodes;
    el.length = 0;
    var k = 0;
    for (var i = 0; i < nodeList.length; i++) {
        if (nodeList[i].tagName != tableName) continue;
        el.options[k] = new Option("" + nodeList[i].selectSingleNode("text").text, nodeList[i].selectSingleNode("value").text);
        k++
    }
    if (selectedValue != null)
        el.value = selectedValue;
}
//从XML文件中获取表数据到下拉框
function GetOptionsHTML_XmlTable(xmlFile, tableName, selectedValue) {
    var doc = GetXmlDocument(xmlFile);
    var nodeList = doc.documentElement.childNodes;
    var ret = "";
    for (var i = 0; i < nodeList.length; i++) {
        if (nodeList[i].tagName != tableName) continue;
        val = nodeList[i].selectSingleNode("value").text;
        text = nodeList[i].selectSingleNode("text").text;
        ret += "<option value=\"" + val + "\"" + (val == selectedValue ? " selected" : "") + ">" + text + "</option>";
    }
    return ret;
}
//功能：由字符串获得下拉框选择项HTML
//参数：bSemicolon-是否以分号分隔的字符串
function GetOptionHTML(str, selectedValue, bSemicolon,blang) {
    if (str == null) return "";
    var ret = "";
    if (selectedValue && selectedValue.toString().indexOf("()") != -1) selectedValue = eval(selectedValue);
    if (bSemicolon || str.indexOf(";") != -1) {
        var arrData = str.split(';');
        var arrVal;
        for (var k = 0; k < arrData.length; k++) {
            if (arrData[k] == "") continue;
            arrVal = arrData[k].split(',');
            if (arrVal.length == 1)
                ret += "<option value=\"" + arrVal[0] + "\"" + (arrVal[0] == selectedValue ? " selected" : "") + ">" + arrVal[0] + "</option>";
            else {
                arrVal[1] = arrData[k].substr(arrData[k].indexOf(",") + 1).replace(/(^,)|(,,)|(,$)/g,"");
                ret += "<option value=\"" + arrVal[0] + "\"" + (arrVal[0] == selectedValue ? " selected" : "") + ">" +  arrVal[1] + "</option>";
            }
        }
    }
    else {
        var arrData = str.split(',');
        for (var k = 0; k < arrData.length; k++) {
            ret += "<option value=\"" + arrData[k] + "\"" + (arrData[k] == selectedValue ? " selected" : "") + ">" + arrData[k] + "</option>";
        }
    }
    return ret;
}
//功能：由字符串获得/选项按钮组HTML
//参数：rankStyle-是否换行显示，css-选项样式
function GetRadioOptionHTML(id, str, selectedValue, rankStyle,css) {
    if (str == null) return "";
    var ret = [];
    var arrData = str.split(';');
    var arrVal;
    for (var k = 0; k < arrData.length; k++) {
        if (arrData[k] == "") continue;
        arrVal = arrData[k].split(',');
        if (rankStyle) ret.push("<div ", css || "");
        if (arrVal.length == 1) {
            ret.push("<input type='radio' name='" + id + "' id='" + id + k + "' value=\"" + arrVal[0] + "\"" + (arrVal[0] == selectedValue ? " checked" : "") + "><label for=" + id + k + ">" + arrVal[1] + "</label>&nbsp;");
        } else {
            arrVal[1] = arrData[k].substr(arrData[k].indexOf(",") + 1).replace(/(^,)|(,,)|(,$)/g, "");
            ret.push("<input type='radio' name='" + id + "' id='" + id + k + "' value=\"" + arrVal[0] + "\"" + (arrVal[0] == selectedValue ? " checked" : "") + "><label for=" + id + k + ">" + arrVal[1] + "</label>&nbsp;");
        }
        if (rankStyle) ret.push("</div>");
    }
    return ret.join("");
}
//下拉菜单数据追加
function AddDropdownListData(f_min, f_max, f_step, f_qtxt, f_htxt, f_tofixed) {
    var data = GetRegularListData(f_min, f_max, f_step, f_qtxt, f_htxt, f_tofixed);
    document.write("<option>" + data.replace(/,/g, "</option><option>") + "</option>");
}
//获取有规律的一系列字符串，中间有“,”分隔。通常用于获取下拉框数据源
function GetRegularListData(f_min, f_max, f_step, f_qtxt, f_htxt, f_tofixed) {
    if (f_min.toString().indexOf("()") != -1) f_min = eval(f_min);
    if (f_max.toString().indexOf("()") != -1) f_max = eval(f_max);
    if (f_step.toString().indexOf(".") == -1) {
        f_min = parseInt(f_min); f_max = parseInt(f_max); f_step = parseInt(f_step);
    } else {
        f_min = parseFloat(f_min); f_max = parseFloat(f_max); f_step = parseFloat(f_step);
    }

    if (f_step == undefined) f_step = 1; else f_step = new Number(f_step);
    f_qtxt == undefined ? f_qtxt = "" : f_qtxt = f_qtxt;
    f_htxt == undefined ? f_htxt = "" : f_htxt = f_htxt;
    f_tofixed == undefined ? f_tofixed = 0 : f_tofixed = f_tofixed;

    var t_ary1 = [], t_sms = 0;
    if (f_min > f_max) {
        for (var j = f_min; j >= f_max; j -= f_step) { t_ary1[t_sms++] = new String(new Number(j).toFixed(f_tofixed))+","+(f_qtxt + new String(new Number(j).toFixed(f_tofixed)) + f_htxt) }
    }
    else {
        for (var j = f_min; j <= f_max; j += f_step) {
            t_ary1[t_sms++] = new String(new Number(j).toFixed(f_tofixed))+","+(f_qtxt + new String(new Number(j).toFixed(f_tofixed)) + f_htxt);
        }
    }
    return t_ary1.join(';');
}
//获取下拉框架指定项值的文本
function GetDropdownOptionText(el, val) {
    if (val != null) val = val.toString();
    for (var n = 0; n < el.length; n++) {
        if (el.options[n].value === val) return el.options[n].text;
    }
    return "";
}
//获取下拉框架指定项文本的值
function SetDropdownOptionValue(el, txt) {
    if (txt != null) txt = txt.toString();
    for (var n = 0; n < el.length; n++) {
        if (el.options[n].text === txt) return el.options[n].value;
    }
    return "";
}

/////////////////////////////////////////DOM对象操作函数////////////////////////////////
//获得DOM对象
function GetXmlDocument(xmlFile) {
    if (window[xmlFile]) return window[xmlFile];
    var doc = C("MoXmlDocument");
    doc.async = false;
    doc.load(xmlFile);
    return doc;
};
//功能说明：获取XML表数据中指定主键项上的字段名的值，相当于数据库表中的指定记录中的指定字段值。
//参数说明：tableName-XML数据中的表名或路径。
function GetXMLFieldValue(doc, tableName, keyFieldName, keyFieldValue, getFieldName) {
    //if(doc.xml=="") return null;
    var objParentNode = doc.documentElement.selectSingleNode("//" + tableName + "[" + keyFieldName + "='" + keyFieldValue + "']");
    if (objParentNode == null) return null;
    return objParentNode.selectSingleNode(getFieldName).text;
};
//从XML文件中获取数据并加入到界面文档中
function AddXmlData(doc, nodeName) {
    var arrNodeName = nodeName.split(",");
    if (arrNodeName.length != 0) {
        for (var i = 0; i < arrNodeName.length; i++) {
            document.write(doc.getElementsByTagName(arrNodeName[i])[0].text + "\n\n");
        }
    } else {
        document.write(doc.getElementsByTagName(nodeName)[0].text + "\n\n");
    }
};
//从XML文件中获取节点数据
function GetXmlData(doc, nodeName) {
    var ret = "";
    var arrNodeName = nodeName.split(",");
    if (arrNodeName.length != 0) {
        for (var i = 0; i < arrNodeName.length; i++) {
            if (doc.getElementsByTagName(arrNodeName[i]).length > 0)
                ret += doc.getElementsByTagName(arrNodeName[i])[0].text + "\n\n";
        }
    } else {
        if (doc.getElementsByTagName(nodeName).length > 0)
            ret = doc.getElementsByTagName(nodeName)[0].text;
    }
    return ret;
};
//从XML文件中获取节点属性数据
function GetXmlAttrData(doc, nodeName, attr) {
    var ret = "";
    if (doc.getElementsByTagName(nodeName).length > 0) {
        proNode = doc.getElementsByTagName(nodeName)[0].attributes.getNamedItem(attr);
        if (proNode != null) ret = proNode.value;
    }
    return ret;
}

//////////////////////////////////////////////获取颜色////////////////////////////////////////
//取颜色值 模式一
function GetColor1(obj) {
    var color = "";
    if (obj) color = obj.value;
    //if(color!="") color=color.substr(1);
    var str = showModalDialog(GetWebFramePath() + '/Common/GetColor.htm' + '?color=' + encodeURIComponent(color), window, "dialogWidth:" + 280 + "px;dialogHeight:" + 250 + "px;help:no;scroll:no;status:no");
    if (str && obj) {
        obj.value = str;
        obj.focus();
    }
    return str;
}
// 选颜色 模式二
function GetColor2(obj1, obj2) {
    var ret = "";
    var elInput = null;
    if (obj1) {
        if (typeof (obj1) == "object")
            elInput = obj1;
        else
            elInput = document.getElementById(obj1);
    }
    var oldColor = "#000000";
    if (elInput) oldColor = elInput.value;
    var url = GetWebFramePath() + "/Common/SelectColor.htm?color=" + encodeURIComponent(oldColor);
    var ret = showModalDialog(url, window, "dialogWidth:465px;dialogHeight:270px;help:no;scroll:no;status:no");
    if (ret) {
        if (elInput) {
            elInput.value = ret; elInput.focus();
        }
        if (obj2) {
            var elBg;
            if (typeof (obj2) == "object")
                elBg = obj2;
            else
                elBg = document.getElementById(obj2);
            elBg.style.backgroundColor = ret;
        }
    }
    return ret;
}

//////////////////////////////////////////////////操作Cookies/////////////////////////////////////////////
//创建COOKIE
function SetCookie(sName, sValue, exDate) {
    if (exDate == null) {
        exDate = new Date();
        exDate.setDate(exDate.getDate() + 365); //cookies过期时间1年
    }
    //document.cookie = sName + "=" + escape(sValue) + "; expires=Fri, 31 Dec 2050 23:59:59 GMT;";// path=/"; 
    document.cookie = sName + "=" + escape(sValue) + "; expires=" + exDate.toGMTString();
}
//获取Cookie值
function GetCookie(sName) {
    var aCookie = document.cookie.split("; ");
    for (var i = 0; i < aCookie.length; i++) {
        var aCrumb = aCookie[i].split("=");
        if (sName == aCrumb[0] && aCrumb.length > 1)
            return unescape(aCrumb[1]);
    }
    return null;
//    var arr = window.document.cookie.match(new RegExp("(?:^|;+|\\s+)" + name + "=([^;]*)"));
//    return !arr ? null : arr[1];
}
//删除Cookie
function DelCookie(sName) {
    document.cookie = sName + "=1; expires=Fri, 31 Dec 1999 23:59:59 GMT;";
}
/////////////////////////////////////////////常用文档元素操作函数///////////////////////////////////////////////
//获取元素绝对顶位置
function GetElementTop(el) {
    var et = 0;
    while (el && el.style.position != "absolute" && el.style.position != "relative") {
        et += el.offsetTop;
        el = el.offsetParent;
    }
    return et;
}
//获取元素绝对左位置
function GetElementLeft(el) {
    var et = 0;
    var eo = el;
    while (el && el.style.position != "absolute" && el.style.position != "relative") {
        et += el.offsetLeft;
        el = el.offsetParent;
    }
    return et;
}
//获取指定标记名称的父元素
function GetParentElementByTagName(el, tagName, endTag) {
    while (null != el && el.tagName && el.tagName.toUpperCase() != tagName.toUpperCase()) {
        el = el.parentNode;
        if (endTag && el.tagName && el.tagName.toUpperCase() == endTag.toUpperCase()) return null;
    }
    return el;
}
//获取指定样式表名的父元素
function GetParentElementByClassName(el, clsName) {
    while (null != el && el.className.toUpperCase() != clsName.toUpperCase()) {
        el = el.parentNode;
    }
    return el;
}
//获取特定父元素
function GetSpecialParent(oEl, tagNameORclassName) {
    while (null != oEl && oEl.tagName.toUpperCase() != tagNameORclassName.toUpperCase() && oEl.className.toUpperCase() != tagNameORclassName.toUpperCase()) {
        oEl = oEl.parentNode;
    }
    return oEl;
}


///////////////////////////////////////////////文件操作////////////////////////////////////////////////////////
//判断是否是图片文件扩展名
function IsImage(ext) {
    if (ext.toLowerCase() == "gif" ||
			ext.toLowerCase() == "jpg" ||
			ext.toLowerCase() == "jpeg" ||
			ext.toLowerCase() == "png" ||
			ext.toLowerCase() == "bmp" ||
			ext.toLowerCase() == "ico")
        return true;
    return false;
};
//图片自适应大小
//id为img控件的id
//width与height为img父控件的宽高——即img的最大宽高
//示例：<img id="dd" src="ee.jpg" onload="imgFit('dd',100,200)" />"
function imgFit(obj, w, h) {
    if (typeof obj == "string") obj = document.getElementById(obj);
    if (w && !h) {
        if (obj.offsetWidth > w)
            $(obj).attr("width", w);
    } else if (!w && h) {
        if (obj.offsetHeight > h)
            $(obj).attr("width", h);
    }
    if (obj.offsetWidth > w || obj.offsetHeight > h) {
        var r1 = parseInt(obj.offsetWidth) / w;
        var r2 = parseInt(obj.offsetHeight) / h;
        if (r2 > r1)
            obj.style.height = obj.offsetHeight / r2 + "px";
        else
            obj.style.width = obj.offsetWidth / r1 + "px";
    }
}

//////////////////////////////////////////////////////////窗口操作/////////////////////////////////////////////////
////获得顶级父窗口
function GetTop() {
    if (window == parent)
        return window;
    else if (window.parent == window.parent.parent)
        return window.parent;
    else if (window.parent.parent == window.parent.parent.parent)
        return window.parent.parent;
    else
        return window.parent.parent.parent;
}
//获得父窗口
function ParentWindow() {
    var pwin;
    if (window.opener) pwin = window.opener;
    else if ($.browser.msie && window.dialogArguments) pwin = dialogArguments;
    else if (window.parent) pwin = window.parent;
    return pwin;
}
function GetParentCtl(id, pw, ifr) {
    var pwin = pw || ParentWindow();
    if (ifr) {
        return pwin.document.getElementById(ifr).contentWindow.document.getElementById(id);
    } else if (id.indexOf(".") == -1) {
        return pwin.document.getElementById(id);
    } else {
        var ifr = id.substr(0, id.indexOf("."));
        id = id.substr(id.indexOf(".") + 1);
        return pwin.document.getElementById(ifr).contentWindow.document.getElementById(id);
    }
}
//关闭当前窗口
function Close() {
    if (window["child"]) window["child"].close();
    else if (window.parent && parent.child) parent.child.close();
    else window.close();
}
//自然打开窗口
function SOpen(url, innerWidth, innerHeight) {
    var ScreenWidth = screen.availWidth;
    var ScreenHeight = screen.availHeight;
    var StartX = (ScreenWidth - innerWidth || 750) / 2;
    var StartY = (ScreenHeight - innerHeight || 510) / 2;
    if ($.browser.msie) {
        //父窗口通过dialogArguments引用
        var retValue = window.showModalDialog(url, window, "dialogHeight: " + innerHeight || 510 + "px;  dialogWidth: " + innerWidth || 750 + "px;dialogLeft:" + StartX + "px; dialogTop:" + StartY + "px;center: yes; help: no; resizable: no; status: no;scroll:no;dialogHide:no;edge:raised;");
        return retValue;
    } else {
    var win = window.open(url, Guid(), 'left=' + StartX + ', top=' + StartY + ', Width=' + innerWidth || 750 + ', height=' + innerHeight || 510 + ', resizable=no, scrollbars=no, status=no, toolbar=no, menubar=no, location=no');
        win.focus();
    }
}
//最大化简化窗口
function SOpenM(url) {
    if ($.browser.msie) {
        //父窗口通过dialogArguments引用
        var retValue = window.showModelessDialog(url, window, "dialogHeight: " + screen.availHeight + "px;  dialogWidth: " + screen.availWidth + "px;dialogLeft:" + 0 + "px; dialogTop:" + 0 + "px;center: yes; help: no; resizable: yes; status: no;scroll:no;dialogHide:no;edge:raised;");
        return retValue;
    } else {
        var win = window.open(url, Guid(), 'status=no,toolbar=no,menubar=no,location=no,resizable=yes,scrollbars=yes');
        win.resizeTo(screen.availWidth, screen.availHeight);
        win.moveTo(0, 0);
        win.focus();
    }
}
//可变化大小窗口
function SOpenR(url, innerWidth, innerHeight) {
    var ScreenWidth = screen.availWidth;
    var ScreenHeight = screen.availHeight;
    var StartX = (ScreenWidth - innerWidth || 750) / 2;
    var StartY = (ScreenHeight - innerHeight || 510) / 2;
    if ($.browser.msie) {
        //父窗口通过dialogArguments引用
        var retValue = window.showModelessDialog(url, window, "dialogHeight: " + innerHeight || 510 + "px;  dialogWidth: " + innerWidth || 750 + "px;dialogLeft:" + StartX + "px; dialogTop:" + StartY + "px;center: yes; help: no; resizable: yes; status: no;scroll:no;dialogHide:no;edge:raised;");
        return retValue;
    } else {
    var win = window.open(url, '', 'left=' + StartX + ', top=' + StartY + ', Width=' + innerWidth || 750 + ', height=' + innerHeight || 510 + ', resizable=yes, scrollbars=no, status=no, toolbar=no, menubar=no, location=no');
        win.focus();
    }
}
////////////////////////////////////////////////////常用界面事件函数/////////////////////////////////////////////////
//========================================================================
// 功能：回车跳格,遇到textarea不跳格
// 传入参数：无
// 返回参数：无
//========================================================================
function EnterToTab(e) {
    if (!/msie/i.test(navigator.userAgent)) return;
    var src = e.srcElement || e.target;
    if (src.type == "submit") {
        src.click();
        return;
    }
    if (src.type == "button" || src.type == "image") return;
    if (e.keyCode == 13) {
        if (src.type != "textarea") {
            e.keyCode = 9;
        }

    }
}