<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dt="urn:schemas-microsoft-com:datatypes">
<xsl:template match="menu">
	<div>
		<div style="position: absolute;z-index:100;background-color:threedface;border:1px outset threedface;" onselectstart="return false" ondragstart="return false" class="div_topMenu">		
			<table border="0" cellspacing="0" cellpadding="1" style="border-collapse:collapse;border-top: 1px solid #ffffff;border-left: 1px solid #ffffff;border-right: 1px solid threedshadow;border-bottom: 1px solid threedshadow;" class="table_topMenu">
				<tr>
					<td>
						<table border="0" cellspacing="0" cellpadding="0">
						<xsl:apply-templates select="entity"/>
						</table>
					</td>
				</tr>
			</table>
		</div>
		<xsl:apply-templates select="entity/contents"/>
	</div>
</xsl:template>

<xsl:template match="entity">
<TR class="tr_item">
<xsl:attribute name="selected">false</xsl:attribute>
<xsl:attribute name="background">threedface</xsl:attribute>
<xsl:attribute name="lightBorder">#808080</xsl:attribute>
<xsl:attribute name="lightBgcolor">#ccccff</xsl:attribute>
<xsl:attribute name="titlebar">threedface</xsl:attribute>
<xsl:attribute name="image">images/<xsl:value-of select="image"/></xsl:attribute>
<xsl:attribute name="imageOpen">images/<xsl:value-of select="imageOpen"/></xsl:attribute>
<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
<xsl:if test="@enabled=0">
<xsl:attribute name="disabled">true</xsl:attribute>
</xsl:if>
<xsl:attribute name="ONCLICK">{ClassName}.clean();{ClassName}.check();<xsl:value-of select="onClick"/></xsl:attribute>
<xsl:attribute name="ONMOUSEOVER">
{ClassName}.contextHighlightRow(this);
<xsl:if test="contents/node()[count(child::*)>0]">
{ClassName}.loadContextMenuSub(this)
</xsl:if>
</xsl:attribute>
<xsl:attribute name="ONMOUSEOUT">{ClassName}.contextHighlightRow(this)</xsl:attribute>
<xsl:if test="./description != 'hr'">
		<TD VALIGN="MIDDLE" ALIGN="CENTER" NOWRAP="true" class="td_item_left" height="22">
		<xsl:attribute name="ONCLICK"><xsl:value-of select="@onmousedown"/></xsl:attribute>
		<xsl:attribute name="STYLE">
			background-color: threedface;
			border-top:1px solid threedface;
			border-bottom:1px solid threedface;
			border-left:1px solid threedface;
			padding-left: 3px;
			padding-right: 3px;
			padding-top: 0px;
			padding-bottom: 0px;
			cursor: default;
		</xsl:attribute>
		<xsl:choose>
			<xsl:when test="./image != ''">	
				<IMG BORDER="0">				
				<xsl:attribute name="SRC"><xsl:value-of select="image"/></xsl:attribute>
				</IMG>
			</xsl:when>
			<xsl:otherwise>
				<IMG BORDER="0" HEIGHT="2" WIDTH="2">
				<xsl:attribute name="SRC">{BasePath}js/ContextMenu/Images/spacer.gif</xsl:attribute>
				</IMG>
			</xsl:otherwise>
		</xsl:choose>
		</TD>
		<TD NOWRAP="true" class="td_item_middle" valign="middle">
		<xsl:attribute name="ONCLICK"><xsl:value-of select="@onmousedown"/></xsl:attribute>
		<xsl:attribute name="STYLE">
			font-family: '宋体',Tahoma, Verdana, Arial, Sans-Serif;
			font-size: 12px;
			font-weight: normal;
			background-color: threedface;
			border-top: 1px solid threedface;
			border-bottom: 1px solid threedface;
			padding-top: 2px;
			padding-bottom:0px;
			padding-left: 2px;
			padding-right: 8px;
			cursor: default;
		</xsl:attribute>
		<xsl:attribute name="id">{ClassName}_item_<xsl:value-of select="description"/></xsl:attribute>
		<xsl:value-of select="description"/></TD>
		<TD VALIGN="middle" ALIGN="right" STYLE="padding-right: 6px;" NOWRAP="true" class="td_item_text">
		<xsl:attribute name="ONCLICK"><xsl:value-of select="@onmousedown"/></xsl:attribute>
		<xsl:attribute name="STYLE">
			background-color: threedface;
			border-top: 1px solid threedface;
			border-bottom: 1px solid threedface;
			border-right: 1px solid threedface;
			padding-right: 5px;
		</xsl:attribute>
		<IMG BORDER="0" WIDTH="4">
		<xsl:attribute name="SRC">
			<xsl:choose>
			<xsl:when test="contents/node()[count(child::*)>0]">
				{BasePath}js/ContextMenu/Images/flyout_arrow.gif
			</xsl:when>
			<xsl:otherwise>
				{BasePath}js/ContextMenu/Images/spacer.gif
			</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
		</IMG></TD>
	</xsl:if>
	<xsl:if test="./description = 'hr'">
		<TD colspan="3" style="height:3px;margin:3px;" ><span style="border-bottom:1px solid threedhighlight;border-top:1px solid threedshadow;display:block;"></span></TD>
	</xsl:if>
	<xsl:if test="./display = 'none'"><xsl:attribute name="STYLE">display: none;</xsl:attribute></xsl:if>			
</TR>
</xsl:template>

<xsl:template match="contents">
	<xsl:if test="count(child::*)>0">
		<div onselectstart="return false" ondragstart="return false" class="div_submenu">
			<xsl:attribute name="STYLE">
				position: absolute;			
				background-color: threedface;
				border:1px solid threedface;
				display: none;
        z-index:999;
			</xsl:attribute>
			<xsl:attribute name="ID"><xsl:value-of select="../@id"/>Sub</xsl:attribute>
			<table border="0" cellspacing="0" cellpadding="1" style="border-collapse:collapse;border-top: 1px solid #ffffff;border-left: 1px solid #ffffff;border-right: 1px solid threedshadow;border-bottom: 1px solid threedshadow;" class="table_submenu">
				<tr>
					<td>
						<table border="0" cellspacing="0" cellpadding="0">
							<xsl:apply-templates select="entity"/>
						</table>
					</td>
				</tr>
			</table>
		</div>
		<xsl:apply-templates select="entity/contents"/>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>		