﻿Include(window._BasePath + "js/AjaxPro.AjaxClass.js");
Include(window._BasePath + "ajaxpro/MUI.AjaxInvoke.Com,MUI.ashx");
/////////////////////////////////////////////MUI.Ajax/////////////////////////////////////////////
MUI.Ajax={};
///////////////////////////////////////////MUI.Ajax.Db////////////////////////////////////////////
MUI.Ajax.Db={
    //执行SQL语句//
    ExecSql:function(sql){
	    return MUI.AjaxInvoke.Com.ExecSql(sql).value;
    }
    //获得表第一行第一列数据//
    ,GetVal:function(sql){
	    return MUI.AjaxInvoke.Com.GetVal(sql).value;
    }
    //获得表第一行第一列数据//
    ,GetVals:function(sql){
	    return MUI.AjaxInvoke.Com.GetVals(sql).value;
    }
    //执行一系列SQL语句，返回执行结果值数组//
    ,GetObj:function(sql){
	    return MUI.AjaxInvoke.Com.GetScalar(sql).value;
    }
    //获取表第一行数据//
    ,GetDR:function(sql){
	    var dt=MUI.AjaxInvoke.Com.GetDT(sql).value;
	    if(dt!=null) return dt.Rows[0];
	    else return null;
    }
    //获取表数据//
    ,GetDT:function(sql){
	    return MUI.AjaxInvoke.Com.GetDT(sql).value;
    }
    //获取数据集//
    ,GetDS:function(sql){
	    return MUI.AjaxInvoke.Com.GetDS(sql).value;
    }
    //添加记录//
    ,InsertRecord:function(tableName,nvData){
	    return MUI.AjaxInvoke.Com.InsertRecord(tableName,nvData).value;
    }
    //修改记录//
    ,ModifyRecord:function(tableName,nvData,keyWhere){
	    if(nvData.getKeys().length==0) return true;
	    return MUI.AjaxInvoke.Com.ModifyRecord(tableName,nvData,escape(keyWhere)).value;
    }
    //删除记录//
    ,DeleteRecord:function(tableName,keyWhere){
	    return MUI.AjaxInvoke.Com.DeleteRecord(tableName,escape(keyWhere)).value;
    }
    //获取分页表数据//
    ,GetPagingTable:function(tableName,selectedFields,keyField,pageSize,pageIndex,sqlWhere,orderBy){
	    return MUI.AjaxInvoke.Com.GetPagingTable(tableName,selectedFields,keyField,pageSize,pageIndex,sqlWhere,orderBy).value;
    }
    //更新CLOB字段//
    ,UpdateLongField:function(tableName,fieldName,fieldValue,keyWhere){
	    return MUI.AjaxInvoke.Com.UpdateLongField(tableName,fieldName,fieldValue,keyWhere).value;
    }
    //更新CLOB字段//
    ,InsertLongField:function(sql,fieldName,fieldValue){
	    return MUI.AjaxInvoke.Com.InsertLongField(sql,fieldName,fieldValue).value;
    }
    //从EXCEL中获取表数据//
    //返回DataTable//
    ,GetDTFromExcel:function(fileName,sheetName){
	    return MUI.AjaxInvoke.Com.GetDTFromExcel(fileName,sheetName).value;
    }
    //获取业务表字段名字符串//
    ,GetFieldNameList:function(tableName){
	    return MUI.AjaxInvoke.Com.GetFieldNameList(tableName).value;
    }
    //获取业务表数据字符串//
    ,GetDataList:function(sql){
	    return MUI.AjaxInvoke.Com.GetDataList(sql).value;
    }
    //获得数据库类型
    ,GetDBType:function(){
      if(typeof window._DBType!="undefined") return window._DBType;
	    return window._DBType=MUI.AjaxInvoke.Com.GetDBType().value;
    }
    //检查是否存在字段
    ,CheckExistField:function(fieldName,tableName){
	    return MUI.AjaxInvoke.Com.CheckExistField(fieldName,tableName).value;
    }
    //检查是否存在记录
    ,CheckExistRecord:function(tableName,sqlwhere){
	    return MUI.AjaxInvoke.Com.CheckExistRecord(tableName,sqlwhere).value;
    }
    //通过新的ID主键值，如00000001//
    ,GetNewID:function(tb,fld,len){
	    return MUI.AjaxInvoke.Com.GetNewID(tb,fld,len).value;
    }
    //通过新的SysID主键值，如site-00000001//
    ,GetNewSysID:function(tb,fld,len){
	    return MUI.AjaxInvoke.Com.GetNewSysID(tb,fld,len).value;
    }
    //通过新的单据号主键值，如site-200801230223320001//
    ,GetNewVoucher:function(tb,fld,len){
	    return MUI.AjaxInvoke.Com.GetNewVoucher(tb,fld,len).value;
    }
    //获取字段内容用于HTML显示
    ,GetFieldContentToHTML:function(tableName,fieldName,keyStr){
	    return MUI.Ajax.Db.GetVal("select "+fieldName+" from "+tableName+" where "+keyStr).replace(/\r\n/gm,"<br>").replace(/ /gm,"&nbsp;");
    }
};

///////////////////////////////////////////////MUI.Ajax.UserState////////////////////////////////////////////////////////////////
MUI.Ajax.UserState={
    //获得应用程序级变量值//
    GetApplication:function(variable){
	    return MUI.AjaxInvoke.Com.GetApplication(variable).value;
    }
    //获得会话级变量值//
    ,GetSession:function(variable){
	    return MUI.AjaxInvoke.Com.GetSession(variable).value;
    }
    //设置应用程序级变量值//
    ,SetApplication:function(variable,val){
	    return MUI.AjaxInvoke.Com.SetApplication(variable,val).value;
    }
    //设置会话级变量值//
    ,SetSession:function(variable,val){
	    return MUI.AjaxInvoke.Com.SetSession(variable,val).value;
    }
    //获得登录用户名//
    ,GetAccount:function(){
      if(typeof window._Account!="undefined") return window._Account;
	    return window._Account=MUI.AjaxInvoke.Com.GetAccount().value;
    }
    //获得请求客户端IP地址//
    ,GetClientIP:function(){
	    return MUI.AjaxInvoke.Com.GetClientIP().value;
    }
};
/////////////////////////////////////////////////////////MUI.Ajax.Invoke//////////////////////////////////////////////////////////////
MUI.Ajax.Invoke={
    //执行AJAX函数//
    //method格式为：“方法名,类名(包括命名空间),程序集名称(即DLL文件名)” 如：“UpdateSysData,MUI.AjaxInvoke.AjaxInvoke,MUI.Web.WebFrame”//
    InvokeMethod:function(method,param){
	    return MUI.AjaxInvoke.Com.InvokeMethod(method,param).value;
    }
    ,InvokeMethod1:function(method,param0){
	    return MUI.AjaxInvoke.Com.InvokeMethod1(method,param0).value;
    }
    ,InvokeMethod2:function(method,param0,param1){
	    return MUI.AjaxInvoke.Com.InvokeMethod2(method,param0,param1).value;
    }
    ,InvokeMethod3:function(method,param0,param1,param2){
	    return MUI.AjaxInvoke.Com.InvokeMethod3(method,param0,param1,param2).value;
    }
    ,InvokeMethod4:function(method,param0,param1,param2,param3){
	return MUI.AjaxInvoke.Com.InvokeMethod4(method,param0,param1,param2,param3).value;
    }
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
MUI.Ajax.IO={
    //保存XML文件//
    SaveXml:function(path,content){
	    return MUI.AjaxInvoke.Com.SaveXml(path,content).value;
    }
    //获取指定路径下的所有合法文件名
    ,GetFileNamesByExt:function(path,allowExt){
	    return MUI.AjaxInvoke.Com.GetFileNamesByExt(path,allowExt).value;
    }
    ,ReplaceRemoteUrl:function(html,allowExt,savePath){
	    return MUI.AjaxInvoke.Com.ReplaceRemoteUrl(html,allowExt,savePath).value;
    }
};
////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////MUI.Db//////////////////////////////////////////////////////
MUI.Db={
    //将记录行数据中的NULL值替换为空字符串
    BlankRowNullData:function(row){
	    if(row==null) return null;
	    for (var key in row) 
	    {
		    if(row[key]==null) row[key]="";
	    }
	    return row;
    }
    //将记录数据中的NULL值替换为空字符串
    ,FormatRowDataForShow:function(row){
	    if(row==null) return null;
	    for (var key in row) 
	    {
		    if(row[key]==null) row[key]="";
		    if(typeof(row[key])=="object"  && isNaN(Date.parse(row[key]))==false){
			    row[key]=ConvertDate(row[key]);
		    }
	    }
	    return row;
    }
    //获取表字段数据类型
    ,GetFieldDataType:function(fieldName,dt){
	    if(dt==null) return "String";
	    //"System.String","System.Int16","System.Int32","System.Byte","System.Boolean","System.DateTime","System.Byte[]","System.Decimal","System.Double"
	    for(h=0;h<dt.Columns.length;h++)
	    {
		    col=dt.Columns[h];//alert(col.__type);
		    if(col.Name.toLowerCase()==fieldName.toLowerCase()) return col.__type.substr(7);
	    }
	    return "String";
    }
    //根据表字段数据类型获取用于SQL语句中的字段值格式
    ,GetSQLFieldValue:function(val,dataType){
	    dataType=dataType.replace("System.","");
	    if(val==null) return "null";
	    var ret="";
	    switch(dataType)
	    {
		    case "String":
			    ret="'"+String(val).replace(/'/g,"''")+"'";
			    break;
		    case "DateTime":
			    if(MUI.Ajax.Db.GetDBType()=="access") ret="DateValue('"+ConvertDate(val)+"')";
			    else{
				    if(typeof val=="date") val=ConvertDate(val);
				    ret="'"+val+"'";
			    }
			    break;
		    case "Int32":
		    case "Int16":
		    case "Decimal":
		    case "Double":
		    case "Byte":
			    ret=val;
			    break;
		    case "Boolean":
			    if(val==true) ret="1";
			    else ret="0";
			    break;
	    }
	    return ret;
    }
    //格式化参数类型，返回数据类型
    ,GetQuerySQLValue:function(val,dataType,bLike){
	    var ret="";
	    if(val.toUpperCase()=="NULL") return " is null";	
	    else if(val.toUpperCase()=="NOTNULL") return " is not null";
	    switch(dataType)
	    {
		    case "String":// 字符型
			    if(bLike)
				    ret = " like '%"+val+"%'";
			    else
				    ret = " = '"+val+"'";
			    break;
		    case "Int32": // 整数型
		    case "Int16":		
		    case "Byte":
		    case "Decimal": //浮点型
			    ret =  " = "+val;
			    break;
		    case "DateTime": //日期时间型
			    ret =  " = "+"'"+val+"'";					
			    break;
		    case "Boolean": //逻辑型
			    ret = " = "+val;		
			    break;
		    default:					
			    ret = " like '%"+val+"%'";
			    break;
	    }
	    return ret;
    }
    //获取视图字符串
    ,GetViewSQL:function(viewName){
	    viewName=viewName.replace(/\{0\}/gm,"1>0");
	    if(viewName.toLowerCase().indexOf("select ")!=-1)
		    return "("+viewName.replace(/\r\n/gim," ")+") TBN";
	    else 
		    return viewName;
    }
    //字符串值为空时返回null
    ,GetStringDBValue:function(str){
	    if(str==null || str=="") return "null";
	    else return "'"+str+"'";
    }
    //按主键值序列排序记录
    ,SortRowByKey:function(dt,key,keyValStr){
	    var tmp=[];
	    var arrKeyValStr=keyValStr.split(",");
	    for(var h=0;h<arrKeyValStr.length;h++){
		    tmp[h]=FindRow(dt,key,arrKeyValStr[h]);
		    if(tmp[h]==null) return null;
	    }
	    dt.Rows=tmp;
	    return dt;
    }
    //查找行
    ,FindRow:function(dt,key,value){
	    for(var p=0;p<dt.Rows.length;p++){
		    if(dt.Rows[p][key]==value) return dt.Rows[p];
	    }
	    return null;
    }
};
/////////////////////////////////////////////MUI.Page////////////////////////////////////////////////
MUI.Page={
    //功能：自动获得页面数据包（要获得数据的控件ID或Name必须以“C_”打头）
    //返回：Ajax.Web.NameValueCollection类型数据
    GetPageModData:function(prefix,parentEl){
	    return GetPageData(prefix,parentEl,true);
    }
    ,GetPageData:function(prefix,parentEl,bOnlyChange){
	    var nvPageData=new Ajax.Web.NameValueCollection();
	    var allEl=[];
	    if(parentEl) allEl=parentEl.all;
	    else allEl=document.all;
	    if(prefix==null) prefix="C_";
	    for(j=0;j<allEl.length;j++)
	    {
		    el=allEl[j];
		    if(bOnlyChange){
			    if(el.pc==undefined || el.pc==false) {continue;}
		    }
		    else{
			    if(bOnlyChange==null && el.dvalue!=undefined && (el.type=="select-one" || el.type=="text" || el.type=="hidden" || el.type=="password" || el.tagName.toLowerCase()=="textarea") &&  el.value==el.dvalue) {continue;}
		    }
		    var fieldName="";
		    if(el.type!="radio"){
			    if(el.id == null || el.id.indexOf(prefix)==-1) continue;
			    fieldName=el.id.substr(2);
		    }
		    else{
			    if(el.name == null || el.name.indexOf(prefix)==-1) continue;
			    fieldName=el.name.substr(2);
		    }
		    if(el.tagName.toLowerCase()=="input")
		    {
			    if(el.type=="text" || el.type=="hidden" || el.type=="password"){
				    nvPageData.add(fieldName,el.value);
			    }
			    else if(el.type=="checkbox")
			    {
				    if(el.checked) nvPageData.add(fieldName,"1");
				    else nvPageData.add(fieldName,"0");
			    }
			    else if(el.type=="radio")
			    {
				    if(el.checked) nvPageData.add(fieldName,el.value);
			    }
		    }
		    else if(el.tagName.toLowerCase()=="textarea")
		    {
			    nvPageData.add(fieldName,el.value);
		    }
		    else if(el.tagName.toLowerCase()=="select")
		    {
			    nvPageData.add(fieldName,el.value);
		    }
	    }
	    return nvPageData;
    }
    //功能：自动为页面控件设置（要设置的控件ID或Name必须以“C_”打头）
    //参数：表记录类型（如Table.Rows[0]）
    //返回：无
    ,SetPageData:function(row,prefix,parentEl){	
	    if(row==null) return ;
	    row=FormatRowDataForShow(row);
	    var allEl=document.body.all;
	    if(prefix==null) prefix="C_";
	    if(parentEl){
		    if(typeof parentEl=="string") parentEl=document.getElementById(parentEl);
		    allEl=parentEl.all;
	    }
	    for(j=0;j<allEl.length;j++)
	    {
		    el=allEl[j];
		    var fieldName="";
		    if(el.type!="radio"){
			    if(el.id == null || el.id.indexOf(prefix)==-1) continue;
			    fieldName=el.id.substr(2);
		    }
		    else{
			    if(el.name == null || el.name.indexOf(prefix)==-1) continue;
			    fieldName=el.name.substr(2);
		    }
		    var val=row[fieldName];
		    if(val==null) {val="";continue;};
		    if(el.tagName.toLowerCase()=="input")
		    {
			    if(el.type=="text" || el.type=="hidden" || el.type=="password")
				    el.value=val;
			    else if(el.type=="checkbox")
			    {
				    if(val==true || val=="1" || val=="是") el.checked=true;
				    else el.checked=false;
			    }
			    else if(el.type=="radio")
			    {
				    if(val=="是") val="1";else if(val=="否") val="0";
				    if(val==el.value) el.checked=true;
				    else el.checked=false;
			    }
		    }
		    else if(el.tagName.toLowerCase()=="textarea")
		    {
			    el.value=val;
		    }
		    else if(el.tagName.toLowerCase()=="select")
		    {
			    el.value=val;
		    }else{
			    if(el.children.length==0) el.innerHTML=val;
		    }
		    el.dvalue=el.value;
	    }
    }
    ,ClearPageData:function(prefix,parentEl){	
	    var allEl=document.body.all;
	    if(prefix==null) prefix="C_";
	    if(parentEl){
		    if(typeof parentEl=="string") parentEl=document.getElementById(parentEl);
		    allEl=parentEl.all;
	    }
	    for(j=0;j<allEl.length;j++)
	    {
		    el=allEl[j];
		    if(el.type!="radio"){
			    if(el.id == null || el.id.indexOf(prefix)==-1) continue;
		    }
		    else{
			    if(el.name == null || el.name.indexOf(prefix)==-1) continue;
		    }
		    if(el.tagName.toLowerCase()=="input")
		    {
			    if(el.type=="text" || el.type=="hidden" || el.type=="password")
				    el.value="";
		    }
		    else if(el.tagName.toLowerCase()=="textarea")
		    {
			    el.value="";
		    }
		    else if(el.tagName.toLowerCase()=="select")
		    {
			    el.value="";
		    }else{
			    if(el.children.length==0) el.innerHTML="";
		    }
	    }
    }
    //设置页面数据（将所有诸如“{fieldname}”的数据替换为表数据）
    ,ReplaceFieldData:function(html,row){
	    var arrRet=html.match(/\{[\w\u0100-\uffff]+\}/gim);
	    if(arrRet==null) return html;
	    for(var p=0;p<arrRet.length;p++){
		    fld=arrRet[p].substr(1,arrRet[p].length-2);
		    html=html.replace(arrRet[p],row[fld]);
	    }
	    return html;
    }
};
var _AppPath=MUI.AjaxInvoke.Com.GetAppPath().value;
//function window.onerror(){return true}