﻿
//////////////////////////////////////////////////操作Cookies/////////////////////////////////////////////
MUI.Cookie={};
Extend(MUI.Cookie,{
	/**
	 * Parses the specified query string into an name/value object.
	 *
	 * @param {String} n String to parse into a n Hashtable object.
	 * @return {Object} Name/Value object with items parsed from querystring.
	 */
	getHash : function(n) {
		var v = this.get(n), h;

		if (v) {
			each(v.split('&'), function(v) {
				v = v.split('=');
				h = h || {};
				h[unescape(v[0])] = unescape(v[1]);
			});
		}

		return h;
	},

	/**
	 * Sets a hashtable name/value object to a cookie.
	 *
	 * @param {String} n Name of the cookie.
	 * @param {Object} v Hashtable object to set as cookie.
	 * @param {Date} d Optional date object for the expiration of the cookie.
	 * @param {String} p Optional path to restrict the cookie to.
	 * @param {String} d Optional domain to restrict the cookie to.
	 * @param {String} s Is the cookie secure or not.
	 */
	setHash : function(n, v, e, p, d, s) {
		var o = '';

		each(v, function(v, k) {
			o += (!o ? '' : '&') + escape(k) + '=' + escape(v);
		});

		this.set(n, o, e, p, d, s);
	},
    set : function(sName, sValue,exDate){ 
        if(exDate==null) 
        {
            exDate=new Date();
            exDate.setDate(exDate.getDate()+365); 
        }
        //document.cookie = sName + "=" + escape(sValue) + "; expires=Fri, 31 Dec 2050 23:59:59 GMT;";// "; 
        document.cookie = sName + "=" + escape(sValue) + "; expires="+exDate.toGMTString()+";path=/";
    },
    get : function(sName){
        var aCookie = document.cookie.split("; ");
        for (var i=0; i < aCookie.length; i++) 
        {    
	        var aCrumb = aCookie[i].split("="); 
	        if (sName == aCrumb[0] && aCrumb.length>1)  
	        return unescape(aCrumb[1]); 
        } 
        return null;
    },
    remove:function(sName){ 
        document.cookie = sName + "=1; expires=Fri, 31 Dec 1999 23:59:59 GMT;"; 
    }
});