﻿///////////////////////////////////////MUI.Validator//////////////////////////////////
if (typeof MUI != "object") MUI = {};
MUI.Validator = {};
//校验方法池
MUI.Validator.ValidatorsPool = {
    //为空
    isEmpty: function(val, params) { return ((val == null) || (val.length == 0)) },
    //不为空
    notEmpty: function(val, params) { if (params == null) return !((val == null) || (val.length == 0)); else { var cb = params[0]; return cb.call(null, val); } },
    //trim后为空
    isTrimedEmpty: function(val, params) { return val.trim() == null || (val.trim().length == 0) },
    //trim后不为空
    notTrimedEmpty: function(val, params) { return !(val.trim() == null || (val.trim().length == 0)) },
    //必须为数值
    isNumber: function(val, params) { return !isNaN(val) },
    //必须为整数
    isDigit: function(val, params) { return /^[0-9]+$/.test(val) },
    //必须为Email
    email: function(val, params) { return /^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$/.test(val) },
    //正则表达式匹配
    regexp: function(val, params) { return eval(params[0]).test(val) },
    //正则表达式匹配取反
    notRegexp: function(val, params) { return !eval(params[0]).test(val) },
    //固定长度
    fixedLength: function(val, params) { return val.length == parseInt(params[0]) },
    //最小长度
    minLength: function(val, params) { return val.length >= parseInt(params[0]) },
    //最大长度
    maxLength: function(val, params) { return val.length <= parseInt(params[0]) },
    //最小值
    minValue: function(val, params) { return val >= parseFloat(params[0]) },
    //最大值
    maxValue: function(val, params) { return val <= parseFloat(params[0]) },
    //不属于其中
    notOneOf: function(val, params) { return params.every(function(v) { return val != v; }) },
    //其中之一
    oneOf: function(val, params) { return params.some(function(v) { return val == v; }) },
    //等于
    equal: function(val, params) { return val == params[0] },
    //不等于
    notEqual: function(val, params) { return val != params[0] },
    //等于某个表单域的值
    equalToField: function(val, params) { var el = params[0]; if (typeof (el) == 'string') el = g(el); return val == el.value; },
    //不等于某个表单域的值
    notEqualToField: function(val, params) { var el = params[0]; if (typeof (el) == 'string') el = g(el); return val != el.value; },
    //必须为日期格式
    isDate: function(val, params) { return /^(\d{0,4})-(\d{0,2})-(\d{0,2})$/.test(val) },
    //必须为日期格式
    isDateTime: function(val, params) { return /^(\d{0,4})-(\d{0,2})-(\d{0,2}) (\d{0,2}):(\d{0,2})(:(\d{0,2}))*$/.test(val) },
    //没有非法字符
    noForbid: function(val, params) { return !Is_forbid(val) },
    //调用函数
    callback: function(val, params) { var cb; if (typeof params == "object") { if (typeof params[0] == "string") cb = eval(params[0]); else cb = params[0]; } else { if (typeof params == "function") cb = params; else cb = eval(params); } return cb.call(null, val); }

};
//非法字符过滤
var ffAlert = '您的输入含有非法字符，请检查！';
function Is_forbid(str) {
    str = str.trim();
    str = str.replace('*', "@");
    str = str.replace('--', "@");
    str = str.replace('/', "@");
    str = str.replace('+', "@");
    str = str.replace('\'', "@");
    str = str.replace('\\', "@");
    str = str.replace('$', "@");
    str = str.replace('^', "@");
    str = str.replace('.', "@");
    //str = str.replace('(',"@");
    //str = str.replace(')',"@");
    //str = str.replace(',',"@");
    str = str.replace(';', "@");
    str = str.replace('<', "@");
    str = str.replace('>', "@");
    //str = str.replace('?',"@");
    str = str.replace('"', "@");
    str = str.replace('{', "@");
    str = str.replace('}', "@");
    //str = str.replace('[',"@");
    //str = str.replace(']',"@");
    var forbid_str = new String('@,%,~,&');
    var forbid_array = new Array();
    forbid_array = forbid_str.split(',');
    for (i = 0; i < forbid_array.length; i++) {
        if (str.search(new RegExp(forbid_array[i])) != -1)
            return true;
    }
    return false;
}
//
MUI.Validator.BCheckValue = function(val, type, params) {
    if (type!="notEmpty" && String.isNullOrEmpty(val)) return true;
    return this.ValidatorsPool[type].call(null, val, params);
}
MUI.Validator.SCheckValue = function(val, validators, bCheckEmpty) {
    var errMsg = "";
    Object.each(validators, function(v,n) {
        if (!bCheckEmpty) {
            if (String.isNullOrEmpty(val)) return false;
            if (v.rule == "notEmpty") return true;
        }
        else if (v.rule != "notEmpty" && String.isNullOrEmpty(val)) return false; //防止可为空的域出现其它非法提示
        if (!MUI.Validator.BCheckValue( val, v.rule,v.params)) {
            errMsg = v.err;
           return false;
        }
    });
    return errMsg;
}
MUI.Validator.SCheckEmpty = function(val, validators) {
    var errMsg = "";
    Object.each(validators, function(v) {
        if (v.rule != "notEmpty") return true;
        if (!MUI.Validator.BCheckValue(val,v.rule,  v.params)) {
            errMsg = v.err;
            return false;
        }
    });
    return errMsg;
}

//弹出方式：检验输入框值的合法性 - 通用方法
//var o={obj:el,type: 'notEmpty', params:[],tip: '您未填写。',focus:true,select:false} 或 数组
MUI.Validator.CheckValue = function(o) {
    var othis = this;
    if (Object.is(o, "array")) {
        return Object.each(o, function(v) {
            if (!othis.BCheckValue(Object.is(v.obj, "object") ? v.obj.value : v.obj, v.type, v.params)) {
                alert(v.tip);
                if (v.select) v.obj.select();
                if (v.focus) v.obj.focus();
                return false;
            }
            return true;
        });
    } else {
        if (!othis.BCheckValue(Object.is(o.obj, "object") ? o.obj.value : o.obj, o.type, o.params)) {
            alert(o.tip);
            if (o.select) o.obj.select();
            if (o.focus) o.obj.focus();
            return false;
        }
        return true;
    }
}
//非弹出方式：检验输入框值的合法性 - 通用方法
//var o=[{obj:el,type: 'notEmpty', params:[],tip: '您未填写。',focus:true,select:false}] 或 单个对象
MUI.Validator.CheckValue2 = function(o) {
    var othis = this;
    if (Object.is(o, "array")) {
        var b = true;
        removeAlert();
        o.forEach(function(v, i) {
            if (!othis.BCheckValue(Object.is(v.obj, "object") ? v.obj.value : v.obj, v.type, v.params)) {
                showAlert(v.tip, v.obj);
                if (b) {
                    if (v.select) v.obj.select();
                    if (v.focus) v.obj.focus();
                }
                b = false;
            }
        });
        return b;
    } else {
        removeAlert(o.obj);
        if (!othis.BCheckValue(Object.is(o.obj, "object") ? o.obj.value : o.obj, o.type, o.params)) {
            showAlert(o.tip, o.obj);
            if (o.select) o.obj.select();
            if (o.focus) o.obj.focus();
            return false;
        }
        return true;
    }
}

//弹出方式：检验输入框值的合法性 - 通用方法
//var o={id: {tip:"名字格式为XXX",validators: [{rule: "notEmpty", err: "您未填写姓名，请填写。",params:[],focus:true,select:false},...] },...}
MUI.Validator.Check = function(o) {
    var othis = this;
    var obj;
    return Object.each(o, function(u, n) {
        obj = g(n);
        if ($(obj).css("display") == "none") return true;
        if ($(obj).attr("disabled") == true) return true;
        return Object.each(u.validators, function(v, i) {
            if (!othis.BCheckValue(obj.value, v.rule, v.params)) {
                alert(v.err);
                if (v.select) obj.select();
                if (v.focus) obj.focus();
                return false;
            }
            return true;
        });
    });
}
//非弹出方式：检验输入框值的合法性 - 通用方法
//var o={id: {tip:"名字格式为XXX",validators: [{rule: "notEmpty", err: "您未填写姓名，请填写。",params:[],focus:true,select:false},...] },...}
MUI.Validator.Check2 = function(o, k) {
    var othis = this;
    var obj;
    if (k == null) {
        var b = true;
        removeAlert();
        Object.each(o, function(u, n) {
            obj = g(n);
            if ($(obj).css("display") == "none") return true;
            if ($(obj).attr("disabled") == true) return true;
            Object.each(u.validators, function(v, i) {
                if (!othis.BCheckValue(obj.value, v.rule, v.params)) {
                    showAlert(v.err, obj);
                    if (b) {
                        if (v.select) obj.select();
                        if (v.focus) obj.focus();
                    }
                    b = false;
                    return false;
                }
                return true;
            });
            return true;
        });
        return b;
    }
    else {
        obj = g(k);
        removeAlert(obj);
        return Object.each(o[k].validators, function(v, i) {
            if (!othis.BCheckValue(obj.value, v.rule, v.params)) {
                showAlert(v.err, obj);
                if (b) {
                    if (v.select) obj.select();
                    if (v.focus) obj.focus();
                }
                b = false;
                return false;
            }
            return true;
        });
    }
}
//焦点则显示提示，失焦则提示错误
MUI.Validator.Tip = function(o) {
    var othis = this;
    Object.each(o, function(u, n) {
        //if (u.hasOwnProperty("tip")) return true;
        //if (!u.tip) return true;
        var obj = g(n);
        if (u.tip) {
            $(obj).focus(function() {
                removeAlert(this);
                showTip(u.tip, this);
            });
        }
        $(obj).blur(function() {
            removeTip(this);
            removeAlert(this);
            var othis2 = this;
            Object.each(o[this.id].validators, function(v, i) {
                if (!othis.BCheckValue(othis2.value, v.rule, v.params)) {
                    showAlert(v.err, othis2);
                    if (v.select) othis2.select();
                    if (v.focus) othis2.focus();
                    return false;
                }
                return true;
            });
        });
    });
}

//显示警告信息
function showAlert(info, el, id) {
    var nid, pEl;
    if (id == null) nid = "alert_" + el.id;
    else nid = id;
    if (id == null) pEl = el.parentNode;
    else pEl = el;
    if (g("tip_" + nid) != null) pEl.removeChild(g("tip_" + nid));
    if (g(nid) != null) { return; }
    var newd = document.createElement("em");
    newd.id = nid;
    newd.className = 'alertInfo';
    newd.innerHTML = info;
    pEl.appendChild(newd);
}
//显示提示信息
function showTip(info, el, id) {
    var nid, pEl;
    if (id == null) nid = "tip_" + el.id;
    else nid = id;
    if (id == null) pEl = el.parentNode;
    else pEl = el;
    if (g("alert_" + nid) != null) pEl.removeChild(g("alert_" + nid));
    if (g(nid) != null) { return; }
    var newd = document.createElement("em");
    newd.id = nid;
    newd.className = 'tipInfo';
    newd.innerHTML = info;
    pEl.appendChild(newd);
}
//删除警告信息
function removeAlert(el) {
    if (typeof el == "string") {
        if (g(el) == null) { return; }
        g(el).parentNode.removeChild(g(el));
    } else {
        if (el) {
            if (g("alert_" + el.id))
                el.parentNode.removeChild(g("alert_" + el.id));
        } else {
            $(".alertInfo").each(function() {
                this.parentNode.removeChild(this);
            });
        }
    }
}
//删除提示信息
function removeTip(el) {
    if (typeof el == "string") {
        if (g(el) == null) { return; }
        g(el).parentNode.removeChild(g(el));
    } else {
        if (el) {
            if (g("tip_" + el.id))
                el.parentNode.removeChild(g("tip_" + el.id));
        } else {
            $(".tipInfo").each(function() {
                this.parentNode.removeChild(this);
            });
        }
    }
}
function g(nodeId) {
    return document.getElementById(nodeId);
};

if (typeof LoadStyle != 'function') {
    //apply style text.
   LoadStyle= function(s) {
        if ($.browser.msie) {
            document.createStyleSheet().cssText = s;
            //el = ss.owningElement;
        }
        else {
            var el = document.createElement("STYLE");
            el.type = "text/css";
            el.appendChild(document.createTextNode(s));
            document.getElementsByTagName("HEAD")[0].appendChild(el);
        }
    };
}
LoadStyle("em.alertInfo{font-style:normal;font-size:12px;background:#FFF2E9 none repeat scroll 0 0;border:1px solid #FF6600;color:#696969;margin:0px 0px 0px 5px;padding:2px 3px;}\n em.tipInfo{font-size:12px;font-style:normal;background:#EEEEFF none repeat scroll 0 0;border:1px solid #CCCCEE;color:#696969;margin:0px 0px 0px 5px;padding:2px 3px;}");