﻿///////////////////////////////////
var isMobile = (typeof Mobile == 'boolean');
if (typeof MUI != "object") MUI = {};
function GetBasePath() {
    var i, base;
    //var src = "js/mui-base.js",
    var re = /(^|\/)js\/MUI\.Window.js/i;
    var scripts = document.getElementsByTagName("script");
    var l = scripts.length;
    for (i = 0; i < l; i++) {
        if (re.test(scripts[i].src)) {
            base = RegExp.leftContext;
            if (base != "") base += "/";
            break;
        }
    }
    return window._BasePath = base;
}
if (typeof MuiModal == 'undefined') {
    if (window._BasePath) Include(window._BasePath + "js/MWindow/MuiModal.js", true, "MuiModal");
    else {
        var bp = GetBasePath();
        $.getScript(bp + "js/MWindow/MuiModal.js");
    }
}
 if (typeof LoadCss != 'function') {
    //apply css file.
    LoadCss = function(oUri, id) {
        var el = document.createElement("link");
        el.type = "text/css";
        el.rel = "stylesheet";
        el.href = String(oUri);
        if (id) el.id = id;
        document.getElementsByTagName("HEAD")[0].appendChild(el);
    };
    //条件加载脚本
    LoadScriptBy = function(id, script) {
        if (!id || script == null) return;
        window["loadScript_timer_" + id || ""] = window.setInterval(function() {
            if (document.getElementById(id)) {
                clearInterval(window["loadScript_timer_" + id]);
                eval(script);
            }
        }, 300);
    };
    //extend json object
    Extend = function(dst, src, replace) {
        if (!dst) return;
        for (var prop in src) {
            if (!replace && dst[prop] != null) { continue; }
            //if (!replace && dst.hasOwnProperty(prop)) { continue; }
            dst[prop] = src[prop];
        }
        return dst;
    };
    EscapeURL = function(href) {
        if (/\?/.test(href)) {
            var reg = new RegExp("(\\?|#|&)[\\w]+=([^&]*)", "g");
            var r = (href || window.location.href).match(reg);
            for (var i = 0, l = r.length; i < l; i++) {
                var c = r[i].substr(r[i].indexOf("="));
                href = href.replace(c, "=" + escape(c.substr(1)));
            }
        }
        return href;
    };
    QueryString=function(name, href) {
        var reg = new RegExp("(\\?|#|&)" + name + "=([^&]*)(&|$)", "i");
        var r = (href || window.location.href).match(reg);
        if (r != null) return unescape(r[2]); return null;
    };
}
LoadCss(window._BasePath + "js/_window/styles/_Window.css");
if (typeof HDGrid == "undefined" && document.getElementById("MWindowCss") == null) LoadCss(window._BasePath + "js/MWindow/mwindow.css");

//////////////////////////////////////////////////显示消息框，对话框，模态窗口/////////////////////////////////////////////
/* p:{id:'xxx',type:'fonshen',style:'none',width:xxx,height:yyy,title:xxx,content:xxx,resize:true,drag:true,close:true,max:true,min:true,cssText:'',cssFile:'',reload:true,autoSize:true}
* jqmp:{overlay:x,overlayClass :x,closeClass:x,trigger:x,ajax:x,ajaxText :x,ajaxMode:'iframe'|'inline',target :x,modal :x,toTop:true,[Callbacks] ,onShow(callback) :fn,onHide(callback):fn}
* type=fonshen:style:'nokia','cabal','sword','vista'
* type=none:style:'default','none'
* type=dialog:style:...未做
* type=tip:style:...未做
* e.g:1、MUI.Window.open({id:'ViewEditor'},{overlay:10,modal:true,toTop:true});
*     2、MUI.Window.open({id:'designwin',type:'fonshen',style:'vista',width:690,height:505,title:'数据列表设计',resize:false},{overlay:10,ajax:'design.htm?fc=Test'})
*/
MUI.Window = {
    zIndex: 3000
    , open: function(p, jqmp, reload) {
        if (p.id == null) p.id = Guid();
        var we = document.getElementById(p.id);
        if (!we || !we.created || (reload || p.reload)) {
            we = this.create(p, jqmp);
        }
        $(we).jqmShow();
        we.previousID = this.currentID;
        this.currentID = p.id;
        we.reload = p.reload;
        we.fnClose = p.fnClose;
        window["child"] = this;
        this.el = we;
        muiw_goFront(we);
        if (this.zIndex) this.zIndex += 1;
        else this.zIndex = 3000;
    }
    , showBox: function(p, jqmp, reload) {
        if (p.id == null) p.id = Guid();
        var we = document.getElementById(p.id);
        if (!we || !we.created || (reload || p.reload)) {
            Extend(p, { type: "none" });
            we = this.create(p, jqmp);
        }
        $(we).jqmShow();
        we.previousID = this.currentID;
        this.currentID = p.id;
        we.reload = p.reload;
        we.fnClose = p.fnClose;
        window["child"] = this;
        this.el = we;
        muiw_goFront(we);
        if (this.zIndex) this.zIndex += 1;
        else this.zIndex = 3000;
    }
    , create: function(p, jqmp) {
        var we;
        if (document.getElementById(p.id)) {
            we = document.getElementById(p.id);
            //if(!jqmp.ajax) Extend(p, { type: "self" }, true);
        }
        else {
            we = document.createElement("div");
            we.id = p.id;
            document.body.appendChild(we);
            if (p.className) we.className = p.className;
            if (p.cssText) LoadStyle(p.cssText);
            if (p.cssFile) LoadCss(p.cssFile);
        }
        switch (p.type) {
            case "self":
                break;
            case "none":
                Extend(p, { style: "default" }, false);
                switch (p.style) {
                    case "default":
                    case "none":
                        if (!we.className) we.className = 'jqmWindow' + ' ' + p.style;
                        if (p.width) we.style.width = parseInt(p.width) + "px";
                        if (p.height) we.style.height = parseInt(p.height) + "px";
                        if (p.content) {
                            if (typeof p.content == 'string')
                                we.innerHTML = p.content;
                            else {
                                we.appendChild(p.content);
                                p.content.style.display = "";
                            }
                        }
                        else if (jqmp.ajax) {
                            we.innerHTML = "<iframe class='iframe-container' style=\"\" frameborder=\"0\" width=\"100%\" height=\"100%\" scrolling=\"no\"></iframe>";
                            var obj = $(we).find(".iframe-container").get(0);
                            obj.frameBorder = 0;
                            obj.marginHeight = 0;
                            obj.marginWidth = 0;
                            obj.src = jqmp.ajax;
                            delete jqmp.ajax;
                        }
                        break;
                }
                break;
            case "mui":
            case "fonshen":
            default:
                if (jqmp.ajax) Extend(jqmp, { ajaxMode: 'iframe' });
                if (we.created) {
                    if (jqmp.ajaxMode == "iframe") {
                        var src = jqmp.ajax;
                        delete jqmp.ajax;
                        we.container.src = src;
                        break;
                    }
                    else {
                        if (p.content) {
                            if (typeof p.content == 'string')
                                we.container.innerHTML = p.content;
                            else {
                                p.content.style.display = "";
                                $(we.container).empty();
                                we.container.innerHTML = "";
                                we.container.appendChild(p.content);
                            }
                        }
                    }
                    return we;
                } else {
                    Extend(p, { close: true, resize: true, drag: true, min: true, autoSize: true }, false);
                    we.style.position = "absolute"; //"fixed"; 
                    if (p.type == "fonshen") {
                        we.className = (p.style || "vista").toUpperCase();
                        Init_Fonshen(we, p, jqmp);
                    } else {
                        if (p.width == 0 && p.height == 0) {
                            p.width = 0, p.height = 0;
                            we.openState = "max";
                            if (jqmp.ajax) { p.width = $(window).width(); p.height = $(window).height(); }
                        }
                        we.className = (p.style || "default").toUpperCase();
                        Init_MWindow(we, p, jqmp);
                    }
                }
                break;

        }
        $(we).jqm(Extend(jqmp, { onShow: function(hash) {
            if (we.state != "max") {
                if (we.style.position == "absolute") {
                    hash.w.css("left", (p.left != null ? p.left : ((document.body.scrollLeft || document.documentElement.scrollLeft) + ($(window).width() - parseInt(p.width || hash.w.width())) / 2)) + "px");
                    var stop = (document.body.scrollTop || document.documentElement.scrollTop);
                    if (stop > 20) stop += 32;
                    hash.w.css("top", (p.top != null ? p.top : Math.max((stop + ($(window).height() - parseInt(p.height || hash.w.height())) / 2 - 10), 5)) + "px");
                }
                else {
                    hash.w.css("left", (p.left != null ? p.left : (($(window).width() - parseInt(p.width || hash.w.width())) / 2)) + "px");
                    hash.w.css("top", (p.top != null ? p.top : Math.max((($(window).height() - parseInt(p.height || hash.w.height())) / 2 - 10), 5)) + "px");
                }
            }
            //hash.w.css('opacity', 0.88).show();
            hash.w.css("zIndex", p.zIndex || MUI.Window.zIndex);
            hash.w.show();
            if (we.openState == "max") {
                $(we).find(".window-maximize-button").trigger("click");
                we.openState = null;
            }
            //hash.w.css('opacity', 0.92).slideDown(); 
        }
            //        , onHide: function(hash) {
            //            //            hash.w.css('opacity', 1);
            //            //            hash.w.fadeOut('2000', function() { hash.o.remove(); });
            //            hash.w.slideUp("slow", function() { if (hash.o) hash.o.remove(); });
            //        }
            //        , onload: function(hash) {

            //        }
        }, true));
        we.created = true;
        //this.we = we;
        return we;
    }
    , config: function(id, jqmp) {
        if (jqmp) $("#" + id).jqm(jqmp);
    }
    , show: function(id, jqmp) {
        if (jqmp) $("#" + id).jqm(jqmp);
        if (id) $("#" + id).jqmShow();
        this.currentID = id;
    }
    , hide: function(id) {
        if (!id) id = this.currentID;
        id = this.getCurrent(id);
        this.currentID = $.g(id).previousID;
        $('#' + id).jqmHide(null, true);
        //this.currentID = null;
    }
    //b-是否关闭前一个窗口
    , close: function (id, b) {
        if (!id) {
            id = this.currentID;
            if (b && id) {
                var ell = $.g(id);
                if (ell && ell.previousID && $.g(ell.previousID).style.display != 'none') id = ell.previousID;
            }
            if (!b) id = this.getCurrent(id);
        }
        if (id) {
            var ell = $.g(id);
            if (ell == null) return;
            this.currentID = ell.previousID;
            $('#' + id).jqmHide(null, true);
            if (ell.fnClose) {
                ell.fnClose();
            }
            //            if (ell.reload) {
            //                $(ell).empty();
            //                ell.parentNode.removeChild(ell);
            //            }
        }
    }
    , getCurrent: function(id) {
        if (id && $.g(id) && $.g(id).style.display != "none") return id;
        else {
            $.each($(".jm_dialog").get(), function(i, d) {
                if (d.style.display != "none") { id = d.id; return false; }
            });
        }
        return id;
    }
    , empty: function(id) {
        var we = $.g(id);
        if (we != null) {
            $(we).jqmHide(null, true);
            if (we.container) we.container.innerHTML = "";
        }
    }
    , remove: function(id) {
        var we = $.g(id);
        if (we != null) {
            $(we).jqmHide(null, true);
            $(we).empty();
            $(we).remove();
            we.parentNode.removeChild(we);
        }
    }
    , addTrigger: function(id, o) {
        $('#' + id).jqmAddTrigger(o);
    }
    , addClose: function(id, o) {
        $('#' + id).jqmAddClose(o);
    }
    , setTitle: function(t, id) {
        if (!id) id = this.currentID;
        $('#' + id).find(".TITLE").html(t);
    }
    , getTitle: function() {
        return $('#' + this.currentID).find(".TITLE").html();
    }
    , minWin: []
    , minSize: { w: 120, h: 27, i: 5 }
    , gofront: function(id) {
        if (!id) id = this.currentID;
        muiw_goFront($.g(id));
    }
}
////////////////////////////////////////////MWindow////////////////////////////////////////////////////////////////////////
function Init_MWindow(we, p, jqmp) {
    $(we).addClass("mui-component"); //.css("zIndex", 100).css("display", "none").attr("tabindex", 0)
    var sb = [];
    sb.push("<iframe class=\"mui-iframe\" style=\"left: -2px; top: -2px;\" tabindex=\"1\"></iframe>");
    sb.push("<div class=\"mui-window active window\" style=\"left: 0px; top: 0px;\">");
    sb.push("<div class=\"mui-window-caption window-caption\" style=\"left: 2px; top: 2px;height: 19px;\">");
    sb.push("<div class=\"mui-component caption-image\" style=\"left: 2px; top: 1px; width: 16px; height: 16px;\"></div>");
    sb.push("<div class=\"mui-label TITLE\" style=\"left: 18px; top: 0px;height: 18px;\">", p.title, "</div>");
    sb.push("<div class=\"mui-button window-minimize-button\" style=\" top: 2px; width: 16px; height: 14px;\" tabindex=\"-1\"></div>");
    sb.push("<div class=\"mui-button window-maximize-button\" style=\"top: 2px; width: 16px; height: 14px;\" tabindex=\"-1\"></div>");
    sb.push("<div class=\"mui-button window-close-button\" style=\"top: 2px; width: 16px; height: 14px;\" tabindex=\"-1\"></div>");
    sb.push("</div>");
    if (jqmp.ajaxMode == 'iframe') {
        sb.push("<iframe class=\"mui-component window-container\" style=\"left: 2px; top: 21px;\"></iframe>");
    } else {
        sb.push("<div class=\"mui-component window-container\" style=\"left: 2px; top: 21px;\"></div>");
    }
    sb.push("</div>");
    we.innerHTML = sb.join("");

    var obj = we.container = $(we).find(".window-container").get(0);
    if (jqmp.ajax) {
        if (jqmp.ajaxMode == 'iframe') {
            if (p.content) $(obj).append(p.content);
            obj.frameBorder = 0;
            //obj.marginHeight = 0;
            //obj.marginWidth = 0;
            obj.src = jqmp.ajax;
            if (obj.src.indexOf("fc=") != -1) {
                obj.id ="ifr_"+ QueryString("fc", obj.src);
            }
            delete jqmp.ajax;
        } else {
            jqmp.target = obj;
        }
    } else {
        if (p.content) {
            if (typeof p.content == 'string')
                obj.innerHTML = p.content;
            else {
                p.content.style.display = "";
                obj.appendChild(p.content);
            }
        }
    }
    var w, h, bw, bh;
    bw = parseInt(p.width) || 500;
    bh = parseInt(p.height) || -1;
    if (bh < 0) bh = obj.offsetHeight;
    if (p.autoSize && bh > ($(window).height() - 35)) {
        bh = $(window).height() - 35;
        obj.style.overflow = "auto";
    }
    if (!$.browser.msie) {
        if (p.scroll) obj.style.overflow = "scroll";
        else if (p.scrollx) obj.style.overflowX = "scroll";
        else if (p.scrolly) obj.style.overflowY = "scroll";
    }
    
    obj.style.width = bw + "px";
    obj.style.height = bh + "px";
    if (obj.style.overflow == "" && obj.firstChild && obj.firstChild.offsetHeight > obj.offsetHeight) {
        bh = obj.firstChild.offsetHeight;
        obj.style.height = bh + "px";
    }   
    w = bw + 8;
    h = bh + 27;
    we.style.width = w + "px";
    we.style.height = h + "px";
    $(we).find(".mui-iframe").css("width", w + 4);
    $(we).find(".mui-iframe").css("height", h + 4);
    $(we).find(".mui-window").css("width", w);
    $(we).find(".mui-window").css("height", h);
    $(we).find(".window-caption").css("width", w - 8);
    $(we).find(".mui-label").css("width", w - 80);
    $(we).find(".window-minimize-button").css("left", w - 60);
    $(we).find(".window-maximize-button").css("left", w - 44);
    $(we).find(".window-restore-button").css("left", w - 44);
    $(we).find(".window-close-button").css("left", w - 26);
    if (p.drag) {
        //$(we).find(".mui-label").bind("mousedown", muiwdrag_mousedown);
        $(we).jqDrag(".mui-label");
    }
    if (p.resize) {
        $(we).bind("mousemove", muiw_mousemove);
        $(we).bind("mousedown", muiwresize_mousedown);
        $(we).find(".mui-window-caption").bind("mousedown", function(e) { muiw_goFront(we); e.stopPropagation(); });
        $(we).find(".window-container").bind("mousedown", function(e) { muiw_goFront(we); e.stopPropagation(); });
        p.max = true;
    } else {
        p.max = false;
    }

    if (p.min) {
        $(we).find(".window-minimize-button").bind("click", function(e) {
            if ($(this).hasClass("window-minimize-button")) {
                $(this).next().removeClass("window-restore-button");
                $(this).next().addClass("window-maximize-button");
                //muiw_afterResize(we, { left: 10, top: $(window).height() - 30, width: 120, height: 27 }, we.state == "max" ? true : false);                
                MUI.Window.minWin.push(we.id);
                muiw_resetRank(we.id);
                $(this).removeClass("window-minimize-button");
                $(this).addClass("window-restore-button");
                //$(".mui-label").unbind("mousedown", muiwdrag_mousedown);
                $(we).unbind("mousemove", muiw_mousemove);
                $(we).unbind("mousedown", muiwresize_mousedown);
                we.style.cursor = "default";
                we.state = "min";
            } else {
                $(this).removeClass("window-restore-button");
                $(this).addClass("window-minimize-button");
                muiw_afterResize(we, { left: we.startLeft, top: we.startTop, width: we.startWidth, height: we.startHeight });
//                $(".mui-label").bind("mousedown", muiwdrag_mousedown);
                $(we).bind("mousemove", muiw_mousemove);
                $(we).bind("mousedown", muiwresize_mousedown);
                we.state = "res";
                MUI.Window.minWin.remove(we.id);
                muiw_resetRank();
            }
        });
    } else {
        $(we).find(".window-minimize-button").addClass("window-minimize-button-disabled").attr("disabled", true); ;
    }

    if (p.max) {
        //        we.startLeft = we.style.left;
        //        we.startTop = we.style.top;
        //        we.startWidth = we.style.width;
        //        we.startHeight = we.style.height;
        $(we).find(".window-maximize-button").bind("click", function(e) {
            if ($(this).hasClass("window-maximize-button")) {
                $(this).prev().removeClass("window-restore-button");
                $(this).prev().addClass("window-minimize-button");
                muiw_afterResize(we, { left: 0, top: 0, width: $(window).width(), height: $(window).height() }, we.state == "min" ? true : false);
                $(this).removeClass("window-maximize-button");
                $(this).addClass("window-restore-button");
                //$(".mui-label").unbind("mousedown", muiwdrag_mousedown);
                $(we).unbind("mousemove", muiw_mousemove);
                $(we).unbind("mousedown", muiwresize_mousedown);
                we.style.cursor = "default";
                if (we.state == "min") {
                    MUI.Window.minWin.remove(we.id);
                    muiw_resetRank();
                }
                we.state = "max";
            } else {
                $(this).removeClass("window-restore-button");
                $(this).addClass("window-maximize-button");
                muiw_afterResize(we, { left: we.startLeft, top: we.startTop, width: we.startWidth, height: we.startHeight });
                //$(".mui-label").bind("mousedown", muiwdrag_mousedown);
                $(we).bind("mousemove", muiw_mousemove);
                $(we).bind("mousedown", muiwresize_mousedown);
                we.state = "res";
            }
        });
    } else {
        $(we).find(".window-maximize-button").addClass("window-maximize-button-disabled").attr("disabled", true);
    }

    if (p.close) {
        jqmp.closeClass = "window-close-button";
    } else {
        $(we).find(".window-close-button").addClass("window-close-button-disabled").attr("disabled", true); ;
    }

}
function muiw_resetRank(wid) {
    var ww = $(window).width() - 10;
    var wh = $(window).height();
    var iw = (MUI.Window.minSize.w + MUI.Window.minSize.i);
    var ih = 30;
    var ln = Math.floor(ww / iw);
    var we;
    if (wid) {
        we = $.g(wid);
        muiw_afterResize(we, { width: MUI.Window.minSize.w, height: MUI.Window.minSize.h }, we.state == "max" ? true : false);
    }
    var arrFW = MUI.Window.minWin.filter(function(o, i) {
        if ($.g(o).style.display == "none") return false;
        return true;
    });
    var l = arrFW.length;
    for (var i = 0; i < l; i++) {
        we = $("#" + arrFW[i]);
        we.css("left", 5 + (i % ln) * iw);
        we.css("top", wh - (Math.floor(i / ln) + 1) * ih);
        we.css("width", MUI.Window.minSize.w);
        we.css("height", MUI.Window.minSize.h);
    }
}
function muiw_goFront(we) {
    //    var we;
    //    if (e.data) we = e.data; else we = e;
    if (MUI.Window.currentID && MUI.Window.currentID != we.id) {
        var nIndex = parseInt($("#" + MUI.Window.currentID).css("zIndex")) + 1;
        $(we).css("zIndex", nIndex);
        MUI.Window.zIndex = nIndex;
        MUI.Window.currentID = we.id;
    }
}
function muiw_getWireFrame(w) {
    if ($(w).parent().find(".window-wireframe").length == 0) {
        $(w).after("<div class=\"mui-component window-wireframe\" style=\"z-index:999999;visibility:hidden;\"></div>");
    }
    return $(w).parent().find(".window-wireframe").get(0);
}
function muiwdrag_mousedown(e) {
    e.stopPropagation();
    var w = $(this).parent().parent().parent().get(0);
    muiw_goFront(w);
    var ow = muiw_getWireFrame(w); //$(".window-wireframe").get(0);
    ow.startX = e.clientX;
    ow.startY = e.clientY;
    ow.startL = parseInt(w.style.left);
    ow.startT = parseInt(w.style.top);
    $(ow).css("left", w.style.left);
    $(ow).css("top", w.style.top);
    $(ow).css("width", w.style.width);
    $(ow).css("height", w.style.height);
    $(ow).css("visibility", "inherit");
    $(ow).bind("mousemove", w, muiwdrag_mousemove);
    $(ow).bind("mouseup", w, muiwdrag_mouseup);
    ow.drag = true;
}
function muiwdrag_mousemove(e) {
    if (this.drag) {
        this.style.left = (this.startL + (e.clientX - this.startX)) + "px";
        this.style.top = (this.startT + (e.clientY - this.startY)) + "px";
    }
};
function muiwdrag_mouseup(e) {
    var w = e.data;
    w.style.left = this.style.left;
    w.style.top = this.style.top;
    $(this).css("visibility", "hidden");
    $(this).unbind("mousemove", muiwdrag_mousemove);
    $(this).unbind("mouseup", muiwdrag_mouseup);
    this.drag = false;
};
function muiwresize_mousedown(e) {
    muiw_goFront(this);
    if (this.resize) {
        var ow = muiw_getWireFrame(this); // $(".window-wireframe").get(0);
        ow.startX = e.clientX;
        ow.startY = e.clientY;
        ow.startT = parseInt(this.style.top);
        ow.startL = parseInt(this.style.left);
        ow.startW = parseInt(this.style.width);
        ow.startH = parseInt(this.style.height);
        $(ow).css("left", this.style.left);
        $(ow).css("top", this.style.top);
        $(ow).css("width", this.style.width);
        $(ow).css("height", this.style.height);
        $(ow).css("visibility", "inherit");
        $(document.body).bind("mousemove", this, muiwresize_mousemove);
        $(document.body).bind("mouseup", this, muiwresize_mouseup);
        this.down = true;
    }
}
function muiwresize_mousemove(e) {
    var we = e.data;
    var ow = muiw_getWireFrame(we);  //$(".window-wireframe").get(0);
    if (!we.down) return false; //$.g("txtShow").value = e.clientX;
    var w, h;
    switch (we.cursor) {
        case "n":
            ow.style.top = (ow.startT + (e.clientY - ow.startY)) + "px";
            h = (ow.startH - (e.clientY - ow.startY));
            if (h >= MUI.Window.minSize.h)
                ow.style.height = h + "px";
            break;
        case "s":
            h = ow.startH + (e.clientY - ow.startY);
            if (h >= MUI.Window.minSize.h)
                ow.style.height = h + "px";
            break;
        case "w":
            ow.style.left = (ow.startL + (e.clientX - ow.startX)) + "px";
            w = ow.startW - (e.clientX - ow.startX);
            if (w >= MUI.Window.minSize.w)
                ow.style.width = w + "px";
            break;
        case "e":
            w = ow.startW + (e.clientX - ow.startX);
            if (w >= MUI.Window.minSize.w)
                ow.style.width = w + "px";
            break;
        case "nw":
            ow.style.top = (ow.startT + (e.clientY - ow.startY)) + "px";
            h = (ow.startH - (e.clientY - ow.startY));
            if (h >= MUI.Window.minSize.h)
                ow.style.height = h + "px";
            ow.style.left = (ow.startL + (e.clientX - ow.startX)) + "px";
            w = ow.startW - (e.clientX - ow.startX);
            if (w >= MUI.Window.minSize.w)
                ow.style.width = w + "px";
            break;
        case "ne":
            ow.style.top = (ow.startT + (e.clientY - ow.startY)) + "px";
            h = (ow.startH - (e.clientY - ow.startY));
            if (h >= MUI.Window.minSize.h)
                ow.style.height = h + "px";
            w = ow.startW + (e.clientX - ow.startX);
            if (w >= MUI.Window.minSize.w)
                ow.style.width = w + "px";
            break;
        case "sw":
            h = ow.startH + (e.clientY - ow.startY);
            if (h >= MUI.Window.minSize.h)
                ow.style.height = h + "px";
            ow.style.left = (ow.startL + (e.clientX - ow.startX)) + "px";
            w = ow.startW - (e.clientX - ow.startX);
            if (w >= MUI.Window.minSize.w)
                ow.style.width = w + "px";
            break;
        case "se":
            h = ow.startH + (e.clientY - ow.startY);
            if (h >= MUI.Window.minSize.h)
                ow.style.height = h + "px";
            w = ow.startW + (e.clientX - ow.startX);
            if (w >= MUI.Window.minSize.w)
                ow.style.width = w + "px";
            break;
    }
}
function muiwresize_mouseup(e) {
    var w = e.data;
    var ow = muiw_getWireFrame(w); //$(".window-wireframe").get(0);
    $(ow).css("visibility", "hidden");
    $(document.body).unbind("mousemove", muiwresize_mousemove);
    $(document.body).unbind("mouseup", muiwresize_mouseup);
    muiw_afterResize(e.data);
    w.down = false;
};
function muiw_mousemove(e) {
    if (this.down) return;
    var _dir = "";
    var oy = $.getOffsetY(e);
    if (oy <= 20) _dir += "n";
    else if (oy >= this.offsetHeight - 20) _dir += "s";
    var ox = $.getOffsetX(e);
    if (ox <= 20) _dir += "w";
    else if (ox >= this.offsetWidth - 20) _dir += "e";
    //$.g("txtShow").value = oy+","+(this.offsetHeight - 20)+","+ox+","+(this.offsetWidth - 20);

    if (_dir != "") {
        this.style.cursor = _dir + "-resize";
        this.resize = true;
        this.cursor = _dir;
    }
    else {
        this.style.cursor = "default";
        this.resize = false;
    }
}
function muiw_afterResize(w, bounds, noinit) {
    if (bounds == null) {
        var ow = muiw_getWireFrame(w);  //$(".window-wireframe").get(0);
        bounds = { left: ow.style.left, top: ow.style.top, width: ow.style.width, height: ow.style.height };
    } else {
        if (bounds.left && bounds.left.toString().indexOf("px") == -1) bounds.left += "px";
        if (bounds.top && bounds.top.toString().indexOf("px") == -1) bounds.top += "px";
        if (bounds.width && bounds.width.toString().indexOf("px") == -1) bounds.width += "px";
        if (bounds.height && bounds.height.toString().indexOf("px") == -1) bounds.height += "px";
    }
    if (!noinit) {
        w.startLeft = w.style.left;
        w.startTop = w.style.top;
        w.startWidth = w.style.width;
        w.startHeight = w.style.height;
    }

    if (bounds.left != null) w.style.left = bounds.left;
    if (bounds.top != null) w.style.top = bounds.top;
    w.style.width = bounds.width;
    w.style.height = bounds.height;
    $(w).find(".mui-iframe").css("width", parseInt(bounds.width) + 4);
    $(w).find(".mui-iframe").css("height", parseInt(bounds.height) + 4);
    $(w).find(".mui-window").css("width", bounds.width);
    $(w).find(".mui-window").css("height", bounds.height);
    $(w).find(".window-caption").css("width", parseInt(bounds.width) - 8);
    $(w).find(".mui-label").css("width", parseInt(bounds.width) - 80);
    $(w).find(".window-minimize-button").css("left", parseInt(bounds.width) - 60);
    $(w).find(".window-maximize-button").css("left", parseInt(bounds.width) - 44);
    //$(w).find(".window-restore-button").css("left", parseInt(bounds.width) - 44);
    $(w).find(".window-close-button").css("left", parseInt(bounds.width) - 26);
    $(w).find(".window-container").css("width", parseInt(bounds.width) - 8);
    $(w).find(".window-container").css("height", parseInt(bounds.height) - 27);
}

////////////////////////////////////////////////////////////////Fonshen/////////////////////////////////////////////////////////////////
function Init_Fonshen(we, p, jqmp) {
    var w, h, bw, bh;
    bw = parseInt(p.width) || 400;
    bh = parseInt(p.height) || -1;
    var styles = new Array("LEFT_TOP", "TOP", "RIGHT_TOP", "RIGHT", "RIGHT_BOTTOM", "BOTTOM", "LEFT_BOTTOM", "LEFT", "CONTENT", "TITLE");
    var sides = new Array();
    if (p.resize) {
        styles[styles.length] = "RESIZE";
        p.drag = true;
    }
    if (p.close) {
        styles[styles.length] = "CLOSE";
        jqmp.closeClass = "CLOSE";
    }
    var obj;
    for (var i = 0; i < styles.length; i++) {
        if (styles[i] == "CONTENT") {
            if (jqmp.ajaxMode == 'iframe') {
                obj = document.createElement("iframe");
            } else {
                obj = document.createElement("div");
            }
            we.container = obj;
        }
        else {
            obj = document.createElement("div");
        }
        obj.className = styles[i];
        obj.style.position = "absolute";
        we.appendChild(obj);
        sides[i] = obj;
        switch (styles[i]) {
            case "CONTENT":
                obj.style.width = bw + "px";
                if (jqmp.ajaxMode == 'iframe') {
                    if (p.content) $(obj).append(p.content);
                    //obj.style.overflow = "auto";
                } else {
                    if (p.content) {
                        if (typeof p.content == 'string')
                            obj.innerHTML = p.content;
                        else {
                            p.content.style.display = "";
                            obj.appendChild(p.content);
                        }
                    }
                }
                if (bh < 0) bh = obj.offsetHeight;
                if (p.autoSize && bh > ($(window).height() - 50)) {
                    bh = $(window).height() - 50;
                    obj.style.overflow = "auto";
                }
                w = bw + sides[3].width + sides[7].width;
                h = bh + sides[1].height + sides[5].height;
                obj.style.height = bh + "px";
                obj.style.left = (sides[7].width + obj.offsetLeft) + "px";
                obj.style.top = (sides[1].height + obj.offsetTop) + "px";
                we.style.width = w + "px";
                we.style.height = h + "px";
                if (jqmp.ajax) {
                    if (jqmp.ajaxMode == 'iframe') {
                        obj.frameBorder = 0;
                        //obj.marginHeight = 0;
                        //obj.marginWidth = 0;
                        obj.src = jqmp.ajax;
                        delete jqmp.ajax;
                    } else {
                        jqmp.target = obj;
                    }
                }
                break;
            case "TITLE":
                obj.style.width = (w - obj.offsetWidth) + "px";
                if (p.title) obj.innerHTML = p.title;
                break;

            case "RESIZE":
                obj.style.cursor = "se-resize";
                break;
            default:
                sides[i].width = obj.offsetWidth;
                sides[i].height = obj.offsetHeight;
                break;
        }
    }
    sides[1].dx = sides[0].width + sides[2].width;
    if (w > sides[1].dx) sides[1].style.width = (w - sides[1].dx) + "px";
    sides[3].dy = sides[2].height + sides[4].height;
    if (h > sides[3].dy) sides[3].style.height = (h - sides[3].dy) + "px";
    sides[5].dx = sides[4].width + sides[6].width;
    if (w > sides[5].dx) sides[5].style.width = (w - sides[5].dx) + "px";
    sides[7].dy = sides[6].height + sides[0].height;
    if (h > sides[7].dy) sides[7].style.height = (h - sides[7].dy) + "px";

    sides[0].style.left = "0px";
    sides[0].style.top = "0px";
    sides[1].style.left = sides[0].width + "px";
    sides[1].style.top = "0px";
    sides[2].style.right = "0px";
    sides[2].style.top = "0px";
    sides[3].style.right = "0px";
    sides[3].style.top = sides[2].height + "px";
    sides[4].style.right = "0px";
    sides[4].style.bottom = "0px";
    sides[5].style.left = sides[6].width + "px";
    sides[5].style.bottom = "0px";
    sides[6].style.left = "0px";
    sides[6].style.bottom = "0px";
    sides[7].style.left = "0px";
    sides[7].style.top = sides[0].height + "px";

    if (p.drag) {
        for (var k = 0, l = styles.length; k < l; k++) {
            if (styles[k] == "CONTENT") continue;
            $(we).jqDrag("." + styles[k]);
        }
    }
    if (p.resize) $(we).jqResize('.RESIZE', function() {
        var dx = $(we).width() - w;
        w += dx;
        sides[1].style.width = (w - sides[1].dx) + "px";
        sides[5].style.width = (w - sides[5].dx) + "px";
        sides[9].style.width = w + "px";
        bw += dx;
        sides[8].style.width = bw + "px";

        var dy = $(we).height() - h;
        h += dy;
        sides[3].style.height = (h - sides[3].dy) + "px";
        sides[7].style.height = (h - sides[7].dy) + "px";
        bh += dy;
        sides[8].style.height = bh + "px";
    });

    $(".TITLE").bind("mousedown", function(e) { muiw_goFront(we);});
}


//////////////////////////组件窗口打开/////////////////////////////////
//组件弹出窗口  {scroll:true,scrollx:true,scrolly:true}-出现流动条
function Open(url, param, param1) {
    url = EscapeURL(url);
    if (url.indexOf("rnd") == -1 && param && param.reload !== false) { if (url.indexOf("?") == -1) url += "?rnd=" + Math.random(); else url += "&rnd=" + Math.random(); }
    if (param1 != null && typeof param != "object") param = { width: param, height: param1 };
    else if (param == null) param = { width: 750, height: 500 };
    MUI.Window.open(Extend({ id: param.id || _getid(url), width: param.width || 750, height: param.height || 500, resize: false, reload: true }, param, true), { overlay: 0, ajax: url });
}
//组件最大化弹出窗口  {scroll:true,scrollx:true,scrolly:true}-出现流动条
function OpenM(url, param, param1) {
    url = EscapeURL(url);
    if (url.indexOf("rnd") == -1 && param && param.reload !== false) { if (url.indexOf("?") == -1) url += "?rnd=" + Math.random(); else url += "&rnd=" + Math.random(); }
    if (param == null) param = {};
    //MUI.Window.open(Extend({ id: _getid(url), left: 0, top: 0, width: $(window).width() - 8, height: $(window).height() - 28, resize: true, reload: true, autoSize: false }, param, true), { overlay: 0, ajax: url });
    MUI.Window.open(Extend({ id: param.id || _getid(url), width: 0, height: 0, resize: true, reload: true, autoSize: false }, param, true), { overlay: 0, ajax: url });
}
//组件可变大小弹出窗口  {scroll:true,scrollx:true,scrolly:true}-出现流动条
function OpenR(url, param, param1) {
    url = EscapeURL(url);
    if (url.indexOf("rnd") == -1 && param && param.reload !== false) { if (url.indexOf("?") == -1) url += "?rnd=" + Math.random(); else url += "&rnd=" + Math.random(); }
    if (param1 != null && typeof param != "object") param = { width: param, height: param1 };
    else if (param == null) param = { width: 750, height: 500 };
    MUI.Window.open(Extend({ id: param.id || _getid(url), width: param.width || 750, height: param.height || 500, resize: true, reload: true }, param, true), { overlay: 0, ajax: url });
}
//组件模态弹出窗口  {scroll:true,scrollx:true,scrolly:true}-出现流动条
function OpenModal(url, param, param1) {
    url = EscapeURL(url);
    if (url.indexOf("rnd") == -1 && param && param.reload !== false) { if (url.indexOf("?") == -1) url += "?rnd=" + Math.random(); else url += "&rnd=" + Math.random(); }
    if (param1 != null && typeof param != "object") param = { width: param, height: param1 };
    else if (param == null) param = { width: 750, height: 500 };
    MUI.Window.open(Extend({ id: param.id || _getid(url), width: param.width || 750, height: param.height || 500, resize: false, reload: true }, param, true), { overlay: 10, modal: true, ajax: url });
}
//组件可变大小模态弹出窗口  {scroll:true,scrollx:true,scrolly:true}-出现流动条
function OpenModalR(url, param, param1) {
    url = EscapeURL(url);
    if (url.indexOf("rnd") == -1 && param && param.reload !== false) { if (url.indexOf("?") == -1) url += "?rnd=" + Math.random(); else url += "&rnd=" + Math.random(); }
    if (param1 != null && typeof param != "object") param = { width: param, height: param1 };
    else if (param == null) param = { width: 750, height: 500 };
    MUI.Window.open(Extend({ id: param.id || _getid(url), width: param.width || 750, height: param.height || 500, resize: true, reload: true }, param, true), { overlay: 10, modal: true, ajax: url });
}

//弹出层
function Show(content, width, height, left, top, e) {
    if (e) {
        e = e || window.event;
        if (left == null && e) left = e.clientX;
        //if (!top) top = e.clientY;
        if (top == null && e) top = Math.min(($(window).height() - parseInt(height) - 0), e.clientY - 30) + (document.body.scrollTop || document.documentElement.scrollTop);
    }
    var param;
    if (typeof width != "object" && width!=null) param = { left: left, top: top, width: width || 300, height: height || 200 };
    else param = width;
    if (typeof content == "object") {
        var eid = content.id;        
        MUI.Window.showBox(Extend({ id: eid, content: null, reload: true}, param, true), { overlay: 10, modal: true }, false);
    }
    else {

        MUI.Window.showBox(Extend({ id: "ShowAllContentXY", content: content, reload: true }, param, true), { overlay: 1, modal: false }, false);
    }
}
//弹出对话框
//param hidetitle-是否隐藏标题栏，mobile-是否手机应用,noBorder-是否要边缘样式
function ShowDialog(param, cb) {
    var elid = param.id; content = param.content, title = param.title||(typeof lan == 'function' ? lan('系统提示') : "系统提示"), btnconfirmtext = param.ok, btncanceltext = param.cancel, fn = param.fn, fnYes = param.fnYes, fnNo = param.fnNo;
    var el = document.getElementById(elid || "jq_dialog");
    if (el == null) {
        var sb = [];
        if (!param.hidetitle) {
            sb.push("<div class=\"jm_dialog_head box\" style=\"cursor: move; border-width: 0 0 1px;\">");
            sb.push("<span class=\"jm_dialog_title TITLE\">", title, "</span></div>");
            if (param.mobile) {
                if (param.left == 0)
                    sb.push("<input onclick=\"window.child.close();\" class=\"btn_return\" value='< ", typeof lan == 'function' ? lan('返回') : "返回", "' />");
                else
                    sb.push("<a href=\"javascript:window.child.close();\" class=\"ico_close\"></a>");
            }
            else
                sb.push("<a href=\"javascript:window.child.close();\" class=\"ico_close\" title=\"\"></a>");
        }
        sb.push("<div style=\"visibility: visible;\">");
        sb.push("<div class=\"jm_dialog_inner\">");
        if (param.ajax) {
            sb.push("<div class=\"jm_dialog_content\" style=\"padding:0px;", (param.width ? "width:" + param.width + "px;" : ""),
            (param.height ? "height:" + (param.height - (param.hidetitle ? 0 : param.headHeight || 35)) + "px;" : ""),
            //    "\"><iframe src=\"", param.ajax, "\" frameborder=\"0\" width=\"100%\" height=\"100%\" scrolling=\"auto\"></iframe></div>");
           "\"><iframe class='iframe-container' frameborder=\"0\" width=\"100%\" height=\"100%\" scrolling=\"auto\"></iframe></div>");
        } else if (typeof content != "object") {
            sb.push("<div class=\"jm_dialog_content\"", (param.noBorder ? "" : " style=\"padding:20px 28px;text-align:left;\""), ">", content, "</div>");
        } else {
            sb.push("<div class=\"jm_dialog_content\"></div>");
        }
        sb.push("<div class=\"jm_dialog_operate box_bg\" style='border-width: 1px 0 0;", param.btncenter ? "text-align:center;font-size:14px;font-weight:bold;" : "", "'>");
        if (btnconfirmtext) sb.push("<input type=\"button\" value=\"", btnconfirmtext || "OK", "\" class=\"btnok_jq_dialog jm_dialog_btn btn\">");
        if (fnNo && btncanceltext) { if (btnconfirmtext) sb.push("&nbsp;&nbsp;&nbsp;&nbsp;"); sb.push("<input type=\"button\" value=\"", btncanceltext, "\" class=\"btnno_jq_dialog jm_dialog_btn btn\">"); }
        else if (btncanceltext) { if (btnconfirmtext) sb.push("&nbsp;&nbsp;&nbsp;&nbsp;"); sb.push("<input type=\"button\" value=\"", btncanceltext, "\" class=\"btnno_jq_dialog jm_dialog_btn btn\" onclick=\"window.child.close();\">"); }
        if (param.yesno) { sb.push("&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"button\" value=\"取消\" class=\"jm_dialog_btn btn\" onclick=\"window.child.close();\">"); }
        sb.push("</div>");
        sb.push("</div>");
        sb.push("</div>");
        el = document.createElement("div");
        el.id = elid || "jq_dialog";
        el.className = "jm_dialog box_bg";
        document.body.appendChild(el);
        if (param.width) el.style.width = param.width + "px";
        else if ($.browser.msie && typeof HDGrid != "undefined" && param.width != 0) el.style.width = "300px";
        el.innerHTML = sb.join("");
        if (param.ajax) $(el).find(".iframe-container").get(0).src = param.ajax;
        else if (typeof content == "object") {
            $(content).show();
            content.style.position = 'static';
            //            if (content.style.position == "absolute") content.style.position = 'static';
            //            else if (content.style.position == "relative") { content.style.left = 0; content.style.top = 0; }
            $(".jm_dialog_content", el).html(content);
        }
        if ($.browser.msie && typeof HDGrid == "undefined") $(".jm_dialog_head", el).width($(el).width() - 30);
        //else if ($.browser.msie)$(".jm_dialog_head", el).width($(el).width());
        $(el).jqDrag(".jm_dialog_head");
        if (!btnconfirmtext && !btncanceltext) {
            $(".jm_dialog_operate", el).hide();
        } else if (fn) {
            el.fn = fn;
            $(".btnok_jq_dialog", el).click(function() { if (param.confirm) closed(); el.fn(); });
        } else if (param.confirm) {
            $(".btnok_jq_dialog", el).click(function() { closed(); });
        } else if (fnYes) {
            $(".btnok_jq_dialog", el).click(function() { closed(); fnYes(); });
        }
        if (fnNo) {
            $(".btnno_jq_dialog", el).click(function() { closed(); fnNo(); });
        }
    } else {
        if (param.ajax) {
            if (param.reload) $(".jm_dialog_content iframe", el).attr("src", NewURL($(".jm_dialog_content iframe", el).attr("src")));
        }
        else {
            if (elid && typeof content == "string" && (param.reload || cb == null)) {
                $(".jm_dialog_content", el).html(content);
            } else if (!elid) {
                $(".jm_dialog_content", el).html(content);
                $(".jm_dialog_title", el).html(title);
                if (btnconfirmtext) {
                    if ($(".btnok_jq_dialog", el).length == 0) $(".jm_dialog_operate", el).prepend("<input type=\"button\" value=\"" + btnconfirmtext + "\" class=\"btnok_jq_dialog jm_dialog_btn btn\">&nbsp;&nbsp;&nbsp;&nbsp;");
                    else { $(".btnok_jq_dialog", el).show(); $(".btnok_jq_dialog", el).val(btnconfirmtext); }
                } else { $(".btnok_jq_dialog", el).hide(); }
                if (btncanceltext) {
                    if ($(".btnno_jq_dialog", el).length == 0) $(".jm_dialog_operate", el).append("&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"button\" value=\"" + btncanceltext + "\" class=\"btnno_jq_dialog jm_dialog_btn btn\">");
                    else { $(".btnno_jq_dialog", el).show(); $(".btnno_jq_dialog", el).val(btncanceltext); }
                } else { $(".btnno_jq_dialog", el).hide(); }
                if (!btnconfirmtext && !btncanceltext) {
                    $(".jm_dialog_operate", el).hide();
                } else {
                    $(".jm_dialog_operate", el).show();
                }
                if (fn) {
                    $(".btnok_jq_dialog", el).unbind("click");
                    $(".btnok_jq_dialog", el).click(function() { if (param.confirm) closed(); fn(); });
                } else if (param.confirm) {
                    $(".btnok_jq_dialog", el).unbind("click");
                    $(".btnok_jq_dialog", el).click(function() { closed(); });
                } else if (fnYes) {
                    $(".btnok_jq_dialog", el).unbind("click");
                    $(".btnok_jq_dialog", el).click(function() { closed(); fnYes(); });
                }
                if (fnNo) {
                    $(".btnno_jq_dialog", el).unbind("click");
                    $(".btnno_jq_dialog", el).click(function() { closed(); fnNo(); });
                }
            }
        }
    }
    if (cb) cb();
    Show(el, Extend({ reload: false, type: 'none' }, { top: param.top, left: param.left, width: param.width, height: param.height, type: param.type, reload: param.reload || false, fnClose: param.fnClose, zIndex: param.zIndex }, true));
}
function NewURL(url) {
    if (url.indexOf("rnd") == -1) {
        if (url.indexOf("?") == -1)
            url += "?rnd=" + Math.random();
        else
            url += "&rnd=" + Math.random();

    } else {
        url = url.substr(0, url.indexOf("rnd")) + "rnd=" + Math.random();
    }
    return url;
}
function _getid(url) {
    var id= url.replace(/\W/g, "").toLowerCase();
    if (id.length > 200) id = id.substr(0, 200);
    return id;
}

function Alert(info, width, w) {
    var fn;
    if (typeof width == "function") {
        fn = width; width = w;
        ShowDialog({ content: "<font>" + info + "</font>", mobile: typeof Mobile == 'boolean', btncenter: true, title: typeof lan == 'function' ? lan('系统提示') : "系统提示", ok: typeof lan == 'function' ? lan('确定') : "确定",alert:true, fn: fn, width: Math.floor((width || 300) * ($.qq || 1)) });
    }
    else {
        ShowDialog({ content: "<font>" + info + "</font>", mobile: typeof Mobile == 'boolean', btncenter: true, title: typeof lan == 'function' ? lan('系统提示') : "系统提示", cancel: typeof lan == 'function' ? lan('确定') : "确定", width: Math.floor((width || 300) * ($.qq || 1)) });
    }
}
function Confirm(info, fn, width) {
    ShowDialog({ content: "<font>" + info + "</font>", mobile: typeof Mobile == 'boolean', btncenter: true, title: typeof lan == 'function' ? lan('系统提示') : "系统提示", ok: typeof lan == 'function' ? lan('确定') : "确定", cancel: typeof lan == 'function' ? lan('取消') : "取消", confirm: true, fn: fn, width: Math.floor((width || 300) * ($.qq || 1)) });
}
function YesNo(info, fnYes, fnNo, width) {
    ShowDialog({ content: "<font style='min-width:100px;'>" + info + "</font>", mobile: typeof Mobile == 'boolean', btncenter: true, title: typeof lan == 'function' ? lan('系统提示') : "系统提示", ok: typeof lan == 'function' ? lan('是') : "是", cancel: typeof lan == 'function' ? lan('否') : "否",yesno:true, fnYes: fnYes, fnNo: fnNo, width: Math.floor((width || 300) * ($.qq || 1)) });
}
function closed() { window.child.close("jq_dialog"); }
//在父窗口打开MUI.Window
function MWin(b) {
    try {
        if (parent.location.host == location.host && parent.MUI.Window && (b == null || (b && parent.document.getElementById("HDGridCss"))))
            return parent.MUI.Window;
        else
            return MUI.Window;
    }
    catch (e) {
        return MUI.Window;
    }
}
//在父窗口打开window
function PWin(b) {
    try {
        if (parent.location.host == location.host && parent.MUI.Window && (b == null || b))
            return parent;
        else
            return window;
    }
    catch (e) {
        return window;
    }
}