﻿///////////////////////////////////自定义组件基类MoComponent///////////////////////////////////

function MoComponent() {
    if (_moInPrototype) return;
    MoEventTarget.call(this);
	this._children=[];
}
_p = Inherit(MoComponent, MoEventTarget, "MoComponent");
_p._element = null;
_p._created = false;

_p.setElement = function(el) {
    this._element = (typeof el === "string") ? document.getElementById(el) : el;
};
_p.setStyleProperty = function(sProp, sValue) {
    this._element.style[sProp] = sValue;
};
_p.getStyleProperty = function(sProp) {
    if (MUI.isIE)
        return this._element.currentStyle[sProp];
    else
        return document.defaultView.getComputedStyle(this._element, String.EMPTY)[sProp];
};
_p.removeStyleProperty = function(sProp) {
    this._element.style[sProp] = String.EMPTY;
};
_p.getHtmlProperty = function(sProp) {
    return this._element[sProp];
};
_p.setHtmlProperty = function(sProp, oValue) {
    this._element[sProp] = oValue;
};
_p.removeHtmlProperty = function(sProp) {
    if (MUI.isIE) this._element.removeAttribute(sProp);
    else delete this._element[sProp];
};
_p.setCssClassName = function(s) {
    this.setHtmlProperty("className", s);
};
_p.getCssClassName = function() {
    return this.getHtmlProperty("className");
};

_p.getLeft = function() {
        return this._element.offsetLeft;
};
_p.getRight = function() {
        return this._element.parentNode.clientWidth - this.getLeft() - this.getWidth();
};
_p.getTop = function() {
   return this._element.offsetTop;
};
_p.getBottom = function() {
        return this._element.parentNode.clientHeight() - this.getTop() - this.getHeight();
};
_p.getWidth = function() {
    if (MUI.isMoz) {
        if (this._element.style.width == String.EMPTY) {
            var ps = this._element.parentNode.style;
            var w = ps.width;
            var h = ps.height;
            ps.width = ps.height = "9999999px";
            var res = this._element.offsetWidth;
            ps.width = w;
            ps.height = h;
            return res;
        }
        return this._element.offsetWidth;
    }
    else {
        return this._element.offsetWidth;
    }
    return this._width;
};
_p.getHeight = function() {
    if (MUI.isMoz) {
        if (this._element.style.height == String.EMPTY) {
            var ps = this._element.parentNode.style;
            var w = ps.width;
            var h = ps.height;
            ps.width = ps.height = "9999999px";
            var res = this._element.offsetHeight;
            ps.width = w;
            ps.height = h;
            return res;
        }
        return this._element.offsetHeight;
    }
    else {
        return this._element.offsetHeight;
    }
    return this._height;
};
_p.getClientWidth = function() {
        return this._element.clientWidth;
};
_p.getClientHeight = function() {
        return this._element.clientHeight;
};

_p.dispose = function() {
    if (this._disposed) return;
    MoEventTarget.prototype.dispose.call(this);
    delete this._element;
};