﻿function MoHashTable(){
	MoObject.call(this);
	this._hash={};
	this._count=0;
	this._addCount=0;
}
_p=Inherit(MoHashTable,"MoObject","MoHashTable");
_p.add=function(key,val){
	if(!this.hasKey(key)){
		this._hash[key]=val;
		this._count++;
		this._addCount++;
	}
};
_p.remove=function(key){
	if(this.hasKey(key)){
		delete this._hash[key];
		 --this._count;
		if(MoBrowserCheck.ie&&this._addCount>this._count*4){
			this._recreate();
		}
	}
};
_p.clear=function(){
	this._hash={};
	this._count=0;
	this._addCount=0;
};
_p.item=function(key){
	if(this.hasKey(key)){
		return this._hash[key];
	}
	return undefined;
};
_p.hasKey=function(key){
	return this._hash.hasOwnProperty(key);
};
_p.getKeys=function(){
	var res=[];
	for(var k in this._hash)if(this._hash.hasOwnProperty(k)){
		res.push(k);
	}
	return res;
};
_p.getValues=function(){
	var res=[];
	for(var k in this._hash)if(this._hash.hasOwnProperty(k)){
		res.push(this._hash[k]);
	}
	return res;
};
_p.isEmpty=function(){
	return this._count==0;
};
_p._recreate=function(){
	var tmp={};
	for(var k in this._hash)if(this._hash.hasOwnProperty(k)){
		tmp[k]=this._hash[k];
	}
	this._hash=tmp;
	this._addCount=this._count;
};
MoHashTable.addProperty("count",Function.READ);
_p.dispose=function(){
	if(this._disposed)return;
	MoObject.prototype.dispose.call(this);
	delete this._hash;
};