﻿function MoJson() {
}
_p = Inherit(MoJson, MoObject, "MoJson");
MoJson.de=MoJson.deserialize = function(s) {
    return eval("(" + s + ")");
};
MoJson.se=MoJson.serialize = function(obj) {
    var sb = [];
    MoJson._serialize(obj, sb);
    return sb.join("");
};
MoJson._serialize = function(obj, sb) {
    switch (typeof obj) {
        case "string": 
            {
                MoJson._serializeString(obj, sb);
                return;
            }
        case "boolean": 
            {
                MoJson._serializeBoolean(obj, sb);
                return;
            }
        case "number": 
            {
                MoJson._serializeNumber(obj, sb);
                return;
            }
        case "undefined": 
            {
                sb.push("null");
                return;
            }
        case "object": 
            {
                if (obj === null) {
                    sb.push("null");
                }
                else if (typeof obj.serialize == "function") {
                    sb.push(obj.serialize());
                }
                else if (obj instanceof Array) {
                    MoJson._serializeArray(obj, sb);
                }
                else if (obj instanceof String) {
                    MoJson._serializeString(obj, sb);
                }
                else if (obj instanceof Boolean) {
                    MoJson._serializeBoolean(obj, sb);
                }
                else if (obj instanceof Number) {
                    MoJson._serializeNumber(obj, sb);
                }
                else {
                    MoJson._serializeObject(obj, sb);
                }
                return;
            }
    }
    throw new Error("JSON could not serialize object: " + obj);
};
MoJson._serializeString = function(obj, sb) {
    sb.push('"');
    for (var i = 0; i < obj.length; i++) {
        var c = obj.charAt(i);
        if (c >= " ") {
            if (c == '"' || c == "\\") {
                sb.push("\\");
            }
            sb.push(c);
        }
        else {
            sb.push("\\");
            switch (c) {
                case "\b": 
                    {
                        sb.push("b");
                        break;
                    }
                case "\f": 
                    {
                        sb.push("f");
                        break;
                    }
                case "\n": 
                    {
                        sb.push("n");
                        break;
                    }
                case "\r": 
                    {
                        sb.push("r");
                        break;
                    }
                case "\t": 
                    {
                        sb.push("t");
                        break;
                    }
                default: 
                    {
                        var hex = "000" + c.charCodeAt(0).toString(16);
                        sb.push("u", hex.substring(hex.length - 4));
                    }
            }
        }
    }
    sb.push('"');
};
MoJson._serializeBoolean = function(obj, sb) {
    sb.push(String(obj));
};
MoJson._serializeNumber = function(obj, sb) {
    if (isFinite(obj)) {
        sb.push(String(obj));
    }
    else {
        sb.push("null");
    }
};
MoJson._serializeArray = function(obj, sb) {
    sb.push("[");
    for (var i = 0; i < obj.length; i++) {
        if (i > 0) {
            sb.push(",");
        }
        MoJson._serialize(obj[i], sb);
    }
    sb.push("]");
};
MoJson._serializeObject = function(obj, sb) {
    sb.push("{");
    var first = true;
    for (var n in obj) {
        if (!first) {
            sb.push(",");
        }
        else {
            first = false;
        }
        MoJson._serialize(n, sb);
        sb.push(":");
        MoJson._serialize(obj[n], sb);
    }
    sb.push("}");
};
MoJson.dispose = function(jsonObj) {
    var o, p;
    for (var key in jsonObj) {
        o = jsonObj[key];
        if (o != null) {
            if (typeof o.dispose == MoObject.TYPE_FUNCTION) {
                o.dispose();
            }
            else if (o instanceof Array) {
                for (var j = o.length - 1; j >= 0; --j) {
                    p = o[j];
                    if (p && typeof p.dispose == MoObject.TYPE_FUNCTION) {
                        p.dispose();
                    }
                }
            }
        }
        delete jsonObj[key];
    }
};
MoJson.size = function(obj) {
    var count = 0;
    for (var n in obj) {
        count++;
    }
    return count;
};
MoJson.remove = function(obj, index) {
    var count = 0;
    for (var n in obj) {
        if (count == index) {
            delete obj[n];
            count = -1;
            break;
        }
        count++;
    }
    return count==-1;
};