//MzTreeView网页树类, 在实例化的时候请把实例名作参数传递进来//////////
function MzTreeView(TName) {
    if (_moInPrototype) return;
	if(TName==null ||  TName == "" || typeof(TName) != "string"){
		TName=Math.round(Math.random() * 100000).toString(32);//
		//return;
	}
	window[TName] = this;
	window["CurTree"] = this;
	MoEventTarget.call(this);
	this._disposed=false;
	this.url      = "#";
	this.target   = "_self";
	this.name     = TName;
	this.wordLine = false;
	this.currentNode = null;
	this.useArrow = true;
	this.nodes = {};
	this.node  = {};
	this.names = "";
	this._d    = "\x0f";
	this.index = 0;
	this.divider   = "_";
	this.equal_d   = ":";
	this.expandAll = false;
	this.expandRoot = true;
	this.autoFocused = true;
	this.node["0"] =
	{
		"id": "0",
		"path": "0",
		"isLoad": false,
		"childNodes": [],
		"childAppend": "",
		"sourceIndex": "0"
	};
	this.colors   =
	{
		"highLight" : "#0A246A",
		"highLightText" : "#FFFFFF",
		"mouseOverBgColor" : "#D4D0C8",
		"lowLight" : "gray",
		"lowLightText" : "#FFFFFF"
	};
	this.icons    = {
		L0        : 'L0.gif',  //┏
		L1        : 'L1.gif',  //┣
		L2        : 'L2.gif',  //┗
		L3        : 'L3.gif',  //━
		L4        : 'L4.gif',  //┃
		PM0       : 'P0.gif',  //＋┏
		PM1       : 'P1.gif',  //＋┣
		PM2       : 'P2.gif',  //＋┗
		PM3       : 'P3.gif',  //＋━
		empty     : 'L5.gif',    
		root      : 'root.gif',   
		folder    : 'folder.gif',
		file: 'file.gif',
		file2: 'file.gif',   
		exit      : 'exit.gif',
        recycle   : 'recyclebin.gif',
        search    : 'searchresult.gif'
	};
	this.iconsExpand = {
		PM0       : 'M0.gif',     //－┏
		PM1       : 'M1.gif',     //－┣
		PM2       : 'M2.gif',     //－┗
		PM3       : 'M3.gif',     //－━
		folder    : 'folderopen.gif',

		exit      : 'exit.gif'
	};  

	this.onkeydown= function(e)
	{
		e = window.event || e; var key = e.keyCode || e.which;
		switch(key)
		{
			case 37 : eval(TName).upperNode(); break;  //Arrow left, shrink child node
			case 38 : eval(TName).pervNode();  break;  //Arrow up
			case 39 : eval(TName).lowerNode(); break;  //Arrow right, expand child node
			case 40 : eval(TName).nextNode();  break;  //Arrow down
		}
	};
	this.loadDataAtOnce = true;
	this.checkBox = false;
	this.pCheckBox = false;//父结点是否显示复选框
	this.checkEnd = true;//是否只选择终端结点
	this.checkedNodes = ""; //选中的结点sourceId，以","分隔
	this.editable = false;
	this.showContextMenu = false;
	this.element = null;
	this.init();
	this.addEventListener("load", this._onLoad, this);
	//event:rename,addto,delete,copyto,moveto,moveup,movedown,focus//
};
//_p = MzTreeView.prototype;
_p = Inherit(MzTreeView, MoEventTarget, "MzTreeView");
_p.contextMenu = null;
_p.contentMenu_ref = null;
_p.currentCutNode=null;
_p.currentCopyNode = null;
_p.contextNode = null;
_p.desNode = null;
_p.init = function() {
    if (this.nodes['0_1'] == null) this.nodes['0_1'] = "text:";

    var base;
    if (window._BasePath) base = _BasePath + "js/";
    else {
        var re = /(^|\/)MzTreeView/i;
        var scripts = document.getElementsByTagName("script");
        var l = scripts.length;
        for (var i = 0; i < l; i++) {
            if (re.test(scripts[i].src)) {
                base = RegExp.leftContext;
                if (base != "") base += "/";
                break;
            }
        }
    }
    this.setIconPath(base + "MzTreeView/Images/");
}
_p._onLoad = function(e) {
    if (this.autoFocused) {
        if (this.rootNode)
            this.focusClientNode(this.rootNode.id);
    }
    if (this.checkBox && this.pCheckBox) this.setPCheckBoxAll();
    this.dispatchEvent("onload");
};
_p.setEditable = function(b) {
    if (b && this.editable != b) {
        this.renameInputEl = document.createElement("input");
        this.renameInputEl.style.position = "absolute";
        this.renameInputEl.style.left = 0;
        this.renameInputEl.style.top = 0;
        this.renameInputEl.style.border = "1px solid #000000";
        this.renameInputEl.tree = this;
        $(this.renameInputEl).bind("blur", this, this.onRenameInputBlur);
        $(this.renameInputEl).bind("select", function(event) { event.stopPropagation(); });
        $(this.renameInputEl).bind("selectstart", function(event) { event.stopPropagation(); });
        $(this.renameInputEl).bind("selectionchange", function(event) { event.stopPropagation(); });
        $(this.renameInputEl).bind("mousedown", function(event) { event.stopPropagation(); });
        $(this.renameInputEl).bind("focus", function(event) { event.stopPropagation(); });
    }
    this.editable = b;
};
_p.getElementById = function(id){
	if (typeof(id) != "string" || id == "") return null;
	if (window.document.getElementById) return window.document.getElementById(id);
	if (window.document.all) return window.document.all(id);
	try {return eval(id);} catch(e){ return null;}
};   
_p.toHTML = function(){
	this.browserCheck();
	this.dataFormat();
	this.setStyle();

	this._load("0");
	var rootCN = this.node["0"].childNodes;
	var str = "<A id='"+ this.name +"_RootLink' href='#' style='DISPLAY: none'></A>";

	if(rootCN.length>0)
	{
		this.node["0"].hasChild = true;
		for(var i=0; i<rootCN.length; i++){
		str += this.nodeToHTML(rootCN[i], i==rootCN.length-1);};
		setTimeout(this.name + ".expand('" + rootCN[0].id + "', true);" +
		//this.name + ".focusClientNode('" + rootCN[0].id + "'); " + this.name + ".atRootIsEmpty()", 10);
		this.name + ".atRootIsEmpty();"+
		this.name + ".dispatchEvent('load');", 10);
	}

	if (this.useArrow) 
	{
		if (document.attachEvent)
			document.attachEvent("onkeydown", this.onkeydown);
		else if (document.addEventListener)
			document.addEventListener('keydown', this.onkeydown, false);
	};
	return "<DIV class='MzTreeView' "+
		"onclick='"+ this.name +".clickHandle(event)' "+
		"ondblclick='"+ this.name +".dblClickHandle(event)' "+
		"oncontextmenu='return "+ this.name +".onContextMenu(event)' "+
		">"+ str +"</DIV>";
};
_p.setData=function(oData){	
	this.nodes=oData;
}
_p.setDataSource = function(data) {
    if (!data) return;
    eval(data);
};
_p.setDataFromXml=function(xmlDoc){	
	if(doc && doc.xml!=""){
		eval(this.getSubNodesInfo(doc.documentElement,"1"));
	}
}
_p.getSubNodesInfo=function(parentNode,parentId){	
	var ret="";
	var id="";
	if(parentId==null) parentId="1";
	var nodeList=parentNode.childNodes;
	for(var k=0;k<nodeList.length;k++)
	{
		nodeChild=nodeList[k];
		if(nodeChild.tagName!="entity") continue;
		if(nodeChild.selectSingleNode("display") && nodeChild.selectSingleNode("display").text=="none") continue;
		if(nodeChild.selectSingleNode("id"))
			id=nodeChild.selectSingleNode("id").text;
		else
			id=parentId+k.toString();
		
		ret+="this.nodes['"+parentId+"_"+id+"']='";			
		if(nodeChild.selectSingleNode("description"))
			ret+="text:"+nodeChild.selectSingleNode("description").text+";";
		if(nodeChild.selectSingleNode("href"))
			ret+="url:"+nodeChild.selectSingleNode("href").text+";";
		if(nodeChild.selectSingleNode("tip"))
			ret+="hint:"+nodeChild.selectSingleNode("tip").text+";";
		if(nodeChild.selectSingleNode("target"))
			ret+="target:"+nodeChild.selectSingleNode("target").text+";";
		if(nodeChild.selectSingleNode("image"))
			ret+="icon:"+nodeChild.selectSingleNode("image").text+";";
		//if(nodeChild.selectSingleNode("imageOpen"))
			//ret+="imageopen:"+nodeChild.selectSingleNode("imageOpen").text+";";
		if(nodeChild.selectSingleNode("onClick"))
			ret+="method:"+nodeChild.selectSingleNode("onClick").text+";";
		ret+="';";
		if(nodeChild.selectSingleNode("contents"))
		{
			ret+=GetSubNodesInfo(nodeChild.selectSingleNode("contents"),id);
		}
	}
	return ret;
}
_p.browserCheck = function(){
  var ua = window.navigator.userAgent.toLowerCase(), bname;
  if(/msie/i.test(ua))
  {
    this.navigator = /opera/i.test(ua) ? "opera" : "";
    if(!this.navigator) this.navigator = "msie";
  }
  else if(/gecko/i.test(ua))
  {
    var vendor = window.navigator.vendor.toLowerCase();
    if(vendor == "firefox") this.navigator = "firefox";
    else if(vendor == "netscape") this.navigator = "netscape";
    else if(vendor == "") this.navigator = "mozilla";
  }
  else this.navigator = "msie";
  if(window.opera) this.wordLine = false;
};
_p.setStyle = function(){
	var style= "DIV.MzTreeView DIV IMG{border: 0px solid #FFFFFF;}"+
	"DIV.MzTreeView DIV SPAN IMG{border: 0px solid #FFFFFF;}"+
	"DIV.MzTreeView A:LINK,DIV.MzTreeView A:VISITED,DIV.MzTreeView A:ACTIVE,DIV.MzTreeView A:HOVER{color: #800080;font-size: 13px;padding-left: 3px;TEXT-DECORATION: NONE;word-wrap:break-word;}";
	if(this.wordLine)
	{
	style +="\
	DIV.MzTreeView DIV\
	{\
		height: 20px;"+
		(this.navigator=="firefox" ? "line-height: 20px;" : "" ) +
		(this.navigator=="netscape" ? "" : "overflow: hidden;" ) +"\
	}\
	DIV.MzTreeView DIV SPAN\
	{\
		vertical-align: middle; font-size: 21px; height: 20px; color: #D4D0C8; cursor: default;\
	}\
	DIV.MzTreeView DIV SPAN.pm\
	{\
		width: "+ (this.navigator=="msie"||this.navigator=="opera" ? "11" : "9") +"px;\
		height: "+ (this.navigator=="netscape"?"9":(this.navigator=="firefox"?"10":"11")) +"px;\
		font-size: 7pt;\
		overflow: hidden;\
		margin-left: -16px;\
		margin-right: 5px;\
		color: #000080; \
		vertical-align: middle;\
		border: 1px solid #D4D0C8;\
		cursor: "+ (this.navigator=="msie" ? "hand" : "pointer") +";\
		padding: 0 2px 0 2px;\
		text-align: center;\
		background-color: #F0F0F0;\
	}";
	}
	if(this.navigator == "msie"){
		var ss=document.createStyleSheet();
		ss.cssText=style;
	}
	else {
		el=document.createElement("STYLE");
		el.type="text/css";
		el.appendChild(document.createTextNode(style));
		var h=document.getElementsByTagName("HEAD")[0];
		h.appendChild(el);
	}
};

_p.atRootIsEmpty = function() {
    var RCN = this.node["0"].childNodes;
    for (var i = 0; i < RCN.length; i++) {
        if (!RCN[i].isLoad) {
            this.expand(RCN[i].id);
        }
        if (RCN[i].text == "") {
            var node = RCN[i].childNodes[0];
            if (node == null) return; 
            HCN = node.hasChild;
            if (this.wordLine) {
                var span = this.getElementById(this.name + "_tree_" + node.id);
                span = span.childNodes[0].childNodes[0].childNodes[0];
                span.innerHTML = RCN[i].childNodes.length > 1 ? "┌" : "─";
            }
            else {
                node.iconExpand = RCN[i].childNodes.length > 1 ? HCN ? "PM0" : "L0" : HCN ? "PM3" : "L3";
                this.getElementById(this.name + "_expand_" + node.id).src = this.icons[node.iconExpand].src;
            }

            if (this.expandRoot) this.expand(node.id, true);
            //this.focusClientNode(node.id);

            this.rootNode = node;
        } else {
            this.rootNode = RCN[i];
            //this.focusClientNode(RCN[i].id);
        }
        //this.dispatchEvent("load");
    }
    if (this.expandAll) this.FnExpandAll();
};

_p.dataFormat = function(){
  var a = new Array();
  for (var id in this.nodes) a[a.length] = id;
  this.names = a.join(this._d + this._d);
  this.totalNode = a.length; a = null;
};

_p._load = function(id){
	var node = this.node[id];  
	if(node.isLoad) return;	
	if(!this.loadDataAtOnce && node.id!="0" &&  node.parentId!="0" && node.isLoad==false){		
		this.getSubNodeInfo(node);
		this.dataFormat();
	}
	var d = this.divider, _d = this._d;
	var sid = node.sourceIndex.substr(node.sourceIndex.indexOf(d) + d.length);
	var reg = new RegExp("(^|"+_d+")"+ sid +d+"[^"+_d+d +"]+("+_d+"|$)", "g");
	var cns = this.names.match(reg), tcn = this.node[id].childNodes; if (cns){
	reg = new RegExp(_d, "g"); for (var i=0; i<cns.length; i++)
	tcn[tcn.length] = this.nodeInit(cns[i].replace(reg, ""), id);}
	node.isLoad = true;
};
_p.getSubNodeInfo=function(node){
};

_p.nodeInit = function(sourceIndex, parentId){
  this.index++;
  var source= this.nodes[sourceIndex], d = this.divider;
  var text  = this.getAttribute(source, "text");
  var hint  = this.getAttribute(source, "hint");
  var sid   = sourceIndex.substr(sourceIndex.indexOf(d) + d.length);
  this.node[this.index] =
  {
    "id"    : String(this.index),
    "text"  : text,
    "hint"  : hint ? hint : text,
    "icon"  : this.getAttribute(source, "icon"),
    "path"  : this.node[parentId].path + d + this.index,
    "isLoad": false,
	"isBuild": false,
    "isExpand": false,
    "parentId": parentId,
    "parentNode": this.node[parentId],
    "sourceIndex" : sourceIndex,
    "sourceId" : sid,
    "childAppend" : "",
	"nodeType":this.getAttribute(source, "nt")//1-folder；0-file
	,"showno": this.getAttribute(source, "showno")
  };
  this.nodes[sourceIndex] = "index:"+ this.index +";"+ source;
  this.node[this.index].hasChild = this.names.search(new RegExp("(^|"+this._d+")" + sid + d))>-1 || (!this.loadDataAtOnce && this.getAttribute(source, "hcn")=="1");
  //if(this.node[this.index].hasChild)  
	this.node[this.index].childNodes = [];
  return this.node[this.index];
};

_p.getAttribute = function(source, name){
  var reg = new RegExp("(^|;|\\s)"+ name +"\\s*"+this.equal_d+"\\s*([^;]*)(\\s|;|$)", "i");
  if (reg.test(source)) return RegExp.$2.replace(/[\x0f]/g, ";"); return "";
};
_p.getAttributeByNode = function(n, name){
   return this.getAttribute(this.nodes[n.sourceIndex],name);
};
_p.nodeToHTML = function(node, AtEnd) {
    var source = this.nodes[node.sourceIndex];
    var target = this.getAttribute(source, "target");
    var data = this.getAttribute(source, "data");
    var url = this.getAttribute(source, "url");
    var nodeType = this.getAttribute(source, "nt");
    if (!url) {
        url = this.url;
        if(url!="#")
            url += (url.indexOf("?") == -1 ? "?" : "&") + "sid="+node.sourceId;
    }
    if (url!="#" && data) url += (url.indexOf("?") == -1 ? "?" : "&") + data;
    if (!target) target = this.target;

    var id = node.id;
    var HCN = node.hasChild, isRoot = node.parentId == "0";
    var iconSrc;
    if (isRoot && node.icon == "") node.icon = "root";
    if (node.icon == "") {
        node.icon = HCN ? "folder" : nodeType == "0" ? "file" : "folder";
        iconSrc = this.icons[node.icon].src;
    } else {
        if (this.icons[node.icon])
            iconSrc = this.icons[node.icon].src;
        else
            iconSrc = node.icon;
    }
    node.iconExpand = AtEnd ? "└" : "├";
    //var HTML = "<DIV noWrap='True'><NOBR>";
    var HTML = "<DIV>";
    if (!isRoot) {
        node.childAppend = node.parentNode.childAppend + (AtEnd ? "　" : "│");
        if (this.wordLine) {
            HTML += "<SPAN>" + node.parentNode.childAppend + (AtEnd ? "└" : "├") + "</SPAN>";
            if (HCN) HTML += "<SPAN class='pm' id='" + this.name + "_expand_" + id + "'>+</SPAN>";
        }
        else {
            node.iconExpand = HCN ? AtEnd ? "PM2" : "PM1" : AtEnd ? "L2" : "L1";
            HTML += "<SPAN>" + this.word2image(node.parentNode.childAppend) + "<IMG " +
        "align='absmiddle' id='" + this.name + "_expand_" + id + "' " +
        "src='" + this.icons[node.iconExpand].src + "' style='cursor: " + (!node.hasChild ? "" :
        (this.navigator == "msie" || this.navigator == "opera" ? "hand" : "pointer")) + "'></SPAN>";
        }
    }
    if (this.checkBox && id != "1" && (this.pCheckBox || (!HCN && nodeType!="1"))) {
        HTML += "<input type='checkbox' hideFocus='true'" + (this.checkedNodes.contains(node.sourceId) ? " checked" : "") +
	" onclick=\"" + this.name + ".nodeCheckBoxClick(event,'" + id + "')\">";
    }
    HTML += "<IMG " +
    "align='" + (this.checkBox ? "absbottom" : "absMiddle") + "' " +
    "id='" + this.name + "_icon_" + id + "' " +
    "src='" + iconSrc + "'><SPAN><A " +
    "class='MzTreeview' hideFocus " +
    "id='" + this.name + "_link_" + id + "' " +
    "href='" + url + "' " +
    "target='" + target + "' " +
    "title='" + node.hint + "' " +
    "onfocus=\"" + this.name + ".focusLink('" + id + "')\" " +
    "onclick=\"return " + this.name + ".nodeClick('" + id + "')\">" + node.text +
  //"</A></SPAN></NOBR></DIV>";
    "</A></SPAN></DIV>";
    if (isRoot && node.text == "") HTML = "";
//\r\n
    HTML = "<SPAN id='" + this.name + "_tree_" + id + "'>" + HTML
    HTML += "<SPAN style='DISPLAY: none'></SPAN></SPAN>";
    return HTML;
};

_p.word2image = function(word){
  var str = "";
  for(var i=0; i<word.length; i++)
  {
    var img = "";
    switch (word.charAt(i))
    {
      case "│" : img = "L4"; break;
      case "└" : img = "L2"; break;
      case "　" : img = "empty"; break;
      case "├" : img = "L1"; break;
      case "─" : img = "L3"; break;
      case "┌" : img = "L0"; break;
    }
    if(img!="")
      str += "<IMG align='absMiddle' src='"+ this.icons[img].src +"' height='20'>";
  }
  return str;
};

_p.buildNode = function(id) {
    var node = this.node[id];
    if (node.isBuild) return;
    if (node.hasChild) {
        //var tcn = node.childNodes;
        var tcn = this.node[id].childNodes.sort(this.sortFolders);
        var str = "";
        for (var i = 0; i < tcn.length; i++)
            str += this.nodeToHTML(tcn[i], i == tcn.length - 1);
        var temp = this.getElementById(this.name + "_tree_" + id).childNodes;
        temp[temp.length - 1].innerHTML = str;
        node.isBuild = true;
    }
};
_p.sortFolders = function(a, b) {
    if (a.showno && b.showno)
        return parseInt(a.showno) > (parseInt(b.showno));
    else return (a.text).localeCompare(b.text);
};


_p.focusClientNode = function(id) {
    if (!this.currentNode) this.currentNode = this.node["0"];
    var a = this.getElementById(this.name + "_link_" + id);
    if (a) {
        //if(a.style.display!="none")a.focus();
        var link = this.getElementById(this.name + "_link_" + this.currentNode.id);
        if (link) with (link.style) { color = ""; backgroundColor = ""; }
        with (a.style) {
            color = this.colors.highLightText;
            backgroundColor = this.colors.highLight;
        }

        if (this.currentNode != this.node[id]) {
            //this.previousNode= this.currentNode;
            this.currentNode = this.node[id];

            this._load(id);
            this._onFocusClientNode();
        }
        this.dispatchEvent("focus");
        this.contextNode = this.currentNode;
        if (this.showContextMenu && this.contentMenu_ref) this.mf_ShowConextMenu(a);
    }
};
_p._onFocusClientNode = function() {
    if (this.url != "#") {
        var link = this.getElementById(this.name + "_link_" + this.currentNode.id);
        if(link) link.click();
    }
}
_p.focusLink= function(id){
  //if(this.currentNode && this.currentNode.id==id) return;
  //this.focusClientNode(id);
};

_p.expand = function(id, sureExpand) {
    if (!id) id = this.currentNode.id;
    var node = this.node[id];
    if (sureExpand && node.isExpand) return;
    if (!node.hasChild) return;
    var area = this.getElementById(this.name + "_tree_" + id);
    if (area) area = area.childNodes[area.childNodes.length - 1];
    if (area) {
        var icon = this.icons[node.icon];
        var iconE = this.iconsExpand[node.icon];
        var Bool = node.isExpand = sureExpand || area.style.display == "none";
        var img = this.getElementById(this.name + "_icon_" + id);
        if (img) img.src = !Bool ? icon.src : typeof (iconE) == "undefined" ? icon.src : iconE.src;
        var exp = this.icons[node.iconExpand];
        var expE = this.iconsExpand[node.iconExpand];
        var expand = this.getElementById(this.name + "_expand_" + id);
        if (expand) {
            if (this.wordLine) expand.innerHTML = !Bool ? "+" : "-";
            else expand.src = !Bool ? exp.src : typeof (expE) == "undefined" ? exp.src : expE.src;
        }
        if (!Bool && this.currentNode && this.currentNode.path.indexOf(node.path) == 0 && this.currentNode.id != id) {
            try { this.getElementById(this.name + "_link_" + id).click(); }
            catch (e) { this.focusClientNode(id); }
        }
        area.style.display = !Bool ? "none" : "block"; //(this.navigator=="netscape" ? "block" : "");
        if (!node.isLoad) {
            this._load(id);
            if (node.id == "0") return;
        }
        if (!node.isBuild) {
            if (node.hasChild && node.childNodes.length > 200) {
                setTimeout(this.name + ".buildNode('" + id + "')", 1);
                var temp = this.getElementById(this.name + "_tree_" + id).childNodes;
                temp[temp.length - 1].innerHTML = "<DIV noWrap><NOBR><SPAN>" + (this.wordLine ?
	        node.childAppend + "└" : this.word2image(node.childAppend + "└")) + "</SPAN>" +
	        "<IMG border='0' height='16' align='absmiddle' src='" + this.icons["file"].src + "'>" +
	        "<A style='background-Color: " + this.colors.highLight + "; color: " +
	        this.colors.highLightText + "; font-size: 9pt'>请稍候...</A></NOBR></DIV>";
            }
            else {
                this.buildNode(id);
            }
        }
    }
};

_p.nodeClick = function(id){
	if(this.editable && this.currentNode && this.currentNode.id==id){
		//this.renameNode(id);
	}
	var source = this.nodes[this.node[id].sourceIndex];
	eval(this.getAttribute(source, "method"));
	return !(!this.getAttribute(source, "url") && this.url=="#");
};
_p.addCheckedNode = function(sid) {
    if (this.checkedNodes == "") this.checkedNodes = sid;
    else {
        if (new RegExp("(^|,)" + sid + "($|,)").test(this.checkedNodes) == false)
            this.checkedNodes += "," + sid;
    }
};
_p.removeCheckedNode = function(sid) {
    this.checkedNodes = this.checkedNodes.replace(new RegExp("," + sid + ",", ""), ",").replace(new RegExp("(^|,)" + sid + "($|,)", ""), "");
};
_p.nodeCheckBoxClick = function(e, id) {
    var node = this.node[id];
    e = window.event || e;
    var el = e.srcElement || e.target;
    if (!this.checkEnd || !node.hasChild) {
        if (el.checked)
            this.addCheckedNode(node.sourceId);
        else
            this.removeCheckedNode(node.sourceId);
    }
    this.setCheckBoxAll(el, node);
    this.checkedNode = node;
    this.checkedEle = el;
    this.dispatchEvent("clickcheckbox");
    //this.sortCheckedNodes() ;
};
//dg-是否递归
_p.setCheckBoxAll = function(el, node, dg) {
    var pnode = node.parentNode;
    if (pnode.id != "1") {
        var pcb = $("#" + this.name + "_tree_" + pnode.id + ">div input:checkbox").get(0);
        if (pcb) {
            if (!el.checked) {
                pcb.checked = false;
                if (!this.checkEnd) {
                    var othis = this;
                    $("#" + this.name + "_tree_" + node.id).siblings().find("div:first>input:checked").each(function(i) {
                        othis.addCheckedNode(othis.node[this.parentNode.parentNode.id.substr(this.parentNode.parentNode.id.lastIndexOf("_") + 1)].sourceId);
                    });
                    this.removeCheckedNode(pnode.sourceId);
                }
            } else {
                if ($("#" + this.name + "_tree_" + node.id).siblings().find("div:first>input:checked").length == node.parentNode.childNodes.length - 1) {
                    pcb.checked = true;
                    if (!this.checkEnd) {
                        var tcn = pnode.childNodes;
                        for (var i = 0, li = tcn.length; i < li; i++) {
                            this.removeCheckedNode(tcn[i].sourceId);
                        }
                        this.addCheckedNode(pnode.sourceId);
                    }
                } else {
                    this.removeCheckedNode(pnode.sourceId);
                }
            }
            this.setCheckBoxAll(pcb, pnode, true);
        }
    }
    if (!dg && node.hasChild) {
        if (el.checked) {
            var tcn = node.childNodes;
            if (this.checkEnd) {
                for (var i = 0; i < tcn.length; i++) {
                    this.removeCheckedNode(tcn[i].sourceId);
                    this.addCheckedNode(tcn[i].sourceId);
                }
            } else {
                for (var i = 0; i < tcn.length; i++) {
                    this.removeCheckedNode(tcn[i].sourceId);
                }
                this.addCheckedNode(node.sourceId);
            }
            $("#" + this.name + "_tree_" + node.id + ">span input:checkbox").attr("checked", true);
        } else {
            var tcn = node.childNodes;
            for (var i = 0; i < tcn.length; i++) {
                this.removeCheckedNode(tcn[i].sourceId);
            }
            if (!this.checkEnd) {
                this.removeCheckedNode(node.sourceId);
            }
            $("#" + this.name + "_tree_" + node.id + ">span input:checkbox").attr("checked", false);
        }
    }
}
_p.setPCheckBoxAll = function() {
    if (this.checkedNodes == "") return;
    var arrSrcId = this.checkedNodes.split(",");
    var node, pnode;
    for (var i = 0, l = arrSrcId.length; i < l; i++) {
        node = this.getNodeBySourceId(arrSrcId[i]);
        if (node == null) continue;
        pnode = node.parentNode;
        if (pnode.id != "1" && !pnode.checked) {
            //alert(node.id+","+$("#" + this.name + "_tree_" + node.id).siblings().find("input:checked").length + "," + pnode.childNodes.length);
            if ($("#" + this.name + "_tree_" + node.id).siblings().find("div:first>input:checked").length == pnode.childNodes.length - 1) {
                var pcb = $("#" + this.name + "_tree_" + pnode.id + ">div input:checkbox").get(0);
                pcb.checked = true;
            }
            pnode.checked = true;
        }
        if (!this.checkEnd && node.hasChild) {
            $("#" + this.name + "_tree_" + node.id + ">span input:checkbox").attr("checked", true);
        }
    }
}
_p.sortCheckedNodes = function() {
    var arr = this.checkedNodes.split(",").sort(this._defSortNodes);
    this.checkedNodes= arr.join(",");
};
_p._defSortNodes = function(a, b) {
    a = window["CurTree"].getNodeBySourceId(a);
    b = window["CurTree"].getNodeBySourceId(b);
    if (a.showno)
        return (a.showno).localeCompare(b.showno);
    else
        return (a.text).localeCompare(b.text);
};
 _p.getTextPath = function(id, bNotRoot) {
     var node = this.node[id];
     var textPath = node.text;
     while (node.id != "1") {
         node = node.parentNode;
         if (bNotRoot && node.id == "1") break;
         textPath = node.text + "/" + textPath;
     }
     if (textPath.startsWith("/")) textPath = textPath.substr(1);
     return textPath;
 };
_p.getTextVirPath = function(id){
	return this.getTextPath(id).replace(this.rootName,this.rootPath);
};
_p.getPath= function(sourceId)
{
  Array.prototype.indexOf = function(item)
  {
    for(var i=0; i<this.length; i++)
    {
      if(this[i]==item) return i;
    }
    return -1;
  };
  var _d = this._d, d = this.divider;
  var A = new Array(), id=sourceId; A[0] = id;
  while(id!="0" && id!="")
  {
    var str = "(^|"+_d+")([^"+_d+d+"]+"+d+ id +")("+_d+"|$)";
    if (new RegExp(str).test(this.names))
    {
      id = RegExp.$2.substring(0, RegExp.$2.indexOf(d));
      if(A.indexOf(id)>-1) break;
      A[A.length] = id;
    }
    else break;
  }
  return A.reverse();
};
//在源代码里指定 MzTreeView 初始聚集到某个节点
//sourceId 节点在数据源里的 id
_p.focus = function(sourceId, defer){
  if (!defer)
  {
    setTimeout(this.name +".focus('"+ sourceId +"', true)", 100);
    return;
  }
  var path = this.getPath(sourceId);
  if(path[0]!="0"){
    alert(+"节点 "+ sourceId +"没有正确的挂靠有效树节点上！ \r\n"+"节点 id 序列 = "+ path.join(this.divider));
    return;
  }
  var root = this.node["0"], len = path.length;
  for(var i=1; i<len; i++)
  {
    if(root.hasChild)
    {
      var sourceIndex= path[i-1] + this.divider + path[i];
      for (var k=0; k<root.childNodes.length; k++)
      {
        if (root.childNodes[k].sourceIndex == sourceIndex)
        {
          root = root.childNodes[k];
          if(i<len - 1) this.expand(root.id, true);
          else this.focusClientNode(root.id);
          break;
        }
      }
    }
  }
};
_p.clickHandle = function(e) {
    e = window.event || e; e = e.srcElement || e.target;
    switch (e.tagName) {
        case "IMG":
            if (e.id) {
                if (e.id.indexOf(this.name + "_icon_") == 0)
                    this.focusClientNode(e.id.substr(e.id.lastIndexOf("_") + 1));
                else if (e.id.indexOf(this.name + "_expand_") == 0)
                    this.expand(e.id.substr(e.id.lastIndexOf("_") + 1));
            }
            break;
        case "A":
            if (e.id) this.focusClientNode(e.id.substr(e.id.lastIndexOf("_") + 1));
            break;
        case "SPAN":
            if (e.className == "pm")
                this.expand(e.id.substr(e.id.lastIndexOf("_") + 1));
            break;
        default:
            if (this.navigator == "netscape") e = e.parentNode;
            if (e.tagName == "SPAN" && e.className == "pm")
                this.expand(e.id.substr(e.id.lastIndexOf("_") + 1));
            break;
    }
};
_p.dblClickHandle = function(e){
  e = window.event || e; e = e.srcElement || e.target;
  if((e.tagName=="A" || e.tagName=="IMG")&& e.id)
  {
    var id = e.id.substr(e.id.lastIndexOf("_") + 1);
    if(this.node[id].hasChild) this.expand(id);    
	this.dispatchEvent("dblclick");
  }
};
_p.upperNode = function(){
  if(!this.currentNode) return;
  if(this.currentNode.id=="0" || this.currentNode.parentId=="0") return;
  if (this.currentNode.hasChild && this.currentNode.isExpand)
    this.expand(this.currentNode.id, false);
  else this.focusClientNode(this.currentNode.parentId);
};
_p.lowerNode = function(){
  if (!this.currentNode) this.currentNode = this.node["0"];
  if (this.currentNode.hasChild)
  {
    if (this.currentNode.isExpand)
      this.focusClientNode(this.currentNode.childNodes[0].id);
    else this.expand(this.currentNode.id, true);
  }
};
_p.pervNode = function(){
  if(!this.currentNode) return; var e = this.currentNode;
  if(e.id=="0") return; var a = this.node[e.parentId].childNodes;
  for(var i=0; i<a.length; i++){if(a[i].id==e.id){if(i>0){e=a[i-1];
  while(e.hasChild){this.expand(e.id, true);
  e = e.childNodes[e.childNodes.length - 1];}
  this.focusClientNode(e.id); return;} else {
  this.focusClientNode(e.parentId); return;}}}
};
_p.nextNode = function(){
  var e = this.currentNode; if(!e) e = this.node["0"];
  if (e.hasChild){this.expand(e.id, true);
  this.focusClientNode(e.childNodes[0].id); return;}
  while(typeof(e.parentId)!="undefined"){
  var a = this.node[e.parentId].childNodes;
  for(var i=0; i<a.length; i++){ if(a[i].id==e.id){
  if(i<a.length-1){this.focusClientNode(a[i+1].id); return;}
  else e = this.node[e.parentId];}}}
};
_p.FnExpandAll = function() {    
    if (this.totalNode > 500) if (confirm("您是否要停止展开全部节点？\r\n\r\n节点过多！展开很耗时")) return;
    if (this.node["0"].childNodes.length == 0) return;
    var e = this.node["0"].childNodes[0];
    var isdo = t = false;
    while (e.id != "0") {
        var p = this.node[e.parentId].childNodes, pn = p.length;
        if (p[pn - 1].id == e.id && (isdo || !e.hasChild)) { e = this.node[e.parentId]; isdo = true; }
        else {
            if (e.hasChild && !isdo) {
                this.expand(e.id, true), t = false;
                for (var i = 0; i < e.childNodes.length; i++) {
                    if (e.childNodes[i].hasChild) { e = e.childNodes[i]; t = true; break; }
                }
                if (!t) isdo = true;
            }
            else {
                isdo = false;
                for (var i = 0; i < pn; i++) {
                    if (p[i].id == e.id) { e = p[i + 1]; break; }
                }
            }
        }
    }
};
_p.collapseAll = function() {
if (this.totalNode > 500) if (confirm("您是否要停止折叠全部节点？\r\n\r\n节点过多！折叠很耗时")) return;
    if (this.node["0"].childNodes.length == 0) return;
    var e = this.node["0"].childNodes[0];
    var isdo = t = false;
    while (e.id != "0") {
        var p = this.node[e.parentId].childNodes, pn = p.length;
        if (p[pn - 1].id == e.id && (isdo || !e.hasChild)) { e = this.node[e.parentId]; isdo = true; }
        else {
            if (e.hasChild && !isdo) {
                if(e.isExpand) this.expand(e.id), t = false;
                for (var i = 0; i < e.childNodes.length; i++) {
                    if (e.childNodes[i].hasChild) { e = e.childNodes[i]; t = true; break; }
                }
                if (!t) isdo = true;
            }
            else {
                isdo = false;
                for (var i = 0; i < pn; i++) {
                    if (p[i].id == e.id) { e = p[i + 1]; break; }
                }
            }
        }
    }
}
_p.setIconPath = function(path) {
    var k = 0, d = new Date().getTime();
    for (var i in this.icons) {
        var tmp = this.icons[i];
        this.icons[i] = new Image();
        this.icons[i].src = path + tmp;
        if (k == 9 && (new Date().getTime() - d) > 5000)
            this.wordLine = true; k++;
    }
    for (var i in this.iconsExpand) {
        var tmp = this.iconsExpand[i];
        this.iconsExpand[i] = new Image();
        this.iconsExpand[i].src = path + tmp;
    }
};
_p.setRootIcon = function(fn){this.icons["root"].src = fn;};
_p.setFolderIcon = function(fn){this.icons["folder"].src = fn;};
_p.setFolderExpandIcon = function(fn) { this.iconsExpand["folder"].src = fn; };
_p.setFileIcon = function(fn) { this.icons["file"].src = fn; };
_p.setFile2Icon = function(fn) { this.icons["file2"].src = fn; };
_p.setURL     = function(url){this.url = url;};
_p.setTarget  = function(target){this.target = target;};

_p.setCheckedNodes=function(ns){
	this.checkedNodes=ns;
};
_p.getCheckedNodes=function(){
	return this.checkedNodes;
};

_p.getContextMenu=function(){
    return this.contentMenu_ref|| this.contextMenu;
}
_p.setContextMenu = function(el) {
    if (typeof el == "object")
        this.contentMenu_ref = el;
    else {
        this.setContextMenuXmlFile(el);
        this.showContextMenu = true;
    }
}
_p.mf_ShowConextMenu = function(a) {
    if (this.contentMenu_ref == null) return false;
    if (a == null) {
        a = this.getElementById(this.name + "_link_" + this.currentNode.id);
    }
    if (this.contentMenu_ref.style.display == "block") return;
    this.contentMenu_ref.style.display = "block";
    this.contentMenu_ref.style.left = (($(a).left() + $(a).width())-this.element.scrollLeft) + "px";
    this.contentMenu_ref.style.top = ($(a).top()-this.element.scrollTop) + "px";
    $(window.document).bind("mousedown", this, this.mf_HideConextMenu);
}
_p.mf_HideConextMenu = function(e) {
    var at = e.target || e.srcElement;
    var othis = e.data;
    var link = othis.getElementById(othis.name + "_link_" + othis.currentNode.id); 
    if (link == at || othis.contentMenu_ref == at || $.isAncestor(link, at) || $.isAncestor(othis.contentMenu_ref, at))
        return;
    othis.contentMenu_ref.style.display = "none";
    $(window.document).unbind("mousedown", othis.mf_HideConextMenu);
}
_p.hideConextMenu = function(c) {
    if (this.contentMenu_ref) {
        this.contentMenu_ref.style.display = "none";
        $(window.document).unbind("mousedown", this.mf_HideConextMenu);
    }
}
_p.setContextMenuXmlFile = function(path) {
    if (this.contextMenu == null) {
        if (!window["ContextMenu"]) Include(_BasePath + "js/ContextMenu/ContextMenu.js");
        this.contextMenu = new ContextMenu();
    }
    var doc=C("MoXmlDocument");
    doc.load(path);
    this.contextMenu.setXmlDoc(doc); //$.get(path).responseXml);
    this.showContextMenu = true;
}
_p.onContextMenu = function(e) {
    if ($.browser.msie) e.cancelBubble = true; else e.stopPropagation = true;
    e.returnValue = false;
    if (this.contextMenu == null) return;
    var el = e.srcElement || e.target;
    if ((el.tagName != "IMG" && el.tagName != "A") || !el.id) return false;
    var id = el.id.substr(el.id.lastIndexOf("_") + 1);
    if (this.contextNode != null) {
        var a = this.getElementById(this.name + "_link_" + this.contextNode.id);
        with (a.style) { color = ""; backgroundColor = ""; }
    }
    var a = this.getElementById(this.name + "_link_" + id);
    if (!a) return;
    with (a.style) {
        color = this.colors.highLightText;
        var link = this.getElementById(this.name + "_link_" + this.currentNode.id);
        if (link) with (link.style) {
            color = this.colors.lowLightText;
            backgroundColor = this.colors.lowLight;
        }
        backgroundColor = this.colors.highLight;
    }
    this.contextNode = this.node[id];
    if (this.contextMenu instanceof ContextMenu) {
        if (this.currentCutNode == null && this.currentCopyNode == null)
            this.contextMenu.setAtrributeEnabled("粘贴");
        else
            this.contextMenu.setAtrributeEnabled("粘贴", true);
        return this.contextMenu.show(e);
    } else {
        this.showContextMenu(e);
    }
};
_p.showContextMenu = function(e) {
    e.returnValue = false;
    if (this.contextMenu == null) retrun;
    this.dispatchEvent("showbefore_contextmenu"); //alert(event.clientX+","+event.clientY);
    //this.contextMenu.setLocation(event.screenX, event.screenY);
    //this.contextMenu.setTop(event.clientY);
    this.contextMenu.setVisible(true);
};
_p.renderContextMenu = function() {
    var link = this.getElementById(this.name + "_link_" + this.currentNode.id);
    this.mf_ShowConextMenu(link);
};


_p.resumeColor = function() {
    if (this.contextNode != this.currentNode) {
        if (this.contextNode != null) {
            var id = this.contextNode.id;
            var a = this.getElementById(this.name + "_link_" + id);
            if (a) { with (a.style) { color = ""; backgroundColor = ""; } }
        }
        var link = this.getElementById(this.name + "_link_" + this.currentNode.id);
        if (link) with (link.style) { color = this.colors.highLightText; backgroundColor = this.colors.highLight; }
    }
    this.contextNode = null;
    this.hideConextMenu();
};
_p.renameNode = function(id) {
    if (!this.editable) return;
    if (id == null) id = this.contextNode.id;
    if (id == this.rootNode.id || this.node[id].parentNode.id == "0") return;
    var a = this.getElementById(this.name + "_link_" + id);
    var pl = a.parentNode;
    this.renameInputEl.style.width = a.offsetWidth + 10;
    //MzTreeView.renameInputEl.style.height=a.offsetHeight+3;	
    this.renameInputEl.value = a.innerHTML;
    pl.appendChild(this.renameInputEl);
    this.renameInputEl.style.display = "";
    this.renameInputEl.style.position = "relative";
    a.style.display = "none";
    this.renameInputEl.select();
    this.renameInputEl.focus(); 
    this.resumeColor();
}
_p.onRenameInputBlur = function(event) {
    var el = this; //event.srcElement || event.target;
    var a = el.previousSibling;
    if (a.innerHTML != el.value) {
        if (el.tree.dispatchEvent("rename")) {
            var id = a.id.substr(a.id.lastIndexOf("_") + 1);
            el.tree.node[id].text = el.value;
            a.innerHTML = el.value;
        }
    }
    a.style.display = "";
    el.style.display = "none";
    el.parentNode.removeChild(el);
};
_p.addNode = function(text,nodeType){
	if(!this.editable) return;
	if(id==null) id=this.contextNode.id;
	var newNode;
	//if(id==this.rootNode.id) return;
	if(this.dispatchEvent("addto"))
		newNode=this.newNode(this.contextNode.id,text,nodeType);
	this.resumeColor();
	return newNode;
};
_p.cutNode = function(id){
	if(!this.editable) return;
	if(id==null) id=this.contextNode.id;
	if(id==this.rootNode.id) return;
	this.currentCutNode=this.contextNode;
	this.currentCopyNode=null;
	this.resumeColor();
};
_p.copyNode = function(id){	
	if(!this.editable) return;
	if(id==null) id=this.contextNode.id;
	if(id==this.rootNode.id) return;
	this.currentCopyNode=this.contextNode;
	this.currentCutNode=null;
	this.resumeColor();
};
_p.pasteNode = function(id){	
	if(!this.editable) return;
	if(id==null) id=this.contextNode.id;
	if(this.currentCopyNode!=null){
		if(this.dispatchEvent("copyto"))
		this.copyNodeTo(this.contextNode.id,null);
	}
	else if(this.currentCutNode!=null){
		if(this.dispatchEvent("moveto"))
		this.moveNodeTo(this.contextNode.id,null);
	}
	this.resumeColor();
};
_p.deleteNode = function(id) {
    if (!this.editable) return;
    if (id == null) {
        id = this.contextNode.id;
        if (id == this.rootNode.id) return;
        if (confirm("确定要删除“" + this.contextNode.text + "”吗？")) {
            if (this.dispatchEvent("delete"))
                this.removeNode(this.contextNode.id);
        }
    }
    else {
        if (id == this.rootNode.id) return;
        if (this.dispatchEvent("delete"))
            this.removeNode(id);
    } 
    this.resumeColor();
};
_p.newNode = function(parentid, text, nodeType, nodesData, srcId) {
    if (text == null) text = "新结点";
    if (nodeType == null) nodeType = "0";
    if (parentid == null) parentid = this.currentNode.id;
    var parentNode = this.node[parentid]; 
    var sourceIndex = parentNode.sourceId + this.divider + (srcId || (this.index + 1));
    if (nodesData != null)
        this.nodes[sourceIndex] = nodesData;
    else
        this.nodes[sourceIndex] = "text" + this.equal_d + text + ";" +
		"nt" + this.equal_d + "" + nodeType + ";";
    this.dataFormat();
    var tcn = parentNode.childNodes;
    tcn[tcn.length] = this.nodeInit(sourceIndex, parentid);
    var parentChildNodes = this.getElementById(this.name + "_tree_" + parentid).childNodes;
    var parentContainer = parentChildNodes[parentChildNodes.length - 1];
    var temp = parentContainer.childNodes;
    if (temp.length == 0) {
        parentNode.isLoad = true;
        parentNode.isBuild = false;
        parentNode.isExpand = false;
        parentNode.hasChild = true;
        parentNode.iconExpand = "PM2";
        this.expand(parentid);
    }
    else {
        this.expand(parentid, true);
        var str = this.nodeToHTML(tcn[tcn.length - 1], true);
        parentContainer.innerHTML += str;

        var preSlibing = temp[temp.length - 2];
        if (this.wordLine) {
            var firstEl = preSlibing.firstChild;
            firstEl.innerHTML = firstEl.innerHTML.replace("　└", "│├");
        }
        else {
            var preId = preSlibing.id.substr(preSlibing.id.lastIndexOf("_") + 1);
            var HCN = this.node[preId].hasChild;
            var iconExpand = HCN ? false ? "PM2" : "PM1" : false ? "L2" : "L1";
            this.getElementById(this.name + "_expand_" + preId).src = this.icons[iconExpand].src;
        }
    }
    this.renameNode(this.index);
    return this.node[this.index];
}
_p.copyNodeTo = function(desDirNodeId,srcNodeId){
	var srcNode,desNode;	
	if(this.currentCopyNode==null && srcNodeId==null) return;
	if(srcNodeId!=null)
		this.currentCopyNode=this.node[srcNodeId];
	srcNode=this.currentCopyNode;		
	if(desDirNodeId==null) desDirNodeId=this.currentNode.id;
	var desNode=this.node[desDirNodeId];
	this._copyNode(desNode.id,srcNode.id);
	this.focusClientNode(this.currentNode.id);	
};
_p.moveNodeTo = function(desDirNodeId,srcNodeId){
	var srcNode,desNode;
	if(this.currentCutNode==null && srcNodeId==null) return;
	if(srcNodeId!=null)
		srcNode=this.node[srcNodeId];//drag move
	else
		srcNode=this.currentCutNode;//paste and not drag//
	if(desDirNodeId==null) desDirNodeId=this.currentNode.id;
	var desNode=this.node[desDirNodeId];
	var newNode=this._copyNode(desNode.id,srcNode.id);
	if(srcNode.flag=="0" && this.currentNode==srcNode)
		this.focusClientNode(newNode.id);
	else
		this.focusClientNode(this.currentNode.id);
	
	this.removeNode(srcNode.id);
	if(srcNodeId==null)
	{
		this.currentCopyNode=null;
		this.currentCutNode=null;
	}
}
_p._copyNode = function(desDirNodeId,srcNodeId){	
	var srcNode=this.node[srcNodeId];
	var desNode=this.node[desDirNodeId];
	var newNode;
	if(desNode.isLoad || this.loadDataAtOnce){
		var sourceIndex=desNode.sourceId+ this.divider + (this.index+1);
		this.nodes[sourceIndex]=this.nodes[srcNode.sourceIndex];
		var tcn=desNode.childNodes;
		newNode=tcn[tcn.length] = this.nodeInit(sourceIndex, desDirNodeId);
		this.dataFormat();
	}
	if(desNode.isBuild){
		var parentChildNodes = this.getElementById(this.name +"_tree_"+ desDirNodeId).childNodes;
		var parentContainer=parentChildNodes[parentChildNodes.length-1];			
		var temp=parentContainer.childNodes;
		if(temp.length==0){
			desNode.isLoad=true;
			desNode.isBuild=false;
			desNode.isExpand=false;
			desNode.hasChild=true;
			desNode.iconExpand="PM2";
			this.expand(desDirNodeId);
		}
		else{
			var str = this.nodeToHTML(newNode,true);			
			parentContainer.innerHTML += str;
			
			var preSlibing=temp[temp.length-2];				
			if(this.wordLine)
			{
				var firstEl=preSlibing.firstChild;
				firstEl.innerHTML=firstEl.innerHTML.replace("　└", "│├");
			}
			else
			{
				var preId=preSlibing.id.substr(preSlibing.id.lastIndexOf("_")+1);
				var HCN=this.node[preId].subdir;					
				var iconExpand  = HCN ? false ? "PM2" : "PM1" : false ? "L2" : "L1";
				this.getElementById(this.name +"_expand_"+ preId).src=this.icons[iconExpand].src;
			}			
		}
	}else{	
	    desNode.hasChild=true;
		this.expand(desDirNodeId,true);
	}
	//this.dataFormat();	
	return newNode;
};
_p.removeNode = function(id) {
    if (!this.editable) return;
    if (id == this.rootNode.id) return;
    if (id == null) id = this.currentNode.id;
    var node = this.node[id];
    var parentNode = node.parentNode;

    if (parentNode.isBuild == false) this.buildNode(parentNode.id);
    for (var key in this.nodes) {
        if (key.substr(0, key.indexOf("_")) == node.sourceId) {
            delete this.nodes[id];
        }
    }
    delete this.nodes[node.sourceIndex];
    var tcn = parentNode.childNodes;
    for (k = 0; k < tcn.length; k++) {
        if (tcn[k] == node) {
            tcn.splice(k, 1);
            break;
        }
    }
    var parentEl = this.getElementById(this.name + "_tree_" + parentNode.id);
    var parentChildNodes = parentEl.childNodes;
    var parentContainer = parentChildNodes[parentChildNodes.length - 1];
    var el = this.getElementById(this.name + "_tree_" + id);

    var bAtEnd = false;
    if (parentContainer.lastChild == el) bAtEnd = true;
    if (this.navigator == "msie") el.replaceAdjacentText("beforeBegin", "");
    //el.removeNode(true);
    parentEl.lastChild.removeChild(el);
    if (bAtEnd) {
        if (parentContainer.childNodes.length == 0) {
            parentContainer.style.display = 'none';
            var ppContainer = parentEl.parentNode;
            if (ppContainer.lastChild == parentEl)
                bAtEnd = true;
            else
                bAtEnd = false;
            var iconExpand = false ? bAtEnd ? "PM2" : "PM1" : bAtEnd ? "L2" : "L1";
            this.getElementById(this.name + "_expand_" + parentNode.id).src = this.icons[iconExpand].src;
            this.getElementById(this.name + "_icon_" + parentNode.id).src = this.icons[parentNode.icon].src;
            parentNode.hasChild = false;
        }
        else {
            try {
                var preSlibing = parentContainer.lastChild;
                if (this.wordLine) {
                    var firstEl = preSlibing.firstChild;
                    firstEl.innerHTML = firstEl.innerHTML.replace("│├", "　└");
                }
                else {
                    var preId = preSlibing.id.substr(preSlibing.id.lastIndexOf("_") + 1);
                    var HCN = this.node[preId].hasChild;
                    var iconExpand = HCN ? true ? "PM2" : "PM1" : true ? "L2" : "L1";
                    this.getElementById(this.name + "_expand_" + preId).src = this.icons[iconExpand].src;
                    if (this.contextNode && this.contextNode.id == preId) {
                        this.contextNode.isExpand = false;
                        this.expand(preId, true);
                    }
                }
            } catch (e) { }
        }
    }
    //this.dataFormat();		
    if (this.currentNode == node)
        this.focusClientNode(parentNode.id);
    else
        this.focusClientNode(this.currentNode.id);
    delete this.node[id];
};

//节点上移
_p.moveUpNode = function(nodeId) {
    if (nodeId == null) nodeId = this.contextNode.id;
    if (nodeId == this.rootNode.nodeId) return;

    var nodeElement = this.getElementById(this.name + "_tree_" + nodeId);
    var parentChildNodes = this.getElementById(this.name + "_tree_" + this.node[nodeId].parentNode.id).childNodes;
    var parentContainer = parentChildNodes[parentChildNodes.length - 1];
    var temp = parentContainer.childNodes;
    if (temp[0] == nodeElement) return;
    for (i = 0; i < temp.length; i++) {
        if (temp[i] == nodeElement) {
            var preNodeElementId = temp[i - 1].id;
            if (preNodeElementId == null) preNodeElementId = temp[i - 2].id;
            else preNodeElementId = temp[i - 1].id;
            preNodeId = preNodeElementId.substr(preNodeElementId.lastIndexOf("_") + 1);
            this.desNode = this.node[preNodeId];
            if (this.dispatchEvent("moveup"))
                $(nodeElement).insertBefore(document.getElementById(preNodeElementId));
            break;
        }
    }
    this.focusClientNode(nodeId);
}
//节点下移
_p.moveDownNode = function(nodeId) {
    if (nodeId == null) nodeId = this.contextNode.id;
    if (nodeId == this.rootNode.nodeId) return;
    var nodeElement = this.getElementById(this.name + "_tree_" + nodeId);
    var parentChildNodes = this.getElementById(this.name + "_tree_" + this.node[nodeId].parentNode.id).childNodes;
    var parentContainer = parentChildNodes[parentChildNodes.length - 1];
    var temp = parentContainer.childNodes;
    if (temp[temp.length - 1] == nodeElement) return;
    for (i = 0; i < temp.length; i++) {
        if (temp[i] == nodeElement) {
            var nextNodeElementId = temp[i + 1].id;
            if (nextNodeElementId == null) nextNodeElementId = temp[i + 2].id;
            else nextNodeElementId = temp[i + 1].id;
            var nextNodeId = nextNodeElementId.substr(nextNodeElementId.lastIndexOf("_") + 1);
            this.desNode = this.node[nextNodeId];

            if (this.dispatchEvent("movedown"))
                $(nodeElement).insertAfter(document.getElementById(nextNodeElementId));
            break;
        }
    }
    this.focusClientNode(nodeId);
}
//通过父节点和文本获取子节点
_p.getChildNodeByText = function(pa,text){
	var pn;
	if(typeof pa =="string") pn=this.node[pa];
	else pn=pa;
	if(text=="") return pn;
	var cs= pn.childNodes;
	for(var i=0;i< cs.length;i++){
		if(cs[i].text==text) 
			return cs[i];
	}
	return null;
}
//判断指定文件路径节点是否装载过
_p.getNotLoadNodeId = function(textPath) {
    var id = "1";
    var sArrText = textPath.split('/');
    var i = 0;
    for (; i < sArrText.length; i++) {
        if (sArrText[i] == "") continue;
        id = this.getChildNodeByText(id, sArrText[i]);
        if (this.node[id].isLoad == false)
            break;
    }
    return id;
}
_p.dispose=function(){
	this._disposed=true;
	delete this.nodes;
	delete this.node;
	delete this.colors;
	delete this.icons;
	delete this.iconsExpand;
	delete this.names;
};

_p.getLevel = function(id) {
    var node;
    if (id == null) node = this.currentNode;
    else node = this.node[id];
    var l = 0;
    while (node.id != "1") {
        l++;
        node = node.parentNode;
    }
    return l;
};
//
_p.getNodeBySourceId = function(sid) {
    for (var id in this.node) {
        if (this.node[id].sourceId == sid) {
            return this.node[id];
        }
    }
    return null;
};

