﻿//例子:
//$(el).popmenu({
//        align: 'left',
//        valign: 'bottom',
//        setCls: 'opening',//selectIn
//        borderColor: '#999999',
//        borderWidth: 1,
//        backgroundColor: '#FFFFFF',
//        content: setfont
//    }
jQuery.fn.extend({
    popmenu: function(options, callback) {
        options = options || {};
        callback = callback || function() { };
        if (jQuery.isFunction(options)) {
            callback = options;
            options = {}
        }
        var elc = this[0];
        var defs = {
            url: null,
            data: {},
            setCls: null,
            dataType: 'html',
            valign: 'bottom',
            align: 'left',
            padding: 6,
            stopPropagation: true,
            idname: 'mid',
            cls: 'popmenu_content',
            content: ""
        };
        var url = options.url || defs.url;
        var data = options.data || defs.data;
        var setCls = options.setCls || defs.setCls;
        var dataType = options.dataType || defs.dataType;
        if (setCls) this.addClass(setCls);
        var valign = options.valign || defs.valign;
        var align = options.align || defs.align;
        var padding = options.padding || defs.padding;
        var stopPropagation = (typeof options.stopPropagation == 'boolean' && !options.stopPropagation) ? false : defs.stopPropagation;
        var cls = options.cls || defs.cls;
        var idname = options.idname || defs.idname;
        var content = (url) ? 'loading...' : (options.content || defs.content);
        var borderColor = options.borderColor || this.css('border-' + align + '-color');
        var borderWidth = options.borderWidth || parseInt(this.css('border-' + align + '-width'));
        var backgroundColor = options.backgroundColor || this.css('background-color');
        var id = this.attr(idname) || new Date().getTime();
        var x = (align == 'right') ? jQuery.clientWidth() - this.offset().left - this.outerWidth() : this.offset().left;
        var y = (valign == 'top') ? this.offset().top + this.height() + borderWidth : jQuery.clientHeight() - this.offset().top - borderWidth;
        this.blur();
        if (this.attr('popup')) return false;
        if (!jQuery('[' + idname + ']')[0]) {
            jQuery(document).click(function(e) {
                e = e.target || window.event.srcElement;
                if (e == elc || e.parentNode == elc) return;
                var popup = jQuery('.' + cls);
                var max = 0;
                jQuery.each(popup, function() {
                    var l = parseInt(jQuery(this).attr('level'));
                    max = (l > max) ? l : max;
                });
                var m = jQuery('.' + cls + '[level="' + max + '"]');
                var b = jQuery('[' + idname + '="' + m.attr('for' + idname) + '"]');
                jQuery('.' + cls + '_css[for' + idname + '="' + m.attr('for' + idname) + '"]').remove();
                b.removeAttr('popup').removeClass(m.attr('cls'));
                m.remove();
            });
            jQuery(window).resize(function() {
                jQuery('.' + cls).each(function() {
                    var css = {};
                    var m = jQuery(this);
                    var to = jQuery('[' + idname + '="' + m.attr('for' + idname) + '"]');
                    if (m.attr('align') == 'right') {
                        css = jQuery.extend(css, {
                            right: jQuery.clientWidth() - to.offset().left - to.outerWidth()
                        })
                    } else {
                        css = jQuery.extend(css, {
                            left: to.offset().left
                        })
                    }
                    if (m.attr('valign') == 'top') {
                        css = jQuery.extend(css, {
                            top: to.offset().top + to.innerHeight() + borderWidth
                        })
                    } else {
                        css = jQuery.extend(css, {
                            bottom: jQuery.clientHeight() - to.offset().top - borderWidth
                        })
                    }
                    m.css(css);
                })
            })
        }
        padding = (typeof padding == 'number') ? padding + 'px' : padding;
        var level = (this.parents('.' + cls).attr('level')) ? parseInt(this.parents('.' + cls).attr('level')) + 1 : 0;
        jQuery.each(jQuery('.' + cls + '[level]'), function() {
            var o = jQuery(this);
            var l = o.attr('level');
            if (parseInt(l) >= level) {
                var m = jQuery('.' + cls + '[level="' + l + '"]');
                jQuery('.' + cls + '_css[for' + idname + '="' + m.attr('for' + idname) + '"]').remove();
                jQuery('[' + idname + '="' + m.attr('for' + idname) + '"]').removeAttr('popup').removeClass(m.attr('cls'));
                m.remove();
            }
        });
        var ojq = jQuery('<div class="' + cls + '" level="' + level + '" cls="' + setCls + '" align="' + align + '" valign="' + valign + '" for' + idname + '="' + id + '" style="position:absolute;padding:' + padding + ';' + align + ':' + x + 'px;' + valign + ':' + y + 'px;border:' + borderWidth + 'px solid ' + borderColor + ';background-color:' + backgroundColor + ';"><div style="position:absolute;width:' + (this.outerWidth() - borderWidth * 2) + 'px;' + align + ':0;' + valign + ':-' + borderWidth + 'px;height:0;border-top:' + borderWidth + 'px solid ' + backgroundColor + ';line-height:1px;font-size:1px;"></div><div class="' + cls + '_content">' + content + '</div></div>').appendTo('body');
        if (!setCls) {
            jQuery('<style class="' + cls + '_css" for' + idname + '="' + id + '">.' + cls + '_in_' + id + '{border:' + borderWidth + 'px solid ' + borderColor + ';background-color:' + backgroundColor + ';margin-left:' + this.css('margin-left') + ';margin-right:' + this.css('margin-right') + ';margin-top:' + this.css('margin-top') + ';margin-bottom:' + this.css('margin-bottom') + ';padding-left:' + this.css('padding-left') + ';padding-right:' + this.css('padding-right') + ';padding-top:' + this.css('padding-top') + ';padding-bottom:' + this.css('padding-bottom') + ';cursor:default;}</style>').appendTo('head');
            this.addClass(cls + '_in_' + id);
        }
        ojq.show();
        this.attr(idname, id).attr('popup', true);
        if (stopPropagation) {
            ojq.click(function(event) {
                event.stopPropagation();
            });
        }
        if (url) {
            jQuery.ajax({
                url: url,
                data: data,
                dataType: dataType,
                cache: false,
                success: function(data) {
                    if (dataType == 'html') ojq.find('.' + cls + '_content').ojq(data);
                    callback.call(this, data, ojq, ojq.find('.' + cls + '_content'));
                }
            })
        } else {
            callback.call(this, ojq, ojq.find('.' + cls + '_content'));
        }
        return ojq;
    }
});