﻿var MUI = {};
var _p;
var _moInPrototype = false;
/*
* function：create class namespace
* @param {String} n Namespace to create for example a.b.c.d.
* @param {Object} o Optional object to add namespace to, defaults to window.
* example：
Package("js.lang");
js.lang.Object = Object;
*/
function Package(ns, o) {
    //if(!ns) return window;
    var root = o || window;
    var nsParts = ns.split(".");
    for (var i = 0; i < nsParts.length; i++) {
        if (typeof root[nsParts[i]] == "undefined") {
            root[nsParts[i]] = {};
        }
        root = root[nsParts[i]];
    }
    return root;
};

//dynamically load js file.
function Include(fileName, async, id) {
    if (async) {
        if (id) {
            if (document.getElementById(id)) return;
        }
        var js = document.createElement("script");
        js.id = id;
        js.type = "text/javascript";
        js.src = fileName;
        document.getElementsByTagName('head')[0].appendChild(js);
    } else {
        var req;
        if (window.XMLHttpRequest) req = new XMLHttpRequest();
        else {
            try { req = new ActiveXObject("Msxml2.XMLHTTP"); }
            catch (ex) {
                try { req = new ActiveXObject("Microsoft.XMLHTTP"); }
                catch (ex) { }
            }
        }
        req.open('GET', fileName, false);
        req.send('');
        try {
            var _pp = _p;
            Eval(req.responseText);
            _p = _pp;
        } catch (ex) {
            //alert("loading " + fileName + " error!");
        }
    }
};
//动态地将Javascript脚本代码加载到文档中
function LoadScript(code, id) {
    var js = document.createElement("script");
    if (id) {
        if (document.getElementById(id)) return;
        js.id = id;
    }
    js.type = "text/javascript";
    if (!document.all) {
        js.innerHTML = code;
    } else {
        js.text = code;
    }
    document.getElementsByTagName('head')[0].appendChild(js);
};
//条件加载脚本,id为空立即执行脚本，id为数字延时id毫秒执行，id为控件ID为控件创建后执行
function LoadScriptBy(script, id,win) {
    if (script == null || script=="") return;
    id = id || "";
    if (id == "") { eval(script); return; }
    var n = 0;
    window["loadScript_timer_" + id] = window.setInterval(function() {
        n++;
        if (n > 5 || (win|| window).document.getElementById(id)) {
            clearInterval(window["loadScript_timer_" + id]);
            eval(script);
        }
    }, isNaN(id) ? 300 : parseInt(id));
}
//apply style text.
function LoadStyle(s) {
    if (MUI.isIE) {
        document.createStyleSheet().cssText = s;
        //el = ss.owningElement;
    }
    else {
        var el = document.createElement("STYLE");
        el.type = "text/css";
        el.appendChild(document.createTextNode(s));
        document.getElementsByTagName("HEAD")[0].appendChild(el);
    }
};
//apply css file.
function LoadCss(oUri,id) {
    var el = document.createElement("link");
    el.type = "text/css";
    el.rel = "stylesheet";
    el.href = String(oUri);
    if(id) el.id = id;
    document.getElementsByTagName("HEAD")[0].appendChild(el);
};

//Evaluate script
function Eval(s) {
    var w = window;
    if (!w.execScript) {
        try {
            eval.call(w, s);
        } catch (ex) {
            eval(s, w); // Firefox 3.0a8
        }
    } else
        if (s) w.execScript(s); // IE
};

//create class object
function C(cls) {
    //var constr=window[cls];
    var constr = Resolve(cls);
    if (!constr) {
        //Include(window._BasePath + "js/" + (MUI.ClassFileMap[cls] || (cls + ".js")));
        if (cls.startsWith("Mo")) Include([window._BasePath, "js/", (MUI.ClassFileMap[cls] || (["MoClass/", cls, ".js"].join("")))].join(""));
        else Include([window._BasePath, "js/", (MUI.ClassFileMap[cls] || ([cls, ".js"].join("")))].join(""));
        //constr=window[cls];
        constr = Resolve(cls);
    }
    var args = [];
    for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);
    if (args.length == 0) return new constr();
    var newConstr = function() {
        constr.apply(this, args);
    };
    newConstr.prototype = constr.prototype; //new constr();
    return new newConstr;
};

//get class constructor or namespace
function N(ns) {
    var constr = Resolve(ns);
    if (!constr) {
        if (ns.startsWith("Mo")) Include([window._BasePath, "js/", (MUI.ClassFileMap[ns] || (["MoClass/", ns, ".js"].join("")))].join(""));
        else Include([window._BasePath, "js/", (MUI.ClassFileMap[ns] || ([ns, ".js"].join("")))].join(""));
        constr = Resolve(ns);
    }
    return constr;
};

//get json object
function Resolve(n, o) {
    var i, l;
    o = o || window;
    n = n.split('.');
    for (i = 0, l = n.length; i < l; i++) {
        o = o[n[i]];
        if (!o)
            break;
    }
    return o;
};

//load jquery.js
//function $() {
//    if (typeof jQuery == "undefined") {
//        Include(window._BasePath + "js/jquery.pack.js");
//    }
//    return $.apply(null, arguments);
//};
function FireEvent(el, type) {
    if (typeof (el) == 'string')
        el = document.getElementById(el);
    $(el).trigger(type);
};

//extend json object
function Extend(dst, src, replace) {
    if (!dst) return;
    for (var prop in src) {
        if (!replace && dst[prop] != null) { continue; }
        //if (!replace && dst.hasOwnProperty(prop)) { continue; }
        dst[prop] = src[prop];
    }
    return dst;
};
function Clone(src) {
    if (src == null) return null;
    if (typeof src == "array")
        return src.concat();
    var dst = {};
    for (var prop in src) {
        dst[prop] = src[prop];
    }
    return dst;
};

//class inherit
/*function Inherit(fConstr, fSuperConstr, sName) {
_moInPrototype = true;
var p = fConstr.prototype = new fSuperConstr();
if (sName) {
p._className = sName;
}
p.constructor = fConstr;
_moInPrototype = false; 
return p;
};
*/

//class inherit
function Inherit(fConstr, sSuperConstr, sName) {
    _moInPrototype = true;
    var fSuperConstr;
    if (typeof (sSuperConstr) == 'string') {
        fSuperConstr = window[sSuperConstr];
        if (!fSuperConstr) {
            Include(window._BasePath + "js/" + (MUI.ClassFileMap[sSuperConstr] || ((sSuperConstr.startsWith("Mo") ? "MoClass/" : "") + sSuperConstr + ".js")));
            fSuperConstr = window[sSuperConstr];
        }
    } else {
        fSuperConstr = sSuperConstr;
    }
    var p = fConstr.prototype = new fSuperConstr();
    if (sName) {
        p._className = sName;
    }
    p.constructor = fConstr;
    _moInPrototype = false;
    return p;
};

//create class or static object interface
//s-object string,eg:"ns.class".
//p-{class:function(){},mothod:function(){}}
/*
function Create(s, p) {
var sp, ns, cn, scn, c, de = 0;

// Parse : <prefix> <class>:<super class>
s = /^((static) )?([\w.]+)(:([\w.]+))?/.exec(s);
cn = s[3].match(/(^|\.)(\w+)$/i)[2]; // Class name

// Create namespace for new class
if (s[3].indexOf(".") == -1) ns = window;
else ns = Package(s[3].replace(/\.\w+$/, ''));

// Class already exists
if (ns[cn]) return;

// Make pure static class
if (s[2] == 'static') {
ns[cn] = p;
return;
}

// Create default constructor
if (!p[cn]) {
p[cn] = function() { };
de = 1;
}

// Add constructor and methods
ns[cn] = p[cn];
Extend(ns[cn].prototype, p);

// Extend
if (s[5]) {
sp = Resolve(s[5]).prototype;
scn = s[5].match(/(^|\.)(\w+)$/i)[2]; // Class name

// Extend constructor
c = ns[cn];
if (de) {
// Add passthrough constructor
ns[cn] = function() {
return sp[scn].apply(this, arguments);
};
} else {
// Add inherit constructor
ns[cn] = function() {
this.parent = sp[scn];
return c.apply(this, arguments);
};
}
ns[cn].prototype[cn] = ns[cn];

// Add super methods
Object.each(sp, function(f, n) {
ns[cn].prototype[n] = sp[n];
});

// Add overridden methods
Object.each(p, function(f, n) {
// Extend methods if needed
if (sp[n]) {
ns[cn].prototype[n] = function() {
this.parent = sp[n];
return f.apply(this, arguments);
};
} else {
if (n != cn)
ns[cn].prototype[n] = f;
}
});
}

// Add static methods
Object.each(p['static'], function(f, n) {
ns[cn][n] = f;
});
};
*/
//get url query viariable
function GetQueryString(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
    var r = window.location.search.substr(1).match(reg);
    if (r != null) return unescape(r[2]); return null;
};
function QueryString(name, href) {
    var reg = new RegExp("(\\?|#|&)" + name + "=([^&]*)(&|$)", "i");
    var r = (href || window.location.href).match(reg);
    if (r != null) return unescape(r[2]); return null;
};
function EscapeURL(href) {
    if (/\?/.test(href)) {
        var reg = new RegExp("(\\?|#|&)[\\w]+=([^&]*)", "g");
        var r = (href || window.location.href).match(reg);
        for (var i = 0, l = r.length; i < l; i++) {
            var c = r[i].substr(r[i].indexOf("="));
            href = href.replace(c, "=" + escape(c.substr(1)));
        }
    }
    return href;
}
//add event listener for element
function AddEvent(o, evType, f, capture) {
    if (o == null) return false;
    if (typeof (o) == 'string')
        o = document.getElementById(o);
    if (o.addEventListener) {
        if (capture == null) capture = false;
        o.addEventListener(evType, f, capture);
        return f;
    } else if (o.attachEvent) {
        var r = o.attachEvent("on" + evType, f);
        return f;
    } else {
        try { o["on" + evType] = f; } catch (e) { }
    }
};

//remove event listener for element
function RemoveEvent(o, evType, f, capture) {
    if (o == null) { return false; }
    if (typeof (o) == 'string')
        o = document.getElementById(o);
    if (o.removeEventListener) {
        if (capture == null) capture = false;
        o.removeEventListener(evType, f, capture);
        return true;
    } else if (o.detachEvent) {
        o.detachEvent("on" + evType, f);
    } else {
        try { o["on" + evType] = function() { }; } catch (e) { }
    }
};

//create common XMLHttpRequest
if (typeof ActiveXObject != "undefined") {
    if (window.XMLHttpRequest);
    else {
        XMLHttpRequest = function() {
            var xmlHttp = null;
            try { xmlHttp = new ActiveXObject("Msxml2.XMLHTTP"); }
            catch (e) {
                try { xmlHttp = new ActiveXObject("Microsoft.XMLHTTP"); }
                catch (e) { xmlHttp = false; }
            }
            return xmlHttp;
        }
    }
};

//get system relative root path,the global viariable is _BasePath
(function() {
    if (window._BasePath) return window._BasePath;
    var i, base;
    //var src = "js/mui-base.js",
    var re = /(^|\/)js\/mui\-base/i;
    var scripts = document.getElementsByTagName("script");
    var l = scripts.length;
    for (i = 0; i < l; i++) {
        if (re.test(scripts[i].src)) {
            base = RegExp.leftContext;
            if (base != "") base += "/";
            break;
        }
    }
    window._BasePath = base;
})();
MUI.ClassFileMap = {};
//Include(window._BasePath + "js/ClassFileMap.js");

//////////////////////////javascript object extends/////////////////////////////////////
//extend Object
Object.isEmpty = function(o) {
    for (var _ in o) return false;
    return true;
};
Object.clear = function(o) {
    for (var _ in o) delete o[_];
};
Object.getKeys = function(o) {
    var r = [];
    for (var i in o) r.push(i);
    return r;
};
Object.getValues = function(o) {
    var r = [];
    for (var i in o) r.push(o[i]);
    return r;
};
Object.is = function(o, t) {
    var n = typeof (o);

    if (!t)
        return n != 'undefined';

    if (t == 'array' && (o instanceof Array))
        return true;

    return n == t;
};
Object.each = function(o, cb, s) {
    var n, l;

    if (!o)
        return false;

    s = s || o;

    if (typeof (o.length) != 'undefined') {
        // Indexed arrays, needed for Safari
        for (n = 0, l = o.length; n < l; n++) {
            if (cb.call(s, o[n], n, o) === false)
                return false;
        }
    } else {
        // Hashtables
        for (n in o) {
            if (o.hasOwnProperty(n)) {
                if (cb.call(s, o[n], n, o) === false)
                    return false;
            }
        }
    }

    return true;
};
Object.grep = function(a, f) {
    var o = [];
    Object.each(a, function(v) {
        if (!f || f(v))
            o.push(v);
    });
    return o;
};
Object.copy = function(src) {
    if (src == null) return null;
    var dst = {};
    for (var prop in src) {
        dst[prop] = src[prop];
    }
    return dst;
};


//extend Array
Array.prototype.indexOf = function(obj, fromIndex) {
    var l = this.length;
    if (fromIndex == null) {
        fromIndex = 0;
    }
    else if (fromIndex < 0) {
        fromIndex = Math.max(0, l + fromIndex);
    }
    for (var i = fromIndex; i < l; i++) if (this[i] === obj) return i;
    return -1;
};
Array.prototype.lastIndexOf = function(obj, fromIndex) {
    if (fromIndex == null) {
        fromIndex = this.length - 1;
    }
    else if (fromIndex < 0) {
        fromIndex = Math.max(0, this.length + fromIndex);
    }
    for (var i = fromIndex; i >= 0; --i) if (this[i] === obj) return i;
    return -1;
};
Array.prototype.contains = function(o) {
    return this.indexOf(o) != -1;
};
Array.prototype.copy = function(o) {
    return this.concat();
};
Array.prototype.insertAt = function(o, i) {
    this.splice(i, 0, o);
};
Array.prototype.insertBefore = function(o, o2) {
    var i = this.indexOf(o2);
    if (i == -1) this.push(o);
    else this.splice(i, 0, o);
};
Array.prototype.removeAt = function(i) {
    this.splice(i, 1);
};
Array.prototype.remove = function(o) {
    var i = this.indexOf(o);
    if (i != -1) this.splice(i, 1);
};
Array.prototype.forEach = function(f, obj) {
    var l = this.length;
    for (var i = 0; i < l; i++) f.call(obj, this[i], i, this);
};
Array.prototype.filter = function(f, obj) {
    var l = this.length;
    var res = [];
    for (var i = 0; i < l; i++) if (f.call(obj, this[i], i, this)) {
        res.push(this[i]);
    }
    return res;
};
Array.prototype.find = function(f, obj) {
    var l = this.length;
    for (var i = 0; i < l; i++) if (f.call(obj, this[i], i, this)) {
        return this[i];
    }
    return null;
};
Array.prototype.map = function(f, obj) {
    var l = this.length;
    var res = [];
    for (var i = 0; i < l; i++) res.push(f.call(obj, this[i], i, this));
    return res;
};
Array.prototype.some = function(f, obj) {
    var l = this.length;
    for (var i = 0; i < l; i++) if (f.call(obj, this[i], i, this)) {
        return true;
    }
    return false;
};
Array.prototype.every = function(f, obj) {
    var l = this.length;
    for (var i = 0; i < l; i++) if (!f.call(obj, this[i], i, this)) {
        return false;
    }
    return true;
};
Array.prototype.add = function(items) {
    if (items.length > 0) {
        for (var i = 0; i < items.length; i++) {
            this.push(items[i]);
        }
    }
};
Array.prototype.clear = function() {
    this.length = 0;
    return this;
};
Array.prototype.copyTo = function(src, srcStart, dst, dstStart, copyLength) {
    if (!src) return;
    if (!dst) return;
    if ((srcStart + copyLength) > src.length) {
        alert("(srcStart + copyLength) > src.length");
        throw "(srcStart + copyLength) > src.length";
    }
    if (dstStart > dst.length) {
        alert("dstStart > dst.length");
        throw "dstStart > dst.length";
    }
    if ((dst.length - dstStart) < copyLength) {
        dst.length = dstStart + copyLength;
    }

    var i;
    var tempArray = new Array();
    for (i = 0; i < copyLength; i++) {
        tempArray.push(src[srcStart + i]);
    }
    for (i = 0; i < copyLength; i++) {
        dst.setAt(tempArray[i], dstStart + i);
    }
};

//extend String
String.EMPTY = "";
String.BOOLEAN_TRUE = "true";
String.BOOLEAN_FALSE = "false";
String.isNullOrEmpty = function(s) {
    if (s == null || s.length == 0) {
        return true;
    }
    return false;
};
String.format = function(s) {
    for (var i = 1; i < arguments.length; i++) {
        s = s.replace(new RegExp("\\{" + (i-1) + "\\}", "g"), arguments[i]);
    }
    return s;
};
String.Format = function(s, arr) {
    var args = [];
    var i = 0;
    if (typeof arr.length != "undefined") args = arr;
    else if (arr.indexOf(",") != -1) args = arr.split(",");
    else { args = arguments; i = 1; }
    for (; i < args.length; i++) {
        s = s.replace(new RegExp("\\{" + (i - 1) + "\\}", "g"), args[i]);
    }
    return s;
};
String.prototype.format = function() {
    var result = this;
    if (arguments.length > 0) {
        Object.each(
			arguments,
			function(n, i) {
			    result = result.replace(new RegExp("\\{" + i + "\\}", "g"), n);
			});
    }

    return result;
}
String.prototype.Format = function(arr) {
    var result = this;
    var args = [];
    if (typeof arr.length != "undefined" && typeof arr != "string") args = arr;
    else if (arr.indexOf(",") != -1) args = arr.split(",");
    else args = arguments;
    if (args.length > 0) {
        Object.each(
			args,
			function(n, i) {
			    result = result.replace(new RegExp("\\{" + i + "\\}", "g"), n);
			});
    }

    return result;
}
String.concat = function() {
    var arr = [];
    for (var i = 0; i < arguments.length; i++) {
        arr.push(arguments[i]);
    }
    return arr.join("");
};
String.prototype.trim = function() {
    return this.replace(/(^\s+)|\s+$/g, "");
};
String.prototype.capitalize = function() {
    return this.charAt(0).toUpperCase() + this.substr(1);
};
String.prototype.startsWith = function(s) {
    return this.substring(0, s.length) == s;
};
String.prototype.endsWith = function(s) {
    return this.substring(this.length - s.length, this.length) == s;
};
String.prototype.trimLeft = function() {
    return this.replace(/^\s*/, "");
};
String.prototype.trimRight = function() {
    return this.replace(/\s*$/, "");
};
String.prototype.byteLength = function() {
    var str = this + 'a';
    var str1 = str.match(/[\x00-\xff]/g).length;
    return ((str.length - str1) * 2 + str1 - 1);
};
String.prototype.contains = function(v, sep) {
    return this.split(sep ? sep : ",").contains(v);
};
String.prototype.reverse = function() {
    return this.split("").reverse().join("");
};

function StringBuilder() {
    this.strings = new Array();
    this.length = 0;
}
StringBuilder.prototype.append = function(string) {
    this.strings.push(string);
    this.length += string.length;
}
StringBuilder.prototype.toString = function(start, length) {
    return this.strings.join("").substr(start, length);
}

//Extend Function
Function.READ = 1;
Function.WRITE = 2;
Function.READ_WRITE = 3;
Function.EMPTY = function() {
};
Function.prototype.addProperty = function(sName, nReadWrite) {
    var p = this.prototype;
    nReadWrite = nReadWrite || Function.READ_WRITE;
    var capitalized = sName.capitalize();
    sName = "_" + sName;
    if (nReadWrite & Function.READ) {
        p["get" + capitalized] = function() {
            return this[sName];
        };
    }
    if (nReadWrite & Function.WRITE) {
        p["set" + capitalized] = function(v) {
            this[sName] = v;
        };
    }
};
Function.prototype.overwrite = function(f) {
    var result = f;
    if (!result.original) {
        result.original = this;
    }

    return result;
}
Date.is = function(v) {
    return v != null && typeof v == "object" && !isNaN(v);
}
Date.prototype.toString = Date.prototype.toString.overwrite(
	function(format) {
	    if (!format) format = "yyyy-MM-dd HH:mm:ss";
	    var result = new String();
	    if (typeof (format) == "string") {
	        result = format;
	        result = result.replace(/yyyy|YYYY/, this.getFullYear());
	        result = result.replace(/yy|YY/, this.getFullYear().toString().substr(2, 2));
	        result = result.replace(/MM/, this.getMonth() >= 9 ? this.getMonth() + 1 : "0" + (this.getMonth() + 1));
	        result = result.replace(/M/, this.getMonth());
	        result = result.replace(/dd|DD/, this.getDate() > 9 ? this.getDate() : "0" + this.getDate());
	        result = result.replace(/d|D/, this.getDate());
	        result = result.replace(/hh|HH/, this.getHours() > 9 ? this.getHours() : "0" + this.getHours());
	        result = result.replace(/h|H/, this.getHours());
	        result = result.replace(/mm/, this.getMinutes() > 9 ? this.getMinutes() : "0" + this.getMinutes());
	        result = result.replace(/m/, this.getMinutes());
	        result = result.replace(/ss|SS/, this.getSeconds() > 9 ? this.getSeconds() : "0" + this.getSeconds());
	        result = result.replace(/s|S/, this.getSeconds());
	    }

	    return result.replace(" 00:00:00", "");
	});
Date.prototype.addDay = function (d) {
    var milliseconds = this.getTime() + 1000 * 60 * 60 * 24 * d;
    return new Date(milliseconds);
};
//////////////////////////MoObject基类////////////////////////////
function MoObject() {
}
_p = Inherit(MoObject, Object, "MoObject");
_p._disposed = false;
_p._id = null;
MoObject.TYPE_FUNCTION = "function";
MoObject.TYPE_OBJECT = "object";
MoObject.TYPE_STRING = "string";
MoObject._hashCodeCounter = 1;
MoObject.toHashCode = function(o) {
    if (o.hasOwnProperty("_hashCode")) return o._hashCode;
    return o._hashCode = "_" + (MoObject._hashCodeCounter++).toString(32);
};
_p.toHashCode = function() {
    return MoObject.toHashCode(this);
};
_p.dispose = function() {
    this._disposed = true;
    delete this._id;
    this.dispose = function() { };
};
_p.disposeFields = function(fieldNames) {
    var fields = fieldNames instanceof Array ? fieldNames : arguments;
    var n, o, p;
    for (var i = 0; i < fields.length; i++) {
        n = fields[i];
        if (this.hasOwnProperty(n)) {
            o = this[n];
            if (o != null) {
                if (typeof o.dispose == MoObject.TYPE_FUNCTION) {
                    o.dispose();
                }
                else if (o instanceof Array) {
                    for (var j = o.length - 1; j >= 0; --j) {
                        p = o[j];
                        if (p && typeof p.dispose == MoObject.TYPE_FUNCTION) {
                            p.dispose();
                        }
                    }
                }
            }
            delete this[n];
        }
    }
};
_p.toString = function() {
    if (this._className) return "[object " + this._className + "]";
    return "[object Object]";
};
_p.getProperty = function(sPropertyName) {
    if (this.hasOwnProperty[sPropertyName]) return this[sPropertyName];
    else {
        var getterName = "get" + sPropertyName.capitalize();
        if (typeof this[getterName] == MoObject.TYPE_FUNCTION) return this[getterName]();
        throw new Error("No such property, " + sPropertyName);
    }
};
_p.setProperty = function(sPropertyName, oValue) {
    if (this.hasOwnProperty[sPropertyName]) this[sPropertyName] = oValue;
    else {
        var setterName = "set" + sPropertyName.capitalize();
        if (typeof this[setterName] == MoObject.TYPE_FUNCTION) this[setterName](oValue);
        //else throw new Error("No such property, "+sPropertyName);
        else this[sPropertyName] = oValue;
    }
};
_p.setProperties = function(oProperties) {
    for (var p in oProperties) this.setProperty(p, oProperties[p]);
};
_p.setAttribute = function(sName, sValue, oParser) {
    var v, vv;
    if (sValue == String.BOOLEAN_TRUE) v = true;
    else if (sValue == String.BOOLEAN_FALSE) v = false;
    else if ((vv = parseFloat(sValue)) == sValue) v = vv;
    else v = sValue;
    this.setProperty(sName, v);
};
_p.getAttribute = function(sName) {
    return String(this.getProperty(sName));
};
MoObject.setAttribute = function(o, sName, sValue) {
    var v, vv;
    if (sValue == String.BOOLEAN_TRUE) v = true;
    else if (sValue == String.BOOLEAN_FALSE) v = false;
    else if ((vv = parseFloat(sValue)) == sValue) v = vv;
    else v = sValue;
    if (this.hasOwnProperty[sName]) this[sName] = v;
    else {
        var setterName = "set" + sName.capitalize();
        if (typeof this[setterName] == MoObject.TYPE_FUNCTION) this[setterName](v);
        //else throw new Error("No such property, "+sName);
    }
};
if (typeof MoObject == "undefined") MoObject = new Function();

//////////////////////////MoEvent///////////////////////////
function MoEvent(sType) {
    if (_moInPrototype) return;
    MoObject.call(this);
    this._type = sType;
}
_p = Inherit(MoEvent, MoObject, "MoEvent");
_p._bubbles = false;
_p._propagationStopped = true;
_p._defaultPrevented = false;
MoEvent.addProperty("type", Function.READ);
MoEvent.addProperty("target", Function.READ);
MoEvent.addProperty("currentTarget", Function.READ);
MoEvent.addProperty("bubbles", Function.READ);
MoEvent.addProperty("data", Function.READ);
_p.stopPropagation = function() {
    this._propagationStopped = true;
};
MoEvent.addProperty("propagationStopped", Function.READ);
_p.preventDefault = function() {
    this._defaultPrevented = true;
};
MoEvent.addProperty("defaultPrevented", Function.READ);
_p.dispose = function() {
    MoObject.prototype.dispose.call(this);
    delete this._target;
    delete this._currentTarget;
    delete this._bubbles;
    delete this._propagationStopped;
    delete this._defaultPrevented;
};
_p.getDefaultPrevented = function() {
    return this._defaultPrevented;
};
function MoMouseEvent() {
}
function MoKeyboardEvent() {
}

////////////////////MoEventTarget//////////////////////
function MoEventTarget() {
    if (_moInPrototype) return;
    MoObject.call(this);
    this._listeners = {};
    this._listenersCount = 0;
}
_p = Inherit(MoEventTarget, MoObject, "MoEventTarget");
_p.addEventListener = function(sType, fHandler, oObject, oData) {
    if (typeof fHandler != MoObject.TYPE_FUNCTION) throw new Error(this + " addEventListener: " + fHandler + " is not a function");
    var ls = this._listeners[sType];
    if (!ls) ls = this._listeners[sType] = {};
    var key = MoObject.toHashCode(fHandler) + (oObject ? MoObject.toHashCode(oObject) : String.EMPTY);
    if (!(key in ls)) {
        this._listenersCount++;
    }
    ls[key] = {
        handler: fHandler, object: oObject || this, data: oData
    };
};
_p.removeEventListener = function(sType, fHandler, oObject) {
    if (this._disposed || !(sType in this._listeners)) return;
    if (fHandler != null) {
        var key = MoObject.toHashCode(fHandler) + (oObject ? MoObject.toHashCode(oObject) : String.EMPTY);
        if (key in this._listeners[sType]) {
            --this._listenersCount;
        }
        delete this._listeners[sType][key];
        if (Object.isEmpty(this._listeners[sType])) {
            delete this._listeners[sType];
        }
    } else {
        for (var key in this._listeners[sType]) {
            --this._listenersCount;
            delete this._listeners[sType][key];
        }
        delete this._listeners[sType];
    }
};
_p.dispatchEvent = function(e) {
    if (this._disposed) return;
    if (typeof e == MoObject.TYPE_STRING) {
        e = new MoEvent(e);
    }
    e._target = this;
    this._dispatchEvent(e);
    delete e._target;
    return !e._defaultPrevented;
};
_p._dispatchEvent = function(e) {
    e._currentTarget = this;
    if (this._listenersCount > 0 && (!(e instanceof MoMouseEvent) && !(e instanceof MoKeyboardEvent) || this.getIsEnabled())) {
        var fs = this._listeners[e.getType()];
        if (fs) {
            for (var hc in fs) {
                var ho = fs[hc];
                e.data = ho.data;
                ho.handler.call(ho.object, e);
            }
        }
    }
    if (e._bubbles && !e._propagationStopped && this._parent && !this._parent._disposed) {
        this._parent._dispatchEvent(e);
    }
    delete e._currentTarget;
};
_p.setAttribute = function(sName, sValue, oParser) {
    if (sName.substring(0, 2) == "on") {
        var type = sName.substring(2);
        this.addEventListener(type, new Function("event", sValue), oParser);
    }
    else MoObject.prototype.setAttribute.call(this, sName, sValue, oParser);
};
_p.dispose = function() {
    if (this._disposed) return;
    MoObject.prototype.dispose.call(this);
    for (var t in this._listeners) delete this._listeners[t];
    delete this._listeners;
    delete this._listenersCount;
};
_p.hasListeners = function(sType) {
    return this._listenersCount > 0 && (sType == null || sType in this._listeners);
};

//判断浏览器类型
MUI.isIE = /msie/i.test(navigator.userAgent);
MUI.isMoz = navigator.product == "Gecko";
MUI.isOpera = window.opera && opera.buildNumber;
MUI.isIE6 = MUI.isIE && /MSIE [56]/.test(navigator.userAgent);
Extend(MUI, {
    noOperation: function() { },
    onLoading: function() { },
    onError: function() { },
    onTimeout: function() { return true; },
    cryptProvider: null,
    version: "7.7.31.1",
    timeoutPeriod: 15 * 1000,
    noUtcTime: false,
    m: {
        '\b': '\\b',
        '\t': '\\t',
        '\n': '\\n',
        '\f': '\\f',
        '\r': '\\r',
        '"': '\\"',
        '\\': '\\\\'
    },
    toJSON: function(o) {
        if (o == null) {
            return "null";
        }
        var v = [];
        var i;
        var c = o.constructor;
        if (c == Number) {
            return isFinite(o) ? o.toString() : MUI.toJSON(null);
        } else if (c == Boolean) {
            return o.toString();
        } else if (c == String) {
            if (/["\\\x00-\x1f]/.test(o)) {
                o = o.replace(/([\x00-\x1f\\"])/g, function(a, b) {
                    var c = MUI.m[b];
                    if (c) {
                        return c;
                    }
                    c = b.charCodeAt();
                    return '\\u00' +
						Math.floor(c / 16).toString(16) +
						(c % 16).toString(16);
                });
            }
            return '"' + o + '"';
        } else if (c == Array) {
            for (i = 0; i < o.length; i++) {
                v.push(MUI.toJSON(o[i]));
            }
            return "[" + v.join(",") + "]";
        } else if (c == Date) {
            var d = {};
            d.__type = "System.DateTime";
            if (MUI.noUtcTime == true) {
                d.Year = o.getFullYear();
                d.Month = o.getMonth() + 1;
                d.Day = o.getDate();
                d.Hour = o.getHours();
                d.Minute = o.getMinutes();
                d.Second = o.getSeconds();
                d.Millisecond = o.getMilliseconds();
            } else {
                d.Year = o.getUTCFullYear();
                d.Month = o.getUTCMonth() + 1;
                d.Day = o.getUTCDate();
                d.Hour = o.getUTCHours();
                d.Minute = o.getUTCMinutes();
                d.Second = o.getUTCSeconds();
                d.Millisecond = o.getUTCMilliseconds();
            }
            return MUI.toJSON(d);
        }
        if (typeof o.toJSON == "function") {
            return o.toJSON();
        }
        if (typeof o == "object") {
            for (var attr in o) {
                if (typeof o[attr] != "function") {
                    v.push('"' + attr + '":' + MUI.toJSON(o[attr]));
                }
            }
            if (v.length > 0) {
                return "{" + v.join(",") + "}";
            }
            return "{}";
        }
        return o.toString();
    },
    eval: function(s) {
        return eval("(" + s + ")");
    }
});
var Swidth = screen.width;
//window.onerror = function() { return true; }

function setWebBILinkCount(s) {

}
//获得随机码
function Guid(pre) {
    pre = pre || "";
    return pre + Math.random().toString().substr(2);
}