﻿////////////////////////////////////////////////////////////////////////////分页类////////////////////////////////////////////////////////////////////////
function DataListPager()
{
	this.dataList;
	this.totalCount=0;
	this.pageCount=0;
	this.pageSize=25;
	this.currentPageIndex=1;
	this.ItemName=lan("条");
	this.elContainer=null;
	this.digitNavNum=10;//数字导航显示的数字数
	this.IsShowDigitNav=true;//是否显示数字导航
	this.IsShowInput=true;//是否显示转到第几页
	this.IsWord=true;
	this.gotoListInfo="";//当一个DataList对象和DataListPager对象供多个列表使用时,用来定位当前列表

	this.PagingBtnClick = function(type,pageIndex)
	{
		switch(type.toLowerCase())
		{
			case "first":
				this.currentPageIndex = 1;
				break;
			case "pre":
				this.currentPageIndex = Math.max(this.currentPageIndex-1,1);
				break;
			case "next":
				this.currentPageIndex = Math.min(this.currentPageIndex+1,this.pageCount);
				break;
			case "last":
				this.currentPageIndex= Math.max(this.pageCount,1);
				break;
			case "go":
				if(pageIndex=="") return;
				this.currentPageIndex = Math.min(this.pageCount,pageIndex);
				break;
			default:
				break;
		}
		//this.dataList.DataBind(this.currentPageIndex, true);
		this.dataList.dispatchEvent("pageindexchanged");
		this.Show();
	}

	this.GetPagingInfo = function()
	{
		var html="";
		if(this.currentPageIndex>1){
			html+="&nbsp;<A href='javascript:' onclick=\""+this.gotoListInfo+this.dataList.objectID+".pager.PagingBtnClick('first')\">"+(this.IsWord?lan("首页"):"<FONT title='"+lan("首页")+"' face='webdings'>9</FONT>")+"</A> ";
			html+=" <A href='javascript:' onclick=\""+this.gotoListInfo+this.dataList.objectID+".pager.PagingBtnClick('pre')\">"+(this.IsWord?lan("上页"):"<FONT title='"+lan("上页")+"' face='webdings'>7</FONT>")+"</A>";
		}
		if(this.pageCount>1 && this.IsShowDigitNav){
		if(this.pageCount<=this.digitNavNum){
			for(var k=1;k<=this.pageCount;k++){
				if(k==this.currentPageIndex)
					html+="&nbsp;<FONT color=red class=CurrentPageFont>"+k+"</FONT>";
				else
					html+="&nbsp;<A href=\"javascript:\" onclick=\""+this.gotoListInfo+this.dataList.objectID+".pager.PagingBtnClick('go',"+k+")\">"+k+"</A>";
			}
		}
		else if(this.currentPageIndex<=Math.ceil(1.0*this.digitNavNum/2)){
			for(var k=1;k<=this.digitNavNum;k++){
				if(k==this.currentPageIndex)
					html+="&nbsp;<FONT color=red class=CurrentPageFont>"+k+"</FONT>";
				else
					html+="&nbsp;<A href=\"javascript:\" onclick=\""+this.gotoListInfo+this.dataList.objectID+".pager.PagingBtnClick('go',"+k+")\">"+k+"</A>";
			}
			html+=" ...";
		}
		else if((this.pageCount-this.currentPageIndex)<=Math.floor(1.0*this.digitNavNum/2)){
			html+=" ...";
			for(var k=(this.pageCount-this.digitNavNum+1);k<=this.pageCount;k++){
				if(k==this.currentPageIndex)
					html+=" <FONT color=red class=CurrentPageFont>"+k+"</FONT> ";
				else
					html+=" <A href=\"javascript:\" onclick=\""+this.gotoListInfo+this.dataList.objectID+".pager.PagingBtnClick('go',"+k+")\">"+k+"</A> ";
			}
		}
		else{
			html+=" ...";
			for(var k=1;k<=this.digitNavNum;k++){
				p=this.currentPageIndex-Math.ceil(1.0*this.digitNavNum/2)+k;
				if(p==this.currentPageIndex)
					html+=" <FONT color=red class=CurrentPageFont>"+p+"</FONT> ";
				else
					html+=" <A href=\"javascript:\" onclick=\""+this.gotoListInfo+this.dataList.objectID+".pager.PagingBtnClick('go',"+p+")\">"+p+"</A> ";
			}
			html+="...";
		}
		}
		//...<A href=''>4</A> <A href=''>5</A> <A href=''>6</A> <A href=''>7</A> <A href=''>8</A> <FONT class=RedFont color=red>9</FONT> <A href='1'>10</A> <A href='2'>11</A> <A href=''>12</A> <A href='4'>13</A>... 
		if(this.currentPageIndex < this.pageCount){
			html+="&nbsp;<A href='javascript:' onclick=\""+this.gotoListInfo+this.dataList.objectID+".pager.PagingBtnClick('next')\">"+(this.IsWord?lan("下页"):"<FONT title='"+lan("下页")+"' face='webdings'>8</FONT>")+"</A> ";
			html+="<A href='javascript:' onclick=\""+this.gotoListInfo+this.dataList.objectID+".pager.PagingBtnClick('last')\">"+(this.IsWord?lan("尾页"):"<FONT title='"+lan("尾页")+"' face='webdings'>:</FONT>")+"</A> ";
		}
		html+=" "+lan("第")+"<B>"+this.currentPageIndex+"</B>/<B>"+this.pageCount+"</B>"+lan("页");
		if(this.currentPageIndex!=this.pageCount)
			html+=" "+lan("每页")+"<B>"+this.pageSize+"</B>"+lan("条");
		else{
			if(this.pageCount>1)
			html+=" "+lan("本页")+"<B>"+(this.totalCount-(this.pageCount-1)*this.pageSize)+"</B>"+lan("条");
		}
		html+=" "+lan("共")+"<B>"+this.totalCount+"</B>"+this.ItemName+" "; 
		if(this.IsShowInput){
		    if (this.pageCount <= 100) html += "<select style='height:18px;font-size:8pt;margin-bottom:3px;' onchange=\"" + this.gotoListInfo + this.dataList.objectID + ".pager.PagingBtnClick('go',this.value)\">" + GetOptionHTML(GetRegularListData(1, this.pageCount, 1), this.currentPageIndex) + "</select>";
			else html+=lan("转到")+"<input type=text style='width:30px;height:16px'>"+lan("页")+"<input type='button' class='btn_go' value='GO' style='width:25px;' onclick=\""+this.gotoListInfo+this.dataList.objectID+".pager.PagingBtnClick('go',this.previousSibling.previousSibling.value)\"/>";
		}
		return html;
	}

	this.Show = function() {
	    //debugger;
	    if (this.elContainer) {
	        if (this.totalCount == 0 || this.pageCount <= 1) {
	            this.elContainer.innerHTML = "";
	            this.elContainer.style.display = "none";
	            if (this.elContainer.bottomLine) this.elContainer.bottomLine.style.display = "none";
	        }
	        else {
	            this.elContainer.innerHTML = this.GetPagingInfo();
	            this.elContainer.style.display = "";
	            if (this.elContainer.bottomLine) this.elContainer.bottomLine.style.display = "";
	        }
	    }
	}

	this.getIsShow = function() {
	    return !(this.totalCount == 0 || this.pageCount <= 1);
	}
}