﻿Include(window._BasePath + "js/AjaxPro.AjaxClass.js");
Include(window._BasePath + "ajaxpro/MUI.AjaxInvoke.GridDesign,HDGrid_dll.ashx");

/*********************************************************************************************************************/
/*设计说明 
*设置option.data作为列表框选项设置值存放；
*设置option.vardata作为列表框选项设置值有更改的存放；
*listbox.OrderChange表示列表框顺序是否调整过；
*/
var ApplicationPath="/";
var HelpInfo, XmlHelp;
// 各列表框选项属性默认值
var LBColumns_DefVal = { BShow: true, Align: "left", EditControlType: "TextBox", EditBEnabled: true, BDetailShow: true ,DetailPlaceType:"0" };
var LBQuerys_DefVal = { BShow: true, PlacePart: 0, ControlType: "TextBox", PlaceType: 0, TextAlign: "center", BAutoPostBack: false };
var LBEdits_DefVal = { BShow: true,BSave:true, BelongTo: 0, ControlType: "TextBox", TextAlign: "center", PlaceType: 0, BEnabled: true };

var Page_Titles = {}, Page_Buttons = {}, Page_Querys = {}, Page_Lists = {}, Page_Datas = {},Page_Others={};
var ConfigDS, FC;
var DelOptIDs_Column = [], DelOptIDs_Query = [], DelOptIDs_Edit = [];
var CurrentUser,CorpID = 0;

//TAB页点击事件
function ToggleTab(o) {
    if (typeof o == "number") o = $(".span_tab")[o];
    var st = $(".span_selectedTab")[0];
    $(st).children()[1].innerHTML = $(o).children()[1].innerHTML;
    st.style.left = ($(o).left() - 3) + "px";
    st.style.display = "block";
    $(".td_tabContent").children().get(o.parentNode.cti || 0).style.display = "none";
    var index = $(o.parentNode).children().index(o);
    $(".td_tabContent").children().get(index).style.display = "block";
    o.parentNode.cti = index;
};

//初始化界面
$(function() {
    FC = GetQueryString("FC");
    if (parent && parent["Grid_" + FC]) {
        parent["Grid_" + FC].designOpen = true; //设计窗口是否打开
    }
    MUI.AjaxInvoke.GridDesign.GetConfigDataSet(FC, function(ret) {
        ConfigDS = ret.value;
        if (ConfigDS) {
            var info = MUI.eval(ConfigDS.Tables[0].Rows[0]["Info"]);
            ApplicationPath = info.ApplicationPath;
            CurrentUser = parent.CurrentUser;
            CorpID = parent.CorpID;
            var designRight = info.DesignOpen;
            if (!designRight) {
                if ($("#P_Other_SetRolesID").val() == "" && $("#P_Other_SetRolesName").val() == "") designRight = false;
                else designRight = IsInRoles_Ajax($("#P_Other_SetRolesID").val(), $("#P_Other_SetRolesName").val());
            }
            if (designRight == false) { document.write("您没有设计权限"); return; }

            var fnSort = function(c1, c2) {
                return c1["ShowNO"] - c2["ShowNO"];
            };
            ConfigDS.Tables[1].Rows.sort(fnSort);
            ConfigDS.Tables[2].Rows.sort(fnSort);
            ConfigDS.Tables[3].Rows.sort(fnSort);
            InitControl(); //初始化控件及其事件

            xmlHelp = GetXmlDocument("Xml/Help.xml");
            HelpInfo = new PopupWin("使用帮助");

            $(window).unload(function() {
                Dispose();
            });
            setInterval(TimerSave, 5 * 60 * 1000);
            EnabledButton();
        }
    });
});
/*无用
//获取数据库连接字符串组，组件支持多个数据库
//返回json数据对象。格式：[{name:name1,value:value1},...]
*/
function GetConnectionStrings_Ajax() {
    MUI.AjaxInvoke.GridDesign.GetConnectionStrings();
}
//初始化控件数据
function InitControl() {//页面变量赋值
    //绑定选择数据库
    MUI.AjaxInvoke.GridDesign.GetConnectionStrings(function(ret) {
        if (ret.value) {
            var arr = eval(ret.value);
            arr.insertAt({ name: "", value: "" }, 0);
            BindDataToSelect_Array(g("X_Database"), arr);
        }
    });
    BindDataToSelect_XmlTable("Xml/ControlType.xml", "EditControlType", g("C_EditControlType"));
    BindDataToSelect_XmlTable("Xml/ControlType.xml", "QueryControlType", g("Q_ControlType"));
    BindDataToSelect_XmlTable("Xml/ControlType.xml", "ControlType", g("E_ControlType"));
    
    var rowPage = ConfigDS.Tables[0].Rows[0];
    $(":input[id^='P_']").each(function() {
        var v = rowPage[this.id.substr(this.id.lastIndexOf("_") + 1)];
        if (this.type == "checkbox")
            this.checked = v || false;
        else
            this.value = v == null ? "" : v;
    });
    BindFieldNameList(); //初始化字段下拉框
    InitListBoxFromDataTable(g("lbColumn"), ConfigDS.Tables[1]); //初始化列表列表框成员对象   
    InitListBoxFromDataTable(g("lbQuery"), ConfigDS.Tables[2]); //初始化查询列表框成员对象
    InitListBoxFromDataTable(g("lbEdit"), ConfigDS.Tables[3]); //初始化编辑列表框成员对象

    //控件绑定事件
    $("#P_Data_ViewTableName").change(function(e) {
        BindFieldNameList(g("lbColumn").length == 0 ? true : false);
    });

    $(":input[id^='P_Title_']").change(function(e) {
        var fn = this.id.substr(8);
        if (this.type == "checkbox")
            Page_Titles[fn] = this.checked;
        else
            Page_Titles[fn] = this.value;
        Change();
    });
    $(":input[id^='P_Button_']").change(function(e) {
        var fn = this.id.substr(9);
        if (this.type == "checkbox")
            Page_Buttons[fn] = this.checked;
        else
            Page_Buttons[fn] = this.value;
        Change();
    });
    $(":input[id^='P_Query_']").change(function(e) {
        var fn = this.id.substr(8);
        if (this.type == "checkbox")
            Page_Querys[fn] = this.checked;
        else
            Page_Querys[fn] = this.value;
        Change();
    });
    $(":input[id^='P_List_']").change(function(e) {
        var fn = this.id.substr(7);
        if (this.type == "checkbox")
            Page_Lists[fn] = this.checked;
        else
            Page_Lists[fn] = this.value;
        Change();
    });
    $(":input[id^='P_Data_']").change(function(e) {
        var fn = this.id.substr(7);
        if (this.type == "checkbox")
            Page_Datas[fn] = this.checked;
        else
            Page_Datas[fn] = this.value;
        Change();
    });
    $(":input[id^='P_Other_']").change(function(e) {
        var fn = this.id.substr(8);
        if (this.type == "checkbox")
            Page_Others[fn] = this.checked;
        else
            Page_Others[fn] = this.value;
        Change();
    });

    //selectedIndex->curIndex 以适应firefox先变selectedIndex
    $(":input[id^='C_']").change(function(e) {
        if (g("lbColumn").curIndex == -1) return;
        var fn = this.id.substr(2);
        var opt = g("lbColumn").options[g("lbColumn").curIndex];
        if (this.type == "checkbox")
            opt.vardata[fn] = opt.data[fn] = this.checked;
        else {
            opt.vardata[fn] = opt.data[fn] = this.value;
            if (fn == "ShowName") opt.text = this.value;
        }
        Change();
    });
    $(":input[id^='Q_']").change(function(e) {
        if (g("lbQuery").curIndex == -1) return;
        var fn = this.id.substr(2);
        var opt = g("lbQuery").options[g("lbQuery").curIndex];
        if (this.type == "checkbox")
            opt.vardata[fn] = opt.data[fn] = this.checked;
        else {
            opt.vardata[fn] = opt.data[fn] = this.value;
            if (fn == "ShowName") opt.text = this.value;
        }
        Change();
    });
    $(":input[id^='E_']").change(function(e) {
        if (g("lbEdit").curIndex == -1) return;
        var fn = this.id.substr(2);
        var opt = g("lbEdit").options[g("lbEdit").curIndex];
        if (this.type == "checkbox")
            opt.vardata[fn] = opt.data[fn] = this.checked;
        else {

            opt.vardata[fn] = opt.data[fn] = this.value;
            if (fn == "ShowName") opt.text = this.value;
        }
        Change();
    });
    $(":checkbox").click(function(e) { this.blur(); });
};
//初始化字段下拉框
function BindFieldNameList(build) {
    var viewName = GetViewSQL(g("P_Data_ViewTableName").value.trim());
    if (viewName && (g("P_Data_DataSourceType").value == "0" || g("P_Data_DataSourceType").value == "")) {
        var view_fnList = MUI.AjaxInvoke.GridDesign.GetFieldNameList(g("P_Data_Database").value,viewName).value || "";
        if (view_fnList) view_fnList = "," + view_fnList;
        //BindDataToSelect_Str(g("C_FieldName"), view_fnList); //初始化字段名称下拉框
        BindDataToSelect_Str(g("CX_FieldName"), view_fnList); //初始化字段名称下拉框
        BindDataToSelect_Str(g("QX_FieldName"), view_fnList); //初始化字段名称下拉框
        
        //依据视图创建成员组
        if (ConfigDS == null || ConfigDS.Tables[1].Rows.length == 0 || build) {
            BindDataToSelect_Str(g("lbColumn"), view_fnList.replace(/^,/,""));
            SetOptionValue(g("lbColumn"));
            Change();
        }
        //初始化新增编辑字段名称下拉框
        if (g("P_Other_TableName").value) {
            BindDataToSelect_Str(g("EX_FieldName"), "," + MUI.AjaxInvoke.GridDesign.GetFieldNameList(g("P_Data_Database").value, g("P_Other_TableName").value).value || "");
            //BindDataToSelect_Str(g("EX_FieldName"), view_fnList);
        }
    }
};
//从数据库表对象读取值并创建列表框成员对象组
function InitListBoxFromDataTable(lb, dt) {
    var lr = dt.Rows.length;
    var lc = dt.Columns.length;
    var i, k;
    var txt, val, dr, col,opt;
    for (i = 0; i < lr; i++) {
        dr = dt.Rows[i];
        txt = dr["ShowName"] || "";
        if (lb.id=="lbColumn" && !dr["FieldName"] && dr["Property"]) txt += "[特殊列]";
        opt = lb.options[i] = new Option(txt);
//        opt.id = newid();
        opt.data = {};
        opt.vardata = {};
        for (k = 0; k < lc; k++) {
            col = dt.Columns[k];
            val = dr[col.Name] == null ? "" : dr[col.Name];
            opt.data[col.Name] = val;
        }
    }
    if (lb.length > 0) {
        lb.selectedIndex = 0;
        SetOptionValue(lb);
    }
};
//列表框成员赋值
function SetOptionValue(lb) {
    var prefix;
    if (lb.id == "lbColumn")
        prefix = "C_";
    else if (lb.id == "lbQuery")
        prefix = "Q_";
    else if (lb.id == "lbEdit")
        prefix = "E_";

    var i = lb.selectedIndex;
    if (i == -1) return;
    var opt = lb.options[i];
    if (!opt.data) {
        opt.data = { FieldName: opt.text, ShowName: opt.text };
        opt.vardata = {};
//        opt.id = newid();
        if (lb.id == "lbColumn") {
            if (opt.text.endsWith("时间")) { opt.data.ShowFormat = "yyyy-MM-dd HH:mm"; opt.data.Align = "center"; opt.data.Width = "110"; }
            else if (opt.text.endsWith("日期")) { opt.data.ShowFormat = "yyyy-MM-dd"; opt.data.Align = "center"; opt.data.Width = "73"; }
            else if (opt.text.endsWith("序号")) { opt.data.Align = "right"; opt.data.Width = "40"; }
            else if (opt.text.endsWith("人") || opt.text.endsWith("者") || opt.text.endsWith("员")) { opt.data.Width = "56"; }
            else if (opt.text.endsWith("金") || opt.text.endsWith("额") || opt.text.endsWith("价") || opt.text.endsWith("费") || opt.text.endsWith("收入")) { opt.data.Align = "right"; opt.data.ShowFormat = "F2"; opt.data.Width = "60"; }
            else if (opt.text.endsWith("数") || opt.text.endsWith("量")) { opt.data.Align = "right"; opt.data.Width = "60"; }
            else if (opt.text.endsWith("单号")) { opt.data.BKey = true; opt.data.Align = "center"; opt.data.Width = "130"; }
            else if (opt.text.endsWith("编号")) { opt.data.BShow = false; opt.data.BDetailShow = false; }
            else if (opt.text == "CorpID") { opt.data.BShow = false; opt.data.BDetailShow = false; }
            else if (opt.text == "UnitID") { opt.data.BShow = false; opt.data.BDetailShow = false; }
            else if (opt.text == "ID" || opt.text == "AI" || opt.text == "i") { opt.data.BKey = true; opt.data.BShow = false; opt.data.BDetailShow = false;if (opt.text == "AI") opt.data.BIdentity = true; }
            else if (opt.text == "TipID") { opt.data.BShow = false; opt.data.BDetailShow = false; }
            else if (opt.text == "f") { opt.data.BShow = false; opt.data.BDetailShow = false; }
            else if (opt.text.indexOf("是否") != -1) { opt.data.EditControlType = "CheckBox"; opt.data.Property = "Label"; opt.data.Align = "center"; opt.data.Property = "56"; }
            else if (opt.text == "禁用") { opt.data.EditControlType = "CheckBox"; opt.data.Property = "Label"; opt.data.Align = "center"; }
            //else if (opt.text == "工单号") { opt.data.Width = "120"; opt.data.Property = "|/gd/gddetail.aspx?id={0}|工单号|OpenM"; opt.data.Align = "left"; }
            else if (opt.text.endsWith("仓库") || opt.text.endsWith("商店")) { opt.data.Width = "60"; opt.data.EditControlType = "DropDown_SQL"; opt.data.EditProperty = "SELECT Item,仓库名称 FROM JXCI_仓库信息 WHERE CorpID=@CorpID ORDER BY 排序号"; opt.data.Align = "left"; }
            else if (opt.text.endsWith("备注")) { opt.data.Width = "200"; opt.data.Property = "30"; }
            else if (opt.text.endsWith("状态")) { opt.data.Align = "center"; opt.data.Width = "60"; }
            else if (opt.text.endsWith("电话") || opt.text.endsWith("手机")) { opt.data.Width = "86"; }
            else if (opt.text=="sync") return;
            Extend(opt.data, LBColumns_DefVal);
        }
        else if (lb.id == "lbQuery") {
//        if (opt.text.startsWith("是否")) { opt.data.ControlType = "DropDown_TypeTable"; opt.data.Property = "公共&是否&全部&"; }
//        else if (opt.text == "禁用") { opt.data.ControlType = "DropDown_TypeTable"; opt.data.Property = "公共&是否&全部&"; }
        if (opt.text.startsWith("是否")) { opt.data.ControlType = "DropDown_String"; opt.data.Property = "1,是;0,否&全部&"; }
        else if (opt.text == "禁用") { opt.data.ControlType = "DropDown_String"; opt.data.Property = "1,是;0,否&全部&"; }
        Extend(opt.data, LBQuerys_DefVal);
        }
        else if (lb.id == "lbEdit") {
            Extend(opt.data, LBEdits_DefVal);
        }
    }
    $(":input[id^='" + prefix + "']").each(function(i) {
        var fn = this.id.substr(2);
        if (this.type == "checkbox") {
            this.checked = opt.data[fn] || false;
        } else {
            this.value = (opt.data[fn] == null ? "" : opt.data[fn]).toString();
        }
    });
    lb.curIndex = lb.selectedIndex;
};
//增加项
function AddListBoxItem(lb, bset) {
    lb.options.add(new Option(""), lb.length);
    var opt = lb.options[lb.length - 1];
    opt.text = "新项" + lb.length;
    opt.data = { ShowName: opt.text };
    opt.vardata = {};
//    opt.id = newid();
    if (bset) {
        for (var i = 0,l=lb.length; i < l; i++) {
            lb.options[i].selected = false;
        }
        opt.selected = true;
        opt.ShowName = opt.text;
        if (lb.id == "lbColumn")
            Extend(opt.data, LBColumns_DefVal);
        else if (lb.id == "lbQuery")
            Extend(opt.data, LBQuerys_DefVal);
        else if (lb.id == "lbEdit")
            Extend(opt.data, LBEdits_DefVal);
        SetOptionValue(lb);
    }
    Change();
    return opt;
};
//移除项
function DeleteListBoxItem(lb) {
    var sid = -1;
    var arrCheckIndex = new Array();
    for (var i = lb.length - 1; i >= 0; i--) {
        if (lb.options[i].selected) {
            arrCheckIndex[i] = true;
            lb.options[i].selected = false;
        }
        else
            arrCheckIndex[i] = false;
    }
    for (var i = lb.length - 1; i >= 0; i--) {
        if (arrCheckIndex[i]) {
            if (lb.options[i].data.ID) {
                if (lb.id == "lbColumn")
                    DelOptIDs_Column.push(lb.options[i].data.ID);
                else if (lb.id == "lbQuery")
                    DelOptIDs_Query.push(lb.options[i].data.ID);
                else if (lb.id == "lbEdit")
                    DelOptIDs_Edit.push(lb.options[i].data.ID);
            }
            sid = i;
            lb.options[i] = null;
        }
    }
    if (sid > 0 && lb.length > 0)
        lb.options[sid - 1].selected = true;
    else if (sid == 0 && lb.length > 0)
        lb.options[0].selected = true;

    SetOptionValue(lb);
    Change();
};
//上移(自定义XML数据源)
function ShiftUpListBoxItem(lb) {
    var i = lb.selectedIndex;
    if (i < 1) return;
    var tmp = lb.options[i];
    lb.options[i] = null;
    lb.options.add(tmp, i - 1);
    lb.selectedIndex = i - 1;

    lb.OrderChange = true;
    Change();
};
//下移(自定义XML数据源)
function ShiftDownListBoxItem(lb) {
    var i = lb.selectedIndex;
    if (i == lb.length - 1) return;
    var opt = lb.options[i];
    lb.options[i] = null;
    lb.options.add(opt, i + 1);
    lb.selectedIndex = i + 1;

    lb.OrderChange = true;
    Change();
};
//获取视图字符串
function GetViewSQL(v) {
   if(!v) v = $("#P_Data_ViewTableName").val();
    v = v.replace(/\{0\}/gm, "1>0");
    if (v.indexOf("^") != -1) v = v.substr(0, v.indexOf("^"));
    if (v.toLowerCase().indexOf("select ") != -1) {
        v = "(" + v.replace(/\r\n/gim, " ") + ") TBN";
        if (typeof (CorpID) != 'undefined')
            v = v.replace(/@CorpID/g, CorpID);
        if (typeof (CurrentUser) != 'undefined')
            v = v.replace("@CurrentUser", CurrentUser);
    }
    return v;
};

//复制相关列表项到查询定制项中
function CopyColItemsToQueryItems() {
    if (g("lbQuery").length > 0) {
        if (confirm("执行此操作将删除所有下列项，确定继续吗？") == false) return false;
        else {
            while (g("lbQuery").length > 0) {
                g("lbQuery").selectedIndex = 0;
                DeleteListBoxItem(g("lbQuery"));
            }
        }
    }
    for (i = 0; i < g("lbColumn").length; i++) {
        var opt = g("lbColumn").options[i];
        if (opt.data.FieldName) {//opt.data.BShow == true &&
            if (opt.data.FieldName == "CorpID") continue;
            if (opt.data.FieldName == "UnitID") continue;
            else if (opt.data.FieldName == "ID" || opt.data.FieldName == "AI" || opt.data.FieldName == "i") continue;
            else if (opt.data.FieldName == "TipID") continue;
            else if (opt.data.FieldName == "序号") continue;

            var newopt = AddListBoxItem(g("lbQuery"), false);
            newopt.data.ShowName = opt.data.ShowName;
            newopt.data.FieldName = opt.data.FieldName;
            Extend(newopt.data, LBQuerys_DefVal);
            newopt.text = opt.data.ShowName;
            if (opt.data.EditProperty) {
                newopt.data.ControlType = opt.data.EditControlType;
                if (opt.data.EditControlType.startsWith("DropDown") && !opt.data.EditProperty.endsWith("&"))
                    newopt.data.Property = opt.data.EditProperty + "&全部&";
                else
                    newopt.data.Property = opt.data.EditProperty;
            }
            //else if (opt.data.FieldName.startsWith("是否")) { newopt.data.ControlType = "DropDown_TypeTable"; newopt.data.Property = "公共&是否&全部&"; }
            else if (opt.data.FieldName.startsWith("是否")) { newopt.data.ControlType = "DropDown_String"; newopt.data.Property = "1,是;0,否&全部&"; }
            else if (opt.data.FieldName.endsWith("编号")) { newopt.data.ControlType = "Hidden"; }
            else if (opt.data.FieldName.endsWith("人") || opt.data.FieldName.endsWith("员") || opt.data.FieldName.endsWith("者") || opt.data.FieldName.endsWith("工程师")) { newopt.data.ControlType = "TextBox_Info"; newopt.data.Property = "readOnly"; newopt.data.Javascript = "SelPerson('Q_" + opt.data.FieldName + "编号', 'Q_" + opt.data.FieldName + "x', 1)"; }
            else if (opt.data.FieldName.endsWith("日期") || opt.data.FieldName.endsWith("时间") || opt.data.FieldName.endsWith("额") || opt.data.FieldName.endsWith("数") || opt.data.FieldName.endsWith("量") || opt.data.FieldName.endsWith("价") || opt.data.FieldName.endsWith("金") || opt.data.FieldName.endsWith("费")) { newopt.data.ControlType = "RangeQuery"; }
        }
    } 
    var newopt1 = AddListBoxItem(g("lbQuery"), false);
    newopt1.data.ShowName = "查询按钮";
    newopt1.data.FieldName = "";
    Extend(newopt1.data, LBQuerys_DefVal);
    newopt1.text = newopt1.data.ShowName;
    newopt1.data.ControlType = "QueryButton";
    newopt1.data.BQuickQuery = true;
    var newopt2 = AddListBoxItem(g("lbQuery"), false);
    newopt2.data.ShowName = "查询重置按钮";
    newopt2.data.FieldName = "";
    Extend(newopt2.data, LBQuerys_DefVal);
    newopt2.text = newopt2.data.ShowName;
    newopt2.data.ControlType = "QueryResetButton";
    newopt2.data.PlaceType = 2;
    newopt2.data.BQuickQuery = true;
    
    if (g("lbQuery").length > 0) {
        g("lbQuery").options[0].selected = true;
        SetOptionValue(g("lbQuery"));
    }
}
//复制相关列表项到编辑定制项中
function CopyColItemsToEditItems() {
    if (g("lbEdit").length > 0) {
        if (confirm("执行此操作将删除所有下列项，确定继续吗？") == false) return false;
        else {
            while (g("lbEdit").length > 0) {
                g("lbEdit").selectedIndex = 0;
                DeleteListBoxItem(g("lbEdit"));
            }
        }
    }
    for (i = 0; i < g("lbColumn").length; i++) {
        var opt = g("lbColumn").options[i];
        if (opt.data.FieldName) {
            if (opt.data.FieldName == "AI" || opt.data.FieldName == "i") continue;
            var newopt = AddListBoxItem(g("lbEdit"), false);
            newopt.data.ShowName = opt.data.ShowName;
            newopt.data.FieldName = opt.data.FieldName;
            Extend(newopt.data, LBEdits_DefVal);
            newopt.text = opt.data.ShowName;
            if (opt.data.EditProperty) {
                newopt.data.ControlType = opt.data.EditControlType;
                newopt.data.Property = opt.data.EditProperty;
            }
            if (opt.data.EditCheckValidStr) newopt.data.CheckValidStr = opt.data.EditCheckValidStr;
            if (opt.data.FieldName == "ID") {
                newopt.data.ControlType = "Hidden";
                newopt.data.Property = "@HNewID&@CorpID&ID&9&CorpID=@CorpID";
            }
            else if (opt.data.FieldName == "单号") {
                newopt.data.ControlType = "TextBox";
                newopt.data.Property = "@NewVoucher&DH&单号&3&@CID@UID";
            }
            else if (opt.data.FieldName == "登记时间" || opt.data.FieldName == "录入时间" || opt.data.FieldName == "开单时间" || opt.data.FieldName == "创建时间" || opt.data.FieldName == "提交时间" || opt.data.FieldName == "操作时间" || opt.data.FieldName == "建档时间") {
                newopt.data.ControlType = "Hidden";
                newopt.data.Property = "@NowTime";
            }
            else if (opt.data.FieldName == "登记人编号" || opt.data.FieldName == "经手人编号" || opt.data.FieldName == "开单人编号" || opt.data.FieldName == "创建人编号" || opt.data.FieldName == "操作员编号" || opt.data.FieldName == "录入员编号" || opt.data.FieldName == "录入人编号" || opt.data.FieldName == "提交人编号" || opt.data.FieldName == "建档人编号") {
                newopt.data.ControlType = "Hidden";
                newopt.data.Property = "@CurrentUser";
            }
            else if (opt.data.FieldName == "登记人" || opt.data.FieldName == "经手人" || opt.data.FieldName == "开单人" || opt.data.FieldName == "创建人" || opt.data.FieldName == "操作员" || opt.data.FieldName == "录入员" || opt.data.FieldName == "录入人" || opt.data.FieldName == "提交人" || opt.data.FieldName == "建档人") {
                newopt.data.ControlType = "Hidden";
                newopt.data.Property = "@RealName";
            }
            else if (opt.data.FieldName.endsWith("编号")) {
                newopt.data.ControlType = "Hidden";
            }
            else if (opt.data.FieldName == "客户名称") {
                newopt.data.ControlType = "TextBox_Info";
                newopt.data.Javascript = "Sel(\"JXC_BI_CustomerSelect\",1,\"C_客户编号,C_客户名称\",\"ID,客户名称\",\"\",\"选择客户\",750,500);";
            }
            else if (opt.data.FieldName == "供货商") {
                newopt.data.ControlType = "TextBox_Info";
                newopt.data.Javascript = "Sel(\"JXC_BI_SupplierSelect\",1,\"C_供货商编号,C_供货商\",\"ID,客户名称\",\"\",\"选择供货商\",750,500);";
            }
            else if (opt.data.FieldName == "CorpID") {
                newopt.data.ControlType = "Hidden";
                newopt.data.Property = "@CorpID";
            }
            else if (opt.data.FieldName == "UnitID") {
                newopt.data.ControlType = "Hidden";
                newopt.data.Property = "@UnitID";
            }
            else if (opt.data.FieldName == "UserID") {
                newopt.data.ControlType = "Hidden";
                newopt.data.Property = "@CurrentUser";
            }
            else if (opt.data.FieldName == "序号") {
                newopt.data.ControlType = "TextBox";
                newopt.data.Property = "@NewShowNO&序号";
            }
            else if (opt.data.FieldName == "禁用") {
                newopt.data.ControlType = "CheckBox";
                newopt.data.Property = "";
            }
            else if (opt.data.FieldName.indexOf("是否") != -1) {
                newopt.data.ControlType = "CheckBox";
                newopt.data.Property = "";
            }
        }
    }
    if (g("lbEdit").length > 0) {
        g("lbEdit").options[0].selected = true;
        SetOptionValue(g("lbEdit"));
    }
}
//值改变但未触发事件的控件，获取其值
function OnChange_OtherElement() {

};
//打开窗口编辑脚本
function OpenScriptEditor(ctlid) {
    MUI.Window.open({ id: 'scripteditor', type: 'fonshen', style: 'vista', width: 500, height: 300, title: '脚本编辑器', resize: true }, { overlay: 10, modal: true, ajax: 'Dialog/ScriptEditor.htm?ctlid=' + escape(ctlid) }, true);

}
//打开窗口获取颜色
function OpenColorSelector(ctlid) {
    MUI.Window.open({ id: 'colorselector', type: 'fonshen', style: 'vista', width: 450, height: 250, title: '颜色选择器', resize: false }, { overlay: 10, modal: true, ajax: 'Dialog/SelectColor.htm?ctlid=' + escape(ctlid) },true);
}
//打开值验证设置窗口
function OpenCheckValidStrSet(retid, ctlid) {
    MUI.Window.open({ id: 'CheckValidStrSet', type: 'fonshen', style: 'vista', width: 600, height: 400, title: '值验证设置', resize: false }, { overlay: 10, modal: true, ajax: 'Dialog/CheckValidStrSet.htm?retid=' + escape(retid) + '&ctlid=' + escape(ctlid) }, true);
}
//打开特殊列设置窗口
function OpenShowArgumentSet(ctlid) {
    MUI.Window.open({ id: 'ShowArgumentSet', type: 'fonshen', style: 'vista', width: 600, height: 400, title: '特殊列设置', resize: true }, { overlay: 10, modal: false, ajax: 'Dialog/ShowArgumentSet.htm?ctlid=' + escape(ctlid) }, true);
}

//打开编辑器窗口编辑脚本
function OpenHTMLEditor(ctlid) {
    MUI.Window.open({ id: 'htmleditor_' + ctlid, type: 'fonshen', style: 'vista', width: 600, height: 400, title: 'HTML编辑器', resize: true }, { overlay: 10, modal: true, ajax: 'Dialog/htmleditor.htm?ctlid=' + escape(ctlid) + '&theme=simple' }, true);

}
//显示无模式对话框(参数为window)
function OpenAjaxDialog(ctlid, w, h) {
    MUI.Window.open({ id: 'AjaxFunctioneditor', type: 'fonshen', style: 'vista', width: 250, height: 160, title: 'AJAX函数名编辑器', resize: true }, { overlay: 10, modal: true, ajax: "Dialog/SetAjaxMethod.htm?ctlid=" + ctlid + "&split=," }, true);
}

/**************************提交按钮事件相关*********************************/
var isUnSavedApply = false;
var dataChange = false; //是否有改变数据
var isSaved = false;//是否有过保存
function GetSaveData() {
    var pageSet = {};
    Extend(pageSet, Page_Others);
    Extend(pageSet, Page_Titles);
    Extend(pageSet, Page_Buttons);
    Extend(pageSet, Page_Querys);
    Extend(pageSet, Page_Lists);
    Extend(pageSet, Page_Datas);
    var el;
    var columnSets = [];
    var columnIDs = [];
    el = g("lbColumn");
    for (var i = 0, l = el.length; i < l; i++) {
        var opt = el.options[i];
        if (!opt.data) {
            opt.data = { FieldName: opt.text, ShowName: opt.text };
            Extend(opt.data, LBColumns_DefVal);
        }
        if (opt.data.ID) {
            if (el.OrderChange) opt.vardata.ShowNO = i;
            if (!Object.isEmpty(opt.vardata)) {
                opt.vardata.ID = opt.data.ID;
                columnSets.push(opt.vardata);
            }
            columnIDs.push(opt.data.ID);
        } else {
            opt.data.ShowNO = i;
            opt.data.ID = Guid();
            columnSets.push(opt.data);
        }
    }
//    for (var i = 0, l = ConfigDS.Tables[1].Rows.length; i < l; i++) {
//        if (!columnIDs.contains(ConfigDS.Tables[1].Rows[i]["ID"])) {
//            columnSets.push({ "ID": ConfigDS.Tables[1].Rows[i]["ID"], "Remove": true });
//        }
//    }
    for (var i = 0; i < DelOptIDs_Column.length; i++) {
        columnSets.push({ "ID": DelOptIDs_Column[i], "Remove": true });
    }
    
    var querySets = [];
    var queryIDs = [];
    el = g("lbQuery");
    for (var i = 0, l = el.length; i < l; i++) {
        var opt = el.options[i];
        if (!opt.data) {
            opt.data = { FieldName: opt.text, ShowName: opt.text };
            Extend(opt.data, LBQuerys_DefVal);
        }
        if (opt.data.ID) {
            if (el.OrderChange) opt.vardata.ShowNO = i;
            if (!Object.isEmpty(opt.vardata)) {
                opt.vardata.ID = opt.data.ID;
                querySets.push(opt.vardata);
            }
            queryIDs.push(opt.data.ID);
        } else {
            opt.data.ShowNO = i;
            opt.data.ID = Guid();
            querySets.push(opt.data);
        }
    }
//    for (var i = 0, l = ConfigDS.Tables[2].Rows.length; i < l; i++) {
//        if (!queryIDs.contains(ConfigDS.Tables[2].Rows[i]["ID"])) {
//            querySets.push({ "ID": ConfigDS.Tables[2].Rows[i]["ID"], "Remove": true });
//        }
//    }
    for (var i = 0; i < DelOptIDs_Query.length; i++) {
        querySets.push({ "ID": DelOptIDs_Query[i], "Remove": true });
    }

    var editSets = [];
    var editIDs = [];
    el = g("lbEdit");
    for (var i = 0, l = el.length; i < l; i++) {
        var opt = el.options[i];
        if (!opt.data) {
            opt.data = { FieldName: opt.text, ShowName: opt.text };
            Extend(opt.data, LBEdits_DefVal);
        }
        if (opt.data.ID) {
            if (el.OrderChange) opt.vardata.ShowNO = i;
            if (!Object.isEmpty(opt.vardata)) {
                opt.vardata.ID = opt.data.ID;
                editSets.push(opt.vardata);
            }
            editIDs.push(opt.data.ID);
        } else {
            opt.data.ShowNO = i;
            opt.data.ID = Guid();
            editSets.push(opt.data);
        }
    }
//    for (var i = 0, l = ConfigDS.Tables[3].Rows.length; i < l; i++) {
//        if (!editIDs.contains(ConfigDS.Tables[3].Rows[i]["ID"])) {
//            editSets.push({ "ID": ConfigDS.Tables[3].Rows[i]["ID"], "Remove": true });
//        }
//    }
    for (var i = 0; i < DelOptIDs_Edit.length; i++) {
        editSets.push({ "ID": DelOptIDs_Edit[i], "Remove": true });
    }

    var configVar = {};
    if (!Object.isEmpty(pageSet)) configVar.PageSet = pageSet;
    if (columnSets.length > 0) configVar.ColumnSet = columnSets;
    if (querySets.length > 0) configVar.QuerySet = querySets;
    if (editSets.length > 0) configVar.EditSet = editSets;

    return configVar;
}; 
//
function Confirm() {
    Save();
    if(parent && parent.child) parent.child.close();
};
//确定并保存到文件
function ConfirmAndSaveToFile() {
    Save();
    SaveConfig();
    if (parent && parent.child) parent.child.close();
};
//
function Save() {
    var saveData = GetSaveData();
    if (!Object.isEmpty(saveData)) {
        MUI.AjaxInvoke.GridDesign.SaveConfigToDataSet(FC, MUI.toJSON(saveData), function(ret) {
            if (ret && ret.value == "ok") {
                if (saveData.PageSet && saveData.PageSet.FC && saveData.PageSet.FC != FC) {
                    var rets = ret.value.split("$");
                    if (rets[0] == "1") {
                        ToggleTab(0);
                        alert(rets[1]);
                        g("P_Other_FC").value = FC;
                        return;
                    } else {
                        if (confirm("您更改了功能代码，需要刷新界面吗？")) {
                            if (parent)
                                parent.location.href = parent.location.href.replace("=" + FC, "=" + saveData.PageSet.FC);
                            else
                                window.location.href = "?fc=" + saveData.PageSet.FC;
                            return;
                        }
                        FC = saveData.PageSet.FC;
                    }
                }
                DelOptIDs_Column = [];
                DelOptIDs_Query = [];
                DelOptIDs_Edit = [];
                dataChange = false;
                isSaved = true;
                Apply();
                ClearChange();
            } else if (ret.value == "lang") {
                alert("请切换语言到中文时再进行设计");
            }
        });
    }
};
//应用改变
function Apply(bBtn) {
    if (isUnSavedApply) return;
    isUnSavedApply = bBtn;
    if (!window.parent) return;
    var grid = parent["Grid_" + FC];
    if (grid == null) {
        var ifrs = parent.document.getElementsByTagName("IFRAME");
        var ifrid;
        for (var k = 0, l = ifrs.length; k < l; k++) {
            ifrid = ifrs[k].id;
            if (ifrid.startsWith("ifr_") || ifrid.indexOf("/hdgrid/") != -1) {
                grid = parent.document.getElementById(ifrid).contentWindow["Grid_" + FC];
                break;
            }
        }
        if (grid == null) return;
    }
    //保存应用则重写页面， 后面为：发布版本只有999999用户时才有设计保存
//    if (!bBtn && !(CurrentUser != "999999" && window.location.href.toLowerCase().indexOf("localhost") == -1)) {
        grid.reload();
        EnabledButton();
        return;
//    }
    
    var bInit = grid._inited;
    if (!Object.isEmpty(Page_Titles)) {
        for (var key in Page_Titles) {
            grid.pageConfig[key] = Page_Titles[key];
        }
        if(bInit) grid.createTitleBar();
    }
    if (!Object.isEmpty(Page_Buttons)) {
        for (var key in Page_Buttons) {
            grid.pageConfig[key] = Page_Buttons[key];
        }
        if (bInit) grid.createBtnBar();
    }
    if (!Object.isEmpty(Page_Querys)) {
        for (var key in Page_Querys) {
            grid.pageConfig[key] = Page_Querys[key];
        }
        if (bInit) grid.createQueryArea();
    }
    if (!Object.isEmpty(Page_Lists)) {
        for (var key in Page_Lists) {
            grid.pageConfig[key] = Page_Lists[key];
        }
        if (bInit) {
            grid.setPageConfig();
            grid.updateGrid();
        }
    }
    if (!Object.isEmpty(Page_Datas)) {
        for (var key in Page_Datas) {
            grid.pageConfig[key] = Page_Datas[key];
        }
        if (bInit) {
            grid.setPageConfig();
            grid.dataBind();
        }
    }
    if (!Object.isEmpty(Page_Others)) {
        for (var key in Page_Others) {
            grid.pageConfig[key] = Page_Others[key];
        }
    }

    var el;
    var columnSets = grid.configDS.Tables[1].Rows;
    var columnIDs = [];
    var columnChange = false;
    el = g("lbColumn");
    for (var i = 0, l1 = el.length; i < l1; i++) {
        var opt = el.options[i];
        if (!opt.data) {
            opt.data = { FieldName: opt.text, ShowName: opt.text };
            Extend(opt.data, LBColumns_DefVal);
        }
        if (opt.data.ID) {
            if (el.OrderChange) opt.vardata.ShowNO = i;
            if (!Object.isEmpty(opt.vardata)) {
                Extend(columnSets.find(function(o, j) { return o["ID"] == opt.data.ID; }), opt.vardata, true);
                columnChange = true;
            }
        } else {
            opt.data.ShowNO = i;
            opt.data.ID = Guid();
            columnSets.push(opt.data);
            opt.vardata = {};
            columnChange = true;
        }
        columnIDs.push(opt.data.ID);
    }
    var columnSetIDs = [];
    for (var i = 0, l3 = columnSets.length; i < l3; i++) {
        columnSetIDs.push(columnSets[i]["ID"]);
    }
    for (var i = 0, l1 = columnSetIDs.length; i < l1; i++) {
        if (!columnIDs.contains(columnSetIDs[i])) {
            columnSets.remove(columnSets.find(function(o, j) { return o["ID"] == columnSetIDs[i]; }));
            columnChange = true;
        }
    }
    if (bInit && columnChange) {
        grid.setColumnDataTable();
        //grid.updateGrid();
        grid.dataBind();
    }

    var querySets = grid.configDS.Tables[2].Rows;
    var queryIDs = [];
    var queryChange = false;
    el = g("lbQuery");
    for (var i = 0, l2 = el.length; i < l2; i++) {
        var opt = el.options[i];
        if (!opt.data) {
            opt.data = { FieldName: opt.text, ShowName: opt.text };
            Extend(opt.data, LBQuerys_DefVal);
        }
        if (opt.data.ID) {
            if (el.OrderChange) opt.vardata.ShowNO = i;
            if (!Object.isEmpty(opt.vardata)) {
                Extend(querySets.find(function(o, j) { return o["ID"] == opt.data.ID; }), opt.vardata, true);
                queryChange = true;
            }
        } else {
            opt.data.ShowNO = i;
            opt.data.ID = Guid();
            querySets.push(opt.data);
            opt.vardata = {};
            queryChange = true;
        }
        queryIDs.push(opt.data.ID);
    }
    var querySetIDs = [];
    for (var i = 0, l3 = querySets.length; i < l3; i++) {
        querySetIDs.push(querySets[i]["ID"]);
    }
    for (var i = 0, l2 = querySetIDs.length; i < l2; i++) {
        if (!queryIDs.contains(querySetIDs[i])) {
            querySets.remove(querySets.find(function(o, j) { return o["ID"] == querySetIDs[i]; }));
            queryChange = true;
        }
    }
    if (bInit && queryChange) {
        grid.createQueryArea();
    }

    var editSets = grid.configDS.Tables[3].Rows;
    var editIDs = [];
    var editChange = false;
    el = g("lbEdit");
    for (var i = 0, l3 = el.length; i < l3; i++) {
        var opt = el.options[i];
        if (!opt.data) {
            opt.data = { FieldName: opt.text, ShowName: opt.text };
            Extend(opt.data, LBEdits_DefVal);
        }
        if (opt.data.ID) {
            if (el.OrderChange) opt.vardata.ShowNO = i;
            if (!Object.isEmpty(opt.vardata)) {
                Extend(editSets.find(function(o, j) { return o["ID"] == opt.data.ID; }), opt.vardata, true);
                editChange = true;
            }
        } else {
            opt.data.ShowNO = i;
            opt.data.ID = Guid();
            editSets.push(opt.data);
            opt.vardata = {};
            editChange = true;
        }
        editIDs.push(opt.data.ID);
    }
    var editSetIDs = [];
    for (var i = 0, l3 = editSets.length; i < l3; i++) {
        editSetIDs.push(editSets[i]["ID"]);
    }
    for (var i = 0, l3 = editSetIDs.length; i < l3; i++) {
        if (!editIDs.contains(editSetIDs[i])) {
            editSets.remove(editSets.find(function(o, j) { return o["ID"] == editSetIDs[i]; }));
            editChange = true;
        }
    }
    if (bInit) {
        grid.updateGridSize();
    }
    EnabledButton();
    
    if (!bInit) {
        grid.create();
    }
};
function Cancel() {
    if (isUnSavedApply && parent) {
        var grid = parent["Grid_" + FC];
        grid.reload();
    }
    if (parent.child) parent.child.close();
};
function Change() {
    if (dataChange && !isUnSavedApply) return;
    dataChange = true;
    isUnSavedApply = false;
    EnabledButton();
}
function EnabledButton() {
    if (dataChange) {
        g("btnConfirm").disabled = false;
        g("btnSave").disabled = false;
        if (isUnSavedApply)
            g("btnApply").disabled = true;
        else
            g("btnApply").disabled = false;
    }
    else {
        g("btnConfirm").disabled = false;
        g("btnSave").disabled = true;
        g("btnApply").disabled = true;
    }
    
}
function ClearChange() {
    Page_Titles = {};
    Page_Buttons = {};
    Page_Querys = {};
    Page_Lists = {};
    Page_Datas = {};
    Page_Others = {};

    var el;
    el = g("lbColumn");
    for (var i = 0, l = el.length; i < l; i++) {
        el.options[i].vardata = {};
    }
    el = g("lbQuery");
    for (var i = 0, l = el.length; i < l; i++) {
        el.options[i].vardata = {};
    }
    el = g("lbEdit");
    for (var i = 0, l = el.length; i < l; i++) {
        el.options[i].vardata = {};
    }
};

//////释放资源//////
function Dispose() {
    if (isSaved)
    MUI.AjaxInvoke.GridDesign.RemoveCacheConfigDataSet(FC);
};
function TimerSave() {
    if (isSaved)
    MUI.AjaxInvoke.GridDesign.SaveCacheConfigDataSet(FC, function() { });
};
function SaveConfig() {
    TimerSave();
}
function onChangeECT(el) {
    if (el.value == 'CheckBox') {
        $.g('C_Align').value = 'center';
        $('#C_Align').trigger("change");
        $.g('C_Property').value = 'Label';
        $('#C_Property').trigger("change");
    }
}

