﻿
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////JavaScript的表单验证的函数[CheckSubmit(验证字符串)]////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//验证参数列表：
//0或O:必填的Text类型											语法：ctlid|0|提示
//N:必须为数值的Text类型										语法：ctlid|N|提示
//I:必须为整数的Text类型										语法：ctlid|I|提示
//E:必须为Email的Text类型										语法：ctlid|E|提示
//W:必须为a-z或0-9或A-Z的字符的Text类型							语法：ctlid|W|提示
//L:必须小于指定位数的Text类型									语法：ctlid|L|提示|number
//G:必须大于指定位数的Text类型									语法：ctlid|G|提示|number
//EQ:必须等于指定位数的Text类型									语法：ctlid|EQ|提示|number
//=:判断两个Text值相同。如确认密码和密码必须相等的Text类型		语法：ctlid1|=|提示|ctlid2
//<>:判断两个Text值不相同										语法：ctlid1|<>|提示|ctlid2
//>:第一个值必须大于第二个值									语法：ctlid1|>|提示|ctlid2
//<=:第一个值必须小于等于第二个值								语法：ctlid1|<=|提示|ctlid2
//D:判断是否是合法的日期										语法：ctlid|D|提示  或ctlid-01-01|D|提示(判断正确年度)
//T:判断是否是合法的时间										语法：ctlid|T|提示
//DT:判断是否是合法的日期或时间									语法：ctlid|DT|提示
//B:与固定数值比较大小											语法：ctlid|B|提示|value|符号  //比较符号有：=、>、>=、<、<=、!=
//LD:判断两个日期的大小，第一个要小于第二个						语法：ctlid1|LD|提示|ctlid2
//P:限制图片大小												语法：ctlid|P|提示|number|ext
//M:值必须匹配Reg												语法：ctlid1|M|提示|Reg[|ctlid2]  //ctlid2为聚集控件ID
//NM:值必须不匹配Reg											语法：ctlid1|NM|提示|Reg[|ctlid2]  //ctlid2为聚集控件ID
//R:不能存在重复值												语法：ctlid|R|提示1,提示2,...|TableName|Edit或[当前记录SqlWhere1,SqlWhere2,...|Field1,Field2,...]
//TableName为表名，Edit代表是编辑界面，TableName后面的参数存在时将访问到服务器验证其它页数据 如:C_UserName|R|账号已存在！|Cwm_Sys_User|Edit
//Ajax:服务器函数												语法：ctlid|Ajax|提示|Ajax联动函数名，联动函数名格式为“方法名,类名,程序集名称”，
//联动函数格式为：public bool MethodName(MUI.Components.Database.DbOperator objDB,System.Collections.Specialized.NameValueCollection nv,string keyWhere) nv为页面数据包，keyWhere为记录主键查询。
//“提示1,提示2,...”和“qlWhere1,SqlWhere2,...”可以含有{i}格式的数据，它代表后面相应位置的以“C_+字段名（Field1,Field2,...）”为ID的控件的值。
function CheckSubmit(errStrs,type) {
    var objArr = errStrs.split(";");
    for (var i = 0; i < objArr.length; i++) {
        if (!CheckOK(objArr[i])) {
            return false;
        }
    }
    if (type == 1 && typeof onNewCheck == 'function') { return onNewCheck(); }
    if (type == 2 && typeof onEditCheck == 'function') { return onEditCheck(); }
    if ((type == 1 || type == 2) && typeof onNewEditCheck == 'function') { return onNewEditCheck(); }
    if (type == 0 && typeof onGridCheck == 'function') { return onGridCheck(); }
    return true;
}
function CheckRadio(errStr) {
    var tmpArr = errStr.split("|");
    var arr = document.getElementsByName(tmpArr[0]);
    for (var i = 0; i < arr.length; i++) {
        if (arr[i].checked) return true;
    }
    window.alert(tmpArr[2]);
    arr[0].focus();
    return false;
}
function CheckOK(errStr) {
    if (errStr == "") return true;
    try {
        var tmpArr = errStr.split("|");
        if (!document.getElementById(tmpArr[0]) && document.getElementsByName(tmpArr[0]).length == 0) return true;
        switch (tmpArr[1].toUpperCase()) {
            case "F": //聚焦到控件
                {
                    window.alert(tmpArr[2]);
                    if (document.getElementById(tmpArr[0]).type != "hidden")
                        document.getElementById(tmpArr[0]).focus();
                    return false;
                    break;
                }
            case "0": //必填的Text类型
                {
                    if (document.getElementById(tmpArr[0]) && Trim(document.getElementById(tmpArr[0]).value) == "") {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    else if (document.getElementsByName(tmpArr[0]).length > 0) {
                        var els = document.getElementsByName(tmpArr[0]);
                        if (els.type != "radio") return true;
                        var hc = false;
                        for (var n = 0, l = els.length; n < l; n++) {
                            if (els[n].checked) { hc = true; break; }
                        }
                        if (!hc) {
                            window.alert(tmpArr[2]);
                            els[0].focus();
                            return false;
                        }
                    }
                    break;
                }
            case "O": //必填的Text类型（同上）
                {
                    if (document.getElementById(tmpArr[0]) && Trim(document.getElementById(tmpArr[0]).value) == "") {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    else if (document.getElementsByName(tmpArr[0]).length > 0) {
                        var els = document.getElementsByName(tmpArr[0]);
                        var hc = false;
                        for (var n = 0, l = els.length; n < l; n++) {
                            if (els[n].checked) { hc = true; break; }
                        }
                        if (!hc) {
                            window.alert(tmpArr[2]);
                            els[0].focus();
                            return false;
                        }
                    }
                    break;
                }
            case "N": //必须为数字的Text类型
                {
                    if (document.getElementById(tmpArr[0]).value != "" && isNaN(document.getElementById(tmpArr[0]).value)) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "I": //必须为整形数字的Text类型
                {
                    if (document.getElementById(tmpArr[0]).value != "" && isNaN(Trim(document.getElementById(tmpArr[0]).value)) || Trim(document.getElementById(tmpArr[0]).value).indexOf('.') != -1) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "L": //必须小于指定位数的Text类型				
                {
                    if (document.getElementById(tmpArr[0]).value != "" && LenOf(document.getElementById(tmpArr[0]).value) >= tmpArr[3]) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "G": //必须大于指定位数的Text类型				
                {
                    if (document.getElementById(tmpArr[0]).value != "" && LenOf(document.getElementById(tmpArr[0]).value) <= tmpArr[3]) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "EQ": //必须等于指定位数的Text类型				
                {
                    if (document.getElementById(tmpArr[0]).value != "" && LenOf(document.getElementById(tmpArr[0]).value) != tmpArr[3]) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "E": //必须为Email的Text类型
                {
                    var s = document.getElementById(tmpArr[0]).value;
                    if (s.length > 100) {
                        window.alert(tmpArr[2] || "Email地址长度不能超过100位!");
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }

                    var regu = "^(([0-9a-zA-Z]+)|([0-9a-zA-Z]+[_.0-9a-zA-Z-]*[0-9a-zA-Z]+))@([a-zA-Z0-9-]+[.])+([a-zA-Z]{2}|net|com|gov|mil|org|edu|int)$";
                    var re = new RegExp(regu);
                    if (s.search(re) != -1 || document.getElementById(tmpArr[0]).value == '') {
                        return true;
                    }
                    else {
                        window.alert(tmpArr[2] || "请输入有效合法的E-mail地址！");
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "W": //必须为a-z或0-9的字符的Text类型
                {
                    var pwdReg = /[0-9a-zA-Z]$/;
                    if ((!pwdReg.test(document.getElementById(tmpArr[0]).value)) && (document.getElementById(tmpArr[0]).value != '')) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "=": //判断两个Text值相同。如确认密码和密码必须相等的Text类型
                {
                    if ((document.getElementById(tmpArr[0]).value) != (document.getElementById(tmpArr[3]).value)) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "<>": //判断两个Text值不相同				
                {
                    if ((document.getElementById(tmpArr[0]).value) == (document.getElementById(tmpArr[3]).value)) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[3]).select();
                        document.getElementById(tmpArr[3]).focus();
                        return false;
                    }
                    break;
                }
            case "D": //确认合法日期				
                {
                    var YearStr = "", DateStr = "";
                    tmpArray = tmpArr[0].split('-');
                    for (var j = 0; j < tmpArray.length; j++) {
                        if (j == 0) {
                            if (isNaN(tmpArray[0])) {
                                DateStr = Trim(document.getElementById(tmpArray[0]).value);
                            }
                            else {
                                DateStr = Trim(tmpArray[j]);
                            }
                            YearStr = DateStr;
                        }
                        else {
                            if (isNaN(tmpArray[j])) {
                                DateStr = DateStr + "-" + Trim(document.getElementById(tmpArray[j]).value);
                            }
                            else {
                                DateStr = DateStr + "-" + Trim(tmpArray[j]);
                            }
                        }
                    }
                    if (DateStr != "" && !IsDate(DateStr) && YearStr != "") {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "T": //确认合法时间				
                {
                    var DateStr = document.getElementById(tmpArr[0]).value;
                    if (DateStr != "" && !IsTime(DateStr)) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "DT": //确认合法日期或时间				
                {
                    var DateStr = document.getElementById(tmpArr[0]).value;
                    if (DateStr != "" && !IsDateTime(DateStr) && !IsDate(DateStr) && !IsTime(DateStr)) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case ">": //第一个值必须大于第二个值
                {
                    if (document.getElementById(tmpArr[0]).value != "" && parseInt(Trim(document.getElementById(tmpArr[0]).value)) <= parseInt(Trim(document.getElementById(tmpArr[3]).value))) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "<=": //第一个值必须小于第二个值
                {
                    if (document.getElementById(tmpArr[0]).value != "" && parseInt(Trim(document.getElementById(tmpArr[0]).value)) > parseInt(Trim(document.getElementById(tmpArr[3]).value))) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }

            case "B": //与固定数值比较大小
                {
                    switch (tmpArr[4]) {
                        case ">":
                            if (document.getElementById(tmpArr[0]).value != "" && !(parseFloat(Trim(document.getElementById(tmpArr[0]).value)) > parseFloat(Trim(tmpArr[3])))) {
                                window.alert(tmpArr[2]);
                                document.getElementById(tmpArr[0]).select();
                                document.getElementById(tmpArr[0]).focus();
                                return false;
                            }
                            break;
                        case "<":
                            if (document.getElementById(tmpArr[0]).value != "" && !(parseFloat(Trim(document.getElementById(tmpArr[0]).value)) < parseFloat(Trim(tmpArr[3])))) {
                                window.alert(tmpArr[2]);
                                document.getElementById(tmpArr[0]).select();
                                document.getElementById(tmpArr[0]).focus();
                                return false;
                            }
                            break;
                        case ">=":
                            if (document.getElementById(tmpArr[0]).value != "" && !(parseFloat(Trim(document.getElementById(tmpArr[0]).value)) >= parseFloat(Trim(tmpArr[3])))) {
                                window.alert(tmpArr[2]);
                                document.getElementById(tmpArr[0]).select();
                                document.getElementById(tmpArr[0]).focus();
                                return false;
                            }
                            break;
                        case "<=":
                            if (document.getElementById(tmpArr[0]).value != "" && !(parseFloat(Trim(document.getElementById(tmpArr[0]).value)) <= parseFloat(Trim(tmpArr[3])))) {
                                window.alert(tmpArr[2]);
                                document.getElementById(tmpArr[0]).select();
                                document.getElementById(tmpArr[0]).focus();
                                return false;
                            }
                            break;
                    }
                    break;
                }
            case "LD": //判断两个日期的大小，第一个要小于第二个 clt01#clt02|c|提示
                {
                    if ((Trim(document.getElementById(tmpArr[0]).value) < Trim(document.getElementById(tmpArr[3]).value)) && (Trim(document.getElementById(tmpArr[0]).value) != '')) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
            case "P": //限制图片大小		
                {
                    var img = new Image();
                    var ctlId = tmpArr[0];
                    if (!document.getElementById(ctlId)) ctlId += "_uploadedFile";
                    var iFileSize = parseInt(tmpArr[3]);
                    if (document.getElementById(ctlId).value != "") {
                        if ((tmpArr.length > 4 && document.getElementById(ctlId).value.toLowerCase().indexOf("." + tmpArr[4]) == -1) || !(((document.getElementById(ctlId).value.toLowerCase()).indexOf(".gif") > 0) ||
					((document.getElementById(ctlId).value.toLowerCase()).indexOf(".jpg") > 0) ||
					((document.getElementById(ctlId).value.toLowerCase()).indexOf(".jpeg") > 0) ||
					((document.getElementById(ctlId).value.toLowerCase()).indexOf(".bmp") > 0))) {
                            if (tmpArr[2] == "")
                                alert('图片大小不能超过' + iFileSize + 'K！');
                            else
                                window.alert(tmpArr[2]);
                            document.getElementById(ctlId).focus();
                            return false;
                        }
                        else {
                            img.src = document.getElementById(ctlId).value;
                            //fsize=img.fileSize;
                            //fsize=fsize.toFixed(0);
                            if (img.fileSize > iFileSize * 1024) {
                                if (tmpArr[2] == "")
                                    alert('图片大小不能超过' + iFileSize + 'K！');
                                else
                                    window.alert(tmpArr[2]);
                                document.getElementById(ctlId).focus();
                                return false;
                            }
                        }
                    }
                    break;
                }
            case "M": //值必须匹配Reg
                {
                    var s = document.getElementById(tmpArr[0]).value;
                    var regu = document.getElementById(tmpArr[3]).value; //"^(([0-9a-zA-Z)+)|([0-9a-zA-Z]+[_.0-9a-zA-Z-]*[0-9a-zA-Z]+))@([a-zA-Z0-9-]+[.])+([a-zA-Z]{2}|net|com|gov|mil|org|edu|int)$"
                    var re = new RegExp(regu);
                    if (s.search(re) != -1 || document.getElementById(tmpArr[0]).value == '') {
                        return true;
                    }
                    else {
                        window.alert(tmpArr[2]);
                        if (document.getElementById(tmpArr[0]).type != "hidden") {
                            document.getElementById(tmpArr[0]).select();
                            document.getElementById(tmpArr[0]).focus();
                        }
                        else {
                            if (tmpArr.length > 4) {
                                if (document.getElementById(tmpArr[4])) {
                                    document.getElementById(tmpArr[4]).select();
                                    document.getElementById(tmpArr[4]).focus();
                                }
                            }
                        }
                        return false;
                    }
                    break;
                }
            case "NM": //值必须不匹配Reg
                {
                    var s = document.getElementById(tmpArr[0]).value;
                    var regu = tmpArr[3]; //"^(([0-9a-zA-Z]+)|([0-9a-zA-Z]+[_.0-9a-zA-Z-]*[0-9a-zA-Z]+))@([a-zA-Z0-9-]+[.])+([a-zA-Z]{2}|net|com|gov|mil|org|edu|int)$"
                    var re = new RegExp(regu);
                    if (s.search(re) == -1 || document.getElementById(tmpArr[0]).value == '') {
                        return true;
                    }
                    else {
                        window.alert(tmpArr[2]);
                        if (document.getElementById(tmpArr[0]).type != "hidden") {
                            document.getElementById(tmpArr[0]).select();
                            document.getElementById(tmpArr[0]).focus();
                        }
                        else {
                            if (tmpArr.length > 4) {
                                if (document.getElementById(tmpArr[4])) {
                                    document.getElementById(tmpArr[4]).select();
                                    document.getElementById(tmpArr[4]).focus();
                                }
                            }
                        }
                        return false;
                    }
                    break;
                }
            case "R": //不能存在重复值	语法：ctlid1|R|[Edit|]提示1,提示2|TableName|当前记录SqlWhere1,SqlWhere2|Field1,Field2     //TableName为是否访问到服务器验证其它页数据		
                {
                    var bExist = false;
                    var sCtlValue = document.getElementById(tmpArr[0]).value;
                    if (sCtlValue == "") return true;
                    var sFieldName = tmpArr[0].substr(tmpArr[0].indexOf("C_") + 2);
                    //服务器验证
                    if (tmpArr.length == 4) {
                        if (CheckExistRecord_Ajax(tmpArr[3], sFieldName + "='" + sCtlValue + "'" + ((document.getElementById("C_CorpID") == null || tmpArr[3] == "ZZ_Person") ? "" : " and CorpID=" + document.getElementById("C_CorpID").value))) {
                            window.alert(tmpArr[2]);
                            document.getElementById(tmpArr[0]).select();
                            document.getElementById(tmpArr[0]).focus();
                            return false;
                        }
                    }
                    else if (tmpArr.length == 5 && tmpArr[2].toLowerCase() == "edit") {
                        if (CheckExistRecord_Ajax(tmpArr[4], sFieldName + "='" + sCtlValue + "' and " + sFieldName + "<>'" + document.getElementById(tmpArr[0]).defvalue + "'" + ((document.getElementById("C_CorpID") == null || tmpArr[4] == "ZZ_Person") ? "" : " and CorpID=" + document.getElementById("C_CorpID").value))) {
                            window.alert(tmpArr[3]);
                            document.getElementById(tmpArr[0]).select();
                            document.getElementById(tmpArr[0]).focus();
                            return false;
                        }
                    }
                    else if (tmpArr.length >= 5) {
                        var sTable, sArrTip, sArrSql, sArrField;
                        if ((tmpArr[2].toLowerCase() != "edit" && tmpArr.length >= 6) || (tmpArr[2].toLowerCase() == "edit" && tmpArr.length >= 7)) {
                            sArrField = tmpArr[tmpArr.length - 1].split(',');
                            for (n = 0; n < sArrField.length; n++) {
                                tmpArr[tmpArr.length - 4] = tmpArr[tmpArr.length - 4].replace(new RegExp("\\@{" + n + "\\}", "g"), GetQueryDBValue(document.getElementById("C_" + sArrField[n]).value));
                                tmpArr[tmpArr.length - 4] = tmpArr[tmpArr.length - 4].replace(new RegExp("\\{" + n + "\\}", "g"), document.getElementById("C_" + sArrField[n]).value);
                                tmpArr[tmpArr.length - 2] = tmpArr[tmpArr.length - 2].replace(new RegExp("\\@{" + n + "\\}", "g"), GetQueryDBValue(document.getElementById("C_" + sArrField[n]).value));
                                tmpArr[tmpArr.length - 2] = tmpArr[tmpArr.length - 2].replace(new RegExp("\\{" + n + "\\}", "g"), document.getElementById("C_" + sArrField[n]).value);
                            }
                        }
                        if (tmpArr[2].toLowerCase() == "edit") {
                            sArrTip = tmpArr[3].split(',');
                            sArrSql = tmpArr[5].split(',');
                            sTable = tmpArr[4];
                        } else {
                            sArrTip = tmpArr[2].split(',');
                            sArrSql = tmpArr[4].split(',');
                            sTable = tmpArr[3];
                        }
                        for (var k = 0; k < sArrTip.length; k++) {
                            if (CheckExistRecord_Ajax(sTable, sFieldName + "='" + sCtlValue + "'" + (tmpArr[2].toLowerCase() == "edit" ? (" AND " + sFieldName + "<>'" + document.getElementById(tmpArr[0]).defvalue + "'") : "") + " AND " + sArrSql[k])) {
                                window.alert(sArrTip[k]);
                                document.getElementById(tmpArr[0]).select();
                                document.getElementById(tmpArr[0]).focus();
                                return false;
                            }
                        }
                    }
                    break;
                }
            case "AJAX": //Ajax:服务器函数 语法：ctlid|Ajax|提示|Ajax联动函数名
                {
                    if (document.getElementById(tmpArr[0]).value.trim() == "") return true;
                    var sFieldName = tmpArr[0].substr(tmpArr[0].indexOf("C_") + 2);
                    var grid = GetGrid();
                    var nv;
                    var pEl;
                    if (grid.state == 1) {
                        pEl = document.getElementById(grid.objectID + "_NewTable");
                        nv = GetPageData("C_", pEl, false);
                    }
                    else {
                        pEl = document.getElementById(grid.objectID + "_EditTable");
                        nv = GetPageData("C_", pEl, true);
                        if (!nv.containsKey(sFieldName)) return true;
                    }
                    if (!InvokeMethodNV_Ajax(tmpArr[3], nv, [grid.state == 1 ? "" : grid._dataModel.getKeyWhereByRowIndex($("#" + grid.objectID + "_EditSaveSubmit", pEl).get(0).rowIndex)])) {
                        window.alert(tmpArr[2]);
                        document.getElementById(tmpArr[0]).select();
                        document.getElementById(tmpArr[0]).focus();
                        return false;
                    }
                    break;
                }
        }
    } catch (e) { return false; }
    return true;
}