/**
 * $Id: editor_plugin_src.js 520 2008-01-07 16:30:32Z spocke $
 *
 * @author NetDragon
 * @copyright Copyright ?2004-2008, NetDragon Websoft Inc., All rights reserved.
 */

(function() {
	tinynde.create('tinynde.plugins.AdvancedHRPlugin', {
		init : function(ed, url) {
			// Register commands
			ed.addCommand('ndeAdvancedHr', function() {
				ed.windowManager.open({
					file : url + '/rule.htm',
					width : 250 + parseInt(ed.getLang('advhr.delta_width', 0)),
					height : 160 + parseInt(ed.getLang('advhr.delta_height', 0)),
					inline : 1
				}, {
					plugin_url : url
				});
			});

			// Register buttons
			ed.addButton('advhr', {
				title : 'advhr.advhr_desc',
				cmd : 'ndeAdvancedHr'
			});

			ed.onNodeChange.add(function(ed, cm, n) {
				cm.setActive('advhr', n.nodeName == 'HR');
			});

			ed.onClick.add(function(ed, e) {
				e = e.target;

				if (e.nodeName === 'HR')
					ed.selection.select(e);
			});
		},

		getInfo : function() {
			return {
				longname : 'Advanced HR',
				author : 'NetDragon Websoft Inc.',
				authorurl : 'http://www.nd.com.cn',
				infourl : 'http://www.nd.com.cn/index.php/TinyNDE:Plugins/advhr',
				version : tinynde.majorVersion + "." + tinynde.minorVersion
			};
		}
	});

	// Register plugin
	tinynde.PluginManager.add('advhr', tinynde.plugins.AdvancedHRPlugin);
})();