/**
 * $Id: editor_plugin_src.js 520 2008-01-07 16:30:32Z spocke $
 *
 * @author NetDragon
 * @copyright Copyright ?2004-2008, NetDragon Websoft Inc., All rights reserved.
 */

(function() {
	tinynde.create('tinynde.plugins.AutoSavePlugin', {
		init : function(ed, url) {
			var t = this;

			t.editor = ed;

			window.onbeforeunload = tinynde.plugins.AutoSavePlugin._beforeUnloadHandler;
		},

		getInfo : function() {
			return {
				longname : 'Auto save',
				author : 'NetDragon Websoft Inc.',
				authorurl : 'http://www.nd.com.cn',
				infourl : 'http://www.nd.com.cn/index.php/TinyNDE:Plugins/autosave',
				version : tinynde.majorVersion + "." + tinynde.minorVersion
			};
		},

		// Private plugin internal methods

		'static' : {
			_beforeUnloadHandler : function() {
				var msg;

				tinynde.each(tinyNDE.editors, function(ed) {
					if (ed.getParam("fullscreen_is_enabled"))
						return;

					if (ed.isDirty()) {
						msg = ed.getLang("autosave.unload_msg");
						return false;
					}
				});

				return msg;
			}
		}
	});

	// Register plugin
	tinynde.PluginManager.add('autosave', tinynde.plugins.AutoSavePlugin);
})();