﻿/**
* $Id: editor_plugin_src.js 677 2008-03-07 13:52:41Z spocke $
*
* @author NetDragon
* @copyright Copyright ?2004-2008, NetDragon Websoft Inc., All rights reserved.
*/

(function() {
    tinynde.create('tinynde.plugins.BlogImagePlugin', {
        init: function(ed, url) {
            // Register commands
            ed.addCommand('ndeBlogImage', function() {
                // Internal image object like a flash placeholder
                if (ed.dom.getAttrib(ed.selection.getNode(), 'class').indexOf('ndeItem') != -1)
                    return;
                var isImg = ed.selection.getNode().nodeName == 'IMG';
                ed.windowManager.open({
                    file: (isImg ? url.replace("plugins/blogimage", "themes/advanced") : url) + '/image.htm',
                    width: (isImg ? 355 : 480) + parseInt(ed.getLang('blogimage.delta_width', 0)),
                    height: (isImg ? 275 : 385) + parseInt(ed.getLang('blogimage.delta_height', 0)),
                    inline: 1
                }, {
                    plugin_url: (ed.selection.getNode().nodeName == 'IMG' ? url.replace("plugins/blogimage", "themes/advanced") : url)
                });
            });

            // Register buttons
            ed.addButton('image', {
                title: 'blogimage.image_desc',
                cmd: 'ndeBlogImage'
            });
        },

        getInfo: function() {
            return {
                longname: 'Blog image',
                author: 'NetDragon Websoft Inc.',
                authorurl: 'http://www.nd.com.cn',
                infourl: 'http://www.nd.com.cn/index.php/TinyNDE:Plugins/blogimage',
                version: tinynde.majorVersion + "." + tinynde.minorVersion
            };
        }
    });

    // Register plugin
    tinynde.PluginManager.add('blogimage', tinynde.plugins.BlogImagePlugin);
})();