/**
 * $Id: editor_plugin_src.js 520 2008-01-07 16:30:32Z spocke $
 *
 * @author NetDragon
 * @copyright Copyright ?2004-2008, NetDragon Websoft Inc., All rights reserved.
 */

(function() {
	tinynde.create('tinynde.plugins.EmotionsPlugin', {
		init : function(ed, url) {
			// Register commands
			ed.addCommand('ndeEmotion', function() {
				ed.windowManager.open({
					file : url + '/emotions.htm',
					width : 250 + parseInt(ed.getLang('emotions.delta_width', 0)),
					height : 160 + parseInt(ed.getLang('emotions.delta_height', 0)),
					inline : 1
				}, {
					plugin_url : url
				});
			});

			// Register buttons
			ed.addButton('emotions', {title : 'emotions.emotions_desc', cmd : 'ndeEmotion'});
		},

		getInfo : function() {
			return {
				longname : 'Emotions',
				author : 'NetDragon Websoft Inc.',
				authorurl : 'http://www.nd.com.cn',
				infourl : 'http://www.nd.com.cn/index.php/TinyNDE:Plugins/emotions',
				version : tinynde.majorVersion + "." + tinynde.minorVersion
			};
		}
	});

	// Register plugin
	tinynde.PluginManager.add('emotions', tinynde.plugins.EmotionsPlugin);
})();