/**
 * $Id: editor_plugin_src.js 766 2008-04-03 20:37:06Z spocke $
 *
 * @author NetDragon
 * @copyright Copyright ?2004-2008, NetDragon Websoft Inc., All rights reserved.
 */

(function() {
	var DOM = tinynde.DOM;

	tinynde.create('tinynde.plugins.FullScreenPlugin', {
		init : function(ed, url) {
			var t = this, s = {}, vp;

			t.editor = ed;

			// Register commands
			ed.addCommand('ndeFullScreen', function() {
				var win, de = DOM.doc.documentElement;

				if (ed.getParam('fullscreen_is_enabled')) {
					if (ed.getParam('fullscreen_new_window'))
						closeFullscreen(); // Call to close in new window
					else {
						DOM.win.setTimeout(function() {
							tinynde.dom.Event.remove(DOM.win, 'resize', t.resizeFunc);
							tinyNDE.get(ed.getParam('fullscreen_editor_id')).setContent(ed.getContent({format : 'raw'}), {format : 'raw'});
							tinyNDE.remove(ed);
							DOM.remove('nde_fullscreen_container');
							de.style.overflow = ed.getParam('fullscreen_html_overflow');
							DOM.setStyle(DOM.doc.body, 'overflow', ed.getParam('fullscreen_overflow'));
							DOM.win.scrollTo(ed.getParam('fullscreen_scrollx'), ed.getParam('fullscreen_scrolly'));
							tinyNDE.settings = tinyNDE.oldSettings; // Restore old settings
						}, 10);
					}

					return;
				}

				if (ed.getParam('fullscreen_new_window')) {
					win = DOM.win.open(url + "/fullscreen.htm", "ndeFullScreenPopup", "fullscreen=yes,menubar=no,toolbar=no,scrollbars=no,resizable=yes,left=0,top=0,width=" + screen.availWidth + ",height=" + screen.availHeight);
					try {
						win.resizeTo(screen.availWidth, screen.availHeight);
					} catch (e) {
						// Ignore
					}
				} else {
					tinyNDE.oldSettings = tinyNDE.settings; // Store old settings
					s.fullscreen_overflow = DOM.getStyle(DOM.doc.body, 'overflow', 1) || 'auto';
					s.fullscreen_html_overflow = DOM.getStyle(de, 'overflow', 1);
					vp = DOM.getViewPort();
					s.fullscreen_scrollx = vp.x;
					s.fullscreen_scrolly = vp.y;

					// Fixes an Opera bug where the scrollbars doesn't reappear
					if (tinynde.isOpera && s.fullscreen_overflow == 'visible')
						s.fullscreen_overflow = 'auto';

					// Fixes an IE bug where horizontal scrollbars would appear
					if (tinynde.isIE && s.fullscreen_overflow == 'scroll')
						s.fullscreen_overflow = 'auto';

					if (s.fullscreen_overflow == '0px')
						s.fullscreen_overflow = '';

					DOM.setStyle(DOM.doc.body, 'overflow', 'hidden');
					de.style.overflow = 'hidden'; //Fix for IE6/7
					vp = DOM.getViewPort();
					DOM.win.scrollTo(0, 0);

					if (tinynde.isIE)
						vp.h -= 1;

					n = DOM.add(DOM.doc.body, 'div', {id : 'nde_fullscreen_container', style : 'position:absolute;top:0;left:0;width:' + vp.w + 'px;height:' + vp.h + 'px;z-index:200000;'});
					DOM.add(n, 'div', {id : 'nde_fullscreen'});

					tinynde.each(ed.settings, function(v, n) {
						s[n] = v;
					});

					s.id = 'nde_fullscreen';
					s.width = n.clientWidth;
					s.height = n.clientHeight - 15;
					s.fullscreen_is_enabled = true;
					s.fullscreen_editor_id = ed.id;
					s.theme_advanced_resizing = false;
					s.save_onsavecallback = function() {
						ed.setContent(tinyNDE.get(s.id).getContent({format : 'raw'}), {format : 'raw'});
						ed.execCommand('ndeSave');
					};

					tinynde.each(ed.getParam('fullscreen_settings'), function(v, k) {
						s[k] = v;
					});

					if (s.theme_advanced_toolbar_location === 'external')
						s.theme_advanced_toolbar_location = 'top';

					t.fullscreenEditor = new tinynde.Editor('nde_fullscreen', s);
					t.fullscreenEditor.onInit.add(function() {
						t.fullscreenEditor.setContent(ed.getContent());
						t.fullscreenEditor.focus();
					});

					t.fullscreenEditor.render();
					tinyNDE.add(t.fullscreenEditor);

					t.fullscreenElement = new tinynde.dom.Element('nde_fullscreen_container');
					t.fullscreenElement.update();
					//document.body.overflow = 'hidden';

					t.resizeFunc = tinynde.dom.Event.add(DOM.win, 'resize', function() {
						var vp = tinynde.DOM.getViewPort();

						t.fullscreenEditor.theme.resizeTo(vp.w, vp.h);
					});
				}
			});

			// Register buttons
			ed.addButton('fullscreen', {title : 'fullscreen.desc', cmd : 'ndeFullScreen'});

			ed.onNodeChange.add(function(ed, cm) {
				cm.setActive('fullscreen', ed.getParam('fullscreen_is_enabled'));
			});
		},

		getInfo : function() {
			return {
				longname : 'Fullscreen',
				author : 'NetDragon Websoft Inc.',
				authorurl : 'http://www.nd.com.cn',
				infourl : 'http://www.nd.com.cn/index.php/TinyNDE:Plugins/fullscreen',
				version : tinynde.majorVersion + "." + tinynde.minorVersion
			};
		}
	});

	// Register plugin
	tinynde.PluginManager.add('fullscreen', tinynde.plugins.FullScreenPlugin);
})();