/**
 * $Id: editor_plugin_src.js 201 2007-02-12 15:56:56Z spocke $
 *
 * @author NetDragon
 * @copyright Copyright ?2004-2008, NetDragon Websoft Inc., All rights reserved.
 */

(function() {
	tinynde.create('tinynde.plugins.Nonbreaking', {
		init : function(ed, url) {
			var t = this;

			t.editor = ed;

			// Register commands
			ed.addCommand('ndeNonBreaking', function() {
				ed.execCommand('ndeInsertContent', false, (ed.plugins.visualchars && ed.plugins.visualchars.state) ? '<span class="ndeItemHidden ndeVisualNbsp">&middot;</span>' : '&nbsp;');
			});

			// Register buttons
			ed.addButton('nonbreaking', {title : 'nonbreaking.nonbreaking_desc', cmd : 'ndeNonBreaking'});

			if (ed.getParam('nonbreaking_force_tab')) {
				ed.onKeyDown.add(function(ed, e) {
					if (tinynde.isIE && e.keyCode == 9) {
						ed.execCommand('ndeNonBreaking');
						ed.execCommand('ndeNonBreaking');
						ed.execCommand('ndeNonBreaking');
						tinynde.dom.Event.cancel(e);
					}
				});
			}
		},

		getInfo : function() {
			return {
				longname : 'Nonbreaking space',
				author : 'NetDragon Websoft Inc.',
				authorurl : 'http://www.nd.com.cn',
				infourl : 'http://www.nd.com.cn/index.php/TinyNDE:Plugins/nonbreaking',
				version : tinynde.majorVersion + "." + tinynde.minorVersion
			};
		}

		// Private methods
	});

	// Register plugin
	tinynde.PluginManager.add('nonbreaking', tinynde.plugins.Nonbreaking);
})();