/**
 * $Id: editor_plugin_src.js 686 2008-03-09 18:13:49Z spocke $
 *
 * @author NetDragon
 * @copyright Copyright ?2004-2008, NetDragon Websoft Inc., All rights reserved.
 */

(function() {
	tinynde.create('tinynde.plugins.SearchReplacePlugin', {
		init : function(ed, url) {
			function open(m) {
				ed.windowManager.open({
					file : url + '/searchreplace.htm',
					width : 420 + parseInt(ed.getLang('searchreplace.delta_width', 0)),
					height : 160 + parseInt(ed.getLang('searchreplace.delta_height', 0)),
					inline : 1,
					auto_focus : 0
				}, {
					mode : m,
					search_string : ed.selection.getContent({format : 'text'}),
					plugin_url : url
				});
			};

			// Register commands
			ed.addCommand('ndeSearch', function() {
				open('search');
			});

			ed.addCommand('ndeReplace', function() {
				open('replace');
			});

			// Register buttons
			ed.addButton('search', {title : 'searchreplace.search_desc', cmd : 'ndeSearch'});
			ed.addButton('replace', {title : 'searchreplace.replace_desc', cmd : 'ndeReplace'});

			ed.addShortcut('ctrl+f', 'searchreplace.search_desc', 'ndeSearch');
		},

		getInfo : function() {
			return {
				longname : 'Search/Replace',
				author : 'NetDragon Websoft Inc.',
				authorurl : 'http://www.nd.com.cn',
				infourl : 'http://www.nd.com.cn/index.php/TinyNDE:Plugins/searchreplace',
				version : tinynde.majorVersion + "." + tinynde.minorVersion
			};
		}
	});

	// Register plugin
	tinynde.PluginManager.add('searchreplace', tinynde.plugins.SearchReplacePlugin);
})();