 /**
 * $Id: editor_plugin_src.js 42 2006-08-08 14:32:24Z spocke $
 *
 * @author NetDragon - based on work by Andrew Tetlaw
 * @copyright Copyright ?2004-2008, NetDragon Websoft Inc., All rights reserved.
 */

function init() {
	SXE.initElementDialog('del');
	if (SXE.currentAction == "update") {
		setFormValue('datetime', tinyNDEPopup.editor.dom.getAttrib(SXE.updateElement, 'datetime'));
		setFormValue('cite', tinyNDEPopup.editor.dom.getAttrib(SXE.updateElement, 'cite'));
		SXE.showRemoveButton();
	}
}

function setElementAttribs(elm) {
	setAllCommonAttribs(elm);
	setAttrib(elm, 'datetime');
	setAttrib(elm, 'cite');
}

function insertDel() {
	var elm = tinyNDEPopup.editor.dom.getParent(SXE.focusElement, 'DEL');

	tinyNDEPopup.execCommand('ndeBeginUndoLevel');
	if (elm == null) {
		var s = SXE.inst.selection.getContent();
		if(s.length > 0) {
			tinyNDEPopup.execCommand('ndeInsertContent', false, '<del id="#sxe_temp_del#">' + s + '</del>');
			var elementArray = tinynde.grep(SXE.inst.dom.select('del'), function(n) {return n.id == '#sxe_temp_del#';});
			for (var i=0; i<elementArray.length; i++) {
				var elm = elementArray[i];
				setElementAttribs(elm);
			}
		}
	} else {
		setElementAttribs(elm);
	}
	tinyNDEPopup.editor.nodeChanged();
	tinyNDEPopup.execCommand('ndeEndUndoLevel');
	tinyNDEPopup.close();
}

function removeDel() {
	SXE.removeElement('del');
	tinyNDEPopup.close();
}

tinyNDEPopup.onInit.add(init);
