 /**
 * $Id: editor_plugin_src.js 42 2006-08-08 14:32:24Z spocke $
 *
 * @author NetDragon - based on work by Andrew Tetlaw
 * @copyright Copyright ?2004-2008, NetDragon Websoft Inc., All rights reserved.
 */

function init() {
	SXE.initElementDialog('ins');
	if (SXE.currentAction == "update") {
		setFormValue('datetime', tinyNDEPopup.editor.dom.getAttrib(SXE.updateElement, 'datetime'));
		setFormValue('cite', tinyNDEPopup.editor.dom.getAttrib(SXE.updateElement, 'cite'));
		SXE.showRemoveButton();
	}
}

function setElementAttribs(elm) {
	setAllCommonAttribs(elm);
	setAttrib(elm, 'datetime');
	setAttrib(elm, 'cite');
}

function insertIns() {
	var elm = tinyNDEPopup.editor.dom.getParent(SXE.focusElement, 'INS');
	tinyNDEPopup.execCommand('ndeBeginUndoLevel');
	if (elm == null) {
		var s = SXE.inst.selection.getContent();
		if(s.length > 0) {
			tinyNDEPopup.execCommand('ndeInsertContent', false, '<ins id="#sxe_temp_ins#">' + s + '</ins>');
			var elementArray = tinynde.grep(SXE.inst.dom.select('ins'), function(n) {return n.id == '#sxe_temp_ins#';});
			for (var i=0; i<elementArray.length; i++) {
				var elm = elementArray[i];
				setElementAttribs(elm);
			}
		}
	} else {
		setElementAttribs(elm);
	}
	tinyNDEPopup.editor.nodeChanged();
	tinyNDEPopup.execCommand('ndeEndUndoLevel');
	tinyNDEPopup.close();
}

function removeIns() {
	SXE.removeElement('ins');
	tinyNDEPopup.close();
}

tinyNDEPopup.onInit.add(init);
