tinyNDEPopup.requireLangPack();

var LinkDialog = {
	preInit : function() {
		var url;

		if (url = tinyNDEPopup.getParam("external_link_list_url"))
			document.write('<script language="javascript" type="text/javascript" src="' + tinyNDEPopup.editor.documentBaseURI.toAbsolute(url) + '"></script>');
	},

	init : function() {
		var f = document.forms[0], ed = tinyNDEPopup.editor;

		// Setup browse button
		document.getElementById('hrefbrowsercontainer').innerHTML = getBrowserHTML('hrefbrowser', 'href', 'file', 'theme_advanced_link');
		if (isVisible('hrefbrowser'))
			document.getElementById('href').style.width = '180px';

		this.fillClassList('class_list');
		this.fillFileList('link_list', 'tinyNDELinkList');
		this.fillTargetList('target_list');

		if (e = ed.dom.getParent(ed.selection.getNode(), 'A')) {
			f.href.value = ed.dom.getAttrib(e, 'href');
			f.linktitle.value = ed.dom.getAttrib(e, 'title');
			f.insert.value = ed.getLang('update');
			selectByValue(f, 'link_list', f.href.value);
			selectByValue(f, 'target_list', ed.dom.getAttrib(e, 'target'));
			selectByValue(f, 'class_list', ed.dom.getAttrib(e, 'class'));
		}
	},

	update : function() {
		var f = document.forms[0], ed = tinyNDEPopup.editor, e, b;

		tinyNDEPopup.restoreSelection();
		e = ed.dom.getParent(ed.selection.getNode(), 'A');

		// Remove element if there is no href
		if (!f.href.value) {
			if (e) {
				tinyNDEPopup.execCommand("ndeBeginUndoLevel");
				b = ed.selection.getBookmark();
				ed.dom.remove(e, 1);
				ed.selection.moveToBookmark(b);
				tinyNDEPopup.execCommand("ndeEndUndoLevel");
				tinyNDEPopup.close();
				return;
			}
		}

		tinyNDEPopup.execCommand("ndeBeginUndoLevel");

		// Create new anchor elements
		if (e == null) {
			tinyNDEPopup.execCommand("CreateLink", false, "#nde_temp_url#", {skip_undo : 1});

			tinynde.each(ed.dom.select("a"), function(n) {
				if (ed.dom.getAttrib(n, 'href') == '#nde_temp_url#') {
					e = n;

					ed.dom.setAttribs(e, {
						href : f.href.value,
						title : f.linktitle.value,
						target : f.target_list ? f.target_list.options[f.target_list.selectedIndex].value : null,
						'class' : f.class_list ? f.class_list.options[f.class_list.selectedIndex].value : null
					});
				}
			});
		} else {
			ed.dom.setAttribs(e, {
				href : f.href.value,
				title : f.linktitle.value,
				target : f.target_list ? f.target_list.options[f.target_list.selectedIndex].value : null,
				'class' : f.class_list ? f.class_list.options[f.class_list.selectedIndex].value : null
			});
		}

		// Don't move caret if selection was image
		if (e.childNodes.length != 1 || e.firstChild.nodeName != 'IMG') {
			ed.focus();
			ed.selection.select(e);
			ed.selection.collapse(0);
			tinyNDEPopup.storeSelection();
		}

		tinyNDEPopup.execCommand("ndeEndUndoLevel");
		tinyNDEPopup.close();
	},

	checkPrefix : function(n) {
		if (n.value && Validator.isEmail(n) && !/^\s*mailto:/i.test(n.value) && confirm(tinyNDEPopup.getLang('advanced_dlg.link_is_email')))
			n.value = 'mailto:' + n.value;

		if (/^\s*www./i.test(n.value) && confirm(tinyNDEPopup.getLang('advanced_dlg.link_is_external')))
			n.value = 'http://' + n.value;
	},

	fillFileList : function(id, l) {
		var dom = tinyNDEPopup.dom, lst = dom.get(id), v, cl;

		l = window[l];

		if (l && l.length > 0) {
			lst.options[lst.options.length] = new Option('', '');

			tinynde.each(l, function(o) {
				lst.options[lst.options.length] = new Option(o[0], o[1]);
			});
		} else
			dom.remove(dom.getParent(id, 'tr'));
	},

	fillClassList : function(id) {
		var dom = tinyNDEPopup.dom, lst = dom.get(id), v, cl;

		if (v = tinyNDEPopup.getParam('theme_advanced_styles')) {
			cl = [];

			tinynde.each(v.split(';'), function(v) {
				var p = v.split('=');

				cl.push({'title' : p[0], 'class' : p[1]});
			});
		} else
			cl = tinyNDEPopup.editor.dom.getClasses();

		if (cl.length > 0) {
			lst.options[lst.options.length] = new Option(tinyNDEPopup.getLang('not_set'), '');

			tinynde.each(cl, function(o) {
				lst.options[lst.options.length] = new Option(o.title || o['class'], o['class']);
			});
		} else
			dom.remove(dom.getParent(id, 'tr'));
	},

	fillTargetList : function(id) {
		var dom = tinyNDEPopup.dom, lst = dom.get(id), v;

		lst.options[lst.options.length] = new Option(tinyNDEPopup.getLang('not_set'), '');
		lst.options[lst.options.length] = new Option(tinyNDEPopup.getLang('advanced_dlg.link_target_same'), '_self');
		lst.options[lst.options.length] = new Option(tinyNDEPopup.getLang('advanced_dlg.link_target_blank'), '_blank');

		if (v = tinyNDEPopup.getParam('theme_advanced_link_targets')) {
			tinynde.each(v.split(','), function(v) {
				v = v.split('=');
				lst.options[lst.options.length] = new Option(v[0], v[1]);
			});
		}
	}
};

LinkDialog.preInit();
tinyNDEPopup.onInit.add(LinkDialog.init, LinkDialog);
