﻿<%@ WebHandler Language="C#" Class="CacheClear" %>

using System;
using System.Web;

public class CacheClear : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        //context.Response.Write("Hello World");
        string action = context.Request.QueryString["act"];
        switch (action)
        {
            case "dept":
                ClearSubSysCache(context,"dept");
                break;
            case "role":
                ClearSubSysCache(context, "role");
                break;
            case "user":
                ClearSubSysCache(context, "user");
                break;
            case "var"://未用
                ClearSubSysCache(context, "var");
                break;
            default:
                break;

        }
        context.Response.End();
    }

    private void ClearSubSysCache(System.Web.HttpContext context,string type)
    {
        try
        {
            int corpID;
            if (string.IsNullOrEmpty(context.Request.QueryString["cid"])) corpID = Nd.Webs.EaLogin.EaUser.Instance.CorpID;
            else corpID = Convert.ToInt32(context.Request.QueryString["cid"]);
            
            bool bFromBiz = false;//是否来自业务域名
            if (context.Request.QueryString["from"] == "biz")
            {
                bFromBiz = true;
                switch (type)
                {
                    case "dept":
                        Nd.Webs.WebAdmin.OrganManager._ClearCache_Dept(corpID);
                        break;
                    case "role":
                        Nd.Webs.WebAdmin.OrganManager._ClearCache_Role(corpID);
                        break;
                    case "user":
                        Nd.Webs.WebAdmin.OrganManager._ClearCache_User(corpID);
                        break;
                    case "var":
                        Nd.Webs.FrameWork.Utility.Corp.RemoveCache(corpID, "SYS");
                        break;
                    default:
                        break;
                }
            }
            #region BIZ
            if (!bFromBiz && !Nd.Webs.WebAdmin.SystemRootConfig.GetRootConfigByKey("BIZ").Url.Equals(Nd.Webs.WebAdmin.SystemRootConfig.GetRootConfigByKey("EA").Url))
            {
                EA.BIZ.WS.CacheClear BIZ = new EA.BIZ.WS.CacheClear();
                BIZ.Url = Nd.Webs.WebAdmin.SystemRootConfig.GetRootConfigByKey("BIZ").Url + "/sys/ws/CacheClear.asmx";
                switch (type)
                {
                    case "dept":
                        BIZ.ClearDeptCacheAsync(corpID);
                        break;
                    case "role":
                        BIZ.ClearRoleCacheAsync(corpID);
                        break;
                    case "user":
                        BIZ.ClearAllUserCacheAsync(corpID);
                        break;
                    case "var":
                        BIZ.ClearConfigCacheAsync(corpID);
                        break;
                    default:
                        break;
                }
            }
            #endregion
        }
        catch// (Exception ex)
        {
            //return ex.ToString(); 
        }
        //return string.Empty;
    }
    public bool IsReusable {
        get {
            return false;
        }
    }

}