﻿<%@ WebHandler Language="C#" Class="app" %>

using System;
using System.Web;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using Nd.Webs.WebAdmin;
using Nd.Webs.EaLogin;
using Nd.Webs.FrameWork.Utility;

public class app : IHttpHandler
{

    public void ProcessRequest(HttpContext context)
    {
        context.Response.ContentType = "text/plain";
        //context.Response.Write("Hello World");
        string action = context.Request.QueryString["act"];
        switch (action)
        {
            case "login":
                context.Response.Write(login(context));
                break;
            case "uploadatt":
                context.Response.Write(uploadatt(context));
                break;
            default:
                break;

        }
        context.Response.End();
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }

    private string login(System.Web.HttpContext context)
    {
        string userName = context.Request.QueryString["usr"];
        string password = context.Request.QueryString["pwd"];

        int isPass = 0;
        long userID = 0;
        int corpID = 0;
        string domainName = String.Empty;
        try
        {
            string sql = String.Empty;
            DataRow dr = null;
            if (new System.Text.RegularExpressions.Regex(@"^(\d+)$").IsMatch(userName))
            {
                userID = Convert.ToInt64(userName);
                sql = "SELECT UserID FROM EA_User WHERE UserID=@username AND Password=@pwd";
                SqlParameter[] parameters = {
		                        new SqlParameter("@username", userName),
		                        new SqlParameter("@pwd", MUI.Components.ClassLib.StrLib.Encrypt_MD5(password))
                                                    };
                dr = MUI.Components.Database.StaticSqlDbOperator.ExecSqlForDataRow(Common.EACommonConnStr, sql, parameters);
                if (dr != null)
                {
                    isPass = 1;
                    corpID = 0;
                }
            }
            else
            {
                sql = "SELECT userid,corpid FROM EAE_User WHERE username=@username AND pwd=@pwd";
                SqlParameter[] parameters = {
		                        new SqlParameter("@username", userName),
		                        new SqlParameter("@pwd", MUI.Components.ClassLib.StrLib.Encrypt_MD5(password))
                                                    };
                dr = MUI.Components.Database.StaticSqlDbOperator.ExecSqlForDataRow(Common.EACommonConnStr, sql, parameters);
                if (dr != null)
                {
                    isPass = 1;
                    userID = Convert.ToInt64(dr["userid"]);
                    corpID = Convert.ToInt32(dr["corpid"]);

                }
                else
                {
                    sql = "SELECT userid,corpid FROM EAE_User WHERE username=@username";
                    SqlParameter[] parameters2 = {
		                        new SqlParameter("@username", userName)
                                                };
                    dr = MUI.Components.Database.StaticSqlDbOperator.ExecSqlForDataRow(Common.EACommonConnStr, sql, parameters2);
                    if (dr == null) isPass = 2;//账号错误
                    else isPass = 3;//密码错误
                }
            }
        }
        catch// (Exception ex)
        {
            isPass = 4;
        }
        if (isPass == 1)
        {
            domainName = MUI.Components.Database.StaticSqlDbOperator.ExecuteScalarForNotNull(Common.EACommonConnStr
                , string.Format("SELECT dn FROM EAE_DNServer WHERE id IN(SELECT dnserver FROM EAE_CorpConfig WHERE corpid={0})", corpID));
        }
        return string.Format("{{\"result\":\"{0}\",\"userid\":\"{1}\",\"corpid\":\"{2}\",\"dn\":\"{3}\"}}", isPass, userID, corpID, domainName);
    }

    private string uploadatt(System.Web.HttpContext context)
    {
        HttpFileCollection files = context.Request.Files;
        if (files.Count == 0) return "no file!";
        HttpPostedFile postedFile = files[0];
        int fileSize = postedFile.ContentLength;
        if (fileSize <= 0) return "no file!";
        decimal fileSize_kb = Math.Round(Convert.ToDecimal(fileSize * 1.0 / 1024), 2);
        string corpID = context.Request.QueryString["cid"];
        string userID = context.Request.QueryString["uid"];
        string gcs = context.Request.QueryString["uname"];
        string gdh = context.Request.QueryString["gdh"];
        string user = context.Request.QueryString["user"];//用户
        string user_mac = context.Request.QueryString["user_mac"];//用户机器
        string att_type = context.Request.QueryString["att_type"];//附件类型
        string att_name = context.Request.QueryString["att_name"];//附件名称

        string url = "";
        try
        {
            string fileName = System.IO.Path.GetFileName(postedFile.FileName);
            string saveDir_rel = string.Format("/upload/{0}/user/{1}", corpID, userID);
            url = string.Format("http://{0}{1}/{2}", context.Request.Url.Authority, saveDir_rel, fileName);
            string saveDir = context.Server.MapPath(saveDir_rel);
            if (!System.IO.Directory.Exists(saveDir)) System.IO.Directory.CreateDirectory(saveDir);
            postedFile.SaveAs(string.Concat(saveDir, "\\", fileName));
        }
        catch
        {
            return "上传失败！";
        }
        string sql = "", where = "";
        bool ok = true;
        string ret = "";
        MUI.Components.Database.DbOperator objDB = MUI.Components.Database.DbBridge.GetDbOperator(Common.DataSqlConnStr);
        where = string.Format("工单号='{0}' AND 附件类型={1} AND 名称='{2}'", gdh, att_type, att_name);
        if (objDB.CheckExistRecord("SGD_工单附件", where))
        {
            sql = string.Format("UPDATE SGD_工单附件 SET 路径=@路径,大小=@大小,创建人=@创建人,创建时间=@创建时间 WHERE {0}", where);
            SqlParameter[] parameters ={
		                         new SqlParameter("@路径",url)
		                        ,new SqlParameter("@大小",fileSize_kb)
		                        ,new SqlParameter("@创建人",gcs)
		                        ,new SqlParameter("@创建时间",DateTime.Now)
                                    };
            ok = objDB.ExecSqlCommandForAffectRow(sql, parameters) > 0;
        }
        else
        {
            sql = "INSERT INTO SGD_工单附件(附件类型,用户,用户电器,工单号,名称,路径,大小,创建人,创建时间,CorpID,UserID)VALUES(@附件类型,@用户,@用户电器,@工单号,@名称,@路径,@大小,@创建人,@创建时间,@CorpID,@UserID)";
            sql += ";select SCOPE_IDENTITY()";
            SqlParameter[] parameters ={
		                         new SqlParameter("@附件类型",att_type)
		                        ,new SqlParameter("@用户",user)
		                        ,new SqlParameter("@用户电器",user_mac)
		                        ,new SqlParameter("@工单号",gdh)
		                        ,new SqlParameter("@名称",att_name)
		                        ,new SqlParameter("@路径",url)
		                        ,new SqlParameter("@大小",fileSize_kb)
		                        ,new SqlParameter("@创建人",gcs)
		                        ,new SqlParameter("@创建时间",DateTime.Now)
		                        ,new SqlParameter("@CorpID",corpID)
		                        ,new SqlParameter("@UserID",userID)
                                    };
            object r = objDB.ExecuteScalar(sql, parameters);
            if (r == null) ok = false;
            else
            {
                ok = true;
                ret = r.ToString();
            }
        }
        objDB.Dispose();
        if (!ok) 
            return "上传失败！";
        else
            return ret;
    }
}