﻿<%@ WebHandler Language="C#" Class="system" %>

using System;
using System.Web;
using System.Data;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data.SqlClient;
using Nd.Webs.WebAdmin;
using Nd.Webs.EaLogin;
using Nd.Webs.FrameWork.Utility;

public class system : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/plain";
        //context.Response.Write("Hello World");
        string action = context.Request.QueryString["act"];
        switch (action)
        {
            case "getsystemnews":
                context.Response.Write(getsystemnews(context));
                break;
            case "GetMsgTip":
                GetMsgTip(context);
                break;
            case "SetMsgViewed":
                SetMsgViewed(context);
                break;
            case "unload":
                UnloadDefault(context);
                break;
            default:
                break;

        }
        context.Response.End();
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    private string getsystemnews(System.Web.HttpContext context)
    {
        DataTable dt = MUI.Components.Database.StaticSqlDbOperator.ExecSqlForTable(string.Format("SELECT 标题 FROM CO_SystemNews WHERE 公告状态=1 ORDER BY Sort,发布时间 DESC"));
        if (dt == null) 
            return string.Empty;
        List<string> list = new List<string>();
        foreach (DataRow dr in dt.Rows)
        {
            list.Add(dr[0].ToString());
        }        
        //return string.Format("{0}({{result:\"{1}\"}})", context.Request.QueryString["callback"], sRet.Replace("\"", "\\\""));        
        return string.Join("^",list.ToArray());
    }

    private void GetMsgTip(HttpContext context)
    {
        Nd.Webs.EaLogin.EaUser ea=Nd.Webs.EaLogin.EaUser.Instance;
        if (ea.UserID == 0) { context.Response.Write(string.Empty); return; }

        if (ea.State == UserState.离线)
            Nd.Webs.EaLogin.UserHandle.ChangeState(UserState.在线);
        else
            Nd.Webs.EaLogin.UserHandle.ChangeUserUpdateTime();

        List<string> myGroups = Nd.Webs.FrameWork.Business.BizUserGroup.GetGroupsOfUser(ea.UserID);
        List<string> list_role = new List<string>();
        foreach (string g in myGroups)
        {
            list_role.Add(string.Format("CHARINDEX('{0}',Roles)>0", g));
        }
        StringBuilder sb = new StringBuilder();
        string msgids = context.Request.Form["msgids"];
        //string sql = string.Format("SELECT ID,[Type],SType,Title,Detail,Url,Rectime FROM CO_MsgTip WHERE [Enabled]=1{1} AND ((UserID={0} AND Viewed=0) OR (UserID IS NULL AND CHARINDEX('{0}',Persons)>0 AND (SELECT 1 FROM CO_MsgTipRead WHERE ID=CO_MsgTip.ID AND UserID={0}) IS NULL))", ea.UserID, string.IsNullOrEmpty(msgids) ? "" : string.Format(" AND ID NOT IN({0})", msgids));
        //string sql = string.Format("SELECT ID,[Type],SType,Title,Detail,Url,Rectime FROM CO_MsgTip WHERE CorpID={0} AND [Enabled]=1{2} AND ((UserID={1} AND Viewed=0) OR (Persons IS NOT NULL AND CHARINDEX('{1}',Persons)>0){3}{4}) AND (SELECT 1 FROM CO_MsgTipRead WHERE ID=CO_MsgTip.ID AND UserID={1}) IS NULL"
        string sql = string.Format("SELECT ID,[Type],SType,Title,Detail,Url,Rectime FROM CO_MsgTip WHERE CorpID={0} AND [Enabled]=1{2} AND ((UserID={1} AND Viewed=0) OR (Persons IS NOT NULL AND CHARINDEX('{1}',Persons)>0){3}{4}) AND ID NOT IN(SELECT ID FROM CO_MsgTipRead WHERE ID=CO_MsgTip.ID AND UserID={1})"
            , ea.CorpID
            , ea.UserID
            , string.IsNullOrEmpty(msgids) ? "" : string.Format(" AND ID NOT IN({0})", msgids)
            , list_role.Count == 0 ? "" : string.Format(" OR (Roles IS NOT NULL AND ({0}))", string.Join(" OR ", list_role.ToArray()))  //角色消息提示
            , string.IsNullOrEmpty(ea.DepartmentCode) ? "" : string.Format(" OR (Depts IS NOT NULL AND CHARINDEX('{0}',Depts)>0)", ea.DepartmentCode)//部门消息提示
            );
        DataTable dt = MUI.Components.Database.StaticSqlDbOperator.ExecSqlForTable(Common.DataSqlConnStr, sql);
        //if (dt == null || dt.Rows.Count == 0) { context.Response.Write(string.Empty); return; }
        if (dt != null && dt.Rows.Count > 0)
        {
            System.Collections.Generic.List<string> list = new System.Collections.Generic.List<string>();
            foreach (DataRow dr in dt.Rows)
            {
                if (string.IsNullOrEmpty(dr["SType"].ToString()))
                    dr["SType"] = ((Nd.Webs.WebAdmin.MsgTip.TipType)Convert.ToInt32(dr["Type"])).ToString();
                list.Add(string.Format("'{0}': {{ \"type\": \"{1}\", \"title\": \"{2}\", \"content\": \"{3}\", \"url\": \"{4}\",\"rectime\":\"{5}\", \"isShow\": false }}"
                    , dr["ID"],  dr["SType"], dr["Title"].ToString().Replace("\"", "\\\""), dr["Detail"].ToString().Replace("\n", "</br>").Replace("\"", "\\\""), Nd.Webs.WebAdmin.SystemRootConfig.UrlTrans(dr["Url"].ToString()), Convert.ToDateTime(dr["Rectime"]).ToString("yyyy-MM-dd HH:mm:ss")));
            }
            sb.Append("'msgs':{" + string.Join(",", list.ToArray()) + "}");
        }
        //此处检查即时通讯是否有新消息
        if (context.Request.Form["flash"] != "1")//第一次闪动后不再检查是否有新消息
        {
            try
            {
                string urlRoot = "";
                urlRoot = Common.IMUrl;
                if (string.IsNullOrEmpty(urlRoot)) 
                    urlRoot = Nd.Webs.WebAdmin.SystemRootConfig.GetRootConfigByKey("EA").Url;
                //string ret_im = new System.Net.WebClient().DownloadString(string.Format("{0}/chat/checkstate.ashx?act=checknew", urlRoot));            
                System.Net.WebClient wc = new System.Net.WebClient();
                string ret_im = wc.DownloadString(string.Format("{0}/chat/checkstate.ashx?act=checknew&to={1}", urlRoot,ea.UserID));
                wc.Dispose();
                if (ret_im.Equals("1"))
                {
                    if (sb.Length > 0) sb.Append(",");
                    sb.Append("'im_msg':true");
                }
            }
            catch { }
        }
        if (sb.Length > 0)
            context.Response.Write("({" + sb.ToString() + "})");
        else
            context.Response.Write(string.Empty);
    }
        /// <summary>
        /// 设置消息提示已读
        /// </summary>
        /// <param name="context"></param>
    private void SetMsgViewed(HttpContext context)
    {
        string msgid = context.Request.Form["msgid"];
        string sql = string.Format("IF EXISTS(SELECT 1 FROM CO_MsgTip WHERE UserID IS NOT NULL AND ID={0}) UPDATE CO_MsgTip SET Viewed=1 WHERE ID={0}" +
            " ELSE INSERT INTO CO_MsgTipRead(ID,UserID)VALUES({0},{1})", msgid, Nd.Webs.EaLogin.EaUser.Instance.UserID);
        bool ret = MUI.Components.Database.StaticSqlDbOperator.ExecSqlCommand(Common.DataSqlConnStr, sql);
        context.Response.Write(ret.ToString());
    }
    /// <summary>
    /// 主页关闭
    /// </summary>
    /// <param name="context"></param>
    private void UnloadDefault(HttpContext context)
    {
        try
        {
            string urlRoot = "";
            urlRoot = Common.IMUrl;
            if (string.IsNullOrEmpty(urlRoot))
                urlRoot = Nd.Webs.WebAdmin.SystemRootConfig.GetRootConfigByKey("EA").Url;
            //string ret_im = new System.Net.WebClient().DownloadString(string.Format("{0}/chat/checkstate.ashx?act=checknew", urlRoot));            
            System.Net.WebClient wc = new System.Net.WebClient();
            wc.DownloadString(string.Format("{0}/chat/checkstate.ashx?act=cleardata&userid={1}", urlRoot, Nd.Webs.EaLogin.EaUser.Instance.UserID));
            wc.Dispose();
        }
        catch { }
    }
}