﻿/*javascript for Bubble Tooltips by Alessandro Fulciniti
- http://pro.html.it - http://web-graphics.com 

function AddCss()//增加CSS样式
{
	var l=CreateEl("link");
	l.setAttribute("type","text/css");
	l.setAttribute("rel","stylesheet");
	l.setAttribute("href","bt.css");
	l.setAttribute("media","screen");
	document.getElementsByTagName("head")[0].appendChild(l);
}
*/

/*
一般来说，一个元素对应一个提示，使用时调用 showTooltipOnObj(obj,text );
有时候也可以是多个元素对应一个提示，showTooltipOnObj(obj,text, name );
{
    提示的名字/ID，
    提示当前对应的对象ID，
    当前是否已经关闭
    偏移X，
    偏移Y
}
*/
//扩展的
var Bubble={};
/*一些设置*/
Bubble.AlwaysTop=false;
Bubble.TooltipIndex=0;
Bubble.ObjIdIndex=0;
Bubble.Tooltips={};//key:objid,value:{ id: 5, objID:""}
Bubble.showTooltipByID=function(objID,text,name,px,py)//定位
{	
	var el=document.getElementById(objID);
	if(el != null)
	{
	    this.showTooltipOnObj(el,text, name || objID,px,py);//如果指定了name，则就不用objID做name了
	}
}
Bubble.showTooltipOnObj = function(el,text,name,px,py)//定位
{	
    if( el ==null)
    return ;
    
    //私有函数
    function CreateEl(t,c)//创建元素
    {
	    var x=document.createElement(t);
	    x.className=c;
	    x.style.display="block";
	    return(x);
    }
    
    function setOpacity(el)//设置透明度
    {
	    el.style.filter="alpha(opacity:95)";
	    el.style.KHTMLOpacity="0.95";
	    el.style.MozOpacity="0.95";
	    el.style.opacity="0.95";
    }
    
    //偏移
    px = px || 0;py = py || 0;
    
	name = name || el.getAttribute("id")+""; //如果没有指定name，就取对象的id

	//alert(name.toString()=="null");
	//name = name || "NoName_"+Bubble.TooltipIndex;//如果对象也没有id，那就给对象指定一个id
	if(name.toString()=="null" || name == null || name==""){ name = "NoName_"+ Bubble.TooltipIndex; el.setAttribute("id",name);}

	var _objID;
	if( el.getAttribute("id")=="")
	    el.setAttribute("id","tipObjId_" + Bubble.ObjIdIndex++ );
	_objID= el.getAttribute("id");
	        
	//位置
	var rect=getOuterRect(el); el=null; //这里需要Positionfunctions.js
	var x=rect.left - px;
	var y=rect.top + rect.height - py;
	
	var tip_id="";//提示的真实的ID，由 name 构造
	if(Bubble.Tooltips[name]!=null)
		tip_id=Bubble.Tooltips[name].tip_id;
	else
	    tip_id="btc_userDefined_" + Bubble.TooltipIndex++;
	    	
	if(!document.getElementById(tip_id))
	{
		Bubble.Tooltips[name]={"id":Bubble.TooltipIndex, "tip_id": tip_id ,"px":px, "py": py, "isShow": true,"nowObjID":_objID};//保存提示的ID
		
		var tooltip;
		tooltip=CreateEl("span","tooltip");
		var span=CreateEl("span","top");
		//span.appendChild(document.createTextNode(text));
		span.innerHTML= text ;
		tooltip.appendChild(span);
		var b=CreateEl("b","bottom");
		tooltip.appendChild(b);
	
		var h=document.createElement("span");
		h.setAttribute("id",tip_id);
		h.setAttribute("name",name);h.setAttribute("nowObj",name);
		h.style.position="absolute";
		document.getElementsByTagName("body")[0].appendChild(h);
		
		setOpacity(tooltip);
		document.getElementById(tip_id).appendChild(tooltip);
		
		tooltip=null;
		
		//Bubble.TooltipIndex;//计数加一
	}
	else //已经存在
	{
	    
	    Bubble.Tooltips[name].nowObjID= _objID;
	    document.getElementById(tip_id).setAttribute("nowObj",_objID);
	}
		
	document.getElementById(tip_id).style.top=(y+5)+"px";
	document.getElementById(tip_id).style.left=(x-10)+"px";
	document.getElementById(tip_id).style.display="block";
	if(this.AlwaysTop)
	    document.getElementById(tip_id).style.zIndex=1000;
	//document.getElementById(tip_id).onclick=function(){this.style.display="none";};
}
Bubble.onWindowResize=function()
{
    var tmp;
	for(var name in Bubble.Tooltips)
	{
	    temp=Bubble.Tooltips[name];
	    if( temp.isShow == false)
	        continue;
		Bubble.showTooltipByID(temp.nowObjID,null,name,temp.px,temp.py);
	}
};

Bubble.Close=function(name)//直接关闭和某个对象关联的提示 ，或者是 提示的ID(多个对象公用的情况)
{
	if(Bubble.Tooltips[name]!=null)
	{
		var tip_id=Bubble.Tooltips[name].tip_id;
		if(document.getElementById(tip_id))
		{
			document.getElementById(tip_id).style.display="none";
			Bubble.Tooltips[name].isShow=false;
		}
	}
}