﻿/**
* WYSIWYG HTML Editor for Internet
* 
* @author Roddy <luolonghao@gmail.com>
* @site http://www.kindsoft.net/
* @licence LGPL(http://www.opensource.org/licenses/lgpl-license.php)
* @version 2.5.5
*/

if(typeof(EaEditor) == "undefined")
{
    EaEditor = {};
}
//定义两个地址用于图片/表情显示
EaEditor.baseImgUrl = "/Lib/EaEditor/icons/";
EaEditor.baseUploadUrl = "/temp/upload/faq/";

EaEditor.KE_VERSION = "2.5.5";
EaEditor.KE_EDITOR_TYPE = "full"; //full or simple
EaEditor.KE_SAFE_MODE = false; // true or false
EaEditor.KE_UPLOAD_MODE = true; // true or false
EaEditor.KE_FONT_FAMILY = "Courier New";
EaEditor.KE_WIDTH = "700px";
EaEditor.KE_HEIGHT = "400px";
EaEditor.KE_SITE_DOMAIN = "";
EaEditor.KE_SKIN_PATH  = "./skins/default/";
EaEditor.KE_ICON_PATH = EaEditor.baseImgUrl;
EaEditor.KE_IMAGE_ATTACH_PATH = "";
EaEditor.KE_IMAGE_UPLOAD_CGI = "";
EaEditor.KE_CSS_PATH = "css.css";
EaEditor.KE_MENU_BORDER_COLOR = '#AAAAAA';
EaEditor.KE_MENU_BG_COLOR = '#EFEFEF';
EaEditor.KE_MENU_TEXT_COLOR = '#222222';
EaEditor.KE_MENU_SELECTED_COLOR = '#CCCCCC';
EaEditor.KE_TOOLBAR_BORDER_COLOR = '#DDDDDD';
EaEditor.KE_TOOLBAR_BG_COLOR = '#EFEFEF';
EaEditor.KE_FORM_BORDER_COLOR = '#DDDDDD';
EaEditor.KE_FORM_BG_COLOR = '#FFFFFF';
EaEditor.KE_BUTTON_COLOR = '#AAAAAA';
EaEditor.KE_LANG = {
	INPUT_URL		: "请输入正确的URL地址。",
	SELECT_IMAGE	: "请选择图片。",
	INVALID_IMAGE	: "只能选择GIF,JPG,PNG,BMP格式的图片，请重新选择。",
	INVALID_FLASH	: "只能选择SWF格式的文件，请重新选择。",
	INVALID_MEDIA	: "只能选择MP3,WAV,WMA,WMV,MID,AVI,MPG,ASF格式的文件，请重新选择。",
	INVALID_REAL	: "只能选择RM,RMVB格式的文件，请重新选择。",
	INVALID_WIDTH	: "宽度不是数字，请重新输入。",
	INVALID_HEIGHT	: "高度不是数字，请重新输入。",
	INVALID_BORDER	: "边框不是数字，请重新输入。",
	INVALID_HSPACE	: "横隔不是数字，请重新输入。",
	INVALID_VSPACE	: "竖隔不是数字，请重新输入。",
	INPUT_CONTENT	: "请输入内容",
	TITLE			: "描述",
	WIDTH			: "宽",
	HEIGHT			: "高",
	BORDER			: "边框",
	ALIGN			: "对齐方式",
	HSPACE			: "左右边界",
	VSPACE			: "上下边界",
	CONFIRM			: "确定",
	CANCEL			: "取消",
	PREVIEW			: "预览",
	LISTENING		: "预览",
	LOCAL			: "本地",
	REMOTE			: "远程",
	NEW_WINDOW		: "新窗口",
	CURRENT_WINDOW	: "当前窗口",
	TARGET			: "目标",
	ABOUT			: "",
	SUBJECT			: "标题"

}
EaEditor.KE_FONT_NAME = Array(
	Array('SimSun', '宋体'), 
	Array('SimHei', '黑体'), 
	Array('FangSong_GB2312', '仿宋体'), 
	Array('KaiTi_GB2312', '楷体'), 
	Array('NSimSun', '新宋体'), 
	Array('Arial', 'Arial'), 
	Array('Arial Black', 'Arial Black'), 
	Array('Times New Roman', 'Times New Roman'), 
	Array('Courier New', 'Courier New'), 
	Array('Tahoma', 'Tahoma'), 
	Array('Verdana', 'Verdana'), 
	Array('GulimChe', 'GulimChe'), 
	Array('MS Gothic', 'MS Gothic') 
);
EaEditor.KE_SPECIAL_CHARACTER = Array(
	'§','№','☆','★','○','●','◎','◇','◆','□','℃','‰','■','△','▲','※',
	'→','←','↑','↓','〓','¤','°','＃','＆','＠','＼','︿','＿','￣','―','α',
	'β','γ','δ','ε','ζ','η','θ','ι','κ','λ','μ','ν','ξ','ο','π','ρ',
	'σ','τ','υ','φ','χ','ψ','ω','≈','≡','≠','＝','≤','≥','＜','＞','≮',
	'≯','∷','±','＋','－','×','÷','／','∫','∮','∝','∞','∧','∨','∑','∏',
	'∪','∩','∈','∵','∴','⊥','∥','∠','⌒','⊙','≌','∽','〖','〗',
	'【','】','（','）','［','］'
);
EaEditor.KE_TOP_TOOLBAR_ICON = Array(
	Array('KE_SOURCE', 'source.gif', '视图转换'),
	Array('KE_PREVIEW', 'preview.gif', '预览'),
	Array('KE_ZOOM', 'zoom.gif', '显示比例'),
	Array('KE_PRINT', 'print.gif', '打印'),
	Array('KE_UNDO', 'undo.gif', '回退'),
	Array('KE_REDO', 'redo.gif', '前进'),
	Array('KE_CUT', 'cut.gif', '剪切'),
	Array('KE_COPY', 'copy.gif', '复制'),
	Array('KE_PASTE', 'paste.gif', '粘贴'),
	Array('KE_SELECTALL', 'selectall.gif', '全选'),
	Array('KE_JUSTIFYLEFT', 'justifyleft.gif', '左对齐'),
	Array('KE_JUSTIFYCENTER', 'justifycenter.gif', '居中'),
	Array('KE_JUSTIFYRIGHT', 'justifyright.gif', '右对齐'),
	Array('KE_JUSTIFYFULL', 'justifyfull.gif', '两端对齐'),
	Array('KE_NUMBEREDLIST', 'numberedlist.gif', '编号'),
	Array('KE_UNORDERLIST', 'unorderedlist.gif', '项目符号'),
	Array('KE_INDENT', 'indent.gif', '减少缩进'),
	Array('KE_OUTDENT', 'outdent.gif', '增加缩进'),
	Array('KE_SUBSCRIPT', 'subscript.gif', '下标'),
	Array('KE_SUPERSCRIPT', 'superscript.gif', '上标'),
	Array('KE_DATE', 'date.gif', '日期'),
	Array('KE_TIME', 'time.gif', '时间')
);
EaEditor.KE_BOTTOM_TOOLBAR_ICON = Array(
	//Array('KE_TITLE', 'title.gif', '标题'),
	Array('KE_LINE', 'line.gif', '行距'),
	Array('KE_FONTNAME', 'font.gif', '字体'),
	Array('KE_FONTSIZE', 'fontsize.gif', '文字大小'),
	Array('KE_TEXTCOLOR', 'textcolor.gif', '文字颜色'),
	Array('KE_BGCOLOR', 'bgcolor.gif', '文字背景'),
	Array('KE_BOLD', 'bold.gif', '粗体'),
	Array('KE_ITALIC', 'italic.gif', '斜体'),
	Array('KE_UNDERLINE', 'underline.gif', '下划线'),
	Array('KE_STRIKE', 'strikethrough.gif', '删除线'),
	Array('KE_REMOVE', 'removeformat.gif', '删除格式'),
	Array('KE_IMAGE', 'image.gif', '图片'),
	Array('KE_FLASH', 'flash.gif', 'Flash'),
	Array('KE_MEDIA', 'media.gif', 'Windows Media Player'),
	Array('KE_REAL', 'real.gif', 'Real Player'),
	//Array('KE_LAYER', 'layer.gif', '层'),
	Array('KE_TABLE', 'table.gif', '表格'),
	Array('KE_SPECIALCHAR', 'specialchar.gif', '特殊字符'),
	Array('KE_HR', 'hr.gif', '横线'),
	Array('KE_ICON', 'emoticons.gif', '笑脸'),
	Array('KE_LINK', 'link.gif', '创建超级连接'),
	Array('KE_UNLINK', 'unlink.gif', '删除超级连接'),
	Array('KE_ABOUT', 'about.gif', '关于')
);
EaEditor.KE_SIMPLE_TOOLBAR_ICON = Array(   
	Array('KE_FONTNAME', 'font.gif', '字体'),
	Array('KE_FONTSIZE', 'fontsize.gif', '文字大小'),
	Array('KE_TEXTCOLOR', 'textcolor.gif', '文字颜色'),
	Array('KE_BGCOLOR', 'bgcolor.gif', '文字背景'),
	Array('KE_BOLD', 'bold.gif', '粗体'),
	Array('KE_ITALIC', 'italic.gif', '斜体'),
	Array('KE_UNDERLINE', 'underline.gif', '下划线'),
	Array('KE_JUSTIFYLEFT', 'justifyleft.gif', '左对齐'),
	Array('KE_JUSTIFYCENTER', 'justifycenter.gif', '居中'),
	Array('KE_JUSTIFYRIGHT', 'justifyright.gif', '右对齐'),
	Array('KE_IMAGE', 'image.gif', '图片'),
	Array('KE_LAYER', 'layer.gif', '层'),
	Array('KE_HR', 'hr.gif', '横线'),
	Array('KE_ICON', 'emoticons.gif', '笑脸'),
	Array('KE_LINK', 'link.gif', '创建超级连接'),
	Array('KE_ABOUT', 'about.gif', '关于')
);
EaEditor.KE_TITLE_TABLE = Array(
	Array('H1', EaEditor.KE_LANG['SUBJECT'] + ' 1'), 
	Array('H2', EaEditor.KE_LANG['SUBJECT'] + ' 2'), 
	Array('H3', EaEditor.KE_LANG['SUBJECT'] + ' 3'), 
	Array('H4', EaEditor.KE_LANG['SUBJECT'] + ' 4'), 
	Array('H5', EaEditor.KE_LANG['SUBJECT'] + ' 5'), 
	Array('H6', EaEditor.KE_LANG['SUBJECT'] + ' 6')
);

//////////新

EaEditor.KE_LINE_TABLE = Array(
	Array('', '默认行距'), 
	Array('1.5', '1.5倍行距'), 
	Array('2', '2倍行距'), 
	Array('2.5','2.5倍行距'), 
	Array('3', '3倍行距'), 
	Array('3.5', '3.5倍行距')
);



EaEditor.KE_ZOOM_TABLE = Array('250%', '200%', '150%', '120%', '100%', '80%', '50%');
EaEditor.KE_FONT_SIZE = Array(
	Array('9px'), 
	Array('10px'), 
	Array('11px'), 
	Array('12px'), 
	Array('13px'), 
	Array('14px'),	
	Array('16px'), 
	Array('18px'), 
	Array('20px'),
	Array('28px'),
	Array('36px')
);


EaEditor.KE_POPUP_MENU_TABLE = Array(
	"KE_ZOOM", "KE_TITLE", "KE_FONTNAME", "KE_FONTSIZE", "KE_TEXTCOLOR", "KE_BGCOLOR", 
	"KE_LAYER", "KE_TABLE", "KE_HR", "KE_ICON", "KE_SPECIALCHAR", "KE_ABOUT", 
	"KE_IMAGE", "KE_FLASH", "KE_MEDIA", "KE_REAL", "KE_LINK","KE_LINE"
);
EaEditor.KE_COLOR_TABLE = Array(
	"#FF0000", "#FFFF00", "#00FF00", "#00FFFF", "#0000FF", "#FF00FF", "#FFFFFF", "#F5F5F5", "#DCDCDC", "#FFFAFA",
	"#D3D3D3", "#C0C0C0", "#A9A9A9", "#808080", "#696969", "#000000", "#2F4F4F", "#708090", "#778899", "#4682B4",
	"#4169E1", "#6495ED", "#B0C4DE", "#7B68EE", "#6A5ACD", "#483D8B", "#191970", "#000080", "#00008B", "#0000CD",
	"#1E90FF", "#00BFFF", "#87CEFA", "#87CEEB", "#ADD8E6", "#B0E0E6", "#F0FFFF", "#E0FFFF", "#AFEEEE", "#00CED1",
	"#5F9EA0", "#48D1CC", "#00FFFF", "#40E0D0", "#20B2AA", "#008B8B", "#008080", "#7FFFD4", "#66CDAA", "#8FBC8F",
	"#3CB371", "#2E8B57", "#006400", "#008000", "#228B22", "#32CD32", "#00FF00", "#7FFF00", "#7CFC00", "#ADFF2F",
	"#98FB98", "#90EE90", "#00FF7F", "#00FA9A", "#556B2F", "#6B8E23", "#808000", "#BDB76B", "#B8860B", "#DAA520",
	"#FFD700", "#F0E68C", "#EEE8AA", "#FFEBCD", "#FFE4B5", "#F5DEB3", "#FFDEAD", "#DEB887", "#D2B48C", "#BC8F8F",
	"#A0522D", "#8B4513", "#D2691E", "#CD853F", "#F4A460", "#8B0000", "#800000", "#A52A2A", "#B22222", "#CD5C5C",
	"#F08080", "#FA8072", "#E9967A", "#FFA07A", "#FF7F50", "#FF6347", "#FF8C00", "#FFA500", "#FF4500", "#DC143C",
	"#FF0000", "#FF1493", "#FF00FF", "#FF69B4", "#FFB6C1", "#FFC0CB", "#DB7093", "#C71585", "#800080", "#8B008B",
	"#9370DB", "#8A2BE2", "#4B0082", "#9400D3", "#9932CC", "#BA55D3", "#DA70D6", "#EE82EE", "#DDA0DD", "#D8BFD8",
	"#E6E6FA", "#F8F8FF", "#F0F8FF", "#F5FFFA", "#F0FFF0", "#FAFAD2", "#FFFACD", "#FFF8DC", "#FFFFE0", "#FFFFF0",
	"#FFFAF0", "#FAF0E6", "#FDF5E6", "#FAEBD7", "#FFE4C4", "#FFDAB9", "#FFEFD5", "#FFF5EE", "#FFF0F5", "#FFE4E1"
);
EaEditor.KE_IMAGE_ALIGN_TABLE = Array(
	"baseline", "top", "middle", "bottom", "texttop", "absmiddle", "absbottom", "left", "right"
);

EaEditor.KE_IMAGE_ALIGN_TABLE_FACE = Array(
	"基线", "顶部", "居中", "底部对齐", "文本顶部", "绝对居中", "绝对底部", "左对齐", "右对齐"
);
EaEditor.KE_OBJ_NAME;
EaEditor.KE_SELECTION;
EaEditor.KE_RANGE;
EaEditor.KE_RANGE_TEXT;
EaEditor.KE_EDITFORM_DOCUMENT;
EaEditor.KE_IMAGE_DOCUMENT;
EaEditor.KE_FLASH_DOCUMENT;
EaEditor.KE_MEDIA_DOCUMENT;
EaEditor.KE_REAL_DOCUMENT;
EaEditor.KE_LINK_DOCUMENT;
EaEditor.KE_BROWSER;
EaEditor.KE_TOOLBAR_ICON;




EaEditor.KindString = function(){
	this.arr = new Array();
	this.append = function(){
	   this.arr.push.apply(this.arr, arguments);
	}
	this.toString = function(){
	   return this.arr.join('');
	}
}
EaEditor.KindGetBrowser = function()
{
	var browser = '';
	var agentInfo = navigator.userAgent.toLowerCase();
	if (agentInfo.indexOf("msie") > -1) {
		var re = new RegExp("msie\\s?([\\d\\.]+)","ig");
		var arr = re.exec(agentInfo);
		if (parseInt(RegExp.$1) >= 5.5) {
			browser = 'IE';
		}
	} else if (agentInfo.indexOf("firefox") > -1) {
		browser = 'FF';
	} else if (agentInfo.indexOf("netscape") > -1) {
		var temp1 = agentInfo.split(' ');
		var temp2 = temp1[temp1.length-1].split('/');
		if (parseInt(temp2[1]) >= 7) {
			browser = 'NS';
		}
	} else if (agentInfo.indexOf("gecko") > -1) {
		browser = 'ML';
	} else if (agentInfo.indexOf("opera") > -1) {
		var temp1 = agentInfo.split(' ');
		var temp2 = temp1[0].split('/');
		if (parseInt(temp2[1]) >= 9) {
			browser = 'OPERA';
		}
	}
	return browser;
}
EaEditor.KindGetFileName = function(file, separator)
{
    if(file == undefined)
    {
        return "0_还没上传"
    }

    if(file.indexOf("undefined")>=0)
    {   
        return "0_还没上传"
    }
    else
    {   
	    var temp = file.split(separator);
	    var len = temp.length;
    	
	    var fileName = temp[len-1];
	    return fileName;
	}
}
EaEditor.KindGetFileExt = function(fileName)
{
    if(fileName.split("_")[0] == "0")
	{
	    return "0";
	}
	else
	{
	    var temp = fileName.split(".");

	    var len = temp.length;
	    if(len==1)
	    {
	      return "sss";
	    }
    	
	        var fileExt = temp[len-1].toLowerCase();

	        return fileExt;
	}
}
EaEditor.KindCheckImageFileType = function(file, separator)
{
	if (separator == "/" && file.match(/http:\/\/.{3,}/) == null) {
		alert(EaEditor.KE_LANG['INPUT_URL']);
		return false;
	}


	
	var fileName = EaEditor.KindGetFileName(file, separator);
	
	var fileExt = EaEditor.KindGetFileExt(fileName);
	if(fileExt == "0")
	{
	    alert("请先上传哦");
	    return false;
	}
	if (file.indexOf(".")<=0)
	{
	    alert(EaEditor.KE_LANG['INPUT_URL']);
		return false;
	}

	if (fileExt != 'gif' && fileExt != 'jpg' && fileExt != 'png' && fileExt != 'bmp') {
		alert(EaEditor.KE_LANG['INVALID_IMAGE']);
		return false;
	}
	return true;
}

EaEditor.KindCheckFlashFileType = function(file, separator)
{
	if (file.match(/http:\/\/.{3,}/) == null) {
		alert(EaEditor.KE_LANG['INPUT_URL']);
		return false;
	}
	if (file.indexOf(".")<=0)
	{
	    alert(EaEditor.KE_LANG['INPUT_URL']);
		return false;
	}
	var fileName = EaEditor.KindGetFileName(file, "/");
	var fileExt = EaEditor.KindGetFileExt(fileName);
	if (fileExt != 'swf') {
		alert(EaEditor.KE_LANG['INVALID_FLASH']);
		return false;
	}
	return true;
}
EaEditor.KindCheckMediaFileType = function(cmd, file, separator)
{
	if (file.match(/http:\/\/.{3,}/) == null) {
		alert(EaEditor.KE_LANG['INPUT_URL']);
		return false;
	}
	if (file.indexOf(".")<=0)
	{
	    alert(EaEditor.KE_LANG['INPUT_URL']);
		return false;
	}
	var fileName = EaEditor.KindGetFileName(file, "/");
	var fileExt = EaEditor.KindGetFileExt(fileName);
	if (cmd == 'KE_REAL') {
		if (fileExt != 'rm' && fileExt != 'rmvb') {
			alert(EaEditor.KE_LANG['INVALID_REAL']);
			return false;
		}
	} else {
		if (fileExt != 'mp3' && fileExt != 'wav' && fileExt != 'wma' && fileExt != 'wmv' && fileExt != 'mid' && fileExt != 'avi' && fileExt != 'mpg' && fileExt != 'asf') {
			alert(EaEditor.KE_LANG['INVALID_MEDIA']);
			return false;
		}
	}
	return true;
}

EaEditor.KindHtmlToXhtml = function(str) 
{

	return str;
}
EaEditor.KindConvertAttribute = function(str)
{
	if (EaEditor.KE_SAFE_MODE == true) {
		str = EaEditor.KindClearAttributeScriptTag(str);
	}
	return str;
}
EaEditor.KindClearAttributeScriptTag = function(str)
{
	var re = new RegExp("(\\son[a-z]+=)[\"']?[^>]*?[^\\\\\>][\"']?([\\s>])","ig");
	str = str.replace(re, function ($0,$1,$2) {
						return($1.toLowerCase() + "\"\"" + $2);
					}
				);
	return str;
}
EaEditor.KindClearScriptTag = function(str)
{
	if (EaEditor.KE_SAFE_MODE == false) {
		return str;
	}
	str = str.replace(/<(script.*?)>/gi, "[$1]");
	str = str.replace(/<\/script>/gi, "[/script]");
	return str;
}
EaEditor.KindHtmlentities = function(str)
{
	str = str.replace(/&/g,'&amp;');
	str = str.replace(/</g,'&lt;');
	str = str.replace(/>/g,'&gt;');
	str = str.replace(/"/g,'&quot;');
	return str;
}
EaEditor.KindGetTop = function(id)
{
	var top = 28;
	var tmp = '';
	var obj = document.getElementById(id);
	while (eval("obj" + tmp).tagName != "BODY") {
		tmp += ".offsetParent";
		top += eval("obj" + tmp).offsetTop;
	}
	return top;
}
EaEditor.KindGetLeft = function(id)
{
	var left = 2;
	var tmp = '';
	var obj = document.getElementById(id);
	while (eval("obj" + tmp).tagName != "BODY") {
		tmp += ".offsetParent";
		left += eval("obj" + tmp).offsetLeft;
	}
	return left;
}
EaEditor.KindDisplayMenu = function(cmd)
{
	KindEditorForm.focus();
	if (cmd != 'KE_ABOUT') {
		EaEditor.KindSelection();
	}
	EaEditor.KindDisableMenu();
	var top, left;
	top = EaEditor.KindGetTop(cmd);
	left = EaEditor.KindGetLeft(cmd);
	if (cmd == 'KE_ABOUT') {
		left -= 200;
	} else if (cmd == 'KE_LINK') {
		left -= 220;
	}
	var str = EaEditor.KindPopupMenu(cmd);
	document.getElementById('menuDiv').style.display = 'none';
	document.getElementById('menuDiv').innerHTML = str;
	document.getElementById('POPUP_'+cmd).style.top =  top.toString(10) + 'px';
	document.getElementById('POPUP_'+cmd).style.left = left.toString(10) + 'px';
	document.getElementById('POPUP_'+cmd).style.display = 'block';
	document.getElementById('menuDiv').style.display = 'block';
}
EaEditor.KindDisableMenu = function()
{
	document.getElementById('menuDiv').innerHTML = '';
	document.getElementById('menuDiv').style.display = 'none';
}
EaEditor.KindGetMenuCommonStyle = function()
{
	var ks = new EaEditor.KindString();
	ks.append('position:absolute;top:1px;left:1px;font-size:12px;color:');
	ks.append(EaEditor.KE_MENU_TEXT_COLOR, ';background-color:', EaEditor.KE_MENU_BG_COLOR);
	ks.append(';border:solid 1px ', EaEditor.KE_MENU_BORDER_COLOR, ';z-index:1;display:none;');
	return ks.toString();
}
EaEditor.KindGetCommonMenu = function(cmd, content)
{
	var ks = new EaEditor.KindString();
	ks.append('<div id="POPUP_', cmd, '" style="', EaEditor.KindGetMenuCommonStyle(), '">');
	ks.append(content, '</div>');
	return ks.toString();
}
EaEditor.KindCreateColorTable = function(cmd, eventStr)
{
	var ks = new EaEditor.KindString();
	ks.append('<table cellpadding="0" cellspacing="2" border="0">');
	for (i = 0; i < EaEditor.KE_COLOR_TABLE.length; i++) {
		if (i == 0 || (i >= 10 && i%10 == 0)) {
			ks.append('<tr>');
		}
		ks.append('<td style="width:12px;height:12px;border:1px solid #AAAAAA;font-size:1px;cursor:pointer;background-color:');
		ks.append(EaEditor.KE_COLOR_TABLE[i], ';" onmouseover="javascript:this.style.borderColor=\'#000000\';');
		ks.append(((eventStr) ? eventStr : ''), '" ');
		ks.append('onmouseout="javascript:this.style.borderColor=\'#AAAAAA\';" '); 
		ks.append('onclick="javascript:EaEditor.KindExecute(\'', cmd, '_END\', \'');
		ks.append(EaEditor.KE_COLOR_TABLE[i], '\');">&nbsp;</td>');
		if (i >= 9 && i%(i-1) == 0) {
			ks.append('</tr>');
		}
	}
	ks.append('</table>');
	return ks.toString();
}
EaEditor.KindDrawColorTable = function(cmd)
{
	var ks = new EaEditor.KindString();
	ks.append('<div id="POPUP_', cmd, '" style="width:160px;padding:2px;');
	ks.append(EaEditor.KindGetMenuCommonStyle(), '">');
	ks.append(EaEditor.KindCreateColorTable(cmd));
	ks.append('</div>');
	return ks.toString();
}
EaEditor.KindDrawMedia = function(cmd)
{
	var ks = new EaEditor.KindString();
	ks.append('<table cellpadding="0" cellspacing="0" style="width:100%;font-size:12px;">');

	ks.append('<tr><td style="width:40px;padding:5px;">', EaEditor.KE_LANG['REMOTE'], '</td>');
	ks.append('<td style="width:210px;padding-bottom:5px;"><input type="text" id="');
	ks.append(cmd, 'link" value="http://" style="width:190px;border:1px solid #555555;" /></td></tr>');
	ks.append('<tr><td colspan="2" style="margin:5px;padding-bottom:5px;" align="center">');
	ks.append('<input type="button" name="button" value="', EaEditor.KE_LANG['LISTENING']);
	ks.append('" onclick="javascript:parent.EaEditor.KindMediaPreview(\'', cmd);
	ks.append('\');" style="border:1px solid #555555;background-color:', EaEditor.KE_BUTTON_COLOR, ';" /> ');
	ks.append('<input type="submit" name="button" id="', cmd, 'submitButton" value="');
	ks.append(EaEditor.KE_LANG['CONFIRM'], '" onclick="javascript:parent.EaEditor.KindDrawMediaEnd(\'');
	ks.append(cmd, '\');" style="border:1px solid #555555;background-color:');
	ks.append(EaEditor.KE_BUTTON_COLOR, ';" /> ', '<input type="button" name="button" value="');
	ks.append(EaEditor.KE_LANG['CANCEL'], '" onclick="javascript:parent.EaEditor.KindDisableMenu();"');
	ks.append('style="border:1px solid #555555;background-color:', EaEditor.KE_BUTTON_COLOR, ';" /></td></tr>');
	ks.append('<tr><td colspan="2"><table border="0"><tr><td id="', cmd);
	ks.append('preview" style="width:240px;height:240px;border:1px solid #AAAAAA;');
	ks.append('background-color:#FFFFFF;" align="center" valign="middle">&nbsp;</td></tr></table></td></tr>');
	ks.append('</table>');
	return ks.toString();
}
EaEditor.KindPopupMenu = function(cmd)
{
	switch (cmd)
	{
		case 'KE_ZOOM':
			var str = '';
			for (i = 0; i < EaEditor.KE_ZOOM_TABLE.length; i++) {
				str += '<div style="padding:2px;width:120px;cursor:pointer;" ' + 
				'onclick="javascript:EaEditor.KindExecute(\'KE_ZOOM_END\', \'' + EaEditor.KE_ZOOM_TABLE[i] + '\');" ' + 
				'onmouseover="javascript:this.style.backgroundColor=\''+EaEditor.KE_MENU_SELECTED_COLOR+'\';" ' +
				'onmouseout="javascript:this.style.backgroundColor=\''+EaEditor.KE_MENU_BG_COLOR+'\';">' + 
				EaEditor.KE_ZOOM_TABLE[i] + '</div>';
			}
			str = EaEditor.KindGetCommonMenu('KE_ZOOM', str);
			return str;
			break;
		case 'KE_TITLE':
			var str = '';
			for (i = 0; i < EaEditor.KE_TITLE_TABLE.length; i++) {
				str += '<div style="width:120px;cursor:pointer;" ' + 
				'onclick="javascript:EaEditor.KindExecute(\'KE_TITLE_END\', \'' + EaEditor.KE_TITLE_TABLE[i][0] + '\');" ' + 
				'onmouseover="javascript:this.style.backgroundColor=\''+EaEditor.KE_MENU_SELECTED_COLOR+'\';" ' +
				'onmouseout="javascript:this.style.backgroundColor=\''+EaEditor.KE_MENU_BG_COLOR+'\';"><' + EaEditor.KE_TITLE_TABLE[i][0] + ' style="margin:2px;">' + 
				EaEditor.KE_TITLE_TABLE[i][1] + '</' + EaEditor.KE_TITLE_TABLE[i][0] + '></div>';
			}
			str = EaEditor.KindGetCommonMenu('KE_TITLE', str);
			return str;
			break;
			
			//新加行距
	    case 'KE_LINE':
			var str = '';
			for (i = 0; i < EaEditor.KE_LINE_TABLE.length; i++) {
				str += '<div style="width:80px;cursor:pointer;" ' + 
				'onclick="javascript:EaEditor.KindExecute(\'KE_LINE_END\', \'' + EaEditor.KE_LINE_TABLE[i][0] + '\');" ' + 
				'onmouseover="javascript:this.style.backgroundColor=\''+EaEditor.KE_MENU_SELECTED_COLOR+'\';" ' +
				'onmouseout="javascript:this.style.backgroundColor=\''+EaEditor.KE_MENU_BG_COLOR+'\';" style="margin:2px;">' + 
				EaEditor.KE_LINE_TABLE[i][1] + '</' + EaEditor.KE_LINE_TABLE[i][0] + '></div>';
			}
			str = EaEditor.KindGetCommonMenu('KE_LINE', str);
			return str;
			break;
			
		case 'KE_FONTNAME':
			var str = '';
			for (i = 0; i < EaEditor.KE_FONT_NAME.length; i++) {
				str += '<div style="font-family:' + EaEditor.KE_FONT_NAME[i][0] + 
				';padding:2px;width:160px;cursor:pointer;" ' + 
				'onclick="javascript:EaEditor.KindExecute(\'KE_FONTNAME_END\', \'' + EaEditor.KE_FONT_NAME[i][0] + '\');" ' + 
				'onmouseover="javascript:this.style.backgroundColor=\''+EaEditor.KE_MENU_SELECTED_COLOR+'\';" ' +
				'onmouseout="javascript:this.style.backgroundColor=\''+EaEditor.KE_MENU_BG_COLOR+'\';">' + 
				EaEditor.KE_FONT_NAME[i][1] + '</div>';
			}
			str = EaEditor.KindGetCommonMenu('KE_FONTNAME', str);
			return str;
			break;
		case 'KE_FONTSIZE':
			var str = '';
			for (i = 0; i < EaEditor.KE_FONT_SIZE.length; i++) {
				str += '<div style="font-size:' + EaEditor.KE_FONT_SIZE[i] + 
				';padding:2px;width:120px;cursor:pointer;" ' + 
				'onclick="javascript:EaEditor.KindExecute(\'KE_FONTSIZE_END\', \'' + EaEditor.KE_FONT_SIZE[i] + '\');" ' + 
				'onmouseover="javascript:this.style.backgroundColor=\''+EaEditor.KE_MENU_SELECTED_COLOR+'\';" ' +
				'onmouseout="javascript:this.style.backgroundColor=\''+EaEditor.KE_MENU_BG_COLOR+'\';">' + 
				EaEditor.KE_FONT_SIZE[i] + '</div>';
			}
			str = EaEditor.KindGetCommonMenu('KE_FONTSIZE', str);
			return str;
			break;
		case 'KE_TEXTCOLOR':
			var str = '';
			str = EaEditor.KindDrawColorTable('KE_TEXTCOLOR');
			return str;
			break;
		case 'KE_BGCOLOR':
			var str = '';
			str = EaEditor.KindDrawColorTable('KE_BGCOLOR');
			return str;
			break;
		case 'KE_HR':
			var str = '';
			str += '<div id="POPUP_'+cmd+'" style="width:160px;'+EaEditor.KindGetMenuCommonStyle()+'">';
			str += '<div id="hrPreview" style="margin:10px 2px 10px 2px;height:1px;border:0;font-size:0;background-color:#FFFFFF;"></div>';
			str += EaEditor.KindCreateColorTable(cmd, 'document.getElementById(\'hrPreview\').style.backgroundColor = this.style.backgroundColor;');
			str += '</div>';
			return str;
			break;
		case 'KE_LAYER':
			var str = '';
			str += '<div id="POPUP_'+cmd+'" style="width:160px;'+EaEditor.KindGetMenuCommonStyle()+'">';
			str += '<div id="divPreview" style="margin:5px 2px 5px 2px;height:20px;border:1px solid #AAAAAA;font-size:1px;background-color:#FFFFFF;"></div>';
			str += EaEditor.KindCreateColorTable(cmd, 'document.getElementById(\'divPreview\').style.backgroundColor = this.style.backgroundColor;');
			str += '</div>';
			return str;
			break;
		case 'KE_ICON':
			var str = '';
			var iconNum = 36;
			str += '<table id="POPUP_'+cmd+'" cellpadding="0" cellspacing="2" style="'+EaEditor.KindGetMenuCommonStyle()+'">';
			for (i = 0; i < iconNum; i++) {
				if (i == 0 || (i >= 6 && i%6 == 0)) {
					str += '<tr>';
				}
				var num;
				if ((i+1).toString(10).length < 2) {
					num = '0' + (i+1);
				} else {
					num = (i+1).toString(10);
				}
				var iconUrl = EaEditor.KE_ICON_PATH + 'etc_' + num + '.gif';
				str += '<td style="padding:2px;border:0;cursor:pointer;" ' + 
				'onclick="javascript:EaEditor.KindExecute(\'KE_ICON_END\', \'' + iconUrl + '\');">' +
				'<img src="' + iconUrl + '" style="border:1px solid #EEEEEE;" onmouseover="javascript:this.style.borderColor=\'#AAAAAA\';" ' +
				'onmouseout="javascript:this.style.borderColor=\'#EEEEEE\';">' + '</td>';
				if (i >= 5 && i%(i-1) == 0) {
					str += '</tr>';
				}
			}
			str += '</table>';
			return str;
			break;
		case 'KE_SPECIALCHAR':
			var str = '';
			str += '<table id="POPUP_'+cmd+'" cellpadding="0" cellspacing="2" style="'+EaEditor.KindGetMenuCommonStyle()+'">';
			for (i = 0; i < EaEditor.KE_SPECIAL_CHARACTER.length; i++) {
				if (i == 0 || (i >= 10 && i%10 == 0)) {
					str += '<tr>';
				}
				str += '<td style="padding:2px;border:1px solid #AAAAAA;cursor:pointer;" ' + 
				'onclick="javascript:EaEditor.KindExecute(\'KE_SPECIALCHAR_END\', \'' + EaEditor.KE_SPECIAL_CHARACTER[i] + '\');" ' +
				'onmouseover="javascript:this.style.borderColor=\'#000000\';" ' +
				'onmouseout="javascript:this.style.borderColor=\'#AAAAAA\';">' + EaEditor.KE_SPECIAL_CHARACTER[i] + '</td>';
				if (i >= 9 && i%(i-1) == 0) {
					str += '</tr>';
				}
			}
			str += '</table>';
			return str;
			break;
		case 'KE_TABLE':
			var str = '';
			var num = 10;
			str += '<table id="POPUP_'+cmd+'" cellpadding="0" cellspacing="0" style="'+EaEditor.KindGetMenuCommonStyle()+'">';
			for (i = 1; i <= num; i++) {
				str += '<tr>';
				for (j = 1; j <= num; j++) {
					var value = i.toString(10) + ',' + j.toString(10);
					str += '<td id="kindTableTd' + i.toString(10) + '_' + j.toString(10) + 
					'" style="width:15px;height:15px;background-color:#FFFFFF;border:1px solid #DDDDDD;cursor:pointer;" ' + 
					'onclick="javascript:EaEditor.KindExecute(\'KE_TABLE_END\', \'' + value + '\');" ' +
					'onmouseover="javascript:EaEditor.KindDrawTableSelected(\''+i.toString(10)+'\', \''+j.toString(10)+'\');" ' + 
					'onmouseout="javascript:;">&nbsp;</td>';
				}
				str += '</tr>';
			}
			str += '<tr><td colspan="10" id="tableLocation" style="text-align:center;height:20px;"></td></tr>';
			str += '</table>';
			return str;
			break;
		case 'KE_IMAGE':
			var str = '';
			str += '<div id="POPUP_'+cmd+'" style="width:300px;'+EaEditor.KindGetMenuCommonStyle()+'">';
			str += '<iframe name="KindImageIframe" id="KindImageIframe" frameborder="0" style="width:300px;height:140px;padding:0;margin:0;border:0;">';
			str += '</iframe></div>';
			return str;
			break;
		case 'KE_FLASH':
			var str = '';
			str += '<div id="POPUP_'+cmd+'" style="width:250px;'+EaEditor.KindGetMenuCommonStyle()+'">';
			str += '<iframe name="KindFlashIframe" id="KindFlashIframe" frameborder="0" style="width:250px;height:50px;padding:0;margin:0;border:0;">';
			str += '</iframe></div>';
			return str;
			break;
		case 'KE_MEDIA':
			var str = '';
			str += '<div id="POPUP_'+cmd+'" style="width:250px;'+EaEditor.KindGetMenuCommonStyle()+'">';
			str += '<iframe name="KindMediaIframe" id="KindMediaIframe" frameborder="0" style="width:250px;height:50px;padding:0;margin:0;border:0;">';
			str += '</iframe></div>';
			return str;
			break;
		case 'KE_REAL':
			var str = '';
			str += '<div id="POPUP_'+cmd+'" style="width:250px;'+EaEditor.KindGetMenuCommonStyle()+'">';
			str += '<iframe name="KindRealIframe" id="KindRealIframe" frameborder="0" style="width:250px;height:50px;padding:0;margin:0;border:0;">';
			str += '</iframe></div>';
			return str;
			break;
		case 'KE_LINK':
			var str = '';
			str += '<div id="POPUP_'+cmd+'" style="width:250px;'+EaEditor.KindGetMenuCommonStyle()+'">';
			str += '<iframe name="KindLinkIframe" id="KindLinkIframe" frameborder="0" style="width:250px;height:85px;padding:0;margin:0;border:0;">';
			str += '</iframe></div>';
			return str;
			break;
		case 'KE_ABOUT':
			var str = '';
			str += '<div id="POPUP_'+cmd+'" style="width:230px;'+EaEditor.KindGetMenuCommonStyle()+';padding:5px;">';
			str += '<span style="margin-right:10px;">EaEditor.KindEditor ' + EaEditor.KE_VERSION + '</span>' + 
				'<a href="http://www.kindsoft.net/" target="_blank" style="color:#4169e1;" onclick="javascript:EaEditor.KindDisableMenu();">'+EaEditor.KE_LANG['ABOUT']+'</a><br />';
			str += '</div>';
			return str;
			break;
		default: 
			break;
	}
}
EaEditor.KindDrawIframe = function(cmd)
{
	switch (cmd)
	{
		case 'KE_IMAGE':
			if (EaEditor.KE_BROWSER == 'IE') {
				EaEditor.KE_IMAGE_DOCUMENT = document.frames("KindImageIframe").document;
			} else {
				EaEditor.KE_IMAGE_DOCUMENT = document.getElementById('KindImageIframe').contentDocument;
			}
			var str = '';
			str += '<div align="center">' +
				'<form name="uploadForm" style="margin:0;padding:0;" method="post" enctype="multipart/form-data" ' +
				'action="' + EaEditor.KE_IMAGE_UPLOAD_CGI + '" onsubmit="javascript:if(parent.EaEditor.KindDrawImageEnd()==false){return false;};">' +
				'<input type="hidden" name="fileName" id="fileName" value="" />' + 
				'<table cellpadding="0" cellspacing="0" style="width:100%;font-size:12px;">' + 					
				'<tr><td style="width:50px;padding-left:5px;">';
			if (EaEditor.KE_UPLOAD_MODE == true) {
				str += '<select id="imageType" onchange="javascript:parent.EaEditor.KindImageType(this.value);document.getElementById(\''+cmd+'submitButton\').focus();"><option value="1" selected="selected">'+EaEditor.KE_LANG['LOCAL']+'</option><option value="2">'+EaEditor.KE_LANG['REMOTE']+'</option></select>';
			    str += '<input type="hidden" id="imageType_flag" value="1" />';
			} else {
				str += EaEditor.KE_LANG['REMOTE'];
			}
			str += '</td><td style="width:200px;padding-bottom:3px;">';
			if (EaEditor.KE_UPLOAD_MODE == true) {
				str += '<input type="text" id="imgLink" value="http://" maxlength="255" style="width:200px;border:1px solid #555555;display:none;" />' +
				//'<input type="file" name="fileData" id="imgFile" size="14" style="border:1px solid #555555;" onclick="javascript:document.getElementById(\'imgLink\').value=\'http://\';" />';			
			    '<div id="imgFile" ><iframe id="uploadFrame" style="padding:0px; margin:0px; width:240px; height:23px;" frameborder="0" scrolling="no" src="'+ Path +'upload.aspx"></iframe> </div>';
			
			
			} else {
				str += '<input type="text" id="imgLink" value="http://" maxlength="255" style="200px;border:1px solid #555555;" />' +
				'<input type="hidden" name="imageType" id="imageType" value="2"><input type="hidden" name="fileData" id="imgFile" value="" />';
			}
			str += '</td></tr><tr><td colspan="2" style="padding-bottom:3px;">' +
				'<table border="0" style="width:100%;font-size:12px;"><tr>' +
				'<td width="18%" style="padding:2px 2px 2px 5px;">'+EaEditor.KE_LANG['TITLE']+'</td><td width="82%"><input type="text" name="imgTitle" id="imgTitle" value="" maxlength="100" style="width:95%;border:1px solid #555555;" /></td></tr></table>' +	
				'<table border="0" style="width:100%;font-size:12px;"><tr>' +
				'<td width="10%" style="padding:2px 2px 2px 5px;">'+EaEditor.KE_LANG['WIDTH']+'</td><td width="23%"><input type="text" name="imgWidth" id="imgWidth" value="0" maxlength="4" style="width:40px;border:1px solid #555555;" /></td>' +
				'<td width="10%" style="padding:2px;">'+EaEditor.KE_LANG['HEIGHT']+'</td><td width="23%"><input type="text" name="imgHeight" id="imgHeight" value="0" maxlength="4" style="width:40px;border:1px solid #555555;" /></td>' +
				'<td width="10%" style="padding:2px;">'+EaEditor.KE_LANG['BORDER']+'</td><td width="23%"><input type="text" name="imgBorder" id="imgBorder" value="0" maxlength="1" style="width:20px;border:1px solid #555555;" /></td></tr></table>' +
				'<table border="0" style="width:100%;font-size:12px;"><tr>' +
				'<td width="39%" style="padding:2px 2px 2px 5px;"><select id="imgAlign" name="imgAlign"><option value="">'+EaEditor.KE_LANG['ALIGN']+'</option>';
			for (var i = 0; i < EaEditor.KE_IMAGE_ALIGN_TABLE.length; i++) {
				str += '<option value="' + EaEditor.KE_IMAGE_ALIGN_TABLE[i] + '">' + EaEditor.KE_IMAGE_ALIGN_TABLE_FACE[i] + '</option>';
			}
			str += '</select></td>' +
				'<td width="20%">'+EaEditor.KE_LANG['HSPACE']+'</td><td width="10%"><input type="text" name="imgHspace" id="imgHspace" value="0" maxlength="1" style="width:20px;border:1px solid #555555;" /></td>' +
				'<td width="20%">'+EaEditor.KE_LANG['VSPACE']+'</td><td width="10%"><input type="text" name="imgVspace" id="imgVspace" value="0" maxlength="1" style="width:20px;border:1px solid #555555;" /></td></tr></table>' +
				'</td></tr><tr><td colspan="2" style="margin:5px;padding-bottom:5px;" align="center">' +
				'<input type="button" name="button" value="'+EaEditor.KE_LANG['PREVIEW']+'" onclick="javascript:parent.EaEditor.KindImagePreview();" style="border:1px solid #555555;background-color:'+EaEditor.KE_BUTTON_COLOR+';" /> ' +
				'<input type="submit" name="button" id="'+cmd+'submitButton" value="'+EaEditor.KE_LANG['CONFIRM']+'" style="border:1px solid #555555;background-color:'+EaEditor.KE_BUTTON_COLOR+';" /> ' +
				'<input type="button" name="button" value="'+EaEditor.KE_LANG['CANCEL']+'" onclick="javascript:parent.EaEditor.KindDisableMenu();" style="border:1px solid #555555;background-color:'+EaEditor.KE_BUTTON_COLOR+';" /></td></tr>' + 
				'<tr><td colspan="2"><table border="0" style="margin-bottom:3px;"><tr><td id="imgPreview" style="width:300px;height:160px;border:1px solid #AAAAAA;background-color:#FFFFFF;" align="center" valign="middle">&nbsp;</td></tr></table></td></tr>' +  
				'</table></form></div>';
			EaEditor.KindDrawMenuIframe(EaEditor.KE_IMAGE_DOCUMENT, str);
			break;
		case 'KE_FLASH':
			if (EaEditor.KE_BROWSER == 'IE') {
				EaEditor.KE_FLASH_DOCUMENT = document.frames("KindFlashIframe").document;
			} else {
				EaEditor.KE_FLASH_DOCUMENT = document.getElementById('KindFlashIframe').contentDocument;
			}
			var str = '<table cellpadding="0" cellspacing="0" style="width:100%;font-size:12px;">' + 
			 	
			'<tr><td style="width:40px;padding:5px;">'+EaEditor.KE_LANG['REMOTE']+'</td>' +
			'<td style="width:210px;padding-bottom:5px;"><input type="text" id="flashLink" value="http://" style="width:190px;border:1px solid #555555;" /></td></tr>' +
			'<tr><td colspan="2" style="margin:5px;padding-bottom:5px;" align="center">' +
			'<input type="button" name="button" value="'+EaEditor.KE_LANG['PREVIEW']+'" onclick="javascript:parent.EaEditor.KindFlashPreview();" style="border:1px solid #555555;background-color:'+EaEditor.KE_BUTTON_COLOR+';" /> ' +
			'<input type="submit" name="button" id="'+cmd+'submitButton" value="'+EaEditor.KE_LANG['CONFIRM']+'" onclick="javascript:parent.EaEditor.KindDrawFlashEnd();" style="border:1px solid #555555;background-color:'+EaEditor.KE_BUTTON_COLOR+';" /> ' +
			'<input type="button" name="button" value="'+EaEditor.KE_LANG['CANCEL']+'" onclick="javascript:parent.EaEditor.KindDisableMenu();" style="border:1px solid #555555;background-color:'+EaEditor.KE_BUTTON_COLOR+';" /></td></tr>' + 
			'<tr><td colspan="2"><table border="0"><tr><td id="flashPreview" style="width:240px;height:160px;border:1px solid #AAAAAA;background-color:#FFFFFF;" align="center" valign="middle">&nbsp;</td></tr></table></td></tr>' + 
			'</table>';
			EaEditor.KindDrawMenuIframe(EaEditor.KE_FLASH_DOCUMENT, str);
			break;
		case 'KE_MEDIA':
			if (EaEditor.KE_BROWSER == 'IE') {
				EaEditor.KE_MEDIA_DOCUMENT = document.frames("KindMediaIframe").document;
			} else {
				EaEditor.KE_MEDIA_DOCUMENT = document.getElementById('KindMediaIframe').contentDocument;
			}
			var str = EaEditor.KindDrawMedia(cmd);
			EaEditor.KindDrawMenuIframe(EaEditor.KE_MEDIA_DOCUMENT, str);
			break;
		case 'KE_REAL':
			if (EaEditor.KE_BROWSER == 'IE') {
				EaEditor.KE_REAL_DOCUMENT = document.frames("KindRealIframe").document;
			} else {
				EaEditor.KE_REAL_DOCUMENT = document.getElementById('KindRealIframe').contentDocument;
			}
			var str = EaEditor.KindDrawMedia(cmd);
			EaEditor.KindDrawMenuIframe(EaEditor.KE_REAL_DOCUMENT, str);
			break;
		case 'KE_LINK':
			if (EaEditor.KE_BROWSER == 'IE') {
				EaEditor.KE_LINK_DOCUMENT = document.frames("KindLinkIframe").document;
			} else {
				EaEditor.KE_LINK_DOCUMENT = document.getElementById('KindLinkIframe').contentDocument;
			}
			var str = '';
			str += '<table cellpadding="0" cellspacing="0" style="width:100%;font-size:12px;">' + 
				'<tr><td style="width:50px;padding:5px;">URL</td>' +
				'<td style="width:200px;padding-top:5px;padding-bottom:5px;"><input type="text" id="hyperLink" value="http://" style="width:190px;border:1px solid #555555;background-color:#FFFFFF;"></td>' +
				'<tr><td style="padding:5px;">'+EaEditor.KE_LANG['TARGET']+'</td>' +
				'<td style="padding-bottom:5px;"><select id="hyperLinkTarget"><option value="_blank" selected="selected">'+EaEditor.KE_LANG['NEW_WINDOW']+'</option><option value="">'+EaEditor.KE_LANG['CURRENT_WINDOW']+'</option></select></td></tr>' + 
				'<tr><td colspan="2" style="padding-bottom:5px;" align="center">' +
				'<input type="submit" name="button" id="'+cmd+'submitButton" value="'+EaEditor.KE_LANG['CONFIRM']+'" onclick="javascript:parent.EaEditor.KindDrawLinkEnd();" style="border:1px solid #555555;background-color:'+EaEditor.KE_BUTTON_COLOR+';" /> ' +
				'<input type="button" name="button" value="'+EaEditor.KE_LANG['CANCEL']+'" onclick="javascript:parent.EaEditor.KindDisableMenu();" style="border:1px solid #555555;background-color:'+EaEditor.KE_BUTTON_COLOR+';" /></td></tr>';
			str += '</table>';
			EaEditor.KindDrawMenuIframe(EaEditor.KE_LINK_DOCUMENT, str);
			break;
		default:
			break;
	}
}
EaEditor.KindDrawMenuIframe = function(obj, str)
{
	obj.open();
	obj.write(str);
	obj.close();
	obj.body.style.color = EaEditor.KE_MENU_TEXT_COLOR;
	obj.body.style.backgroundColor = EaEditor.KE_MENU_BG_COLOR;
	obj.body.style.margin = 0;
	obj.body.scroll = 'no';
}
EaEditor.KindDrawTableSelected = function(i, j)
{
	var text = i.toString(10) + ' by ' + j.toString(10) + ' Table';
	document.getElementById('tableLocation').innerHTML = text;
	var num = 10;
	for (m = 1; m <= num; m++) {
		for (n = 1; n <= num; n++) {
			var obj = document.getElementById('kindTableTd' + m.toString(10) + '_' + n.toString(10) + '');
			if (m <= i && n <= j) {
				obj.style.backgroundColor = EaEditor.KE_MENU_SELECTED_COLOR;
			} else {
				obj.style.backgroundColor = '#FFFFFF';
			}
		}
	}
}
EaEditor.KindImageType = function(type)
{
	if (type == 1) {
		EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgFile').style.display = 'block';
		EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgLink').style.display = 'none';
		EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgLink').value = 'http://';
		EaEditor.KE_IMAGE_DOCUMENT.getElementById('imageType_flag').value = '1';
	} else {
		EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgFile').style.display = 'none';
		EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgLink').style.display = 'block';
		EaEditor.KE_IMAGE_DOCUMENT.getElementById('imageType_flag').value = '2';
	}
	EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgPreview').innerHTML = "&nbsp;";
	EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgWidth').value = 0;
	EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgHeight').value = 0;
}
EaEditor.KindImagePreview = function()
{
	var type = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imageType_flag').value;
	var url = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgLink').value;
	

	
	if (type == 1) {

		if (EaEditor.KE_BROWSER != 'IE') {
			return false;
		}
		if (file == '') {
			alert(EaEditor.KE_LANG['SELECT_IMAGE']);
			return false;
		}
		url = 'file:///' + file;
		if (EaEditor.KindCheckImageFileType(url, "\\") == false) {
			return false;
		}
	} else {
	
		if (EaEditor.KindCheckImageFileType(url, "/") == false) {
		
			return false;
		}
	}
	var imgObj = EaEditor.KE_IMAGE_DOCUMENT.createElement("IMG");
	imgObj.src = url;
	var width = parseInt(imgObj.width);
	var height = parseInt(imgObj.height);
	EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgWidth').value = width;
	
	EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgHeight').value = height;
	var rate = parseInt(width/height);
	if (width >230 && height <= 230) {
		width = 230;
		height = parseInt(width/rate);
	} else if (width <=230 && height > 230) {
		height = 230;
		width = parseInt(height*rate);
	} else if (width >230 && height > 230) {
		if (width >= height) {
			width = 230;
			height = parseInt(width/rate);
		} else {
			height = 230;
			width = parseInt(height*rate);
		}
	}
	imgObj.style.width = width;
	imgObj.style.height = height;
	var el = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgPreview');
	if (el.hasChildNodes()) {
		el.removeChild(el.childNodes[0]);
	}
	el.appendChild(imgObj);
	document.getElementById("KindImageIframe").style.height = "310px";
	return imgObj;
}
EaEditor.KindDrawImageEnd = function()
{
	var type = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imageType_flag').value;
	
	var url = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgLink').value;
	var file = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgFile').value;
	var width = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgWidth').value;
	var height = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgHeight').value;
	var border = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgBorder').value;
	var title = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgTitle').value;
	var align = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgAlign').value;
	var hspace = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgHspace').value;
	var vspace = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgVspace').value;
	if (type == 1) {
		if (file == '') {
			alert(EaEditor.KE_LANG['SELECT_IMAGE']);
			return false;
		}
		if (EaEditor.KindCheckImageFileType(file, "\\") == false) {
			return false;
		}
	} else {
		if (EaEditor.KindCheckImageFileType(url, "/") == false) {
			return false;
		}
	}
	if (width.match(/^\d+$/) == null) {
		alert(EaEditor.KE_LANG['INVALID_WIDTH']);
		return false;
	}
	if (height.match(/^\d+$/) == null) {
		alert(EaEditor.KE_LANG['INVALID_HEIGHT']);
		return false;
	}
	if (border.match(/^\d+$/) == null) {
		alert(EaEditor.KE_LANG['INVALID_BORDER']);
		return false;
	}
	if (hspace.match(/^\d+$/) == null) {
		alert(EaEditor.KE_LANG['INVALID_HSPACE']);
		return false;
	}
	if (vspace.match(/^\d+$/) == null) {
		alert(EaEditor.KE_LANG['INVALID_VSPACE']);
		return false;
	}
	var fileName;
	KindEditorForm.focus();
	if (type == 1) {
		fileName = EaEditor.KindGetFileName(file, "\\");
		var fileExt = EaEditor.KindGetFileExt(fileName);
		var dateObj = new Date();
		var year = dateObj.getFullYear().toString(10);
		var month = (dateObj.getMonth() + 1).toString(10);
		month = month.length < 2 ? '0' + month : month;
		var day = dateObj.getDate().toString(10);
		day = day.length < 2 ? '0' + day : day;
		var ymd = year + month + day;
		fileName = ymd + dateObj.getTime().toString(10) + '.' + fileExt;
		EaEditor.KE_IMAGE_DOCUMENT.getElementById('fileName').value = fileName;
	} else {
		EaEditor.KindInsertImage(url, width, height, border, title, align, hspace, vspace);
	}
}
EaEditor.KindInsertImage = function(url, width, height, border, title, align, hspace, vspace)
{
    var type = EaEditor.KE_IMAGE_DOCUMENT.getElementById('imageType').value;
    if(type==1)//如果是本地上传的就更新地址  
    {    
        var imgUrl = url.substr(url.lastIndexOf("/")+1);
        url = EaEditor.baseUploadUrl + imgUrl
    }
	var ks = new EaEditor.KindString();
	ks.append('<img src="', url);
	if (width > 0) {
		ks.append('" width="', width);
	}
	if (height > 0) {
		ks.append('" height="', height);
	}
	if (align != "") {
		ks.append('" align="', align);
	}
	if (hspace > 0) {
		ks.append('" hspace="', hspace);
	}
	if (vspace > 0) {
		ks.append('" vspace="', vspace);
	}
	ks.append('" border="', border);
	ks.append('" alt="', EaEditor.KindHtmlentities(title), '" />');
	EaEditor.KindSelect();
	EaEditor.KindInsertHtml(ks.toString());
	EaEditor.KindDisableMenu();
}
EaEditor.KindGetFlashHtmlTag = function(url)
{
	var str = '<embed src="'+url+'" type="application/x-shockwave-flash" quality="high"></embed>';
	return str;
}
EaEditor.KindFlashPreview = function()
{
	var url = EaEditor.KE_FLASH_DOCUMENT.getElementById('flashLink').value;
	if (EaEditor.KindCheckFlashFileType(url, "/") == false) {
		return false;
	}
	var el = EaEditor.KE_FLASH_DOCUMENT.getElementById('flashPreview');
	el.innerHTML = EaEditor.KindGetFlashHtmlTag(url);
	document.getElementById("KindFlashIframe").style.height = "255px";
}
EaEditor.KindDrawFlashEnd = function()
{
	var url = EaEditor.KE_FLASH_DOCUMENT.getElementById('flashLink').value;
	if (EaEditor.KindCheckFlashFileType(url, "/") == false)
	{
		return false;
	}
	KindEditorForm.focus();
	EaEditor.KindSelect();
	var ks = new EaEditor.KindString();
	ks.append('<embed src="', url);
	ks.append('" type="', "application/x-shockwave-flash");
	ks.append('" quality="', "high", '" />');
	EaEditor.KindInsertHtml(ks.toString());
	EaEditor.KindDisableMenu();
}
EaEditor.KindGetMediaHtmlTag = function(cmd, url)
{
	var ks = new EaEditor.KindString();
	ks.append('<embed src="', url);
	ks.append('" type="');
	if (cmd == "KE_REAL") {
		ks.append("audio/x-pn-realaudio-plugin");
	} else {
		ks.append("video/x-ms-asf-plugin");
	}
	ks.append('" width="', '230');
	ks.append('" height="', '230');
	ks.append('" loop="', 'true');
	ks.append('" autostart="', "true", '" />');
	
	//EaEditor.KindInsertHtml(ks.toString());
	return ks.toString();
}
EaEditor.KindMediaPreview = function(cmd)
{
	var mediaDocument;
	if (cmd == 'KE_REAL') {
		mediaDocument = EaEditor.KE_REAL_DOCUMENT;
	} else {
		mediaDocument = EaEditor.KE_MEDIA_DOCUMENT;
	}
	var url = mediaDocument.getElementById(cmd+'link').value;
	
	if (EaEditor.KindCheckMediaFileType(cmd, url, "/") == false) {
		return false;
	}
	var el = mediaDocument.getElementById(cmd+'preview');
	el.innerHTML = EaEditor.KindGetMediaHtmlTag(cmd, url);
	if(cmd == 'KE_REAL')
	{
	    //改变IFRAME大小
	    document.getElementById("KindRealIframe").style.height = "300px";
	}
	else if(cmd == 'KE_MEDIA')
	{
	    //改变IFRAME大小
	    document.getElementById("KindMediaIframe").style.height = "300px";
	}

	
}

EaEditor.KindDrawMediaEnd = function(cmd)
{
	var mediaDocument;
	if (cmd == 'KE_REAL') {
		mediaDocument = EaEditor.KE_REAL_DOCUMENT;
	} else {
		mediaDocument = EaEditor.KE_MEDIA_DOCUMENT;
	}
	var url = mediaDocument.getElementById(cmd+'link').value;
	
	if (EaEditor.KindCheckMediaFileType(cmd, url, "/") == false) {
		return false;
	}
	KindEditorForm.focus();
	EaEditor.KindSelect();
	EaEditor.KindInsertHtml(EaEditor.KindGetMediaHtmlTag(cmd,url));
	EaEditor.KindDisableMenu(cmd);
}
EaEditor.KindDrawLinkEnd = function()
{
	var range;
	var url = EaEditor.KE_LINK_DOCUMENT.getElementById('hyperLink').value;
	var target = EaEditor.KE_LINK_DOCUMENT.getElementById('hyperLinkTarget').value;
	if (url.match(/http:\/\/.{3,}/) == null) {
		alert(EaEditor.KE_LANG['INPUT_URL']);
		return false;
	}
	try{
        if (file.indexOf(".")<=0)
        {
            alert(EaEditor.KE_LANG['INPUT_URL']);
            return false;
        }
    }
    catch(e)
    {
    }

	KindEditorForm.focus();
	EaEditor.KindSelect();
	var element;
    if (EaEditor.KE_BROWSER == 'IE') {
		if (EaEditor.KE_SELECTION.type.toLowerCase() == 'control') {
			var el = document.createElement("a");
			el.href = url;
			if (target) {
				el.target = target;
			}
			EaEditor.KE_RANGE.item(0).applyElement(el);
		} else if (EaEditor.KE_SELECTION.type.toLowerCase() == 'text') {
			EaEditor.KindExecuteValue('CreateLink', url);
			element = EaEditor.KE_RANGE.parentElement();
			if (target) {
				element.target = target;
			}
		}
	} else {
		EaEditor.KindExecuteValue('CreateLink', url);
		element = EaEditor.KE_RANGE.startContainer.previousSibling;
		element.target = target;
		if (target) {
			element.target = target;
		}
    }
	EaEditor.KindDisableMenu();
}
EaEditor.KindSelection = function()
{
	if (EaEditor.KE_BROWSER == 'IE') {
		EaEditor.KE_SELECTION = EaEditor.KE_EDITFORM_DOCUMENT.selection;
		EaEditor.KE_RANGE = EaEditor.KE_SELECTION.createRange();
		EaEditor.KE_RANGE_TEXT = EaEditor.KE_RANGE.text;
	} else {
		EaEditor.KE_SELECTION = document.getElementById("KindEditorForm").contentWindow.getSelection();
        EaEditor.KE_RANGE = EaEditor.KE_SELECTION.getRangeAt(0);
		EaEditor.KE_RANGE_TEXT = EaEditor.KE_RANGE.toString();
	}
}
EaEditor.KindSelect = function()
{
	if (EaEditor.KE_BROWSER == 'IE') {
		EaEditor.KE_RANGE.select();
	}
}
EaEditor.KindInsertHtml = function(html)
{
	if (EaEditor.KE_BROWSER == 'IE') {
		if (EaEditor.KE_SELECTION.type.toLowerCase() == 'control') {
			EaEditor.KE_RANGE.item(0).outerHTML = html;
		} else {
			EaEditor.KE_RANGE.pasteHTML(html);
		}
	} else {
		EaEditor.KE_EDITFORM_DOCUMENT.execCommand('inserthtml', false, html);
	}
}
EaEditor.KindExecuteValue = function(cmd, value)
{

	EaEditor.KE_EDITFORM_DOCUMENT.execCommand(cmd, false, value);
}
EaEditor.KindSimpleExecute = function(cmd)
{
	KindEditorForm.focus();
	EaEditor.KE_EDITFORM_DOCUMENT.execCommand(cmd, false, null);
	EaEditor.KindDisableMenu();
}
EaEditor.KindExecute = function(cmd, value)
{
	switch (cmd)
	{
		case 'KE_SOURCE':
			var length = document.getElementById(EaEditor.KE_TOP_TOOLBAR_ICON[0][0]).src.length - 10;
			var image = document.getElementById(EaEditor.KE_TOP_TOOLBAR_ICON[0][0]).src.substr(length,10);
			if (image == 'source.gif') {
				document.getElementById("KindCodeForm").value = EaEditor.KindHtmlToXhtml(EaEditor.KE_EDITFORM_DOCUMENT.body.innerHTML);
				document.getElementById("KindEditorIframe").style.display = 'none';
				document.getElementById("KindEditTextarea").style.display = 'block';
				
	
				EaEditor.KindDisableToolbar(true);
			} else {
				EaEditor.KE_EDITFORM_DOCUMENT.body.innerHTML = EaEditor.KindClearScriptTag(document.getElementById("KindCodeForm").value);
				document.getElementById("KindEditTextarea").style.display = 'none';
				document.getElementById("KindEditorIframe").style.display = 'block';
				EaEditor.KindDisableToolbar(false);
			}
			EaEditor.KindDisableMenu();
			break;
		case 'KE_PRINT':
			EaEditor.KindSimpleExecute('print');
			break;
		case 'KE_UNDO':
			EaEditor.KindSimpleExecute('undo');
			break;
		case 'KE_REDO':
			EaEditor.KindSimpleExecute('redo');
			break;
		case 'KE_CUT':
			EaEditor.KindSimpleExecute('cut');
			break;
		case 'KE_COPY':
			EaEditor.KindSimpleExecute('copy');
			break;
		case 'KE_PASTE':
			EaEditor.KindSimpleExecute('paste');
			break;
		case 'KE_SELECTALL':
			EaEditor.KindSimpleExecute('selectall');
			break;
		case 'KE_SUBSCRIPT':
			EaEditor.KindSimpleExecute('subscript');
			break;
		case 'KE_SUPERSCRIPT':
			EaEditor.KindSimpleExecute('superscript');
			break;
		case 'KE_BOLD':
			EaEditor.KindSimpleExecute('bold');
			break;
		case 'KE_ITALIC':
			EaEditor.KindSimpleExecute('italic');
			break;
		case 'KE_UNDERLINE':
			EaEditor.KindSimpleExecute('underline');
			break;
		case 'KE_STRIKE':
			EaEditor.KindSimpleExecute('strikethrough');
			break;
		case 'KE_JUSTIFYLEFT':
			EaEditor.KindSimpleExecute('justifyleft');
			break;
		case 'KE_JUSTIFYCENTER':
			EaEditor.KindSimpleExecute('justifycenter');
			break;
		case 'KE_JUSTIFYRIGHT':
			EaEditor.KindSimpleExecute('justifyright');
			break;
		case 'KE_JUSTIFYFULL':
			EaEditor.KindSimpleExecute('justifyfull');
			break;
		case 'KE_NUMBEREDLIST':
			EaEditor.KindSimpleExecute('insertorderedlist');
			break;
		case 'KE_UNORDERLIST':
			EaEditor.KindSimpleExecute('insertunorderedlist');
			break;
		case 'KE_INDENT':
			EaEditor.KindSimpleExecute('indent');
			break;
		case 'KE_OUTDENT':
			EaEditor.KindSimpleExecute('outdent');
			break;
		case 'KE_REMOVE':
			EaEditor.KindSimpleExecute('removeformat');
			break;
		case 'KE_ZOOM':
			EaEditor.KindDisplayMenu(cmd);
			break;
		case 'KE_ZOOM_END':
			KindEditorForm.focus();
			EaEditor.KE_EDITFORM_DOCUMENT.body.style.zoom = value;
			EaEditor.KindDisableMenu();
			break;
		case 'KE_TITLE':
			EaEditor.KindDisplayMenu(cmd);
			break;
		
		//新加行设置	
	    case 'KE_LINE':
	        EaEditor.KindDisplayMenu(cmd);
	        KindEditorForm.focus();
	        EaEditor.KindSelection();
	        break;
	        

        case 'KE_FONTSIZE':
            EaEditor.KindDisplayMenu(cmd);
			break;
	    
		case 'KE_TITLE_END':
			KindEditorForm.focus();
			value = '<' + value + '>';
			EaEditor.KindSelect();
			EaEditor.KindExecuteValue('FormatBlock', value);
			EaEditor.KindDisableMenu();
			break;
		
		//新加行设置		
		case 'KE_LINE_END':
		    KindEditorForm.focus(); 
			
			if (EaEditor.KE_BROWSER == 'IE') {
				var tempValue = EaEditor.KE_RANGE.htmlText;
		    var newHtmlText = "";
		    if(value=="1")
		    {
		        value="";
		    }

		    if(tempValue.indexOf("<P")<0)
		    {
		        newHtmlText = "<P style='line-height:"+ value +"'>" + tempValue + "</P>";

		    }
		    else
		    {
		        newHtmlText = tempValue.replace(/<P/g,"<P style='line-height:"+ value +"'")
		    }
		    EaEditor.KE_RANGE.pasteHTML(newHtmlText);
			} else {
				var startRangeNode = EaEditor.KE_RANGE.startContainer;				
				if (startRangeNode.nodeType == 3) {
					var parent = startRangeNode.parentNode;
					var element = document.createElement("P");
					element.style.lineHeight = value;
					element.appendChild(EaEditor.KE_RANGE.extractContents());
					var startRangeOffset = EaEditor.KE_RANGE.startOffset;
					var newRange = document.createRange();
					var afterNode;
					var textNode = startRangeNode;
					startRangeNode = textNode.parentNode;
					var text = textNode.nodeValue;
					var textBefore = text.substr(0, startRangeOffset);
					var textAfter = text.substr(startRangeOffset);
					var beforeNode = document.createTextNode(textBefore);
					var afterNode = document.createTextNode(textAfter);
					startRangeNode.insertBefore(afterNode, textNode);
					startRangeNode.insertBefore(element, afterNode);
					startRangeNode.insertBefore(beforeNode, element);
					startRangeNode.removeChild(textNode);
					newRange.setEnd(afterNode, 0);
					newRange.setStart(afterNode, 0);
					EaEditor.KE_SELECTION.addRange(newRange);
					EaEditor.KindSelect();
			        EaEditor.KindDisableMenu();
				}
			}
			EaEditor.KindSelect();
			EaEditor.KindDisableMenu();	
			break;
			
		case 'KE_FONTSIZE_END':
			KindEditorForm.focus(); 
			if (EaEditor.KE_BROWSER == 'IE') {
				var tempValue = EaEditor.KE_RANGE.htmlText;
		        var newHtmlText = "";
		        if(value=="1")
		        {
		            value="";
		        }

		        if(tempValue.indexOf("<FONT")<0)
		        {
		            newHtmlText = "<FONT style='font-size:"+ value +"'>" + tempValue + "</FONT>";

		        }
		        else
		        {
		            newHtmlText = tempValue.replace(/<FONT/g,"<FONT style='font-size:"+ value +"'")
		        }

		        EaEditor.KE_RANGE.pasteHTML(newHtmlText);
			    
			} else {
				var startRangeNode = EaEditor.KE_RANGE.startContainer;				
				if (startRangeNode.nodeType == 3) {
					var parent = startRangeNode.parentNode;
					var element = document.createElement("Font");
					element.style.fontSize = value;
					element.appendChild(EaEditor.KE_RANGE.extractContents());
					var startRangeOffset = EaEditor.KE_RANGE.startOffset;
					var newRange = document.createRange();
					var afterNode;
					var textNode = startRangeNode;
					startRangeNode = textNode.parentNode;
					var text = textNode.nodeValue;
					var textBefore = text.substr(0, startRangeOffset);
					var textAfter = text.substr(startRangeOffset);
					var beforeNode = document.createTextNode(textBefore);
					var afterNode = document.createTextNode(textAfter);
					startRangeNode.insertBefore(afterNode, textNode);
					startRangeNode.insertBefore(element, afterNode);
					startRangeNode.insertBefore(beforeNode, element);
					startRangeNode.removeChild(textNode);
					newRange.setEnd(afterNode, 0);
					newRange.setStart(afterNode, 0);
					EaEditor.KE_SELECTION.addRange(newRange);
				}
			}
			EaEditor.KindSelect();
			EaEditor.KindDisableMenu();
			break;
			
			
		case 'KE_FONTNAME':
			EaEditor.KindDisplayMenu(cmd);
			break;
		case 'KE_FONTNAME_END':
			KindEditorForm.focus();
			EaEditor.KindSelect();
			EaEditor.KindExecuteValue('fontname', value);
			EaEditor.KindDisableMenu();
			break;
//		case 'KE_FONTSIZE':
//			EaEditor.KindDisplayMenu(cmd);
//			break;
//		case 'KE_FONTSIZE_END':
//			KindEditorForm.focus();
//			value = value.substr(0, 1);
//			EaEditor.KindSelect();
//			EaEditor.KindExecuteValue('fontsize', value);
//			EaEditor.KindDisableMenu();
//			break;
		case 'KE_TEXTCOLOR':
			EaEditor.KindDisplayMenu(cmd);
			break;
		case 'KE_TEXTCOLOR_END':
			KindEditorForm.focus();
			EaEditor.KindSelect();
			EaEditor.KindExecuteValue('ForeColor', value);
			EaEditor.KindDisableMenu();
			break;
		case 'KE_BGCOLOR':
			EaEditor.KindDisplayMenu(cmd);
			break;
		case 'KE_BGCOLOR_END':
			KindEditorForm.focus();
			if (EaEditor.KE_BROWSER == 'IE') {
				EaEditor.KindSelect();
				EaEditor.KindExecuteValue('BackColor', value);
			} else {
				var startRangeNode = EaEditor.KE_RANGE.startContainer;
				if (startRangeNode.nodeType == 3) {
					var parent = startRangeNode.parentNode;
					var element = document.createElement("font");
					element.style.backgroundColor = value;
					element.appendChild(EaEditor.KE_RANGE.extractContents());
					var startRangeOffset = EaEditor.KE_RANGE.startOffset;
					var newRange = document.createRange();
					var afterNode;
					var textNode = startRangeNode;
					startRangeNode = textNode.parentNode;
					var text = textNode.nodeValue;
					var textBefore = text.substr(0, startRangeOffset);
					var textAfter = text.substr(startRangeOffset);
					var beforeNode = document.createTextNode(textBefore);
					var afterNode = document.createTextNode(textAfter);
					startRangeNode.insertBefore(afterNode, textNode);
					startRangeNode.insertBefore(element, afterNode);
					startRangeNode.insertBefore(beforeNode, element);
					startRangeNode.removeChild(textNode);
					newRange.setEnd(afterNode, 0);
					newRange.setStart(afterNode, 0);
					EaEditor.KE_SELECTION.addRange(newRange);
				}
			}
			EaEditor.KindDisableMenu();
			break;
		case 'KE_ICON':
			EaEditor.KindDisplayMenu(cmd);
			break;
		case 'KE_ICON_END':
			KindEditorForm.focus();
			var ks = new EaEditor.KindString();
			ks.append('<img src="', value);
			ks.append('" border="', '0');
			ks.append('" alt="', '" />');
			EaEditor.KindSelect();
			EaEditor.KindInsertHtml(ks.toString());
			EaEditor.KindDisableMenu();
			break;
		case 'KE_IMAGE':
		
			EaEditor.KindDisplayMenu(cmd);
			EaEditor.KindDrawIframe(cmd);
			KindImageIframe.focus();
			EaEditor.KE_IMAGE_DOCUMENT.getElementById(cmd+'submitButton').focus();
			break;
		case 'KE_FLASH':
			EaEditor.KindDisplayMenu(cmd);
			EaEditor.KindDrawIframe(cmd);
			KindFlashIframe.focus();
			EaEditor.KE_FLASH_DOCUMENT.getElementById(cmd+'submitButton').focus();
			break;
		case 'KE_MEDIA':
			EaEditor.KindDisplayMenu(cmd);
			EaEditor.KindDrawIframe(cmd);
			KindMediaIframe.focus();
			EaEditor.KE_MEDIA_DOCUMENT.getElementById(cmd+'submitButton').focus();
			break;
		case 'KE_REAL':
			EaEditor.KindDisplayMenu(cmd);
			EaEditor.KindDrawIframe(cmd);
			KindRealIframe.focus();
			EaEditor.KE_REAL_DOCUMENT.getElementById(cmd+'submitButton').focus();
			break;
		case 'KE_LINK':
			EaEditor.KindDisplayMenu(cmd);
			EaEditor.KindDrawIframe(cmd);
			KindLinkIframe.focus();
			EaEditor.KE_LINK_DOCUMENT.getElementById(cmd+'submitButton').focus();
			break;
		case 'KE_UNLINK':
			EaEditor.KindSimpleExecute('unlink');
			break;
		case 'KE_SPECIALCHAR':
			EaEditor.KindDisplayMenu(cmd);
			break;
		case 'KE_SPECIALCHAR_END':
			KindEditorForm.focus();
			EaEditor.KindSelect();
			EaEditor.KindInsertHtml(value);
			EaEditor.KindDisableMenu();
			break;
		case 'KE_LAYER':
			EaEditor.KindDisplayMenu(cmd);
			break;
		case 'KE_LAYER_END':
			KindEditorForm.focus();
			var ks = new EaEditor.KindString();
			ks.append('<div style="padding:5px;border:1px solid #AAAAAA;background-color:');
			ks.append(value, '">', EaEditor.KE_LANG['INPUT_CONTENT'], '</div>');
			EaEditor.KindSelect();
			EaEditor.KindInsertHtml(ks.toString());
			EaEditor.KindDisableMenu();
			break;
		case 'KE_TABLE':
			EaEditor.KindDisplayMenu(cmd);
			break;
		case 'KE_TABLE_END':
			KindEditorForm.focus();
			var location = value.split(',');
			var ks = new EaEditor.KindString();
			ks.append('<table style="width:100px;height:100px;" ');
			ks.append('cellpadding="0" cellspacing="0" border="1">');
			for (var i = 0; i < location[0]; i++) {
				ks.append('<tr>');
				for (var j = 0; j < location[1]; j++) {
					ks.append('<td>&nbsp;</td>');
				}
				ks.append('</tr>');
			}
			ks.append('</table>');
			EaEditor.KindSelect();
			EaEditor.KindInsertHtml(ks.toString());
			EaEditor.KindDisableMenu();
			break;
		case 'KE_HR':
			EaEditor.KindDisplayMenu(cmd);
			break;
		case 'KE_HR_END':
			KindEditorForm.focus();
			var ks = new EaEditor.KindString();
			ks.append('<hr width="100%" color="', value, '" size="1" />');
			EaEditor.KindSelect();
			EaEditor.KindInsertHtml(ks.toString());
			EaEditor.KindDisableMenu();
			break;
		case 'KE_DATE':
			KindEditorForm.focus();
			EaEditor.KindSelection();
			var date = new Date();
			var year = date.getFullYear().toString(10);
			var month = (date.getMonth() + 1).toString(10);
			month = month.length < 2 ? '0' + month : month;
			var day = date.getDate().toString(10);
			day = day.length < 2 ? '0' + day : day;
			var value = year + '-' + month + '-' + day;
			EaEditor.KindInsertHtml(value);
			EaEditor.KindDisableMenu();
			break;
		case 'KE_TIME':
			KindEditorForm.focus();
			EaEditor.KindSelection();
			var date = new Date();
			var hour = date.getHours().toString(10);
			hour = hour.length < 2 ? '0' + hour : hour;
			var minute = date.getMinutes().toString(10);
			minute = minute.length < 2 ? '0' + minute : minute;
			var second = date.getSeconds().toString(10);
			second = second.length < 2 ? '0' + second : second;
			var value = hour + ':' + minute + ':' + second;
			EaEditor.KindInsertHtml(value);
			EaEditor.KindDisableMenu();
			break;
		case 'KE_PREVIEW':
			eval(EaEditor.KE_OBJ_NAME).data();
			var newWin = window.open('', 'kindPreview','width=800,height=600,left=30,top=30,resizable=yes,scrollbars=yes');
			EaEditor.KindWriteFullHtml(newWin.document, document.getElementById(eval(EaEditor.KE_OBJ_NAME).hiddenName).value);
			EaEditor.KindDisableMenu();
			break;
		case 'KE_ABOUT':
			EaEditor.KindDisplayMenu(cmd);
			break;
		default: 
			break;
	}
}
EaEditor.KindDisableToolbar = function(flag)
{
	if (flag == true) {
		document.getElementById(EaEditor.KE_TOP_TOOLBAR_ICON[0][0]).src = EaEditor.KE_SKIN_PATH + 'design.gif';
		for (i = 0; i < EaEditor.KE_TOOLBAR_ICON.length; i++) {
			var el = document.getElementById(EaEditor.KE_TOOLBAR_ICON[i][0]);
			if (EaEditor.KE_TOOLBAR_ICON[i][0] == 'KE_SOURCE' || EaEditor.KE_TOOLBAR_ICON[i][0] == 'KE_PREVIEW' || EaEditor.KE_TOOLBAR_ICON[i][0] == 'KE_ABOUT') {
				continue;
			}
			el.style.visibility = 'hidden';
		}
	} else {
		document.getElementById(EaEditor.KE_TOP_TOOLBAR_ICON[0][0]).src = EaEditor.KE_SKIN_PATH + 'source.gif';
		for (i = 0; i < EaEditor.KE_TOOLBAR_ICON.length; i++) {
			var el = document.getElementById(EaEditor.KE_TOOLBAR_ICON[i][0]);
			el.style.visibility = 'visible';
			EaEditor.KE_EDITFORM_DOCUMENT.designMode = 'On';
		}
	}
}
EaEditor.KindCreateIcon = function(icon)
{
	var str = '<img id="'+ icon[0] +'" src="' + EaEditor.KE_SKIN_PATH + icon[1] + '" alt="' + icon[2] + '" title="' + icon[2] + 
			'" align="absmiddle" style="border:1px solid ' + EaEditor.KE_TOOLBAR_BG_COLOR +';cursor:pointer;height:20px;';
	str += '" onclick="javascript:EaEditor.KindExecute(\''+ icon[0] +'\');" '+
			'onmouseover="javascript:this.style.border=\'1px solid ' + EaEditor.KE_MENU_BORDER_COLOR + '\';" ' +
			'onmouseout="javascript:this.style.border=\'1px solid ' + EaEditor.KE_TOOLBAR_BG_COLOR + '\';" ';
	str += '>';
	return str;
}
EaEditor.KindCreateToolbar = function()
{
	var htmlData = '<table cellpadding="0" cellspacing="0" border="0" height="26"><tr>';
	if (EaEditor.KE_EDITOR_TYPE == 'full') {
		for (i = 0; i < EaEditor.KE_TOP_TOOLBAR_ICON.length; i++) {
			htmlData += '<td style="padding:2px;border:none">' + EaEditor.KindCreateIcon(EaEditor.KE_TOP_TOOLBAR_ICON[i]) + '</td>';
		}
		htmlData += '</tr></table><table cellpadding="0" cellspacing="0" border="0" height="26"><tr>';
		for (i = 0; i < EaEditor.KE_BOTTOM_TOOLBAR_ICON.length; i++) {
			htmlData += '<td style="padding:2px;border:none">' + EaEditor.KindCreateIcon(EaEditor.KE_BOTTOM_TOOLBAR_ICON[i]) + '</td>';
		}
	} else {
		for (i = 0; i < EaEditor.KE_SIMPLE_TOOLBAR_ICON.length; i++) {
			htmlData += '<td style="padding:2px;">' + EaEditor.KindCreateIcon(EaEditor.KE_SIMPLE_TOOLBAR_ICON[i]) + '</td>';
		}
	}
	htmlData += '</tr></table>';
	return htmlData;
}
EaEditor.KindWriteFullHtml = function(documentObj, content)
{
	var editHtmlData = '';
	editHtmlData += '<html>\r\n<head>\r\n<title>EaEditor.KindEditor</title>\r\n';
	editHtmlData += '<link href="'+EaEditor.KE_CSS_PATH+'" rel="stylesheet" type="text/css">\r\n</head>\r\n<body>\r\n';
	editHtmlData += content;
	editHtmlData += '\r\n</body>\r\n</html>\r\n';
	documentObj.open();
	documentObj.write(editHtmlData);
	documentObj.close();
}
EaEditor.KindEditor = function(objName) 
{
	this.objName = objName;
	this.hiddenName = objName;
	this.siteDomain;
	this.editorType;
	this.safeMode;
	this.uploadMode;
	this.editorWidth;
	this.editorHeight;
	this.skinPath;
	this.iconPath;
	this.imageAttachPath;
	this.imageUploadCgi;
	this.cssPath;
	this.menuBorderColor;
	this.menuBgColor;
	this.menuTextColor;
	this.menuSelectedColor;
	this.toolbarBorderColor;
	this.toolbarBgColor;
	this.formBorderColor;
	this.formBgColor;
	this.buttonColor;
	this.init = function()
	{
		if (this.siteDomain) EaEditor.KE_SITE_DOMAIN = this.siteDomain;
		if (this.editorType) EaEditor.KE_EDITOR_TYPE = this.editorType.toLowerCase();
		if (this.safeMode) EaEditor.KE_SAFE_MODE = this.safeMode;
		if (this.uploadMode) EaEditor.KE_UPLOAD_MODE = this.uploadMode;
		if (this.editorWidth) EaEditor.KE_WIDTH = this.editorWidth;
		if (this.editorHeight) EaEditor.KE_HEIGHT = this.editorHeight;
		if (this.skinPath) EaEditor.KE_SKIN_PATH = this.skinPath;
		if (this.iconPath) EaEditor.KE_ICON_PATH = this.iconPath;
		if (this.imageAttachPath) EaEditor.KE_IMAGE_ATTACH_PATH = this.imageAttachPath;
		if (this.imageUploadCgi) EaEditor.KE_IMAGE_UPLOAD_CGI = this.imageUploadCgi;
		if (this.cssPath) EaEditor.KE_CSS_PATH = this.cssPath;
		if (this.menuBorderColor) EaEditor.KE_MENU_BORDER_COLOR = this.menuBorderColor;
		if (this.menuBgColor) EaEditor.KE_MENU_BG_COLOR = this.menuBgColor;
		if (this.menuTextColor) EaEditor.KE_MENU_TEXT_COLOR = this.menuTextColor;
		if (this.menuSelectedColor) EaEditor.KE_MENU_SELECTED_COLOR = this.menuSelectedColor;
		if (this.toolbarBorderColor) EaEditor.KE_TOOLBAR_BORDER_COLOR = this.toolbarBorderColor;
		if (this.toolbarBgColor) EaEditor.KE_TOOLBAR_BG_COLOR = this.toolbarBgColor;
		if (this.formBorderColor) EaEditor.KE_FORM_BORDER_COLOR = this.formBorderColor;
		if (this.formBgColor) EaEditor.KE_FORM_BG_COLOR = this.formBgColor;
		if (this.buttonColor) EaEditor.KE_BUTTON_COLOR = this.buttonColor;
		EaEditor.KE_OBJ_NAME = this.objName;
		EaEditor.KE_BROWSER = EaEditor.KindGetBrowser();
		EaEditor.KE_TOOLBAR_ICON = Array();
		for (var i = 0; i < EaEditor.KE_TOP_TOOLBAR_ICON.length; i++) {
			EaEditor.KE_TOOLBAR_ICON.push(EaEditor.KE_TOP_TOOLBAR_ICON[i]);
		}
		for (var i = 0; i < EaEditor.KE_BOTTOM_TOOLBAR_ICON.length; i++) {
			EaEditor.KE_TOOLBAR_ICON.push(EaEditor.KE_BOTTOM_TOOLBAR_ICON[i]);
		}
	}
	this.show = function()
	{
		this.init();
		var widthStyle = 'width:' + EaEditor.KE_WIDTH + ';';
		var widthArr = EaEditor.KE_WIDTH.match(/(\d+)([px%]{1,2})/);
		var iframeWidthStyle = 'width:' + (parseInt(widthArr[1]) - 2).toString(10) + widthArr[2] + ';';
		var heightStyle = 'height:' + EaEditor.KE_HEIGHT + ';';
		var heightArr = EaEditor.KE_HEIGHT.match(/(\d+)([px%]{1,2})/);
		var iframeHeightStyle = 'height:' + (parseInt(heightArr[1]) - 3).toString(10) + heightArr[2] + ';';
		if (EaEditor.KE_BROWSER == '') {
			var htmlData = '<div id="KindEditTextarea" style="' + widthStyle + heightStyle + '">' +
			'<textarea  name="KindCodeForm" id="KindCodeForm" style="' + widthStyle + heightStyle + 
			'padding:0;margin:0;border:1px solid '+ EaEditor.KE_FORM_BORDER_COLOR + 
			';font-size:12px;line-height:16px;font-family:'+EaEditor.KE_FONT_FAMILY+';background-color:'+ 
			EaEditor.KE_FORM_BG_COLOR +';" >' + document.getElementById(this.hiddenName).value + '</textarea></div>';
			document.open();
			document.write(htmlData);
			document.close();
			return;
		}
		var ks = new EaEditor.KindString();
		ks.append('<div style="font-family:', EaEditor.KE_FONT_FAMILY, ';">');
		ks.append('<div style="', widthStyle, ';border:1px solid ');
		ks.append(EaEditor.KE_TOOLBAR_BORDER_COLOR, ';background-color:');
		ks.append(EaEditor.KE_TOOLBAR_BG_COLOR, '">');
		ks.append(EaEditor.KindCreateToolbar());
		ks.append('</div><div id="KindEditorIframe" style="', widthStyle, heightStyle); 
		ks.append('border:1px solid ', EaEditor.KE_FORM_BORDER_COLOR, ';border-top:0;">');
		
		ks.append('<iframe name="KindEditorForm" id="KindEditorForm" frameborder="0"  style="' );
		ks.append(iframeWidthStyle, iframeHeightStyle);
		ks.append('padding:0;margin:0;border:0;"></iframe></div>');
		if (EaEditor.KE_EDITOR_TYPE == 'full') {
			ks.append('<div id="KindEditTextarea" style="', widthStyle, heightStyle); 
			ks.append('border:1px solid ', EaEditor.KE_FORM_BORDER_COLOR, ';background-color:');
			ks.append(EaEditor.KE_FORM_BG_COLOR, ';border-top:0;display:none;">');
			ks.append('<textarea name="KindCodeForm" id="KindCodeForm" style="');
			ks.append(iframeWidthStyle, iframeHeightStyle); 
			ks.append('padding:0;margin:0;border:0;font-size:12px;line-height:16px;font-family:');
			ks.append(EaEditor.KE_FONT_FAMILY, ';background-color:', EaEditor.KE_FORM_BG_COLOR);
			ks.append(';" onclick="javascirit:EaEditor.KindDisableMenu();"></textarea></div>');
		}
		ks.append('<div id="menuDiv">');
		ks.append('</div>');
		ks.append('</div>');
		document.open();
		document.write(ks.toString());
		document.close();
		if (EaEditor.KE_BROWSER == 'IE') {
			EaEditor.KE_EDITFORM_DOCUMENT = document.frames("KindEditorForm").document;
		} else {
			EaEditor.KE_EDITFORM_DOCUMENT = document.getElementById('KindEditorForm').contentDocument;
		}
		EaEditor.KE_EDITFORM_DOCUMENT.designMode = 'On';
		EaEditor.KindWriteFullHtml(EaEditor.KE_EDITFORM_DOCUMENT, document.getElementById(eval(EaEditor.KE_OBJ_NAME).hiddenName).value);
		var el = EaEditor.KE_EDITFORM_DOCUMENT.body;
		if (EaEditor.KE_EDITFORM_DOCUMENT.addEventListener){
			EaEditor.KE_EDITFORM_DOCUMENT.addEventListener('click', EaEditor.KindDisableMenu, false); 
		} else if (el.attachEvent){
			el.attachEvent('onclick', EaEditor.KindDisableMenu);
		}
	}
	this.data = function()
	{
		var htmlResult;
		if (EaEditor.KE_BROWSER == '') {
			htmlResult = document.getElementById("KindCodeForm").value;
		} else {
			if (EaEditor.KE_EDITOR_TYPE == 'full') {
				var length = document.getElementById(EaEditor.KE_TOP_TOOLBAR_ICON[0][0]).src.length - 10;
				var image = document.getElementById(EaEditor.KE_TOP_TOOLBAR_ICON[0][0]).src.substr(length,10);
				if (image == 'source.gif') {
					htmlResult = EaEditor.KE_EDITFORM_DOCUMENT.body.innerHTML;
				} else {
					htmlResult = document.getElementById("KindCodeForm").value;
				}
			} else {
				htmlResult = EaEditor.KE_EDITFORM_DOCUMENT.body.innerHTML;
			}
		}
		//EaEditor.KindDisableMenu();
		htmlResult = EaEditor.KindHtmlToXhtml(htmlResult);
		htmlResult = EaEditor.KindClearScriptTag(htmlResult);
		document.getElementById(this.hiddenName).value = htmlResult;
		return htmlResult;
	}
	
}
var editor;
var Path;

var skinPath;
var editorHiddenName = "sContent";

EaEditor.KindSubmit = function()
{
    editor.data();    
}
EaEditor.finishUpload = function(url)
{
    EaEditor.KindImageType(2);
    EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgLink').value = url;
    EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgLink').style.display = 'none';
    EaEditor.KE_IMAGE_DOCUMENT.getElementById('imgFile').style.display = '';
    EaEditor.KindImagePreview();
    setTimeout(EaEditor.KindImagePreview,100);
}
EaEditor.initEditor = function(sPath,hiddenName,styleFlag,width,height)
{
    document.write("<div id='tb_body' style='font-family:Courier New;font-size:12px;margin:2px;}'>");      
    if(hiddenName)
    {
        editorHiddenName = hiddenName;
    }
    else
    {
        editorHiddenName = "sContent";
    }
    
    if(sPath)
    {
        Path = sPath;
    }
    else
    {
        Path = "";
    }
    if(height)
    {

    }
    else
    {
        height = "405px";
    }
    if(width)
    {
    }
    else
    {
        width = "810px";
    }

    switch(styleFlag)
    {
        case 0:
            skinPath = sPath + "skins/tiny/";
            EaEditor.tmpH = 40;
            break;
        case 1:
            skinPath = sPath + "skins/tiny/"; //默认
            break;
        case 2:
            skinPath = sPath + "skins/fck/";
            break;
        case 3:
            skinPath = sPath + "skins/default/";
            break;
        default : 
            skinPath = sPath + "skins/tiny/"; //默认
            break;
    }
    EaEditor.KE_CSS_PATH = sPath + "css.css";    
    editor = new EaEditor.KindEditor("editor");
    editor.hiddenName = editorHiddenName;
    editor.skinPath = skinPath ;
    EaEditor.picPath = skinPath  ;
    editor.iconPath = EaEditor.baseImgUrl;
    editor.imageAttachPath = "";
    editor.imageUploadCgi = "";
    editor.cssPath = "";
    editor.editorWidth = width;
    editor.editorHeight = height;
    editor.menuBorderColor = '#CCCCCC';
    editor.menuBgColor = '#F0F0EE';
    editor.menuTextColor = '#222222';
    editor.menuSelectedColor = '#CCCCCC';
    editor.toolbarBorderColor = '#CCCCCC';
    editor.toolbarBgColor = '#F0F0EE';
    editor.formBorderColor = '#CCCCCC';
    editor.buttonColor = '#DDDDDD';
    if(styleFlag==0)
    {
        editor.editorType = "simple";
    }
    editor.show();    
    EaEditor.writeStyle();
    EaEditor.makeMenu();    
    EaEditor.KE_EDITFORM_DOCUMENT.firstChild.oncontextmenu=function(){EaEditor.showMenu();return false}
    EaEditor.KE_EDITFORM_DOCUMENT.firstChild.onclick=function(){EaEditor.hideMenu()}
    document.onclick = function(){EaEditor.hideMenu()}
    document.write("</div>");
    if(styleFlag!=0)
    {
        document.write("<div style='font:30px;text-align:right;width:"+width+"'>");
        document.write("<img src='"+sPath+"\skins/\sizeplus.gif' onclick='EaEditor.sizeplus()' style='border:none;cursor:pointer' alt='加大高度'/>");
        document.write("<img src='"+sPath+"\skins/\sizeminus.gif' onclick='EaEditor.sizeminus()' style='border:none;cursor:pointer' alt='减小高度'/>");
        document.write("</div>");
    }
    EaEditor.KE_EDITFORM_DOCUMENT.body.onblur = EaEditor.KindSubmit;
    if(document.getElementById("KindCodeForm"))
    {
        document.getElementById("KindCodeForm").onblur = EaEditor.KindSubmit;
    }
}
EaEditor.sizeplus = function()
{
    var tmpH = document.getElementById("KindEditorForm").style.height.replace("px","") ;
    tmpH = parseInt(tmpH)+150 + "px"    
    document.getElementById("KindEditorForm").style.height= tmpH;
    document.getElementById("KindEditorIframe").style.height= tmpH;   

}
EaEditor.sizeminus = function()
{
    var tmpH = document.getElementById("KindEditorForm").style.height.replace("px","") ;
    if(parseInt(tmpH)<200)
    {
        return;
    }
    tmpH = parseInt(tmpH)-100 + "px"    
    document.getElementById("KindEditorForm").style.height= tmpH;
    document.getElementById("KindEditorIframe").style.height= tmpH;
}


//右键开始-------------------------------------------------
 EaEditor.contextMenu = function()
{
    this.items   = new Array();
    this.addItem = function (item)
    {
        this.items[this.items.length] = item;
    }
    this.show = function (oDoc)
    {
        var strShow = "";
        var i;
        strShow = "<div class='myTable' id=\"rightmenu\" style=\"BACKGROUND-COLOR: #ffffff; BORDER: #999 1px solid; LEFT: 0px; POSITION: absolute; TOP: 0px; VISIBILITY: hidden; Z-INDEX: 10\">";
        strShow += "<table border=\"0\" width=\"100px\" height=\"";
        strShow += this.items.length * 20;
        strShow += "\" cellpadding=\"0\" cellspacing=\"0\">";
        strShow += "<tr height=\"3\"><td bgcolor=\"#EFEFEF\" width=\"2\"></td><td>";
        strShow += "<table border=\"0\" width=\"100%\" height=\"100%\" cellpadding=0 cellspacing=0 bgcolor=\"#ffffff\">";
        strShow += "<tr><td bgcolor=\"#EFEFEF\" width=\"23\"></td><td><img src=\" \" height=\"1\" border=\"0\"></td></tr></table>";
        strShow += "</td><td width=\"2\"></td></tr>";
        strShow += "<tr><td bgcolor=\"#EFEFEF\"></td><td>";
        strShow += "<table border=\"0\" width=\"100%\" height=\"100%\" cellpadding=3 cellspacing=0 bgcolor=\"#ffffff\">";
        oDoc.write(strShow);
        for(i=0; i<this.items.length; i++)
        {
            this.items[i].show(oDoc);
        }
        strShow = "</table></td><td></td></tr>";
        strShow += "<tr height=\"3\"><td bgcolor=\"#EFEFEF\"></td><td>";
        strShow += "<table border=\"0\" width=\"100%\" height=\"100%\" cellpadding=0 cellspacing=0 bgcolor=\"#ffffff\">";
        strShow += "<tr><td bgcolor=\"#EFEFEF\" width=\"16\"></td><td><img src=\" \" height=\"1\" border=\"0\"></td></tr></table>";
        strShow += "</td><td></td></tr>";
        strShow += "</table></div>\n";
        oDoc.write(strShow);
    }
}

// menu Item object
EaEditor.contextItem = function(text, icon, cmd, type)
{
    this.text = text ? text : "";
    this.icon = icon ? icon : "";
    this.cmd = cmd ? cmd : "";
    this.type = type ? type : "menu";
    this.show = function (oDoc)
    {
        var strShow = "";
        if(this.type == "menu")
        {
            strShow += "<tr ";
            strShow += "onmouseover=\"EaEditor.changeStyle(this, 'on');\" ";
            strShow += "onmouseout=\"EaEditor.changeStyle(this, 'out');\" ";
            strShow += "onmousedown=\"";
            strShow += this.cmd;
            strShow += "\">";
            strShow += "<td class=\"ltdexit\" width=\"16\">";
            if (this.icon == "")
                strShow += "&nbsp;";
            else
            {
                strShow += "<img border=\"0\" src=\"";
                strShow += this.icon;
                strShow += "\" width=\"16\" height=\"16\" style=\"POSITION: relative\"></img>";
            }
        strShow += "</td><td class=\"mtdexit\">";
        strShow += this.text;
        strShow += "</td><td class=\"rtdexit\" width=\"5\">&nbsp;</td></tr>";
        }
        else if (this.type == "separator")
        {
            strShow += "<tr><td class=\"ltdexit\">&nbsp;</td>";
            strShow += "<td class=\"mtdexit\" colspan=\"2\"><hr color=\"#999\" size=\"1\"></td></tr>";
        }
        oDoc.write(strShow);
    }
}

EaEditor.changeStyle = function(obj, cmd)
{ 
    if(obj)
    try 
    {
        var imgObj = obj.children(0).children(0);
        if(cmd == 'on')
        {
            obj.children(0).className = "ltdfocus";
            obj.children(1).className = "mtdfocus";
            obj.children(2).className = "rtdfocus";
            if(imgObj)
            {
                if(imgObj.tagName.toUpperCase() == "IMG")
                {
                 imgObj.style.left = "-1px";
                 imgObj.style.top = "-1px";
                }
            }
        }
        else if(cmd == 'out')
        {
            obj.children(0).className = "ltdexit";
            obj.children(1).className = "mtdexit";
            obj.children(2).className = "rtdexit";
            if(imgObj)
            {
                if(imgObj.tagName.toUpperCase() == "IMG")
                {
                    imgObj.style.left = "0px";
                    imgObj.style.top = "0px";
                }
            }
         }
    }
    catch (e)
    {
    }
}
EaEditor.tmpH = 65;
EaEditor.showMenu = function()
{

    var x, y, w, h, ox, oy;

    var x0 = document.getElementById("tb_body").offsetLeft;
    var y0 = document.getElementById("tb_body").parentNode.offsetTop;
    x = document.frames("KindEditorForm").event.clientX + x0;
    y = document.frames("KindEditorForm").event.clientY + y0 + EaEditor.tmpH -EaEditor.getScrollTop();

    var obj = document.getElementById("rightmenu");
    if (obj == null)
    return true;

    ox = document.body.clientWidth;
    oy = document.body.clientHeight;
    if(x > ox || y > oy)
    return false;
    w = obj.offsetWidth;
    h = obj.offsetHeight;
    if((x + w) > ox)
    x = x - w;
    if((y + h) > oy)
    y = y - h;
    obj.style.posLeft = x + document.body.scrollLeft;
    obj.style.posTop = y + document.body.scrollTop;
    obj.style.visibility = "visible";
    return false;
}
EaEditor.hideMenu = function()
{
    var obj = document.getElementById("rightmenu");
    if (obj == null)
    return true;
    obj.style.visibility = "hidden";
    obj.style.posLeft = 0;
    obj.style.posTop = 0;
}
EaEditor.writeStyle = function()
{
    var strStyle = "";
    strStyle += "<STYLE type=text/css>";
    strStyle += "TABLE {Font-FAMILY: \"Tahoma\",\"Verdana\",\"宋体\"; FONT-SIZE: 9pt}";
    strStyle += ".mtdfocus {BACKGROUND-COLOR: #eee; BORDER-BOTTOM: #999 1px solid; BORDER-TOP: #999 1px solid; CURSOR: hand}";
    strStyle += ".mtdexit {BACKGROUND-COLOR: #ffffff; BORDER-BOTTOM: #ffffff 1px solid; BORDER-TOP: #ffffff 1px solid}";
    strStyle += ".ltdfocus {BACKGROUND-COLOR: #eee; BORDER-BOTTOM: #999 1px solid; BORDER-TOP: #999 1px solid; BORDER-LEFT: #999 1px solid; CURSOR: hand}";
    strStyle += ".ltdexit {BACKGROUND-COLOR: #EFEFEF; BORDER-BOTTOM: #EFEFEF 1px solid; BORDER-TOP: #EFEFEF 1px solid; BORDER-LEFT: #EFEFEF 1px solid}";
    strStyle += ".rtdfocus {BACKGROUND-COLOR: #eee; BORDER-BOTTOM: #999 1px solid; BORDER-TOP: #999 1px solid; BORDER-RIGHT: #999 1px solid; CURSOR: hand}";
    strStyle += ".rtdexit {BACKGROUND-COLOR: #ffffff; BORDER-BOTTOM: #ffffff 1px solid; BORDER-TOP: #ffffff 1px solid; BORDER-RIGHT: #ffffff 1px solid}";
    strStyle += ".myTable td{ border:none;margin:0;padding:0;color:#333;}";
    strStyle += "</STYLE>";
    document.write(strStyle);
}
EaEditor.picPath = EaEditor.KE_SKIN_PATH; 
EaEditor.makeMenu = function()
{
    var myMenu, item;
    myMenu = new EaEditor.contextMenu();
    item = new EaEditor.contextItem("&nbsp剪&nbsp&nbsp切", ""+skinPath+"cut.gif", "EaEditor.KindExecute('KE_CUT');", "menu");
    myMenu.addItem(item);
    item = new EaEditor.contextItem("&nbsp复&nbsp&nbsp制", ""+skinPath+"copy.gif","EaEditor.KindExecute('KE_COPY');", "menu");
    myMenu.addItem(item);
    item = new EaEditor.contextItem("&nbsp粘&nbsp&nbsp贴",  ""+skinPath+"paste.gif", "EaEditor.KindExecute('KE_PASTE');", "menu");
    myMenu.addItem(item);
    item = new EaEditor.contextItem("", "", "", "separator");
    myMenu.addItem(item);
    item = new EaEditor.contextItem("&nbsp清除格式", ""+skinPath+"removeformat.gif", "EaEditor.KindExecute('KE_REMOVE');", "menu");
    myMenu.addItem(item);
    myMenu.show(window.document);
    delete item;
    delete myMenu;
}
EaEditor.toggleMenu = function(isEnable)
{
    if(isEnable)
        KindEditorForm.oncontextmenu = EaEditor.showMenu;
    else
        KindEditorForm.oncontextmenu = new function() {return true;};
}

//取窗口滚动条高度 
EaEditor.getScrollTop = function()
{
    var scrollTop=0;
    if(document.documentElement&&document.documentElement.scrollTop)
    {
        scrollTop=document.documentElement.scrollTop;
    }
    else if(document.body)
    {
        scrollTop=document.body.scrollTop;
    }
    return scrollTop;
}

//右键结束-------------------------------------------------


//赋初值

EaEditor.setEidtorHtml = function (contentID,html)
{
    EaEditor.KE_EDITFORM_DOCUMENT.body.innerHTML = html;
    if(document.getElementById(contentID))
    {
        document.getElementById(contentID).value=html;
    }    
}
