﻿
var Utility = {
    /// <summary>JS公共类</summary>
};

///浏览器类型
//浏览器类型
Utility.Brower =
{
    /// <summary>
    /// 判断浏览器类型
    /// </summary>
    /// <returns>{IsIE 等}</returns>
    IsIE: true,
    IsFF: false,
    IsIE5: false,
    IsIE6: false,
    IsIE7: true,
    IsOpera: false,
    IsBox: true
};
(function(b)
{
    var ua = navigator.userAgent;
    var opera = /opera [56789]|opera\/[56789]/i.test(ua);
    var ie = !opera && /MSIE/.test(ua);
    b.IsOpera = opera;
    b.IsIE = ie;
    b.IsIE5 = ie && /MSIE 5\.[01234]/.test(ua);
    b.IsIE6 = ie && /MSIE 6/.test(ua);
    b.IsIE7 = ie && /MSIE 7/.test(ua);
    b.IsBox = ie && (document.compatMode == null || document.compatMode != "CSS1Compat");
    var webkit = /webkit/i.test(ua);
    b.IsFF = !opera && !webkit && /gecko/i.test(ua);
}
)(Utility.Brower);

Utility.StringBuffer = function()
{
    /// <summary>
    /// StringBuffer类
    /// </summary>
    /// <returns>StringBuffer对象</returns>
    this._string = new Array();
    if(arguments.length > 0)
    {
        Array.prototype.push.apply(this._string, arguments);
    }
}

Utility.StringBuffer.prototype.Append = function()
{
    /// <summary>
    /// StringBuffer类Append方法，支持多个添加
    /// </summary>
    if(arguments.length > 0)
    {
        Array.prototype.push.apply(this._string, arguments);
    }
}

Utility.StringBuffer.prototype.AppendFormat = function()
{
    /// <summary>
    /// StringBuffer类AppendFormat方法
    /// </summary>
    var str = arguments[0];
    var reg = /\{\d+\}/g;
    var strReg = str.match(reg);
    var index;
    for(var i = 0; i < strReg.length; i++)
    {
        index = parseInt(strReg[i].substring(1, strReg[i].length - 1));
        str = str.replace(strReg[i], arguments[index + 1]);
    }
    this._string.push(str);
}

Utility.StringBuffer.prototype.ToString = function()
{
    ///<summary>StringBuffer类ToString方法</summary>
    return this._string.join("");
}
Utility.StringBuffer.prototype.toString = function()
{
    return this.ToString();
}


Utility.Ajax = {
    /// <summary>Ajax类</summary>
};
//封装XMLHttpRequest（IE）对象
if (window.ActiveXObject && !window.XMLHttpRequest)
{
    window.XMLHttpRequest = function()
    {
        var MSXML = new Array("Msxml2.XMLHTTP", "Microsoft.XMLHTTP");
        for(var i = 0; i < MSXML.length; i++)
        {
            try
            {
                return new ActiveXObject(MSXML[i]);
            }
            catch(e) { }
        }
        
        return null;
    }
}
Utility.Ajax.Request = function(jsonObj)
{
    /// <summary>发送Ajax请求</summary>
    var xmlHttp = new XMLHttpRequest();
    var method = jsonObj.method ? jsonObj.method : "POST";
    var url = jsonObj.url;
    var showProcess = jsonObj.showProcess;
    var param = "";
    if(jsonObj.param)
    {
        if(jsonObj.param.constructor == String)
        {
            param = jsonObj.param;
        }
        else
        {
            for(var name in jsonObj.param)
            {
                param += name + "=" + encodeURIComponent(jsonObj.param[name]) + "&";
            }
            param = param.length == 0 ? "" : param.substring(0, param.length - 1);
        }
    }
    var success = jsonObj.success;
    var failure = jsonObj.failure;
    var after = jsonObj.after;
    
    if(showProcess == undefined || showProcess == true)
    {
        Utility.Ajax.Begin();
    }
    
	if(method.toUpperCase() == "POST")
	{
	    //POST
	    xmlHttp.open("POST", url, true);
	    xmlHttp.setRequestHeader("content-length", param.length);
        xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        xmlHttp.send(param);
    }
    else
    {
        //GET
        if(param.length > 0)
        {
            if(url.indexOf("?") == -1)
            {
                url += "?" + param;
            }
            else
            {
                url += "&" + param;
            }
        }
        xmlHttp.open("GET", url, true);
        xmlHttp.send(null);
    }
    xmlHttp.onreadystatechange = function()
    {
        if (xmlHttp.readyState == 4)
		{
		    var func = new Array();
		    var execFun;
		    func.push(xmlHttp.status == 200 ? success : failure);
		    
		    if(after)
		    {
		        func.push(after);
		    }
		    
		    Utility.Ajax.End();
		    for(var i = 0; i < func.length; i++)
		    {
		        execFun = typeof func[i] == "function" ? func[i] : new Function(func[i]);
		        execFun(xmlHttp);
		    }
		}
	}
}

Utility.Ajax.Begin = function()
{
    /// <summary>进度条启动</summary>
    if(document.body)
    {
        var t_span = document.getElementById("processbar_div");
        if(!t_span)
        {
            var t_span = document.createElement("span");
	        t_span.id = "processbar_div";
	        t_span.style.position = "absolute";
	        t_span.style.backgroundColor = "#ffffba";
	        t_span.style.border = "solid 1px #9db3c5";
	        t_span.style.right = "25px";
	        t_span.style.top = "10px";
	        t_span.style.zIndex = 1000;
	        t_span.style.fontSize = "12px";
	        t_span.style.padding = "2px";
	        t_span.innerHTML = "&nbsp;loading data...&nbsp;&nbsp;";
	        document.body.appendChild(t_span);
        }
        else
        {
            t_span.style.display = "";
	        t_span.style.top = document.body.scrollTop + 10;
        }
    }
}

Utility.Ajax.End = function()
{
    /// <summary>进度条关闭</summary>
    if(document.getElementById("processbar_div"))
    {
	    document.getElementById("processbar_div").style.display="none";
	}
}

Utility.QueryString = function(key)
{
    /// <summary>获取URL中GET参数值</summary>
    var search = location.search;
    if(search.indexOf("?") == 0)
    {
        search = search.substring(1);
    }
    var split = search.split("&");
    var reg;
    for(var i = 0; i < split.length; i++)
    {
        if(split[i].indexOf(key + "=") == 0)
        {
            return unescape(split[i].substring(key.length + 1));
        }
    }
    
    return "";
}

Utility.Event = {
    /// <summary>添加事件</summary>
};
Utility.Event.Add = function(el, eventType, hander)
{
    if(Utility.Brower.IsIE)
    {
        el.attachEvent("on" + eventType, hander);
    }
    else
    {
        el.addEventListener(eventType, hander, false);
    }
}

Utility.Event.Remove = function(el, eventType, hander)
{
    /// <summary>移除事件</summary>
    if(Utility.Brower.IsIE)
    {
        el.detachEvent("on" + eventType, hander);
    }
    else
    {
        el.removeEventListener(eventType, hander, false);
    }
}

Utility.Script = function()
{
    /// <summary>脚本操作类</summary>
    this.allScript = document.getElementsByTagName("script");
}

Utility.Script.prototype.Append = function(src, func)
{
    /// <summary>载入脚本文件AJAX</summary>
    if (this.IsExists(src))
    {
        Utility.Script.Exec(func);
        return;
    }
    
    //AJAX取得JS脚本内容
    function getCode(result)
    {
        var jsCode = result.responseText;
        var _script = document.createElement("script");
        _script.type = "text/javascript";
        _script.text = jsCode;
        _script.id = src;
        document.getElementsByTagName("head")[0].appendChild(_script);
        Utility.Script.Exec(func);
        _script = null;
    }
    
    Utility.Ajax.Request({url: src, method: "GET", success: getCode});
    src = null;
    func = null;
}

Utility.Script.Append = function(src)
{
    /// <summary>载入脚本文件DOM</summary>
    var _script = document.createElement("script");
    _script.language = "javascript";
    _script.type = "text/javascript";
    _script.id= src;
    _script.src= src;
}

Utility.Script.prototype.IsExists = function(id)
{
    /// <summary>判断给与的Id是否已存在</summary>
    var script = this.allScript;
    for(var i = 0; i < script.length; i++)
    {
        if(script[i].id == id)
        {
            //存在
            return true;
        }
    }
    
    //不存在
    return false;
}

Utility.Script.Exec = function(func)
{
    /// <summary>执行方法</summary>
    if(func)
    {
        var execFun = typeof func == "function" ? func : new Function(func);
        execFun();
    }
}

///String原型
String.prototype.NoHarmCode = function()
{
    /// <summary>过滤&号和+号</summary>
    return this.replace(/&/g, "%26").replace(/\+/g, "%2b");
}

String.prototype.Trim = function()
{
    /// <summary>删除字符串首尾空格</summary>
    return this.replace(/^\s*|\s*$/g, "");
}

String.prototype.Format = function()
{
    /// <summary>Format方法</summary>
    var str = this;
    var reg = /\{\d+\}/g;
    var strReg = str.match(reg);
    var index;
    for(var i = 0; i < strReg.length; i++)
    {
        index = parseInt(strReg[i].substring(1, strReg[i].length - 1));
        str = str.replace(strReg[i], arguments[index]);
    }
    
    return str;
}
String.prototype.HTMLEncode = function()
{
    /// <summary></summary>
    return this.replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
}
String.prototype.HTMLEncode = function()
{
    /// <summary></summary>
    return this.replace(/&amp;/g, "&").replace(/&quot;/g, "\"").replace(/&lt;/g, "<").replace(/&gt;/g, ">") ;
}
//扩展document的getElementsByClassName
document.getElementsByClassName = function(className,oBox) 
{
	/// <summary>适用于获取某个HTML区块内部含有某一特定className的所有HTML元素</summary>
	this.d= oBox || document;
	var children = this.d.getElementsByTagName('*') || document.all;
	var elements = new Array();
	for (var ii = 0; ii < children.length; ii++) {
		var child = children[ii];
		if(child.className==className)
		{
		    elements.push(child);
			continue;
		}
		var classNames = child.className.split(' ');
		for (var j = 0; j < classNames.length; j++) 
		{
			if (classNames[j] == className) 
			{
				elements.push(child);
				continue;
			}
		}
	}
	return elements;
}

function numonly(obj) 
{ 
    /// <summary>只允许数字</summary>
	obj.value=obj.value.replace(/\D/g,'');
}

//extend json object
function Extend(dst, src, replace) {
    if (!dst) return;
    for (var prop in src) {
        if (!replace && dst[prop] != null) { continue; }
        dst[prop] = src[prop];
    }
    return dst;
};

Utility.setCookie = function(name, value, days, path, domain) {
    var expires = new Date();
    if (days) {
        expires.setTime(expires.getTime() + 3600000 * days);
    } else {
        expires.setTime(expires.getTime() + 3600000 * 24 * 365);
    }
    //window.document.cookie = name + "=" + value + "; " + (days ? ("expires=" + expires.toGMTString() + "; ") : "") + (path ? ("path=" + path + "; ") : "path=/; domain=sbdz.com;"); //+(domain ? ("domain=" + domain + ";") : ("domain=" + window.location.host.substr(window.location.host.indexOf(".")+1) + ";"));
    if (window.location.host.indexOf("localhost") != -1 || window.location.host.indexOf("192.168") != -1)
        window.document.cookie = name + "=" + value + "; " + ("expires=" + expires.toGMTString() + "; path=/;");
    else
        window.document.cookie = name + "=" + value + "; " + ("expires=" + expires.toGMTString() + "; path=/; domain=moralsoft.com;");
    return true;
};
Utility.getCookie = function(name) {
    // var arr = window.document.cookie.match(new RegExp("(?:^|;+|\\s+)" + name + "=([^;]*)"));
    // return !arr ? null : arr[1];
    //alert(document.cookie);
    var arr = document.cookie.match(new RegExp("(^| )" + name + "=([^;]*)(;|$)"));
    if (arr != null) return arr[2]; return null;
};
Utility.removeCookie = function(name, domain, path) {
    if (window.location.host.indexOf("localhost") != -1 || window.location.host.indexOf("192.168") != -1)
        window.document.cookie = name + "=1; expires=Fri, 31 Dec 1999 23:59:59 GMT;";
    else
        window.document.cookie = name + "=1; expires=Fri, 31 Dec 1999 23:59:59 GMT; path=/; domain=moralsoft.com;";
};