/*                 JQuery 为 Visual Studio 中文智能感知
 * 修改到1116行
 * **************************************************************
 * ************ CONTAINS NO FUNCTIONAL JQUERY CODE **************
 * **************************************************************
 * 
 *
 * 
 * 资源:
 *     API 版本: 1.2.3
 *     文档编写版本: 1.1.2
 * 
 * JQuery is Copyright (c) John Resig (jquery.com)
 * 中文智能感知汉化.iceface
 */
 
 
jQuery = $ = function (expr, context) {
	/// <summary>
	///    这个函数接收一个包含 CSS 选择器的字符串，然后用这个字符串去匹配一组元素。 
	///    jQuery 的核心功能都是通过这个函数实现的。 jQuery中的一切都构建于这个函数之上，或者说都是在以某种方式使用这个函数。
	///    这个函数最基本的用法就是向它传递一个表达式（通常由 CSS 选择器组成），然后根据这个表达式来查找所有匹配的元素。
	///    默认情况下, 如果没有指定context参数，$()将在当前的 HTML 文档中查找 DOM 元素；如果指定了 context 参数，如一个 DOM 元素集或 jQuery 对象	
	///，那就会在这个 context 中查找。参考 Selectors 获取更多用于 expression 参数的 CSS 语法的信息
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr">
	///    0.context (Element, jQuery):(可选) 作为待查找的 DOM 元素集、文档或 jQuery 对象。
	///    1: expr - 用来查找的字符串
	///    2: html - 用于动态创建DOM元素的HTML标记字符串.
	///    3: elems - 用于封装成jQuery对象的DOM元素
	///    4: fn - 当DOM加载完成后要执行的函数,$(document).ready()的简写
	/// </param>
	/// <param name="context" optional="true"> (可选) 作为待查找的 DOM 元素集、文档或 jQuery 对象</param>
};

$.prototype = {
	offset: function(){
	    ///<summary>
		///    获取匹配元素在当前视口的相对偏移。返回的对象包含两个整形属性：top 和 left。此方法只对可见元素有效
		///</summary>
		/// <returns type="object">Object{top,left}</returns>
	},
	dequeue: function(a){
	 ///<summary>
	///    从动画队列中移除一个队列函数
	///</summary>
	/// <param name="a" >对象名称</param>
	/// <returns type="jQuery"></returns>
	},
	stop: function(b,c){},
	queue: function(a,b){},
	animate: function (params, speed, easing, callback) {
	/// <summary>
	///用于创建自定义动画的函数。
	///这个函数的关键在于指定动画形式及结果样式属性对象。这个对象中每个属性都表示一个可以变化的样式属性（如“height”、“top”或“opacity”）。 
	///注意：所有指定的属性必须用骆驼形式，比如用marginLeft代替margin-left. 
	///而每个属性的值表示这个样式属性到多少时动画结束。如果是一个数值，样式属性就会从当前的值渐变到指定的值。如果使用的是“hide”、“show”或“toggle”这样的字符串值，则会为该属性调用默认的动画形式。
	///在 jQuery 1.2 中，你可以使用 em 和 % 单位。另外，在 jQuery 1.2 中，你可以通过在属性值前面指定 "+=" 或 "-=" 来让元素做相对运动
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="params"> 一组包含作为动画属性和终值的样式属性和及其值的集合.</param>
	/// <param name="speed" optional="true">(可选)speed (String,Number) : (可选) 三种预定速度之一的字符串("slow", "normal", or "fast")或表示动画时长的毫秒数值(如：1000).</param>
	/// <param name="easing" optional="true">(可选)easing (String) : 要使用的擦除效果的名称(需要插件支持).默认jQuery提供"linear" 和 "swing".</param>
	/// <param name="callback" optional="true">(可选) 在动画完成时执行的函数.</param>
},
	fadeTo: function (speed, opacity, callback) {
	/// <summary>
	///把所有匹配元素的不透明度以渐进方式调整到指定的不透明度，并在动画完成后可选地触发一个回调函数。
	///这个动画只调整元素的不透明度，也就是说所有匹配的元素的高度和宽度不会发生变化
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="speed">三种预定速度之一的字符串("slow", "normal", or "fast")或表示动画时长的毫秒数值(如：1000).</param>
	/// <param name="opacity">要调整到的不透明度值(0到1之间的数字)..</param>
	/// <param name="callback" optional="true">(可选)在动画完成时执行的函数.</param>
},
	fadeOut: function (speed, callback) {
	/// <summary>
	///	通过不透明度的变化来实现所有匹配元素的淡出效果，并在动画完成后可选地触发一个回调函数。
	///	这个动画只调整元素的不透明度，也就是说所有匹配的元素的高度和宽度不会发生变化
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="speed" optional="true">三种预定速度之一的字符串("slow", "normal", or "fast")或表示动画时长的毫秒数值(如：1000).</param>
	/// <param name="callback" optional="true">(可选) 在动画完成时执行的函数.</param>
},
	fadeIn: function (speed, callback) {
	/// <summary>
	///	通过不透明度的变化来实现所有匹配元素的淡入效果，并在动画完成后可选地触发一个回调函数。
	///	这个动画只调整元素的不透明度，也就是说所有匹配的元素的高度和宽度不会发生变化
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="speed" optional="true">三种预定速度之一的字符串("slow", "normal", or "fast")或表示动画时长的毫秒数值(如：1000).</param>
	/// <param name="callback" optional="true">(可选) 在动画完成时执行的函数.</param>
},
	slideToggle: function (speed, callback) {
	/// <summary>
	///	通过高度变化来切换所有匹配元素的可见性，并在切换完成后可选地触发一个回调函数。
	///	这个动画效果只调整元素的高度，可以使匹配的元素以“滑动”的方式隐藏或显示
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="speed" optional="true">speed (String,Number) : 三种预定速度之一的字符串("slow", "normal", or "fast")或表示动画时长的毫秒数值(如：1000).</param>
	/// <param name="callback" optional="true">(可选) 在动画完成时执行的函数.</param>
},
	slideUp: function (speed, callback) {
	/// <summary>
	///	通过高度变化（向上减小）来动态地隐藏所有匹配的元素，在隐藏完成后可选地触发一个回调函数。
	///	这个动画效果只调整元素的高度，可以使匹配的元素以“滑动”的方式隐藏起来
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="speed" optional="true">speed (String,Number) : 三种预定速度之一的字符串("slow", "normal", or "fast")或表示动画时长的毫秒数值(如：1000).</param>
	/// <param name="callback" optional="true">(可选) 在动画完成时执行的函数.</param>
},
	slideDown: function (speed, callback) {
	/// <summary>
	///	通过高度变化（向下增大）来动态地显示所有匹配的元素，在显示完成后可选地触发一个回调函数。
	///	这个动画效果只调整元素的高度，可以使匹配的元素以“滑动”的方式显示出来
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="speed" optional="true">三种预定速度之一的字符串("slow", "normal", or "fast")或表示动画时长的毫秒数值(如：1000).</param>
	/// <param name="callback" optional="true">(可选) 在动画完成时执行的函数.</param>
},
	_toggle: function(){},
	hide: function (speed, callback) {
	/// <summary>
	///	隐藏显示的元素
	///	这个就是 'hide( speed, [callback] )' 的无动画版。如果选择的元素是隐藏的，这个方法将不会改变任何东西.
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="speed" optional="true"> 三种预定速度之一的字符串("slow", "normal", or "fast")或表示动画时长的毫秒数值(如：1000)</param>
	/// <param name="callback" optional="true"> (可选) 在动画完成时执行的函数. </param>
},
	show: function (speed, callback) {
	/// <summary>
	///	显示隐藏的匹配元素。
	///	这个就是 'show( speed, [callback] )' 无动画的版本。如果选择的元素是可见的，这个方法将不会改变任何东西。
	///	无论这个元素是通过hide()方法隐藏的还是在CSS里设置了display:none;，这个方法都将有效
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="speed" optional="true"> 三种预定速度之一的字符串("slow", "normal", or "fast")或表示动画时长的毫秒数值(如：1000)</param>
	/// <param name="callback" optional="true"> (可选) 在动画完成时执行的函数. </param>
},
	ajaxSend: function (callback) {
	/// <summary>
	///	AJAX 请求发送前执行函数.Ajax 事件.XMLHttpRequest 对象和设置作为参数传递给回调函数
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="callback">待执行函数.</param>
},
	ajaxSuccess: function (callback) {
	/// <summary>
	///	AJAX 请求成功时执行函数.Ajax 事件.XMLHttpRequest 对象和设置作为参数传递给回调函数
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="callback">待执行函数.</param>
},
	ajaxError: function (callback) {
	/// <summary>
	///	AJAX 请求发生错误时执行函数.Ajax 事件.XMLHttpRequest 对象和设置作为参数传递给回调函数。捕捉到的错误可作为最后一个参数传递
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="callback">待执行函数.</param>
},
	ajaxComplete: function (callback) {
	/// <summary>
	///	AJAX 请求完成时执行函数。Ajax 事件。XMLHttpRequest 对象和设置作为参数传递给回调函数
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="callback">待执行函数.</param>
},
	ajaxStop: function (callback) {
	/// <summary>
	///	AJAX 请求结束时执行函数。Ajax 事件
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="callback">待执行函数.</param>
},
	ajaxStart: function (callback) {
	/// <summary>
	///	AJAX 请求开始时执行函数。Ajax 事件
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="callback">待执行函数.</param>
},
	serializeArray: function(){
	/// <summary>
	///	序列化表格元素 (类似 '.serialize()' 方法) 返回 JSON 数据结构数据
	/// </summary>
	/// <returns type="jQuery"></returns>		
},
	serialize: function () {
	/// <summary>
	///	序列表表格内容为字符串
	/// </summary>
	/// <returns type="jQuery"></returns>
},
	error: function (fn) {
	/// <summary>
	///	这个函数会调用执行绑定到error事件的所有函数，包括浏览器的默认行为。可以通过在某个绑定的函数中返回false来防止触发浏览器的默认行为
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的keyup事件中绑定的处理函数.</param>
},
	keyup: function (fn) {
	/// <summary>
	///	触发每一个匹配元素的keyup事件这个函数会调用执行绑定到keyup事件的所有函数，包括浏览器的默认行为。
	///	可以通过在某个绑定的函数中返回false来防止触发浏览器的默认行为。keyup事件会在按键释放时触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的keyup事件中绑定的处理函数.</param>
},
	keypress: function (fn) {
	/// <summary>
	///	在每一个匹配元素的keypress事件中绑定一个处理函数。
	///	keypress事件会在敲击按键时触发。 敲击按键的定义为按下并抬起同一个按键。这几个事件发生的顺序是: 
	///	keydown,keyup,keypress
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的keyup事件中绑定的处理函数.</param>
},
	keydown: function (fn) {
	/// <summary>
	///	在每一个匹配元素的keydown事件中绑定一个处理函数。keydown事件会在键盘按下时触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的keydown事件中绑定的处理函数.</param>
},
	submit: function (fn) {
	/// <summary>
	///	触发每一个匹配元素的submit事件。
	///	这个函数会调用执行绑定到submit事件的所有函数，包括浏览器的默认行为。可以通过在某个绑定的函数中返回false来防止触发浏览器的默认行为
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn" optional="true">在每一个匹配元素的submit事件中绑定的处理函数</param>
},
	select: function (fn) {
	/// <summary>
	///	触发每一个匹配元素的select事件这个函数会调用执行绑定到select事件的所有函数，
	///	包括浏览器的默认行为。可以通过在某个绑定的函数中返回false来防止触发浏览器的默认行为
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn" optional="true">在每一个匹配元素的submit事件中绑定的处理函数 </param>
},
	change: function (fn) {
	/// <summary>
	///	在每一个匹配元素的change事件中绑定一个处理函数.change事件会在元素失去焦点的时候触发，也会当其值在获得焦点后改变时触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的submit事件中绑定的处理函数.</param>
},
	mouseout: function (fn) {
	/// <summary>
	///	在每一个匹配元素的mouseout事件中绑定一个处理函数。mousedown事件在鼠标从元素上离开后会触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的submit事件中绑定的处理函数.</param>
},
	mouseover: function (fn) {
	/// <summary>
	///	在每一个匹配元素的mouseover事件中绑定一个处理函数。mouseout事件会在鼠标移入对象时触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的mousemove事件中绑定的处理函数.</param>
},
	mousemove: function (fn) {
	/// <summary>
	///	在每一个匹配元素的mousemove事件中绑定一个处理函数.mousemove 事件通过鼠标在元素上移动来触发。事件处理函数会被传递一个变量——事件对象，其.clientX 和 .clientY 属性代表鼠标的坐标
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的mousemove事件中绑定的处理函数..</param>
},
	mouseup: function (fn) {
	/// <summary>
	///	在每一个匹配元素的mouseout事件中绑定一个处理函数。mousedown事件在鼠标从元素上离开后会触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的mouseout事件中绑定的处理函数.</param>
},
	mousedown: function (fn) {
	/// <summary>
	///	在每一个匹配元素的mousedown事件中绑定一个处理函数。mousedown事件在鼠标在元素上点击后会触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的mousedown事件中绑定的处理函数.</param>
},
	dblclick: function (fn) {
	/// <summary>
	///	1.在每一个匹配元素的dblclick事件中绑定一个处理函数。的那个在某个元素上双击的时候就会触发dblclick事件
	///		触发每一个匹配元素的dbclick事件。
	///	2.这个函数会调用执行绑定到dblclick事件的所有函数，包括浏览器的默认行为。可以通过在某个绑定的函数中返回false来防止触发浏览器的默认行为。
	///		dblclick事件会在元素的同一点双击时触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的mousedown事件中绑定的处理函数.</param>
},
	click: function (fn) {
	/// <summary>
	///	在每一个匹配元素的click事件中绑定一个处理函数。
	///	点击事件会在你的指针设备的按钮在元素上单击时触发。单击的定义是在屏幕的同一点触发了mousedown和mouseup.常用的事件有如下的 
	///	mousedown,mouseup,click
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn" optional="true">绑定到click事件的函数</param>
},
	unload: function (fn) {
	/// <summary>
	///	在每一个匹配元素的unload事件中绑定一个处理函数
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的unload事件中绑定的处理函数.</param>
},
	scroll: function (fn) {
	/// <summary>
	///	在每一个匹配元素的resize事件中绑定一个处理函数.当滚动条发生变化时触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的resize事件中绑定的处理函数.</param>
},
	resize: function (fn) {
	/// <summary>
	///	在每一个匹配元素的resize事件中绑定一个处理函数。当文档窗口改变大小时触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">在每一个匹配元素的resize事件中绑定的处理函数.</param>
},
	load: function (fn, params, callback) {
	/// <summary>
	///	在每一个匹配元素的load事件中绑定一个处理函数。
	///	如果绑定给window对象，则会在所有内容加载后触发，包括窗口，框架，对象和图像。如果绑定在元素上，则当元素的内容加载完毕后触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">
	///    1: fn - 在每一个匹配元素的load事件中绑定的处理函数.
	///    2: url - 导入一个url地址.
	/// </param>
	/// <param name="params" optional="true">(可选)发生一个键值对到服务端</param>
	/// <param name="callback" optional="true">(可选)如果绑定在元素上，则当元素的内容加载完毕后触发 </param>
},
	focus: function (fn) {
	/// <summary>
	///	在每一个匹配元素的focus事件中绑定一个处理函数。focus事件可以通过鼠标点击或者键盘上的TAB导航触发
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn" optional="true">在每一个匹配元素的focus事件中绑定的处理函数</param>
},
	blur: function (fn) {
	/// <summary>
	///	在每一个匹配元素的blur事件中绑定一个处理函数。blur事件会在元素失去焦点的时候触发，既可以是鼠标行为，也可以是按tab键离开的
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn" optional="true">在每一个匹配元素的blur事件中绑定的处理函数</param>
},
	ready: function (fn) {
	/// <summary>
	///	当DOM载入就绪可以查询及操纵时绑定一个要执行的函数。
	///	这是事件模块中最重要的一个函数，因为它可以极大地提高web应用程序的响应速度。
	///	简单地说，这个方法纯粹是对向window.load事件注册事件的替代方法。通过使用这个方法，
	///	可以在DOM载入就绪能够读取并操纵时立即调用你所绑定的函数，
	///	而99.99%的JavaScript函数都需要在那一刻执行。
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">要在DOM就绪时执行的函数.</param>
},
	hover: function (over, out) {
	/// <summary>
	///	一个模仿悬停事件（鼠标移动到一个对象上面及移出这个对象）的方法。这是一个自定义的方法，
	///	它为频繁使用的任务提供了一种“保持在其中”的状态。
	///	当鼠标移动到一个匹配的元素上面时，会触发指定的第一个函数。当鼠标移出这个元素时，会触发指定的第二个函数。而且，
	///	会伴随着对鼠标是否仍然处在特定元素中的检测（例如，处在div中的图像），
	///	如果是，则会继续保持“悬停”状态，而不触发移出事件（修正了使用mouseout事件的一个常见错误
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="over">鼠标移到元素上要触发的函数.</param>
	/// <param name="out">鼠标移出元素要触发的函数.</param>
},
	toggle: function (even, odd) {
	/// <summary>
	///	每次点击时切换要调用的函数。
	///	如果点击了一个匹配的元素，则触发指定的第一个函数，当再次点击同一元素时，则触发指定的第二个函数。
	///	随后的每次点击都重复对这两个函数的轮番调用。可以使用unbind("click")来删除
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="even" optional="true">第奇数次点击时要执行的函数</param>
	/// <param name="odd" optional="true">第偶数次点击时要执行的函数</param>
},	
	triggerHandler: function(type,data){
	/// <summary>
	///	这个特别的方法将会触发指定的事件类型上所有绑定的处理函数。但不会执行浏览器默认动作
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="type" >要触发的事件类型</param>
	/// <param name="data" optional="true">(可选)传递给事件处理函数的附加参数</param>
},
	trigger: function (type, data) {
	/// <summary>
	///	在每一个匹配的元素上触发某类事件。
	///	这个函数也会导致浏览器同名的默认行为的执行。比如，如果用trigger()触发一个'submit'，
	///	则同样会导致浏览器提交表单。如果要阻止这种默认行为，应返回false。
	///	你也可以触发由bind()注册的自定义事件
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="type">要触发的事件类型.</param>
	/// <param name="data" optional="true">(可选)传递给事件处理函数的附加参数</param>
},
	unbind: function (type, fn) {
	/// <summary>
	///	bind()的反向操作，从每一个匹配的元素中删除绑定的事件。
	///	如果没有参数，则删除所有绑定的事件。
	///	你可以将你用bind()注册的自定义事件取消绑定。
	///	I如果提供了事件类型作为参数，则只删除该类型的绑定事件。
	///	如果把在绑定时传递的处理函数作为第二个参数，则只有这个特定的事件处理函数会被删除
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="type" optional="true">(可选) 事件类型</param>
	/// <param name="fn" optional="true">(可选) 要从每个匹配元素的事件中反绑定的事件处理函数</param>
},
	one: function (type, data, fn) {
	/// <summary>
	///	为每一个匹配元素的特定事件（像click）绑定一个一次性的事件处理函数。
	///	在每个对象上，这个事件处理函数只会被执行一次。其他规则与bind()函数相同。
	///	这个事件处理函数会接收到一个事件对象，可以通过它来阻止（浏览器）默认的行为。
	///	如果既想取消默认的行为，又想阻止事件起泡，这个事件处理函数必须返回false。
	///	多数情况下，可以把事件处理函数定义为匿名函数（见示例一）。
	///	在不可能定义匿名函数的情况下，可以传递一个可选的数据对象作为第二个参数（而事件处理函数则作为第三个参数），见示例二
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="type">type (String) : 事件类型</param>
	/// <param name="data" optional="true">data (Object) : (可选) 作为event.data属性值传递给事件对象的额外数据对象</param>
	/// <param name="fn">fn (Function) : 绑定到每个匹配元素的事件上面的处理函数</param>
},
	bind: function (type, data, fn) {
	/// <summary>
	///	为每一个匹配元素的特定事件（像click）绑定一个事件处理器函数。
	///	这个事件处理函数会接收到一个事件对象，可以通过它来阻止（浏览器）默认的行为。
	///	如果既想取消默认的行为，又想阻止事件起泡，这个事件处理函数必须返回false。多数情况下，可以把事件处理器函数定义为匿名函数（见示例一）。
	///	在不可能定义匿名函数的情况下，可以传递一个可选的数据对象作为第二个参数（而事件处理器函数则作为第三个参数），见示例二
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="type">事件类型</param>
	/// <param name="data" optional="true"> (可选) 作为event.data属性值传递给事件对象的额外数据对象</param>
	/// <param name="fn">绑定到每个匹配元素的事件上面的处理函数</param>
},
	width: function (val) {
	/// <summary>
	///	为每个匹配的元素设置CSS宽度(width)属性的值。如果没有明确指定单位（如：em或%），使用px
	/// </summary>
	/// <returns type="Object"></returns>
	/// <param name="val" optional="true">设定 CSS 'width' 的属性值</param>
},
	height: function (val) {
	/// <summary>
	///	为每个匹配的元素设置CSS高度(hidth)属性的值。如果没有明确指定单位（如：em或%），使用px。如果没有明确指定单位（如：em或%），使用px
	/// </summary>
	/// <returns type="Object"></returns>
	/// <param name="val" optional="true">设定CSS中 'height' 的值</param>
},
	empty: function () {
	/// <summary>
	///	删除匹配的元素集合中所有的子节点
	/// </summary>
	/// <returns type="jQuery"></returns>
},
	remove: function (expr) {
	/// <summary>
	///	从DOM中删除所有匹配的元素。这个方法不会把匹配的元素从jQuery对象中删除，因而可以在将来再使用这些匹配的元素
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr" optional="true">(可选) 用于筛选元素的jQuery表达式.</param>
},
	toggleClass: function (cssClass) {
	/// <summary>
	///	如果存在（不存在）就删除（添加）一个类
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="cssClass">CSS类名</param>
},
	removeClass: function (cssClass) {
	/// <summary>
	///	从所有匹配的元素中删除全部或者指定的类
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="cssClass" optional="true">(可选)一个或多个要删除的CSS类名，请用空格分开</param>
},
	addClass: function (cssClass) {
	/// <summary>
	///	为每个匹配的元素添加指定的类名
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="cssClass">一个或多个要添加到元素中的CSS类名，请用空格分开</param>
},
	removeAttr: function (name) {
	/// <summary>
	///	从每一个匹配的元素中删除一个属性
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="name">要删除的属性名.</param>
},
	replaceAll: function(selector){
	/// <summary>
	///	用匹配的元素替换掉所有 selector匹配到的元素
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="selector">(选择器) : 用于查找所要被替换的元素</param>		
},
	insertAfter: function (content) {
	/// <summary>
	///	把所有匹配的元素插入到另一个、指定的元素元素集合的后面。
	///	实际上，使用这个方法是颠倒了常规的$(A).after(B)的操作，即不是把B插入到A后面，而是把A插入到B后面
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="content">用于匹配元素的jQuery表达式.</param>
},
	insertBefore: function (content) {
	/// <summary>
	///	把所有匹配的元素插入到另一个、指定的元素元素集合的前面。
	///	实际上，使用这个方法是颠倒了常规的$(A).before(B)的操作，即不是把B插入到A前面，而是把A插入到B前面
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="content">用于匹配元素的jQuery表达式.</param>
},
	prependTo: function (content) {
	/// <summary>
	///	把所有匹配的元素前置到另一个、指定的元素元素集合中。
	///	实际上，使用这个方法是颠倒了常规的$(A).prepend(B)的操作，即不是把B前置到A中，而是把A前置到B中
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="content">用于匹配元素的jQuery表达式.</param>
},
	appendTo: function (content) {
	/// <summary>
	///	把所有匹配的元素追加到另一个、指定的元素元素集合中。
	///	实际上，使用这个方法是颠倒了常规的$(A).append(B)的操作，即不是把B追加到A中，而是把A追加到B中
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="content">用于被追加的内容.</param>
},
	contents: function(){
	/// <summary>
	///	查找匹配元素内部所有的子节点（包括文本节点）。如果元素是一个iframe，则查找文档内容
	/// </summary>
	/// <returns type="jQuery"></returns>
},	
	children: function (expr) {
	/// <summary>
	///	取得一个包含匹配的元素集合中每一个元素的所有子元素的元素集合。
	///	可以通过可选的表达式来过滤所匹配的子元素。注意：parents()将查找所有祖辈元素，而children()之考虑子元素而不考虑所有后代元素
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr" optional="true">(可选) 用以过滤子元素的表达式</param>
},
	siblings: function (expr) {
	/// <summary>
	///	取得一个包含匹配的元素集合中每一个元素的所有唯一同辈元素的元素集合。可以用可选的表达式进行筛选
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr" optional="true">可选) 用于筛选同辈元素的表达式</param>
},
	prevAll: function(expr){
	/// <summary>
	///	查找当前元素之前所有的同辈元素可以用表达式过滤
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr" optional="true">(可选) 用于过滤的表达式</param>
},
	nextAll: function(expr){
	/// <summary>
	///	查找当前元素之前所有的同辈元素可以用表达式过滤
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr" optional="true">(可选)用来过滤的表达式</param>	
},
	prev: function (expr) {
	/// <summary>
	///	取得一个包含匹配的元素集合中每一个元素紧邻的前一个同辈元素的元素集合。
	///	可以用一个可选的表达式进行筛选。只有紧邻的同辈元素会被匹配到，而不是前面所有的同辈元素
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr" optional="true">(可选) 用于筛选前一个同辈元素的表达式.</param>
},
	next: function (expr) {
	/// <summary>
	///	取得一个包含匹配的元素集合中每一个元素紧邻的后面同辈元素的元素集合。
	///	这个函数只返回后面那个紧邻的同辈元素，而不是后面所有的同辈元素（可以使用nextAll）。可以用一个可选的表达式进行筛选
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr" optional="true"> (可选) 用于筛选的表达式</param>
},
	parents: function (expr) {
	/// <summary>
	///	取得一个包含着所有匹配元素的祖先元素的元素集合（不包含根元素）。可以通过一个可选的表达式进行筛选
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr" optional="true">(可选) 用于筛选祖先元素的表达式</param>
},
	parent: function (expr) {
	/// <summary>
	///	取得一个包含着所有匹配元素的唯一父元素的元素集合.你可以使用可选的表达式来筛选
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr" optional="true">(可选)用来筛选的表达式</param>
},
	extend: function(object){
	/// <summary>
	///	扩展jQuery对象本身。用来在jQuery命名空间上增加新函数。 查看 'jQuery.fn.extend' 获取更多添加插件的信息
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="object" >用以扩展 jQuery 对象</param>
},	
	removeData: function(expr){
	/// <summary>
	///	在元素上移除存放的数据与$(...).data(name, value)函数作用相反
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr" optional="true">存储的数据名</param>
},
	data: function(name,value){
	/// <summary>
	///	在元素上存放数据，同时也返回value。
	///	如果jQuery集合指向多个元素，那将在所有元素上设置对应数据。
	///	这个函数不用建立一个新的expando，就能在一个元素上存放任何格式的数据，而不仅仅是字符串
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="name">存储的数据名</param>
	/// <param name="value" >将要存储的任意数据</param>
},
	andSelf: function(){
	/// <summary>
	///	加入先前所选的加入当前元素中对于筛选或查找后的元素，要加入先前所选元素时将会很有用
	/// </summary>
	/// <returns type="jQuery"></returns>
},
	map: function(callback){
	/// <summary>
	///	将一组元素转换成其他数组（不论是否是元素数组）
	///	你可以用这个函数来建立一个列表，不论是值、属性还是CSS样式，或者其他特别形式。这都可以用'$.map()'来方便的建立
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="callback" >给每个元素执行的函数</param>	
},
	slice: function(start,end){
	/// <summary>
	///	选取一个匹配的子集与原来的slice方法类似
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="start">开始选取子集的位置。第一个元素是0.如果是负数，则可以从集合的尾部开始选起</param>
	/// <param name="end" >(可选) 结束选取自己的位置，如果不指定，则就是本身的结尾</param>
},	
	eq: function (pos) {
	/// <summary>
	///	获取第N个元素这个元素的位置是从0算起
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="pos">元素在jQuery对象中的索引.</param>
},
	replaceWith: function(pos){
	/// <summary>
	///	将所有匹配的元素替换成指定的HTML或DOM元素
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="pos">用于将匹配元素替换掉的内容.</param>
},
	html: function (val) {
	/// <summary>
	/// 1: html() - 取得第一个匹配元素的html内容。这个函数不能用于XML文档。但可以用于XHTML文档
	/// 2: html(val) - 设置每一个匹配元素的html内容。这个函数不能用于XML文档。但可以用于XHTML文档
	/// </summary>
	/// <returns type="Object"></returns>
	/// <param name="val" optional="true">用于设定HTML内容的值</param>
},
	val: function (val) {
	/// <summary>
	/// 1: val() - 获得第一个匹配元素的当前值。
	///			在 jQuery 1.2 中,可以返回任意元素的值了。包括select。如果多选，将返回一个数组，其包含所选的值
	/// 2: val(val) - 设置每一个匹配元素的值。在 jQuery 1.2, 这也可以为select元件赋值
	///			check,select,radio等都能使用为之赋值
	/// </summary>
	/// <returns type="Object"></returns>
	/// <param name="val" optional="true">要设置的值</param>
},
	hasClass: function(calss){
	/// <summary>
	///	检查当前的元素是否含有某个特定的类，如果有，则返回true。这其实就是 is("." + class)。
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="calss">用于匹配的类名.</param>
},
	is: function (expr) {
	/// <summary>
	///	用一个表达式来检查当前选择的元素集合，如果其中至少有一个元素符合这个给定的表达式就返回true.
	///	如果没有元素符合，或者表达式无效，都返回'false'. 'filter' 内部实际也是在调用这个函数，所以，filter()函数原有的规则在这里也适用
	/// </summary>
	/// <returns type="Boolean"></returns>
	/// <param name="expr">用于筛选的表达式</param>
},
	add: function (expr) {
	/// <summary>
	///	把与表达式匹配的元素添加到jQuery对象中。这个函数可以用于连接分别与两个表达式匹配的元素结果集
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr">
	///	expr (String, DOMElement, Array<DOMElement>) : 用于匹配元素并添加的表达式字符串，或者用于动态生成的HTML代码，如果是一个字符串数组则返回多个元素
	///</param>
},
	not: function (el) {
	/// <summary>
	///	删除与指定表达式匹配的元素
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="el">
	///	expr (String, DOMElement, Array<DOMElement>) : 一个表达式、一个元素或者一组元素
	/// </param>
},
	filter: function (expression) {
	/// <summary>
	///	1,筛选出与指定函数返回值匹配的元素集合
	///	   这个函数内部将对每个对象计算一次 (正如 '$.each'). 如果调用的函数返回false则这个元素被删除，否则就会保留
	/// 	2,筛选出与指定表达式匹配的元素集合。这个方法用于缩小匹配的范围。用逗号分隔多个表达式
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expression">
	///	1,传递进filter的函数
	///	2,表达式
	///	</param>
},
	clone: function (deep) {
	/// <summary>
	///	元素以及其所有的事件处理并且选中这些克隆的副本在想把DOM文档中元素的副本添加到其他位置时这个函数非常有用
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="deep" optional="true">(可选)设置为true以便复制元素的所有事件处理.</param>
},
	find: function (expr) {
	/// <summary>
	///	搜索所有与指定表达式匹配的元素。这个函数是找出正在处理的元素的后代元素的好方法。
	///	所有搜索都依靠jQuery表达式来完成。这个表达式可以使用CSS1-3的选择器语法来写
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="expr">用于查找的表达式.</param>
},
	end: function () {
	/// <summary>
	///	回到最近的一个"破坏性"操作之前。即，将匹配的元素列表变为前一次的状态。
	///	如果之前没有破坏性操作，则返回一个空集。所谓的"破坏性"就是指任何改变所匹配的jQuery元素的操作。
	///	这包括在 Traversing 中任何返回一个jQuery对象的函数
	///	'add', 'andSelf', 'children', 'filter', 'find', 'map', 'next', 'nextAll', 'not', 'parent', 'parents', 'prev', 'prevAll', 'siblings' and 'slice'
	///	再加上 Manipulation 中的 'clone'
	/// </summary>
	/// <returns type="jQuery"></returns>
},
	after: function (content) {
	/// <summary>
	///	在每个匹配的元素之后插入内容
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="content">content (String, Element, jQuery) : 插入到每个目标后的内容.</param>
},
	prepend: function (content) {
	/// <summary>
	///	向每个匹配的元素内部追加内容。这个操作与对指定的元素执行appendChild方法，将它们添加到文档中的情况类似
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="content">content (String, Element, jQuery) : 要追加到目标中的内容.</param>
},
	append: function (content) {
	/// <summary>
	///	向每个匹配的元素内部前置内容。这是向所有匹配元素内部的开始处插入内容的最佳方式
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="content">content (String, Element, jQuery) : 要插入到目标元素内部前端的内容</param>
},
	wrap: function (html) {
	/// <summary>
	/// 1: wrap(html) - 把所有匹配的元素用其他元素的结构化标记包裹起来。
	///				    这种包装对于在文档中插入额外的结构化标记最有用，而且它不会破坏原始文档的语义品质。
	///				    这个函数的原理是检查提供的第一个元素（它是由所提供的HTML标记代码动态生成的），
	///				    并在它的代码结构中找到最上层的祖先元素－－这个祖先元素就是包裹元素。
	///				    当HTML标记代码中的元素包含文本时无法使用这个函数。因此，如果要添加文本应该在包裹完成之后再行添加
	/// 2: wrap(elem) - 把所有匹配的元素用其他元素的结构化标记包装起来
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="html">
	/// 1: html - HTML标记代码字符串，用于动态生成元素并包裹目标元素
	/// 2: elem - 用于包装目标元素的DOM元素
	/// </param>
},
	wrapInner: function(html){
	/// <summary>
	/// 1: wrap(html) - 将每一个匹配的元素的子内容(包括文本节点)用一个HTML结构包裹起来
	///				    这个函数的原理是检查提供的第一个元素（它是由所提供的HTML标记代码动态生成的），
	///				    并在它的代码结构中找到最上层的祖先元素－－这个祖先元素就是包装元素
	/// 2: wrap(elem) - 将每一个匹配的元素的子内容(包括文本节点)用DOM元素包裹起来
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="html">
	/// 1: html - HTML标记代码字符串，用于动态生成元素并包装目标元素
	/// 2: elem - 用于包装目标元素的DOM元素
	/// </param>
},
	wrapAll: function(b){
	/// <summary>
	/// 1: wrap(html) - 将所有匹配的元素用单个元素包裹起来
	///				   这于 '.wrap()' 是不同的，'.wrap()'为每一个匹配的元素都包裹一次。
	///				   这种包装对于在文档中插入额外的结构化标记最有用，而且它不会破坏原始文档的语义品质。
	///				   这个函数的原理是检查提供的第一个元素并在它的代码结构中找到最上层的祖先元素－－这个祖先元素就是包装元素
	/// 2: wrap(elem) - 将所有匹配的元素用单个元素包裹起来这于 '.wrap()' 是不同的，'.wrap()'为每一个匹配的元素都包裹一次
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="html">
	/// 1: html - TML标记代码字符串，用于动态生成元素并包装目标元素
	/// 2: elem - 用于包装目标元素的DOM元素
	/// </param>
},
	text: function (val) {
	/// <summary>
	/// 1: text() - 取得所有匹配元素的内容。
	///			 结果是由所有匹配元素包含的文本内容组合起来的文本。这个方法对HTML和XML文档都有效
	/// 2: text(val) - 设置所有匹配元素的文本内容, 但将编码 HTML (将 "<" 和 ">" 替换成相应的HTML实体).
	/// </summary>
	/// <returns type="String"></returns>
	/// <param name="val" optional="true">用于设置元素内容的文本</param>
},
	css: function (name, value) {
	/// <summary>
	/// 1: css(name) - 访问第一个匹配元素的样式属性
	/// 2: css(properties) - 把一个“名/值对”对象设置为所有匹配元素的样式属性。这是一种在所有匹配的元素上设置大量样式属性的最佳方式
	/// 3: css(key, value) - 在所有匹配的元素中，设置一个样式属性的值。数字将自动转化为像素值
	/// </summary>
	/// <returns type="Object"></returns>
	/// <param name="name">
	/// 1: name - 要访问的属性名称
	/// 2: properties - 要设置为样式属性的名/值对.
	/// 3: key - 属性名.
	/// </param>
	/// <param name="value" optional="true"> 属性值</param>
},
	attr: function (name, value) {
	/// <summary>
	/// 1: attr(name) - 	   取得第一个匹配元素的属性值。通过这个方法可以方便地从第一个匹配元素中获取一个属性的值。如果元素没有相应属性，则返回 undefined 
	/// 2: attr(properties) - 将一个“名/值”形式的对象设置为所有匹配元素的属性。
	///					   这是一种在所有匹配元素中批量设置很多属性的最佳方式。 
	///					   注意，如果你要设置对象的class属性，你必须使用'className' 作为属性名。或者你可以直接使用.addClass( class ) 和 .removeClass( class ).
	/// 3: attr(key, value) - 为所有匹配的元素设置一个属性值
	/// 4: attr(key, fn) -      为所有匹配的元素设置一个计算的属性值。不提供值，而是提供一个函数，由这个函数计算的值作为属性值
	/// </summary>
	/// <returns type="Object"></returns>
	/// <param name="name">
	/// 1: name -	属性名称
	/// 2: properties - 作为属性的“名/值对”对象.
	/// 3: name - 		属性名称.
	/// 4: name - 	属性名称.
	/// </param>
	/// <param name="value" optional="true">
	/// 3: value - 属性值.
	/// 4: fn - 	 返回值的函数 范围:当前元素, 参数: 当前元素的索引值.
	/// </param>
},
	index: function (subject) {
	/// <summary>
	///	搜索与参数表示的对象匹配的元素，并返回相应元素的索引值值。
	///	如果找到了匹配的元素，从0开始返回；如果没有找到匹配的元素，返回-1
	/// </summary>
	/// <returns type="Number"></returns>
	/// <param name="subject">要搜索的对象</param>
},
	pushStack: function (elems) {
	/// <summary>
	/// 将一个数组压入堆栈
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="elems">一个数组</param>
},
	get: function (num) {
	/// <summary>
	/// 1: get() - 	取得所有匹配的 DOM 元素集合。
	///				这是取得所有匹配元素的一种向后兼容的方式（不同于jQuery对象，而实际上是元素数组）。
	///				如果你想要直接操作 DOM 对象而不是 jQuery 对象，这个函数非常有用
	/// 2: get(num) - 取得其中一个匹配的元素。 num表示取得第几个匹配的元素。
	///				这能够让你选择一个实际的DOM 元素并且对他直接操作，而不是通过 jQuery 函数。$(this).get(0)与$(this)[0]等价
	/// </summary>
	/// <returns type="Object"></returns>
	/// <param name="num" optional="true">取得第 index 个位置上的元素</param>
},
	size: function () {
	/// <summary>
	/// jQuery 对象中元素的个数。这个函数的返回值与 jQuery 对象的'length' 属性一致
	/// </summary>
	/// <returns type="Number"></returns>
},
	init: function(d,b){},
	setArray: function (elems) {
	/// <summary>
	/// 取出一个堆栈数组
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="elems">一个数组</param>
},
	length: {
	/// <summary>
	/// jQuery 对象中元素的个数。当前匹配的元素个数。 size 将返回相同的值
	/// </summary>
	/// <returns type="Number"></returns>
},
	prevObject: {},
	jquery: {},
	before: function (content) {
	/// <summary>
	/// 在每个匹配的元素之前插入内容
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="content">content (String, Element, jQuery) : 插入到每个目标前的内容</param>
},
	domManip: function (args, table, dir, fn) {
	/// <summary>
	/// test
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="args">test</param>
	/// <param name="table">.test</param>
	/// <param name="dir">.setse</param>
	/// <param name="fn">setse</param>
},
	each: function (fn) {
	/// <summary>
	///	以每一个匹配的元素作为上下文来执行一个函数。
	///	意味着，每次执行传递进来的函数时，函数中的this关键字都指向一个不同的DOM元素（每次都是一个不同的匹配元素）。
	///	而且，在每次执行函数时，都会给函数传递一个表示作为执行环境的元素在匹配的元素集合中所处位置的数字值作为参数（从零开始的整形）。 
	///	返回 'false' 将停止循环 (就像在普通的循环中使用 'break')。返回 'true' 跳至下一个循环(就像在普通的循环中使用'continue'
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="fn">对于每个匹配的元素所要执行的函数</param>
}
};

$.extend = function (target,obj1,objN) {
	/// <summary>
	///  用一个或多个其他对象来扩展一个对象，返回被扩展的对象。用于简化继承
	/// </param>
	/// <param name="target" optional="true">待修改对象 </param>
	/// <param name="obj1" optional="true">待合并到第一个对象的对象 </param>
	/// <param name="objN" optional="true">(可选) 待合并到第一个对象的对象</param>
};

$.noConflict = function () {
	/// <summary>
	/// 运行这个函数将变量$的控制权让渡给第一个实现它的那个库。
	///	这有助于确保jQuery不会与其他库的$对象发生冲突。
	///	在运行这个函数后，就只能使用jQuery变量访问jQuery对象。例如，在要用到$("div p")的地方，就必须换成jQuery("div p")。
	///注意:这个函数必须在你导入jQuery文件之后，并且在导入另一个导致冲突的库之前使用。当然也应当在其他冲突的库被使用之前，除非jQuery是最后一个导入的
	/// </summary>
};

$.isFunction = function(obj){
	/// <summary>
	/// 测试对象是否为函数
	/// </summary>
	/// <returns type="jQuery"></returns>
	/// <param name="obj" optional="true">用于测试是否为函数的对象</param>
};

$.isXMLDoc = function(a){};

$.globalEval = function(a){};

$.nodeName = function(b,a){};

$.cache = {};

$.data = function(c,d,b){};

$.removeData = function(c,b){};

$.each = function (obj, fn) {
	/// <summary>
	/// 通用例遍方法，可用于例遍对象和数组。
	///	不同于例遍 jQuery 对象的 $().each() 方法，此方法可用于例遍任何对象。
	///	回调函数拥有两个参数：第一个为对象的成员或数组的索引，第二个为对应变量或内容。
	///	如果需要退出 each 循环可使回调函数返回 false，其它返回值将被忽略
	/// </summary>
	/// <returns type="Object"></returns>
	/// <param name="obj">需要例遍的对象或数组.</param>
	/// <param name="fn"> (可选) 每个成员/元素执行的回调函数.</param>
};

$.prop = function(b,a,c,i,d){};

$.className = {};

$.swap = function(b,c,a){};

$.css = function(d,e,c){};

$.curCSS = function(e,k,j){};

$.clean = function(l,h){};

$.attr = function(d,e,c){};

$.trim = function (str) {
	/// <summary>
	/// 去掉字符串起始和结尾的空格
	/// </summary>
	/// <returns type="String"></returns>
	/// <param name="str"> 需要处理的字符串</param>
};

$.makeArray = function(obj){
	/// <summary>
	/// 将类数组对象转换为数组对象。类数组对象有 length 属性，其成员索引为 0 至 length - 1。实际中此函数在 jQuery 中将自动使用而无需特意转换
	/// </summary>
	/// <returns type="Array"></returns>
	/// <param name="obj"> 类数组对象</param>
	};

$.inArray = function(value,array){
	/// <summary>
	/// 确定第一个参数在数组中的位置(如果没有找到则返回 -1 )
	/// </summary>
	/// <returns type="Array"></returns>
	/// <param name="value"> 用于在数组中查找是否存在</param>
	/// <param name="array"> 待处理数组</param>
};

$.merge = function (first, second) {
	/// <summary>
	/// 
	///[short] Merge two arrays together, removing all duplicates.
	///[desc] Merge two arrays together, removing all duplicates.
	///
	///The result is the altered first argument with
	///the unique elements from the second array added.The first array to merge, the unique elements of second added.The second array to merge into the first, unaltered.Merges two arrays, removing the duplicate 2Merges two arrays, removing the duplicates 3 and 2
	/// </summary>
	/// <returns type="Array"></returns>
	/// <param name="first">The first array to merge, the unique elements of second added.</param>
	/// <param name="second">The second array to merge into the first, unaltered.</param>
};

$.unique = function(value){
	/// <summary>
	/// 删除数组中重复元素
	/// </summary>
	/// <returns type="Array"></returns>
	/// <param name="value"> 待处理数组</param>
};

$.grep = function (array, fn, inv) {
	/// <summary>
	/// 使用过滤函数过滤数组元素。此函数至少传递两个参数：待过滤数组和过滤函数。过滤函数必须返回 true 以保留元素或 false 以删除元素
	/// </summary>
	/// <returns type="Array"></returns>
	/// <param name="array">待过滤数组.</param>
	/// <param name="fn">
	///	此函数将处理数组每个元素。第一个参数为当前元素，第二个参数而元素索引值。此函数应返回一个布尔值。
	///	另外，此函数可设置为一个字符串，当设置为字符串时，将视为“lambda-form”（缩写形式？），
	///	其中 a 代表数组元素，i 代表元素索引值。如“a > 0”代表“function(a){ return a > 0; }”。
	///</param>
	/// <param name="inv">
	///	(可选) 如果 "invert" 为 false 或为设置，则函数返回数组中由过滤函数返回 true 的元素，当"invert" 为 true，则返回过滤函数中返回 false 的元素集
	///	</param>
};

$.map = function (array, fn) {
	/// <summary>
	/// 将一个数组中的元素转换到另一个数组中。
	///	作为参数的转换函数会为每个数组元素调用，而且会给这个转换函数传递一个表示被转换的元素作为参数。
	///	转换函数可以返回转换后的值、null（删除数组中的项目）或一个包含值的数组，并扩展至原始数组中
	/// </summary>
	/// <returns type="Array"></returns>
	/// <param name="array">待转换数组.</param>
	/// <param name="fn">
	///	为每个数组元素调用，而且会给这个转换函数传递一个表示被转换的元素作为参数。函数可返回任何值。
	///	另外，此函数可设置为一个字符串，当设置为字符串时，将视为“lambda-form”（缩写形式？），
	///	其中 a 代表数组元素。如“a * a”代表“function(a){ return a * a; };
	///</param>
};

$.browser = {
	/// <summary>
	/// 浏览器内核标识。依据 navigator.userAgent 判断。
	///	可用值: safari ,opera ,msie,mozilla 
	///	此属性在 DOM 树加载完成前即有效，可用于为特定浏览器设置 ready 事件。 
	///	浏览器对象检测技术与此属性共同使用可提供可靠的浏览器检测支持
	/// </summary>
	/// <returns type="Array"></returns>
	/// <param name="value"> 待处理数组</param>
};

$.boxModel = {
	///<summary>
	///当前页面中浏览器是否使用标准盒模型渲染页面。 W3C CSS 盒模型
	///</summary>
	///<returns type="bool"></returns>
};

$.props = {};

$.expr = {};

$.parse = {};

$.multiFilter = function(a,c,b){};

$.find = function () {
	/// <summary>
	///    暂时没有
	/// </summary>
	/// <returns type="Array<Element>">暂时没有</returns>
};

$.classFilter = function(r,m,a){};

$.filter = function(t,r,h){};

$.dir = function(b,c){};

$.nth = function (cur, num, dir) {
	/// <summary>
	/// 
	///[short] A handy, and fast, way to traverse in a particular direction and find
	///a specific element.
	///[desc] A handy, and fast, way to traverse in a particular direction and find
	///a specific element.The element to search from.The Nth result to match. Can be a number or a string (like 'even' or 'odd').The direction to move in (pass in something like 'previousSibling' or 'nextSibling').
	/// </summary>
	/// <returns type="DOMElement"></returns>
	/// <param name="cur">The element to search from.</param>
	/// <param name="num">The Nth result to match. Can be a number or a string (like 'even' or 'odd').</param>
	/// <param name="dir">The direction to move in (pass in something like 'previousSibling' or 'nextSibling').</param>
};

$.sibling = function (elem) {
	/// <summary>
	/// 
	///[short] All elements on a specified axis.
	///[desc] All elements on a specified axis.The element to find all the siblings of (including itself).
	/// </summary>
	/// <returns type="Array"></returns>
	/// <param name="elem">The element to find all the siblings of (including itself).</param>
};

$.event = {};

$.isReady = {};

$.readyList = {};

$.ready = function(){
    /// <summary>
	///	当DOM载入就绪可以查询及操纵时绑定一个要执行的函数。
	///	这是事件模块中最重要的一个函数，因为它可以极大地提高web应用程序的响应速度。
	///	简单地说，这个方法纯粹是对向window.load事件注册事件的替代方法。通过使用这个方法，
	///	可以在DOM载入就绪能够读取并操纵时立即调用你所绑定的函数，
	///	而99.99%的JavaScript函数都需要在那一刻执行。
	/// </summary>
	/// <returns type="jQuery"></returns>
};

$.get = function (url, params, callback) {

	/// <summary>
	/// 通过远程 HTTP GET 请求载入信息。这是一个简单的 GET 请求功能以取代复杂 $.ajax 。请求成功时可调用回调函数。如果需要在出错时执行函数，请使用 $.ajax
	/// </summary>
	/// <returns type="XMLHttpRequest"></returns>
	/// <param name="url">待载入页面的URL地址.</param>
	/// <param name="params" optional="true">(可选) 待发送 Key/value 参数.</param>
	/// <param name="callback" optional="true">(可选) 载入成功时回调函数.</param>
};

$.getScript = function (url, callback) {
	/// <summary>
	///    通过 HTTP GET 请求载入并执行一个 JavaScript 文件。
    ///    jQuery 1.2 版本之前，getScript 只能调用同域 JS 文件,1.2中您可以跨域调用 JavaScript 文件。注意：Safari 2 或更早的版本不能在全局作用域中同步执行脚本。
    ///    如果通过 getScript 加入脚本，请加入延时函数 
	/// </summary>
	/// <returns type="XMLHttpRequest"></returns>
	/// <param name="url">待载入 JS 文件地址.</param>
	/// <param name="callback" optional="true">callback (Function) : (可选) 成功载入后回调函数.</param>
};

$.getJSON = function (url, params, callback) {
	/// <summary>
	///    通过 HTTP GET 请求载入 JSON 数据。
    ///    在 jQuery 1.2 中，您可以通过使用JSONP 形式的回调函数来加载其他网域的JSON数据，如 "myurl?callback=?"。jQuery 将自动替换 ? 为正确的函数名，以执行回调函数。
    ///    注意：此行以后的代码将在这个回调函数执行前执行 
	/// </summary>
	/// <returns type="XMLHttpRequest"></returns>
	/// <param name="url">发送请求地址.</param>
	/// <param name="params" optional="true">(可选) 待发送 Key/value 参数.</param>
	/// <param name="callback">(可选) 载入成功时回调函数.</param>
};

$.post = function (url, params, callback) {
	/// <summary>
	///    通过远程 HTTP POST 请求载入信息。
    ///    这是一个简单的 POST 请求功能以取代复杂 $.ajax 。请求成功时可调用回调函数。如果需要在出错时执行函数，请使用 $.ajax
	/// </summary>
	/// <returns type="XMLHttpRequest"></returns>
	/// <param name="url">发送请求地址.</param>
	/// <param name="params" optional="true">(可选) 待发送 Key/value 参数.</param>
	/// <param name="callback" optional="true">(可选) 发送成功时回调函数.</param>
};

$.ajaxSetup = function (settings) {
	/// <summary>
	/// 设置全局 AJAX 默认选项。参数见 '$.ajax' 说明
	/// </summary>
	/// <param name="settings">选项设置。所有设置项均为可选设置</param>
};

$.ajaxSettings = {};

$.lastModified = {};

$.ajax = function (properties) {
	/// <summary>
	///    通过 HTTP 请求加载远程数据。
    ///    jQuery 底层 AJAX 实现。简单易用的高层实现见 $.get, $.post 等。
    ///    $.ajax() 返回其创建的 XMLHttpRequest 对象。大多数情况下你无需直接操作该对象，但特殊情况下可用于手动终止请求。
    ///    $.ajax() 只有一个参数：参数 key/value 对象，包含各配置及回调函数信息。详细参数选项见下。
    ///    注意： 如果你指定了 dataType 选项，请确保服务器返回正确的 MIME 信息，(如 xml 返回 "text/xml")。错误的 MIME 类型可能导致不可预知的错误。见 Specifying the Data Type for AJAX Requests 。
    ///    注意：如果dataType设置为"script"，那么所有的远程(不在同一域名下)的POST请求都将转化为GET请求。(因为将使用DOM的script标签来加载)
    ///    jQuery 1.2 中，您可以跨域加载 JSON 数据，使用时需将数据类型设置为 JSONP。使用 JSONP 形式调用函数时，如 "myurl?callback=?" jQuery 将自动替换 ? 为正确的函数名，以执行回调函数。数据类型设置为 "jsonp" 时，jQuery 将自动调用回调函数
	/// </summary>
	/// <returns type="XMLHttpRequest"></returns>
	/// <param name="properties">options (可选) : AJAX 请求设置。所有选项都是可选的.</param>
};

$.handleError = function(s,a,b,e){};

$.active = {};

$.httpSuccess = function(r){};

$.httpNotModified = function(a,c){};

$.httpData = function(r,b){};

$.param = function(a){};

$.speed = function(b,a,c){};

$.easing = {};

$.timers = {};

$.fx = function(b,c,a){};

$.easing.linear = function(p,n,b,a){};

$.easing.swing = function(p,n,b,a){};

$.ajaxSettings.global = {};

$.ajaxSettings.type = {};

$.ajaxSettings.timeout = {};

$.ajaxSettings.contentType = {};

$.ajaxSettings.processData = {};

$.ajaxSettings.async = {};

$.ajaxSettings.data = {};

$.ajaxSettings.username = {};

$.ajaxSettings.password = {};

$.ajaxSettings.accepts = {};

$.ajaxSettings.accepts.xml = {};

$.ajaxSettings.accepts.html = {};

$.ajaxSettings.accepts.script = {};

$.ajaxSettings.accepts.json = {};

$.ajaxSettings.accepts.text = {};

$.ajaxSettings.accepts._default = {};

$.props.float = {};

$.props.cssFloat = {};

$.props.styleFloat = {};

$.props.innerHTML = {};

$.props.className = {};

$.props.value = {};

$.props.disabled = {};

$.props.checked = {};

$.props.readonly = {};

$.props.selected = {};

$.props.maxlength = {};

$.props.selectedIndex = {};

$.props.defaultValue = {};

$.props.tagName = {};

$.props.nodeName = {};

$.browser.version = {
	/// <summary>
	///    浏览器渲染引擎版本号。
    ///    典型结果: Internet Explorer: 6.0, 7.0 Mozilla/Firefox/Flock/Camino: 1.7.12, 1.8.1.3 Opera: 9.20 Safari/Webkit: 312.8, 418.9
	/// </summary>
	/// <returns type="string"></returns>
};

$.browser.safari = {
	/// <summary>
	///   浏览器内核标识
	/// </summary>
	/// <returns type="Boolean"></returns>
};

$.browser.opera = {
	/// <summary>
	///   浏览器内核标识
	/// </summary>
	/// <returns type="Boolean"></returns>
};

$.browser.msie = {
	/// <summary>
	///   浏览器内核标识
	/// </summary>
	/// <returns type="Boolean"></returns>
};

$.browser.mozilla = {
	/// <summary>
	///   浏览器内核标识
	/// </summary>
	/// <returns type="Boolean"></returns>
};

$.className.add = function(c,b){};

$.className.remove = function(c,b){};

$.className.has = function(b,a){};

