﻿var LangUtil = {};
(function() {
    if (typeof window.XMLHttpRequest === "undefined") {
        window.XMLHttpRequest = function() {
            return new window.ActiveXObject(navigator.userAgent.indexOf("MSIE 5") >= 0 ? "Microsoft.XMLHTTP" : "Msxml2.XMLHTTP");
        };
    }
    LangUtil.ajax = function(uri, options) {
        var httpRequest, httpSuccess, timeout, isTimeout = false, isComplete = false;
        options = {
            method: options.method || "GET", data: options.data || null, arguments: options.arguments || null, onSuccess: options.onSuccess || function() { }, onError: options.onError || function() { }, onComplete: options.onComplete || function() { }, onTimeout: options.onTimeout || function() { }, isAsync: options.isAsync || true, timeout: options.timeout ? options.timeout : 30000, contentType: options.contentType ? options.contentType : "utf-8", type: options.type || "xml"
        };
        uri = uri || "";
        timeout = options.timeout;
        httpRequest = new window.XMLHttpRequest();
        httpRequest.open(options.method, uri, options.isAsync);
        httpRequest.setRequestHeader("Content-Type", options.contentType);
        httpSuccess = function(r) {
            try {
                return (!r.status && location.protocol == "file:") || (r.status >= 200 && r.status < 300) || (r.status == 304) || (navigator.userAgent.indexOf("Safari") > -1 && typeof r.status == "undefined");
            }
            catch (e) { } return false;
        };
        httpRequest.onreadystatechange = function() {
            if (httpRequest.readyState == 4) {
                if (!isTimeout) {
                    var o = {};
                    o.responseText = httpRequest.responseText;
                    o.responseXML = httpRequest.responseXML;
                    o.data = options.data;
                    o.status = httpRequest.status;
                    o.uri = uri;
                    o.arguments = options.arguments;
                    if (httpSuccess(httpRequest)) {
                        if (options.type === "script") {
                            eval.call(window, o.responseText);
                            options.onSuccess(o);
                        }
                        else
                            options.onSuccess(o, o.responseText);
                    }
                    else {
                        options.onError(o);
                    }
                    options.onComplete(o);
                }
                isComplete = true;
                httpRequest = null;
            }
        };
        httpRequest.send(options.data);
        window.setTimeout(function() {
            var o;
            if (!isComplete) {
                isTimeout = true;
                o = {};
                o.uri = uri;
                o.arguments = options.arguments;
                options.onTimeout(o);
                options.onComplete(o);
            }
        }
	, timeout);
        return httpRequest;
    };
    //页面装载完毕后事件
    var b = function(r) {
        if (b.done) {
            return r();
        }
        if (b.timer) {
            b.ready.push(r);
        }
        else {
            b.ready = [r];
            window.onload = q;
            b.timer = window.setInterval(q, 300);
        }
    };
    var q = function() {
        if (b.done) {
            return true;
        }
        if (document && document.getElementsByTagName && document.getElementById && document.body) {
            b.done = true;
            window.clearInterval(b.timer);
            b.timer = null;
            for (var r = 0; r < b.ready.length; r++) {
                b.ready[r]();
            }
            b.ready = null;
            return true;
        }
    };
    LangUtil.ready = b;
    LangUtil.$ = function(id) {
        return document.getElementById(id);
    };
    LangUtil.left = function(el) {
        var l = 0;
        while (el && el.style.position != "absolute" && el.style.position != "relative") {
            l += el.offsetLeft;
            el = el.offsetParent;
        }
        return l;
    };
    LangUtil.top = function(el) {
        var t = 0;
        while (el && el.style.position != "absolute" && el.style.position != "relative") {
            t += el.offsetTop;
            el = el.offsetParent;
        }
        return t;
    };
    LangUtil.setCookie = function(name, value, days, path, domain) {
        var expires = new Date();
        if (days) {
            expires.setTime(expires.getTime() + 3600000 * days);
        } else {
            expires.setTime(expires.getTime() + 3600000 * 24 * 365);
        }
        //window.document.cookie = name + "=" + value + "; " + (days ? ("expires=" + expires.toGMTString() + "; ") : "") + (path ? ("path=" + path + "; ") : "path=/; domain=sbdz.com;"); //+(domain ? ("domain=" + domain + ";") : ("domain=" + window.location.host.substr(window.location.host.indexOf(".")+1) + ";"));
        if (window.location.host.indexOf("localhost") != -1 || window.location.host.indexOf("192.168") != -1)
            window.document.cookie = name + "=" + value + "; " + ("expires=" + expires.toGMTString() + "; path=/;");
        else
            window.document.cookie = name + "=" + value + "; " + ("expires=" + expires.toGMTString() + "; path=/; domain=sbdz.com;");
        return true;
    };
    LangUtil.getCookie = function(name) {
        // var arr = window.document.cookie.match(new RegExp("(?:^|;+|\\s+)" + name + "=([^;]*)"));
        // return !arr ? null : arr[1];
        //alert(document.cookie);
        var arr = document.cookie.match(new RegExp("(^| )" + name + "=([^;]*)(;|$)"));
        if (arr != null) return arr[2]; return null;
    };
    LangUtil.removeCookie = function(name, domain, path) {
        if (window.location.host.indexOf("localhost") != -1 || window.location.host.indexOf("192.168") != -1)
            window.document.cookie = name + "=1; expires=Fri, 31 Dec 1999 23:59:59 GMT;";
        else
            window.document.cookie = name + "=1; expires=Fri, 31 Dec 1999 23:59:59 GMT; path=/; domain=sbdz.com;";
    };
})();
//点击控件编辑
function EditLang(src, key) {
    var ed = LangUtil.$("LangEditBox");
    if (!ed) return;
    var ll = LangUtil.left(src);
    var tt = LangUtil.top(src);
    ed.style.left = ll + "px";
    var tw = window.document.body.clientHeight - tt;
    if(tw<50)
        ed.style.top = (tt - tw-30) + "px";
    else
        ed.style.top = (tt) + "px";
    ed.style.display = "";
    ed.key = key;
    ed.src = src;
    LangUtil.$("LangContent").defval=LangUtil.$("LangContent").value = src.value || src.innerHTML;
}
//保存编辑
function SaveLangEdit() {
    var ed = document.getElementById("LangEditBox");
    var newVal = LangUtil.$("LangContent").value;
    if (newVal == LangUtil.$("LangContent").defval) {
        ed.style.display = "none"; return;
    }
    var lang = LangUtil.getCookie("langtype");
    LangUtil.ajax("/handler/SaveLangEdit.ashx?act=save&key=" + ed.key + "&lang=" + (lang || "cn")
    + "&val=" + encodeURIComponent(newVal)
    + "&rnd=" + Math.random(), {
        //        method: "POST"
        //        , data: "val=" + encodeURIComponent(newVal),
        onSuccess: function(o, r) {
            if (!r) {
                ed.style.display = "none";
                var src = ed.src;
                if (src.tagName == "INPUT") src.value = newVal;
                else src.innerHTML = newVal;
                return;
            }
            alert("save error!");
        }
    });
}
//语言切换
function LangChange(lang) {
    var url = window.location.href.toLowerCase();
    if (0) {
        if (url.indexOf("rnd") == -1) {
            if (url.indexOf("?") == -1)
                url += "?rnd=" + Math.random();
            else
                url += "&rnd=" + Math.random();

        } else {
            url = url.substr(0, url.indexOf("rnd")) + "rnd=" + Math.random();
        }
    }
    if (url.substring(url.length - 1, url.length) == "#") {
        url = url.substr(0, url.length - 1);
    }
    //兼容原来客服通系统
    var lan = "0";
    switch (lang) {
        case "cn":
            lan = "0";
            break;
        case "en":
            lan = "1";
            break;
    }

    //清缓存
    LangUtil.ajax("/handler/SaveLangEdit.ashx?act=changelang&l=" + lang+"&rnd=" + Math.random(), {
        onSuccess: function(o, r) {
            LangUtil.setCookie("langtype", lang);
            LangUtil.setCookie("language", lan); 
            window.location.href = url;
        }
    });
}
//若有语言切换下拉框
function onChangeLang(src) {
    LangChange(src.value);
}
LangUtil.ready(function() {
    if (LangUtil.$("LangType")) {
        var lang = LangUtil.getCookie("langtype") || "cn";
        LangUtil.$("LangType").value = lang;
    }
    //是否在线翻译
    if (false) {
        //if (true) {
        var div = document.createElement("DIV");
        div.id = "LangEditBox";
        div.style.position = "absolute";
        div.style.backgroundColor = "#EEE";
        div.style.border = "1px solid black";
        div.style.padding = "5px";
        div.style.textAlign = "right";
        div.innerHTML = "<textarea id=\"LangContent\" style=\"height:20px;\"></textarea><div><input type=\"button\" value=\"save\" style=\"width:60px;\" onclick=\"SaveLangEdit()\" />&nbsp; <input type=\"button\" value=\"cancel\" style=\"width:60px;\" onclick=\"this.parentNode.parentNode.style.display='none';\" /></div>";
        document.body.appendChild(div);
    }
});