﻿//去除字符串两边的空格
String.prototype.trim = function () {return this.replace(/(^\s+)|(\s+$)/g, "");}
//检测字符串是否为空
String.prototype.isEmpty = function () {return !(/.?[^\s　]+/.test(this));}
//检测值是否介于某两个指定的值之间
String.prototype.isBetween = function (val, min, max) {return isNaN(val) == false && val >= min && val <= max;}
//获取最大值或最小值
String.prototype.getBetweenVal = function (what) {
    var val = this.split(',');
    var min = val[0];
    var max = val[1] == null ? val[0] : val[1];
    if (parseInt(min) > parseInt(max)) {min = max;max = val[0];}
    return what == 'min' ? (isNaN(min) ? null : min) : (isNaN(max) ? null : max);
}

var validator={};
//要用到的正则表达式
validator.reg={
	"english":/^[a-zA-Z0-9_\-]+$/,
    "chinese":/^[\u0391-\uFFE5]+$/,
    "number":/^[-\+]?\d+(\.\d+)?$/,
    "integer":/^[-\+]?\d+$/,
    "float":/^[-\+]?\d+(\.\d+)?$/,
    "date":/^(\d{4})(-|\/)(\d{1,2})\2(\d{1,2})$/,
    "email":/^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/,
    //"url" : /^(((ht|f)tp(s?))\:\/\/)[a-zA-Z0-9]+\.[a-zA-Z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/,//不支持 http://localhost/
    "url" : /^(((ht|f)tp(s?))\:\/\/)[a-zA-Z0-9]+[a-zA-Z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/,
    "phone" : /^((\(\d{2,3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}(\-\d{1,4})?$/,
    "mobile" : /^((\(\d{2,3}\))|(\d{3}\-))?((13\d{9})|(159\d{8}))$/,
    "ip" : /^(0|[1-9]\d?|[0-1]\d{2}|2[0-4]\d|25[0-5]).(0|[1-9]\d?|[0-1]\d{2}|2[0-4]\d|25[0-5]).(0|[1-9]\d?|[0-1]\d{2}|2[0-4]\d|25[0-5]).(0|[1-9]\d?|[0-1]\d{2}|2[0-4]\d|25[0-5])$/,
    "zipcode": /^[1-9]\d{5}$/,
    "qq" : /^[1-9]\d{4,10}$/,
    "msn" : /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/,
    "idcard" : /(^\d{15}$)|(^\d{17}[0-9Xx]$)/
};
//提示信息
validator.tip={
    "unknow":"未找到的验证类型，无法执行验证。",
    "paramError":"参数设置错误，无法执行验证。",
    "required":"不允许为空。",
    "english":"仅允许英文字符及下划线 (a-zA-Z0-9_)。",
    "chinese":"仅允许中文字符。",
    "number":"不是一个有效的数字。",
    "integer":"不是一个有效的整数。",
    "float":"不是一个有效的浮点数。",
    "date":"不是一个有效的日期格式。 (例如：2007-06-29)",
    "email":"不是一个有效的电子邮件格式。",
    "url":"不是一个有效的超链接格式。",
    "phone":"不是一个有效的电话号码。",
    "mobile":"不是一个有效的手机号码。",
    "ip":"不是一个有效的IP地址。",
    "zipcode":"不是一个有效的邮政编码。",
    "qq":"不是一个有效的QQ号码。",
    "msn":"不是一个有效的MSN帐户。",
    "idcard":"不是一个有效的身份证号码。",
	"notSame":"两次输入的内容不一致，请重新输入。"
};
//保存默认消息
validator.messages={};
//为每一个添加事件和提示
validator.addEvent=function(selector,errorClassName,okClassName,obj)
{
    var o=$(obj);
    if(o.attr("type")=="button" || o.attr("type")=="submit")//按钮不做处理
	    return;
    	
    //保存提示内容,同时加上默认的样式 onFocus
    validator.messages[selector][obj.name]=$(selector+" ."+obj.name+"_msg").html();
    	
    o.blur(function()
    {
	    if(validator.doValidate(o,validator.feedback,selector))
		    validator.OK(o,selector);
    })

    o.focus(function()//点击的时候触发
    {
	    validator.showFocusText(o,selector);
    })
}
//安装
validator.setup=function(selector,errorClassName,okClassName)
{
    validator.messages[selector]={} || validator.messages[selector];
    
	//错误的时候的样式
	validator.errorClassName=errorClassName==null?"":errorClassName;
	//通过的时候的样式
	validator.okClassName=okClassName==null?"":okClassName;
	$(selector + " input," + selector + " textarea," + selector + " select").each(
		function()
		{
			validator.addEvent(selector,errorClassName,okClassName,this);
			//validator.showFocusText($(this),selector);//默认显示
		}
		);
}
//显示提示的内容
validator.showFocusText=function(ele,selector)
{
    var name=ele.attr("name");
    var txt=validator.messages[selector][name];//ele.attr("title")==null?"&nbsp;":ele.attr("title");
    //alert(txt);
    $(selector+" ."+ name +"_msg").removeClass("onError").removeClass("onSuccess").addClass("onFocus").html(txt);
}
//验证全部
validator.validatorAll=function(selector,callback)
{
    var invalid=[];
	var bl=true;
	$(selector + " input," + selector + " textarea," + selector + " select").each(
	function()
	{
	    if ($(this).attr("type") == "hidden" || $(this).attr("type") == "button" || $(this).attr("type") == "submit")//按钮不做处理
			return;
		if(validator.doValidate($(this),validator.feedback,selector))
			validator.OK($(this),selector);
		else {
		    bl = false;
		    invalid.push(this);
		}
	}
	);
	if(!bl)
	{
	    if(callback!=null)
	        callback(invalid,selector);
	    else
	        alert("页面校验没有通过，请检查您的输入!");
	}
	return bl;
}
//关闭错误提示
validator.OK=function(ele,selector)
{
	$(selector+" ."+ele.attr("name")+"_msg").removeClass("onError").removeClass("onFocus").addClass("onSuccess").html("验证通过");//.fadeOut("slow");
	ele.removeClass(validator.errorClassName);
	ele.addClass(validator.okClassName);
}
//显示错误提示
validator.feedback = function (ele,type,selector) 
{
	var msg = validator.tip[type];
	if(typeof(msg)=="undefined")
		msg=type;

	ele.removeClass(validator.okClassName);//去掉成功的样式
	ele.addClass(validator.errorClassName);//加上失败的样式
	
	$(selector+" ."+ele.attr("name")+"_msg").removeClass("onSuccess").removeClass("onFocus").addClass("onError").html(msg).fadeIn("slow");
}
//执行验证
validator.doValidate=function(element,feedback,selector)
{
	var v = element.val();
	//alert(v);
	//验证是否允许非空
	var required = element.attr('required');
	if (required != null && required != false && v.isEmpty()) {
		feedback(element,'required',selector);
		return false;
	}
	//验证是否合法格式
	var dataType = element.attr('dataType');
	if (!v.isEmpty() && dataType != null &&  dataType.toLowerCase() != 'password') {
		dataType = dataType.toLowerCase();
		try {
			if (!( validator.reg[dataType]).test(v)) {
				feedback(element,dataType,selector);
				return false;
			}
		} catch(e) {
			feedback(element,'unknow',selector);
			return false;
		}
	}
	//执行数据验证
	var confirmObj = element.attr('confirmObj');
	if (confirmObj != null) {
		try {
			var data = $(confirmObj).val();
			if (v != data) {
				feedback(element,"notSame",selector);
				return false;
			}
		} catch (e) {
			feedback(element,'paramError',selector);
			return false;
		}
	}
	//验证数字大小
	var dataBetween = element.attr('dataBetween');
	if (!v.isEmpty() && dataBetween != null) {
		
		if (!( validator.reg["integer"]).test(v)){
			feedback(element,"integer",selector);
			return false;
		}
		var min = dataBetween.getBetweenVal('min');
		var max = dataBetween.getBetweenVal('max');
		if (min == null || max == null) {
			feedback(element,'paramError',selector);
			return false;
		}
		if (!v.isBetween(parseInt(v.trim()), min, max)) {
			feedback(element,'必须是介于 ' + min + '-' + max + ' 之间的数字。',selector);
			return false;
		}
	}
	//验证字符长度
	var dataLength = element.attr('dataLength');
	if (!v.isEmpty() && dataLength != null) {
		var min = dataLength.getBetweenVal('min');
		var max = dataLength.getBetweenVal('max');
		if (min == null || max == null) {
			feedback(element,'paramError',selector);
			return false;
		}
		if (!v.isBetween(v.trim().length, min, max)) {
			feedback(element,'必须是 ' + min + '-' + max + ' 个字符。',selector);
			return false;
		}
	}
	return true;
}