//contextmenu object
//2007-7-3 Simon.Q
function ContextMenu(sId)
{
	this.MenuId = sId;
	this.MenuItems = [];
}
//menu item object
function MenuItem(bType, sText, sAction, bEnable, sIcon)
{
	this.type = bType;
	this.text = sText;
	this.action = sAction;
	this.enable = (bEnable == undefined) ? true : false;
	this.icon = sIcon;
}
//add menu item
ContextMenu.prototype.addMenuItem = function(sText, sAction, bEnable, sIcon)
{
	this.MenuItems[this.MenuItems.length] = new MenuItem(true, sText, sAction, bEnable, sIcon);
}
//add separator
ContextMenu.prototype.addSeparator = function()
{
	this.MenuItems[this.MenuItems.length] = new MenuItem(false, null, null, null, null);
}
//build menu item html
ContextMenu.prototype.addItem = function()
{
	var sHtml = "";
	for (var i = 0; i < this.MenuItems.length; i++)
	{
		if (this.MenuItems[i].type)
		{
			if (this.MenuItems[i].enable)
			{
				sHtml += "<div class=\"menuitem\" onmouseover=\"this.className = 'menuitem-over';\" onmouseout=\"this.className = 'menuitem';\""
				if (this.MenuItems[i].action)
					sHtml += " onclick=\""+ this.MenuItems[i].action +"\"";
				sHtml += ">"+ this.MenuItems[i].text +"</div>\n";
			}
			else
			{
				sHtml += "<div class=\"menuitem-disabled\">"+ this.MenuItems[i].text +"</div>\n";
			}
		}
		else
		{
			//sHtml += "<div class=\"menuitem-separator\"></div>\n";
			sHtml += "<hr class=\"menuitem-separator\" />\n";
		}
	}	
	return sHtml;
}
//create contextmenu to string
ContextMenu.prototype.toString = function()
{
		var sHtml = "<div id=\""+ this.MenuId +"\" class=\"contextmenu\" onselectstart=\"return false;\">\n";
		sHtml += this.addItem();
		sHtml += "</div>\n";
		//alert(sHtml);
		return sHtml;
}
//build contextmenu
ContextMenu.prototype.createMenu = function()
{
	document.write(this);
	this.hideMenu();
} 

//show contextmenu
ContextMenu.prototype.showMenu = function(e)
{
	var obj;
	var e, x, y;
	var docheight,docwidth,dh,dw;	

	e = e || window.event;
	x = e.clientX;
	y = e.clientY;
	

	obj = document.getElementById(this.MenuId);

	docwidth  = document.documentElement.clientWidth;
	docheight = document.documentElement.clientHeight;

	dw = (obj.offsetWidth + x)  - docwidth;
	dh = (obj.offsetHeight + y) - docheight;

	if(dw > 0)
	{
		obj.style.left = (x - dw) + document.documentElement.scrollLeft + "px";		
	}
	else
	{
		obj.style.left = x + document.documentElement.scrollLeft + "px";
	}
	if(dh > 0)
	{
		obj.style.top = (y - dh) + document.documentElement.scrollTop + "px"
	}
	else
	{
		obj.style.top  = y + document.documentElement.scrollTop + "px";
	}	
	obj.style.visibility = "inherit";
} 
//hide contextmenu
ContextMenu.prototype.hideMenu = function()
{
	document.getElementById(this.MenuId).style.visibility = "hidden";
}
/* 
//MenuClick
ContextMenu.prototype.menuClick = function(e,obj)
{
	e = e || window.event;
} */

ContextMenu.Close=function()
{
    //ҪUtility.js
    //for in arrayֻobject
    var items = document.getElementsByClassName("contextmenu");
    var i=0;
    for(;i<items.length;i++)
        items[i].style.visibility = "hidden";
}
/* create contextmenu instance */
var contextmenu = new ContextMenu("ContextMenu");
