﻿/*
 * Menu - jQuery plugin for click menus
 *
 * Author: 杜有发
 */

(function($) {

 	var menu, shadow, trigger, content, hash, currentTarget;
  var defaults = 
  {
    menuStyle: 
	{
      listStyle: 'none',
      padding: '1px',
      margin: '0px',
      backgroundColor: '#fff',
      border: '1px solid #A5CAED',
      width: '100px',
	  "font-size": '12px' //字体大小
    },
    itemStyle: 
	{
      margin: '0px',
      color: '#000',
      display: 'block',
      cursor: 'default',
      padding: '3px',
      border: '1px solid #fff',
      backgroundColor: 'transparent'
    },
    itemHoverStyle: 
	{
      border: '1px solid #0a246a',
      backgroundColor: '#D9EBFC'
    },
	showOnCursorRight: true,//是否出现在鼠标的右边，默认是
    eventPosX: 'pageX',
    eventPosY: 'pageY',
    shadow : true,
    onMenu: null,
    onShowMenu: null,
	fireType: "click", //触发菜单的方式，click为单击，contextmenu为右键
	objClassWhenMenu: ""//当出现菜单的时候，触发菜单的对象的附加样式名称
 	};

  $.fn.Menu = function(id, options) 
  {
    if (!menu) 
	{                                      // Create singleton menu
      menu = $('<div id="jqMenu"></div>')
               .hide()
               .css({position:'absolute', zIndex:'500'})
               .appendTo('body')
               .bind('click', function(e) {
                 e.stopPropagation();
               });
    }
    if (!shadow) 
	{
      shadow = $('<div id="jqMenuShadow"></div>')
                 .css({backgroundColor:'#A5CAED',position:'absolute',opacity:0.6,zIndex:499})
                 .appendTo('body')
                 .hide();
    }
    hash = hash || [];
    hash.push({
      id : id,
      menuStyle: $.extend({}, defaults.menuStyle, options.menuStyle || {}),
      itemStyle: $.extend({}, defaults.itemStyle, options.itemStyle || {}),
      itemHoverStyle: $.extend({}, defaults.itemHoverStyle, options.itemHoverStyle || {}),
      bindings: options.bindings || {},
	  showOnCursorRight: options.showOnCursorRight || options.showOnCursorRight === false ? options.showOnCursorRight : defaults.showOnCursorRight,
      shadow: options.shadow || options.shadow === false ? options.shadow : defaults.shadow,
      //onclick: options.onMenu || defaults.onMenu,
      onShowMenu: options.onShowMenu || defaults.onShowMenu,
      eventPosX: options.eventPosX || defaults.eventPosX,
      eventPosY: options.eventPosY || defaults.eventPosY,
	  objClassWhenMenu: options.objClassWhenMenu || defaults.objClassWhenMenu,
	  fireType: options.fireType || defaults.fireType
    });
    var index = hash.length - 1; 
	//alert(this[0].tagName);
	$(this).bind(hash[index].fireType, function(e) 
	{
		  // Check if onMenu() defined
		  //alert(this.tagName);
		  $(this).addClass(hash[index].objClassWhenMenu);
		  var bShow = (!!hash[index].onMenu) ? hash[index].onMenu(e) : true;
		  if (bShow) display(index, this, e, options);
		  return false;
		});
    return this;
  };

  function display(index, trigger, e, options) 
  {
    var cur = hash[index];
    content = $('#'+cur.id).find('ul:first').clone(true);
    content.css(cur.menuStyle).find('li').css(cur.itemStyle).hover(
      function() 
	  {
        $(this).css(cur.itemHoverStyle);
      },
      function()
	  {
        $(this).css(cur.itemStyle);
      }
    ).find('img').css({verticalAlign:'middle',paddingRight:'2px'});

    menu.html(content);

    // if there's an onShowMenu, run it now -- must run after content has been added
		// if you try to alter the content variable before the menu.html(), IE6 has issues
		// updating the content
    if (!!cur.onShowMenu) cur.onShowMenu(e, menu, trigger);//menu = cur.onShowMenu(e, menu);

    $.each(cur.bindings, function(id, func) 
	{
      $('#'+id, menu).bind('click', function(e)//点了菜单里的某一项 
		{
			hide();
			$(trigger).removeClass(cur["objClassWhenMenu"]);
			func(trigger, currentTarget);
		  });
    });
	var _menuLeft = cur["showOnCursorRight"]?e[cur.eventPosX]: e[cur.eventPosX] - menu.width();
    menu.css({'left':_menuLeft,'top':e[cur.eventPosY]}).show();
    if (cur.shadow) shadow.css({width:menu.width(),height:menu.height(),left:_menuLeft+2,top:e[cur.eventPosY]+2}).show();
    $(document).one('click', function(){
										  hide();
										  $(trigger).removeClass(cur["objClassWhenMenu"]);
									  }
	);
  }

  function hide() 
  {
    menu.hide();
    shadow.hide();
  }

  // Apply defaults
  $.Menu = {
    defaults : function(userDefaults) 
	{
      $.each(userDefaults, function(i, val) 
		{
			if (typeof val == 'object' && defaults[i]) 
			  	$.extend(defaults[i], val);
			else 
				defaults[i] = val;
      });
    }
  };

})(jQuery);

$(function() {
  $('div.Menu').hide();
});