$.fn.mypagination = function(totalProperty, opts) {
    opts = $.extend({
        perPage: 10,
        currPage: 1,
        baseFolder: "",
        callback: function() { }
    }, opts || {});

    return this.each(function() {
        function numPages() {
            return Math.ceil(totalProperty / opts.perPage);
        }


        function selectPage(page) {
            return function() {
                currPage = parseInt(page, 10) || 1;
                if (page < 0) currPage = 1;
                if (page >= allPages) currPage = allPages;

                render();

                $('img.page-wait', panel).attr('src', baseFolder + 'images/wait.gif');
                opts.callback(currPage);
                $('img.page-wait', panel).attr('src', baseFolder + 'images/nowait.gif');
            }
        }

        function render() {
            var imgWait = baseFolder + 'images/nowait.gif';
            var html = '';
            if (typeof langMypage == 'undefined')
                html = '<table title="一共有 ' + totalProperty + ' 条记录"><tbody><tr>'
				+ '<td><a href="javascript:void(0);"><img class="page-first" /></a></td>'
				+ '<td><a href="javascript:void(0);"><img class="page-prev" /></a></td>'
				+ '<td><span>第<input type="text" class="page-num">页/共' + allPages + '页</span></td>'
				+ '<td><a href="javascript:void(0);"><img class="page-next" /></a></td>'
				+ '<td><a href="javascript:void(0);"><img class="page-last" /></a></td>'
            //+'<td><img src="'+imgWait +'" class="page-wait"></td>'
            //+'<td><span style="padding-left:50px;">检索到'+totalProperty+'记录</span></td>'
				+ '</tr></tbody></table>';
            else {
                html = '<table title="'+langMypage[0]+' ' + totalProperty + ' '+langMypage[1]+'"><tbody><tr>'
				+ '<td><a href="javascript:void(0);"><img class="page-first" /></a></td>'
				+ '<td><a href="javascript:void(0);"><img class="page-prev" /></a></td>'
				+ '<td><span>' + langMypage[2] + '<input type="text" class="page-num">' + langMypage[3] + '/' + langMypage[4] + '' + allPages + '' + langMypage[3] + '</span></td>'
				+ '<td><a href="javascript:void(0);"><img class="page-next" /></a></td>'
				+ '<td><a href="javascript:void(0);"><img class="page-last" /></a></td>'
                //+'<td><img src="'+imgWait +'" class="page-wait"></td>'
                //+'<td><span style="padding-left:50px;">检索到'+totalProperty+'记录</span></td>'
				+ '</tr></tbody></table>';
            }
            var imgFirst = baseFolder + 'images/page-first-disabled.gif';
            var imgPrev = baseFolder + 'images/page-prev-disabled.gif';
            var imgNext = baseFolder + 'images/page-next-disabled.gif';
            var imgLast = baseFolder + 'images/page-last-disabled.gif';
            if (currPage > 1) {
                imgFirst = baseFolder + 'images/page-first.gif';
                imgPrev = baseFolder + 'images/page-prev.gif';
            }
            if (currPage < numPages()) {
                imgNext = baseFolder + 'images/page-next.gif';
                imgLast = baseFolder + 'images/page-last.gif';
            }
            panel.empty();
            panel.append(html);
            $('img.page-first', panel)
				.bind('click', selectPage(1))
				.attr('src', imgFirst);
            $('img.page-prev', panel)
				.bind('click', selectPage(currPage - 1))
				.attr('src', imgPrev);
            $('img.page-next', panel)
				.bind('click', selectPage(currPage + 1))
				.attr('src', imgNext);
            $('img.page-last', panel)
				.bind('click', selectPage(allPages))
				.attr('src', imgLast);
            $('input.page-num', panel)
				.val(currPage)
				.change(function() {
				    selectPage($(this).val())();
				})
				.keydown(function(event) {
				    event = window.event ? window.event : event;
				    if (event.keyCode == 13) {
				        selectPage($(this).val())();
				    }
				});

            if (currPage == 1 || currPage < 1) {
                $('img.page-first', panel).unbind("click");
                $('img.page-prev', panel).unbind("click");
            }

            if (currPage == allPages || currPage < 1) {
                $('img.page-next', panel).unbind("click");
                $('img.page-last', panel).unbind("click");
            }
        }

        var currPage = opts.currPage;
        var allPages = numPages();
        currPage = currPage || 1;
        if (currPage > allPages)
            currPage = allPages;
        var panel = $(this);
        var baseFolder = opts.baseFolder || "";
        //if( baseFolder[baseFolder.length-1]!='/')
        //baseFolder+="/";
        render();

    });
}