﻿document.getElementsByClassName = function(className, oBox) {
    //适用于获取某个HTML区块内部含有某一特定className的所有HTML元素
    this.d = oBox || document;
    var children = this.d.getElementsByTagName('*') || document.all;
    var elements = new Array();
    for (var ii = 0; ii < children.length; ii++) {
        var child = children[ii];
        if (child.className == className) {
            elements.push(child);
            continue;
        }
        var classNames = child.className.split(' ');
        for (var j = 0; j < classNames.length; j++) {
            if (classNames[j] == className) {
                elements.push(child);
                continue;
            }
        }
    }
    return elements;
}

document.getElementsByType = function(sTypeValue, oBox) {
    //适用于获取某个HTML区块内部同属于某一特定type的所有HTML元素，如:input,script,link等等
    this.d = oBox || document;
    var children = this.d.getElementsByTagName('*') || document.all;
    var elements = new Array();
    for (var ii = 0; ii < children.length; ii++) {
        if (children[ii].type == sTypeValue) {
            elements.push(children[ii]);
        }
    }
    return elements;
}

function $F() {
    var elements = new Array();
    for (var ii = 0; ii < arguments.length; ii++) {
        var element = arguments[ii];
        if (typeof element == 'string')
            element = document.getElementById(element);
        if (arguments.length == 1)
            return element;
        elements.push(element);
    }
    return elements;
}

$Cls = function(s, o) {
    return document.getElementsByClassName(s, o);
};

$Type = function(s, o) {
    return document.getElementsByType(s, o);
};

$Tag = function(s, o) {
    this.d = o || document;
    return this.d.getElementsByTagName(s);
};

/** Mozilla兼容MsIE脚本，stylesheet扩展部分。
* o stylesheet.addRule()
*/
(function() {
    if (document.all) return;
    if (!window.CSSStyleSheet) return;
    function _ss_GET_rules_() {
        return this.cssRules;
    }
    var _ss = CSSStyleSheet.prototype;
    _ss.addRule = function(sSelector, sRule) {
        this.insertRule(sSelector + "{" + sRule + "}", this.cssRules.length);
    }
    _ss.__defineGetter__("rules", _ss_GET_rules_);
}
)();