﻿/*
Author  : 杜有发
*/

// Prototype Method to get the element based on ID
function FindById(d){
	return document.getElementById(d);
}

// set or get the current display style of the div
function Display(d,v){
	if(v==undefined)
		return d.style.display;
	else
		d.style.display=v;
}

// set or get the height of a div.
// d 对象都是内容面板的DOM
function GetHeight(d){
	// if you are getting the height then display must be block to return the absolute height
	var key= d.parentNode.id;//得到父系的ID，是Accordian的ID
	var content_id = d.id;//内容ID
	var heightType= AccordianHelper[key].heightType || "" ;//高度类型
	
	if(Display(d)!='none'&& Display(d)!='')
	{
		return d.offsetHeight;
	}
	viz = d.style.visibility;
	d.style.visibility = 'hidden';
	o = Display(d);
	Display(d,'block');
	
	var r=0;
	if( heightType=="auto")
		r = parseInt(d.offsetHeight);
	else
	{
		if ( AccordianHelper[key] != null && AccordianHelper[key].height!=0)
		{
			r = AccordianHelper[key].height;
		}
		else
		{
			var head_id = content_id.replace(/-content/gi,"") + "-header"; // header 的ID
			
			SaveNewContentHeight(head_id);
			r = AccordianHelper[key].height;
		}
	}
	
	Display(d,o);
	d.style.visibility = viz;
	return r;
}

function SaveNewContentHeight(head_id)
{
    var head_dom = FindById(head_id);
    var key= head_dom.parentNode.id;
    var r = 0;
	var fx = 0;
	var count = AccordianHelper[key].count || 0 ;//alert(count);
	if(moz)//在FF下可以直接得到margin-bottom的值，可在IE下只能得到margin的值，是缩写形式，为 0px 0px 1px等，顺序是 上 右 下 左
	{
	    var margin_bottom = getStyle(head_dom,"margin-bottom") ;
	    var margin_top = getStyle(head_dom,"margin-top")  ;
	    fx = parseInt(margin_bottom.replace(/px/gi,"") )  + parseInt(margin_top.replace(/px/gi,"") );
	}
	else
	{
	    fx= getStyle(head_dom,"margin").replace(/px/gi,"");
	    var arr = fx.split(" ");
	    fx = parseInt(arr[0]) + parseInt(arr[2]) ;
	}
	//alert(getStyle(head_dom,"marginBottom"));//marginBottom却有值
	fx=fx||0;//如果没有设置margin，则这里给予默认值
	
	r = parseInt(getStyle(FindById(key),"height").replace(/px/gi,"")) - count * getOuterRect( head_dom ).height - count* fx;
	AccordianHelper[key].height = r;
}

function SetHeight(d,v)
{
	d.style.height=v;
	if( AccordianHelper.animationDirection =="Expand")
	{
	    if( v == d.maxh )//动画完毕
	    {
		    d.style.overflowY="auto";
    		
		    AccordianHelper.onFinish();
	    }
	}
	else if( AccordianHelper.animationDirection =="Collapse")
	{
	    if( v==0 )
	        AccordianHelper.onFinish();
	}
}
/*
* Variable 'S' defines the speed of the accordian
* Variable 'T' defines the refresh rate of the accordian
s=7;
t=10;
*/

//Collapse Timer is triggered as a setInterval to reduce the height of the div exponentially.
function CollapseTimer(d){
	d = FindById(d);
	if(GetHeight(d)>0)
	{
		v = Math.round(GetHeight(d)/d.s);
		v = (v<1) ? 1 :v ;
		v = (GetHeight(d)-v);
		SetHeight(d,v+'px');
		//d.style.opacity = (v/d.maxh);
		//d.style.filter= 'alpha(opacity='+(v*100/d.maxh)+');';
	}
	else
	{
		SetHeight(d,0);
		Display(d,'none');
		clearInterval(d.t);
	}
}

//Expand Timer is triggered as a setInterval to increase the height of the div exponentially.
function ExpandTimer(d){
	d = FindById(d);
	if(GetHeight(d)<d.maxh){
		v = Math.round((d.maxh-GetHeight(d))/d.s);
		v = (v<1) ? 1 :v ;
		v = (GetHeight(d)+v);
		SetHeight(d,v+'px');
		//d.style.opacity = (v/d.maxh);
		//d.style.filter= 'alpha(opacity='+(v*100/d.maxh)+');';
	}else{
		SetHeight(d,d.maxh);
		clearInterval(d.t);
	}
}

// Collapse Initializer
function CollapseInitializer(d){
	if(Display(d)=='block')
	{
		clearInterval(d.t);
		d.t=setInterval('CollapseTimer("'+d.id+'")',10);
	}
}

//Expand Initializer
function ExpandInitializer(d){
	if(Display(d)=='none')
	{
		Display(d,'block');
		d.style.height='0px';
		clearInterval(d.t);
		d.t=setInterval('ExpandTimer("'+d.id+'")',10);// 10 - defines the refresh rate of the accordian
	}
	else//不需要设置高度，则执行回调函数
    {
	    //AccordianHelper.onFinish();
	    //alert("ExpandInitializer");
	}
}

// Removes Classname from the given div.
function RemovesClassname(n,v){
	s=n.className.split(/\s+/);
	for(p=0;p<s.length;p++)
	{
		if(s[p]==v+n.tc)
		{
			s.splice(p,1);
			n.className=s.join(' ');
			break;
		}
	}
}

function WhenResize(key)
{
    if( AccordianHelper[key] ==null)
        return;
    //alert(AccordianHelper[key].nowExpandID);
    var header_id= AccordianHelper[key].nowExpandID; 
    var content_id = header_id.substr(0,header_id.indexOf('-'))+'-content';
    //alert("原来的高度："+ AccordianHelper[key].height);
    SaveNewContentHeight(header_id);
    //alert("现在的高度："+ AccordianHelper[key].height);
    var height = AccordianHelper[key].height ;
    FindById(content_id).style.height= height + "px";
    
    //设置每个content 的maxh
    var l=FindById(key).getElementsByTagName('div');
    var _id;
    for(i=0;i<l.length;i++)
	{
		_id=l[i].id;
		if(_id.substr(_id.indexOf('-')+1,_id.length)=='content')
		{
			FindById(_id).maxh = height;
		}
	}
}

var AccordianHelper= {};
AccordianHelper.onStart = function(){};//动画开始后的回调函数
AccordianHelper.onFinish = function(){};//动画结束后的回调函数
AccordianHelper.animationDirection="";
//Accordian Initializer
function Accordian(d,s,tc,settings){
	//一些设置
	var key =d ;

	AccordianHelper[key]= {};//为了清除一些以前的设置，比如内容的高。运用场合：在页面resize的时候，重新设置动画。
	AccordianHelper[key]=settings || { heightType:"auto",count:0, height: 0, nowExpandID:""};
	
	AccordianHelper[key].height = 0;
	
	this.ItemCount = 0;
	// get all the elements that have id as content
	var l=FindById(d).getElementsByTagName('div');
	if( l.length == 0 )
	{
	    AccordianHelper[key]= {}
	    return;
	}
	
	var c=[];
	var h;
	for(i=0;i<l.length;i++)
	{
		h=l[i].id;
		if(h.substr(h.indexOf('-')+1,h.length)=='content')
		{
			c.push(h);
			
			this.ItemCount++;//个数
		}
	}
	
	AccordianHelper[key].count = this.ItemCount;//保存设置
	
	sel=null;
	//then search through headers
	for(i=0;i<l.length;i++)
	{
		h=l[i].id;
		if(h.substr(h.indexOf('-')+1,h.length)=='header')
		{
			d=FindById(h.substr(0,h.indexOf('-'))+'-content');
			d.style.display='none';
			d.style.overflow='hidden';
			d.style.overflowX = "hidden";
			d.maxh =GetHeight(d);
			d.s=(s==undefined)? 5 : s;
			
			//AccordianHelper[d.id]= null;//清除原来的（高度）设置
			
			h=FindById(h);
			h.tc=tc;
			h.c=c;
			// set the onclick function for each header.
			h.onclick = function() {
			    AccordianHelper.onStart();

			    AccordianHelper[key] = AccordianHelper[key] || {};
			    AccordianHelper[key].nowExpandID = this.id;

			    for (i = 0; i < this.c.length; i++) {
			        cn = this.c[i];
			        n = cn.substr(0, cn.indexOf('-'));

			        var content_ele = FindById(n + '-content');
			        content_ele.style.overflow = 'hidden'; //点击后设置overflow为hidden，等待动画结束后再设置回来

			        if ((n + '-header') == this.id)//展开
			        {
			            if (Display(content_ele) == "none") {
			                if (content_ele.innerHTML == "") {
			                    //alert(22);
			                    var ret = $.ajax({ url: "Handler/Default.ashx?action=GetSubMenuConent", data: { MenuCode: n, MenuType: __helper.menuType }, async: false }).responseText;
			                    content_ele.innerHTML = ret;
			                    new CNLTreeMenu($("#" + n + "-content .CNLTreeMenu")[0], "li").InitCss("Opened", "Closed", "Child c", "/Lib/Skin/ComImages/s.gif");
			                    //$("#" + n + "-content .CNLTreeMenu").addClass("inited");
			                    // $("#menusForSystem_" + __helper.nowSystemCode + "_" + __helper.menuType).val($("#MenuList").html());
			                    //var mv = "<div id=\"JYDDTM-header\" class=\"accordion_headings\">按类别商品数据维护</div><div id=\"JYDDTM-content\" class=\"accordion_child_holder\"></div>";
			                    var mv = $("#menusForSystem_" + __helper.nowSystemCode + "_" + __helper.menuType).val();
			                    if (mv) {
			                        var re = new RegExp("(.+" + n + "-content" + "[^\>]+\>)(\</div\>)");
			                        $("#menusForSystem_" + __helper.nowSystemCode + "_" + __helper.menuType).val(mv.replace(re, "$1" + ret + "$2"));
			                    }
			                }
			                AccordianHelper.animationDirection = "Expand";

			                content_ele.style.overflowY = 'hidden';
			                //没有显示，来展开
			                ExpandInitializer(content_ele);
			                n = FindById(n + '-header');
			                RemovesClassname(n, '__');
			                n.className = n.className + ' ' + n.tc;
			            }
			            else {
			                content_ele.style.overflowY = 'auto'; //本身已经在显示了就不用再设置为hidden了（再次点击已经显示的header）

			                AccordianHelper.animationDirection = "Collapse";

			                //已经在显示的，再次点击，隐藏它
			                content_ele.style.overflowY = 'hidden';
			                CollapseInitializer(content_ele);
			                RemovesClassname(FindById(n + '-header'), '');
			                return;
			            }


			        }
			        else//其他的收回
			        {
			            content_ele.style.overflowY = 'hidden';
			            CollapseInitializer(content_ele);
			            RemovesClassname(FindById(n + '-header'), '');
			        }
			    }

			    if (AccordianHelper[key].customFunction != null)
			        AccordianHelper[key].customFunction(this);
			}
			if(h.className.match(/selected+/)!=undefined){ sel=h;}
		}
	}	
	if(sel!=undefined){sel.onclick();}
}