﻿/*
 *
 *	Created by 杜有发
 *	
 *	input.tree-check-box-hidden {
 *		display:	none;
 *	}
 *
 */

function WebFXCheckBoxImgTreeItem(sText, sAction, bChecked, eParent, sIcon, sOpenIcon, sData) {
	this.base = WebFXTreeItem;
	this.base(sText, sAction, eParent, sIcon, sOpenIcon, sData);
	
	this._checked = bChecked || false  ;
}

WebFXCheckBoxImgTreeItem.prototype = new WebFXTreeItem;

/*设置*/
var WebFXCheckBoxImgTree={};
WebFXCheckBoxImgTree.Img={
	"AllChecked":"AllChecked.gif",
	"SomeChecked":"SomeChecked.gif",
	"NoChecked":"NoChecked.gif",
	"AllChecked_disabled":"AllChecked_disabled.gif",
	"SomeChecked_disabled":"SomeChecked_disabled.gif",
	"NoChecked_disabled":"NoChecked_disabled.gif"
};
/*设置ico目录，如果不是当前目录，路径后面要加/*/
WebFXCheckBoxImgTree.SetImgPath = function (sPath)
{
	var imgs=["AllChecked","SomeChecked","NoChecked","AllChecked_disabled","SomeChecked_disabled","NoChecked_disabled"];
	var i=0;
	for( ; i< imgs.length; i++)
		WebFXCheckBoxImgTree.Img[imgs[i]] = sPath + WebFXCheckBoxImgTree.Img[imgs[i]] ;
}

WebFXCheckBoxImgTree.SetImgPath("/lib/xtree/images/");//

WebFXCheckBoxImgTreeItem.prototype.toString = function (nItem, nItemCount) {
	var foo = this.parentNode;
	var indent = '';
	if (nItem + 1 == nItemCount) { this.parentNode._last = true; }
	var i = 0;
	while (foo.parentNode) {
		foo = foo.parentNode;
		indent = "<img src=\"" + ((foo._last)?webFXTreeConfig.blankIcon:webFXTreeConfig.iIcon) + "\">" + indent;
		i++;
	}
	this._level = i;
	if (this.childNodes.length) { this.folder = 1; }
	else { this.open = false; }
	if ((this.folder) || (webFXTreeHandler.behavior != 'classic')) {
		if (!this.icon) { this.icon = webFXTreeConfig.folderIcon; }
		if (!this.openIcon) { this.openIcon = webFXTreeConfig.openFolderIcon; }
	}
	else if (!this.icon) { this.icon = webFXTreeConfig.fileIcon; }
	var label = this.text;//replace(/</g, '&lt;').replace(/>/g, '&gt;');
	var str = "<div id=\"" + this.id + "\" ondblclick=\"webFXTreeHandler.toggle(this);\" class=\"webfx-tree-item\" onkeydown=\"return webFXTreeHandler.keydown(this, event)\">";
	str += indent;
	str += "<img id=\"" + this.id + "-plus\" src=\"" + ((this.folder)?((this.open)?((this.parentNode._last)?webFXTreeConfig.lMinusIcon:webFXTreeConfig.tMinusIcon):((this.parentNode._last)?webFXTreeConfig.lPlusIcon:webFXTreeConfig.tPlusIcon)):((this.parentNode._last)?webFXTreeConfig.lIcon:webFXTreeConfig.tIcon)) + "\" onclick=\"webFXTreeHandler.toggle(this);\">"
	
	// insert check box
	str += "<img src=\""+ (this._checked?WebFXCheckBoxImgTree.Img.AllChecked:WebFXCheckBoxImgTree.Img.NoChecked) + "\"" + 
	" id=\""+ this.id +"-checkboximg\"" +
	" onclick=\"webFXTreeHandler.onClick("+ this.id +",this )\"" +
	" /><input type=\"checkbox\"" +
		" class=\"tree-check-box-hidden\"" +
		" id=\""+ this.id +"-checkbox\"" +
		" value=\""+ this.data +"\"" +
		(this._checked ? " checked=\"checked\"" : "") +
		" />";
	// end insert checkbox
	
	str += "<img id=\"" + this.id + "-icon\" class=\"webfx-tree-icon\" src=\"" + ((webFXTreeHandler.behavior == 'classic' && this.open)?this.openIcon:this.icon) + "\" onclick=\"webFXTreeHandler.select(this);\"><a href=\"" + this.action + "\" id=\"" + this.id + "-anchor\" onfocus=\"webFXTreeHandler.focus(this);\" onblur=\"webFXTreeHandler.blur(this);\">" + label + "</a><span id=\""+this.id+"-csCont\"></span></div>";
	str += "<div id=\"" + this.id + "-cont\" class=\"webfx-tree-container\" style=\"display: " + ((this.open)?'block':'none') + ";\">";
	var sb = [];
	for (var i = 0; i < this.childNodes.length; i++) {
		sb.push(this.childNodes[i].toString(i,this.childNodes.length));
	}
	//str += "</div>";
	this.plusIcon = ((this.parentNode._last)?webFXTreeConfig.lPlusIcon:webFXTreeConfig.tPlusIcon);
	this.minusIcon = ((this.parentNode._last)?webFXTreeConfig.lMinusIcon:webFXTreeConfig.tMinusIcon);
	return str + sb.join("") + "</div>";
}

WebFXCheckBoxImgTreeItem.prototype.getChecked = function () {
	var divEl = document.getElementById(this.id);
	var inputEl = divEl.getElementsByTagName("INPUT")[0];
	return this._checked = inputEl.checked;
};

WebFXCheckBoxImgTreeItem.prototype.setChecked = function (bChecked,src) {
	var bDisabled = false ;
	var inputEl = document.getElementById(this.id+"-checkbox");
	bDisabled = inputEl.disabled; 
	if(bChecked != null )//用在 只设置图标，不影响checkbox状态的情况下
	{
		if ( !bDisabled )
		{
			this._checked = bChecked;
			inputEl.checked = bChecked;
		}
	}
	//设置图片
	if(src!=null)
	{
		if(bDisabled)
		{
			if( src.indexOf("_disabled.gif")==-1 )
				src = src.replace(/\.gif/gi,"_disabled.gif");
		}
		document.getElementById(this.id+"-checkboximg").src= src;
		
		//修正是否勾选，仅仅在被禁用的情况下，用这：只有一个子，被禁用，而且没被选上，那点父级，则父级会被选上（由于没被禁用，则一点击就选了）
		if(bDisabled)
		{
			if( src.toLowerCase().indexOf("nochecked") != -1)
				inputEl.checked = false ;
			if( src.toLowerCase().indexOf("allchecked") != -1)
				inputEl.checked = true ;
		}
	}
};
//勾选执行的自定义函数
webFXTreeHandler.customFunctionForCheckBox=function(obj){return;};
//勾选执行的函数
webFXTreeHandler.onClick=function(id,obj)
{
	var item_=webFXTreeHandler.all[id+""];//当前项
	var checkbox_ = document.getElementById(id+"-checkbox");
	item_._checked= ! item_._checked;
	if( checkbox_.disabled ) return ;
	var flag = item_._checked;
	
	//设置图片
	var src= flag? WebFXCheckBoxImgTree.Img.AllChecked : WebFXCheckBoxImgTree.Img.NoChecked;
	item_.setChecked(flag,src);
	
	//实现勾选以后再执行客户自定义函数
	this.customFunctionForCheckBox(checkbox_);//兼容原来的 checkbox
	
	//勾全部子级,id为 id-cont 以及  id 的容器里的checkbox都要被选择
	var checkboxes=document.getElementById(id+"-cont").getElementsByTagName("INPUT");
	for(var i=0;i<checkboxes.length;i++)
	{
		if(checkboxes[i].disabled)
		{}
		else
		{
			var child_id= checkboxes[i].id.replace(/-checkbox/gi,"");
			webFXTreeHandler.all[child_id+""].setChecked(flag,src,true,"child");
		}
	}
	
	var _topped_parent_id=0; 
	//要选择父系的类别
	var temp = item_ ;
	while(true)
	{
		//alert(temp.parentNode.id);
		if(temp.parentNode instanceof WebFXCheckBoxImgTreeItem)
		{
			if(flag)
				temp.parentNode.setChecked(true,null);
			_topped_parent_id = temp.parentNode.id;
		}
		else
			break;
		temp=temp.parentNode;
	}

	//log.info(_topped_parent_id);
	if (_topped_parent_id == 0 )
		webFXTreeHandler.SetIcoHelper(id);
	else
		webFXTreeHandler.SetIcoHelper(_topped_parent_id);
}
//设置图表
webFXTreeHandler.SetIcoHelper =  function(nodeID)
{
    var flag=true; //是否全选上了
    var _this= webFXTreeHandler.all[""+nodeID];
    var _thisCheckBox = document.getElementById(nodeID+"-checkbox");
    var i=0; //循环计数i
	var x=0; //循环内看已经被选上的数目
	var count= 0;// 此节点下被选择的个数，包括子节点
	var isAllDisabled = true ;//是否全部被禁用,默认全部被禁用，后面会修改这个值的
    var temp;//节点的返回的对象json
	var len= _this.childNodes.length;
    if(len>0) //如果有子节点
    {
        for(;i< len;i++)//假如父系的被选上了，可是子的没选或者是部分没选，那父系的选上也没用，只有子全部被选上才会用到父系的（不论是否被选）
        {
            var id=_this.childNodes[i].id;
            if(webFXTreeHandler.all[""+id].childNodes.length!=0)//如果还有子节点
            {
                temp = webFXTreeHandler.SetIcoHelper(id);
				if( temp.flag == false )
					flag = false ;//没有全选上
				else //全选上了
					x=x + 1 ;
				
				count = count + temp.count;
				
				if( ! temp.isAllDisabled  )
					isAllDisabled = false ;//没有全选上
            }
            else
            {
				//注意，循环内部的节点单独设置图标，因为循环外部只设置父系的图标
				var box=document.getElementById(id+"-checkbox");
				if( !box.disabled) //没被禁用的
					isAllDisabled = false;
					
                if(box.checked)
				{
					x=x+1;
					count = count + 1;
                    _this.childNodes[i].setChecked( true,WebFXCheckBoxImgTree.Img.AllChecked );
				}
				else
				{
					_this.childNodes[i].setChecked( false,WebFXCheckBoxImgTree.Img.NoChecked );
					flag = false ;//没有全选上
				}
            }
        }
    }
    else //没有子节点
    {   
		if( nodeID!= 0) //nodeID==0 为根节点
		{
       		flag = _thisCheckBox.checked ;
			isAllDisabled = _thisCheckBox.disabled; 
		}
    }
    
    
    if (_this instanceof WebFXCheckBoxImgTreeItem)
	{
		if(isAllDisabled)
			_thisCheckBox.disabled = true;
			
        if( flag )//全选了
		    _this.setChecked( true,WebFXCheckBoxImgTree.Img.AllChecked );
	    else//全没选还是选了一部分
	    { 
	        if ( count !=0 )
		        _this.setChecked( true,WebFXCheckBoxImgTree.Img.SomeChecked );//仅仅选了部分
	        else
		        _this.setChecked( false,WebFXCheckBoxImgTree.Img.NoChecked );//一个也没选
		 }
	}
	
	return { "flag": flag ,"count": count, "isAllDisabled":isAllDisabled};// x 是节点被选上的总个数
}