﻿/*
*	Created by 杜有发
.webfx-tree-plaintext 
{
    margin-left: 3px;
    padding: 1px 4px 1px 4px;
    text-decoration: none;
    font-size:13px;
}
*/

/*也重写树的顶级节点*/

function webfxPlainTextTree(sText, sAction, sBehavior, sIcon, sOpenIcon, sData) {
	this.base = WebFXTree;
	this.base(sText, sAction);
	this.data= sData || "";
	this.icon      = sIcon || webFXTreeConfig.rootIcon;
	this.openIcon  = sOpenIcon || webFXTreeConfig.openRootIcon;
	/* Defaults to open */
	if (webFXTreeConfig.usePersistence) {
		this.open  = (webFXTreeHandler.cookies.getCookie(this.id.substr(18,this.id.length - 18)) == '0')?false:true;
	} else { this.open  = true; }
	this.folder    = true;
	this.rendered  = false;
	//this.onSelect  = null;
	if (!webFXTreeHandler.behavior) {  webFXTreeHandler.behavior = sBehavior || webFXTreeConfig.defaultBehavior; }
}

webfxPlainTextTree.prototype = new WebFXTree;
webfxPlainTextTree.prototype.toString = function() {
	var str ="<div id=\"" + this.id + "\" ondblclick=\"webFXTreeHandler.toggle(this);\" class=\"webfx-tree-item\">" +
		"<img id=\"" + this.id + "-icon\" class=\"webfx-tree-icon\" src=\"" + ((webFXTreeHandler.behavior == 'classic' && this.open)?this.openIcon:this.icon) + "\">" +
		"<span id=\"" + this.id + "-plainText\" class=\"webfx-tree-plaintext\"" +
		">" + this.text + "</span><span id=\""+this.id+"-csCont\"></span></div>" +
		"<div id=\"" + this.id + "-cont\" class=\"webfx-tree-container\" style=\"display: " + ((this.open)?'block':'none') + ";\">";

	var sb = [];
	for (var i = 0; i < this.childNodes.length; i++) {
		sb[i] = this.childNodes[i].toString(i, this.childNodes.length);
	}
	this.rendered = true;
	return str + sb.join("") + "</div>";
};

function webfxPlainTextTreeItem(sText,sIcon, sOpenIcon, sData) {
	this.base = WebFXTreeItem;
	this.base(sText, '', '', sIcon, sOpenIcon, sData);
}

webfxPlainTextTreeItem.prototype = new WebFXTreeItem;

webfxPlainTextTreeItem.prototype.toString = function (nItem, nItemCount) {
	var foo = this.parentNode;
	var indent = '';
	if (nItem + 1 == nItemCount) { this.parentNode._last = true; }
	var i = 0;
	while (foo.parentNode) {
		foo = foo.parentNode;
		indent = "<img src=\"" + ((foo._last)?webFXTreeConfig.blankIcon:webFXTreeConfig.iIcon) + "\">" + indent;
		i++;
	}
	this._level = i;
	if (this.childNodes.length) { this.folder = 1; }
	else { this.open = false; }
	if ((this.folder) || (webFXTreeHandler.behavior != 'classic')) {
		if (!this.icon) { this.icon = webFXTreeConfig.folderIcon; }
		if (!this.openIcon) { this.openIcon = webFXTreeConfig.openFolderIcon; }
	}
	else if (!this.icon) { this.icon = webFXTreeConfig.fileIcon; }
	var label = this.text;//replace(/</g, '&lt;').replace(/>/g, '&gt;');
	
	var str = "<div id=\"" + this.id + "\" ondblclick=\"webFXTreeHandler.toggle(this);\" class=\"webfx-tree-item\">" +
		indent +
		"<img id=\"" + this.id + "-plus\" onclick=\"webFXTreeHandler.toggle(this);\" src=\"" + ((this.folder)?((this.open)?((this.parentNode._last)?webFXTreeConfig.lMinusIcon:webFXTreeConfig.tMinusIcon):((this.parentNode._last)?webFXTreeConfig.lPlusIcon:webFXTreeConfig.tPlusIcon)):((this.parentNode._last)?webFXTreeConfig.lIcon:webFXTreeConfig.tIcon)) + "\" />" +
		"<img id=\"" + this.id + "-icon\" class=\"webfx-tree-icon\" src=\"" + ((webFXTreeHandler.behavior == 'classic' && this.open)?this.openIcon:this.icon) + "\">" +
		"<span id=\"" + this.id + "-plainText\" class=\"webfx-tree-plaintext\"" +
		">" + this.text + "</span><span id=\""+this.id+"-csCont\"></span></div>" +
		"<div id=\"" + this.id + "-cont\" class=\"webfx-tree-container\" style=\"display: " + ((this.open)?'block':'none') + ";\">";
	
	var sb = [];
	for (var i = 0; i < this.childNodes.length; i++) {
		sb.push(this.childNodes[i].toString(i,this.childNodes.length));
	}
	//str += "</div>";
	this.plusIcon = ((this.parentNode._last)?webFXTreeConfig.lPlusIcon:webFXTreeConfig.tPlusIcon);
	this.minusIcon = ((this.parentNode._last)?webFXTreeConfig.lMinusIcon:webFXTreeConfig.tMinusIcon);
	return str + sb.join("") + "</div>";
}